/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.monitoring.web;

import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.GroupingActivity;
import org.lamsfoundation.lams.monitoring.service.IMonitoringService;
import org.lamsfoundation.lams.util.audit.IAuditService;
import org.lamsfoundation.lams.util.wddx.FlashMessage;
import org.lamsfoundation.lams.util.wddx.WDDXProcessor;
import org.lamsfoundation.lams.web.servlet.AbstractStoreWDDXPacketServlet;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class PerformChosenGroupingServlet
extends AbstractStoreWDDXPacketServlet {
    private static Logger log = Logger.getLogger(PerformChosenGroupingServlet.class);
    private static final long serialVersionUID = -3423985351915607659L;
    private static IAuditService auditService;

    public IMonitoringService getMonitoringService() {
        WebApplicationContext webContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        return (IMonitoringService)webContext.getBean("monitoringService");
    }

    protected String process(String chosenGroupingPacket, HttpServletRequest request) throws Exception {
        String message;
        FlashMessage flashMessage;
        try {
            Hashtable table = (Hashtable)WDDXProcessor.deserialize((String)chosenGroupingPacket);
            long activityId = WDDXProcessor.convertToLong((String)"groupingActivityID", table.get("groupingActivityID"));
            List groups = (List)table.get("groups");
            IMonitoringService monitoringService = this.getMonitoringService();
            Activity act = monitoringService.getActivityById(activityId);
            if (!act.isGroupingActivity()) {
                throw new Exception("The given activity [" + activityId + "] is not grouping type.");
            }
            GroupingActivity activity = (GroupingActivity)act;
            monitoringService.performChosenGrouping(activity, groups);
            Grouping grouping = activity.getCreateGrouping();
            HashMap<String, Long> map = new HashMap<String, Long>();
            map.put("groupingActivityID", new Long(activityId));
            map.put("grouping", (Long)grouping.getGroupingDTO(true));
            flashMessage = new FlashMessage("performChosenGrouping", map);
        }
        catch (Exception e) {
            log.error((Object)e);
            this.getAuditService().log(PerformChosenGroupingServlet.class.getName(), e.getMessage());
            flashMessage = new FlashMessage("performChosenGrouping", (Object)("Perfrom chosen grouping occurs error:" + e.getMessage()), 1);
        }
        try {
            message = flashMessage.serializeMessage();
        }
        catch (IOException e) {
            message = "Failed on creating flash message:" + flashMessage;
        }
        return message;
    }

    protected String getMessageKey(String packet, HttpServletRequest request) {
        return "performChosenGrouping";
    }

    private IAuditService getAuditService() {
        if (auditService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
            auditService = (IAuditService)ctx.getBean("auditService");
        }
        return auditService;
    }
}

