/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ide;

import com.ibm.ivj.util.base.IvjException;
import com.ibm.ivj.util.base.Package;
import com.ibm.ivj.util.base.Project;
import java.io.File;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.optional.ide.VAJLocalUtil;

class VAJWorkspaceScanner
extends DirectoryScanner {
    private static final String[] DEFAULTEXCLUDES = new String[]{"IBM*/**", "Java class libraries/**", "Sun class libraries*/**", "JSP Page Compile Generated Code/**", "VisualAge*/**"};
    private Vector packagesIncluded = new Vector();

    VAJWorkspaceScanner() {
    }

    public void addDefaultExcludes() {
        int excludesLength = this.excludes == null ? 0 : this.excludes.length;
        String[] newExcludes = new String[excludesLength + DEFAULTEXCLUDES.length];
        if (excludesLength > 0) {
            System.arraycopy(this.excludes, 0, newExcludes, 0, excludesLength);
        }
        int i = 0;
        while (i < DEFAULTEXCLUDES.length) {
            newExcludes[i + excludesLength] = DEFAULTEXCLUDES[i].replace('/', File.separatorChar).replace('\\', File.separatorChar);
            ++i;
        }
        this.excludes = newExcludes;
    }

    public Vector findMatchingProjects() {
        Project[] projects = VAJLocalUtil.getWorkspace().getProjects();
        Vector<Project> matchingProjects = new Vector<Project>();
        boolean allProjectsMatch = false;
        int i = 0;
        while (i < projects.length) {
            Project project = projects[i];
            int j = 0;
            while (j < this.includes.length && !allProjectsMatch) {
                StringTokenizer tok = new StringTokenizer(this.includes[j], File.separator);
                String projectNamePattern = tok.nextToken();
                if (projectNamePattern.equals("**")) {
                    allProjectsMatch = true;
                } else if (DirectoryScanner.match((String)projectNamePattern, (String)project.getName())) {
                    matchingProjects.addElement(project);
                    break;
                }
                ++j;
            }
            ++i;
        }
        if (allProjectsMatch) {
            matchingProjects = new Vector();
            int i2 = 0;
            while (i2 < projects.length) {
                matchingProjects.addElement(projects[i2]);
                ++i2;
            }
        }
        return matchingProjects;
    }

    public Package[] getIncludedPackages() {
        int count = this.packagesIncluded.size();
        Package[] packages = new Package[count];
        int i = 0;
        while (i < count) {
            packages[i] = (Package)this.packagesIncluded.elementAt(i);
            ++i;
        }
        return packages;
    }

    public void scan() {
        if (this.includes == null) {
            this.includes = new String[1];
            this.includes[0] = "**";
        }
        if (this.excludes == null) {
            this.excludes = new String[0];
        }
        Vector matchingProjects = this.findMatchingProjects();
        Enumeration e = matchingProjects.elements();
        while (e.hasMoreElements()) {
            Project project = (Project)e.nextElement();
            this.scanProject(project);
        }
    }

    public void scanProject(Project project) {
        try {
            Package[] packages = project.getPackages();
            if (packages != null) {
                int i = 0;
                while (i < packages.length) {
                    Package item = packages[i];
                    String name = project.getName() + File.separator + item.getName().replace('.', File.separatorChar);
                    if (this.isIncluded(name) && !this.isExcluded(name)) {
                        this.packagesIncluded.addElement(item);
                    }
                    ++i;
                }
            }
        }
        catch (IvjException e) {
            throw VAJLocalUtil.createBuildException("VA Exception occurred: ", e);
        }
    }
}

