/*
 * Decompiled with CFR 0.152.
 */
package org.imsglobal.lti;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthException;
import net.oauth.OAuthMessage;
import net.oauth.SimpleOAuthValidator;
import net.oauth.server.OAuthServlet;
import net.oauth.signature.OAuthSignatureMethod;
import org.apache.commons.lang.StringUtils;
import org.imsglobal.lti.BasicLTIConstants;
import org.imsglobal.lti.XMLMap;
import org.imsglobal.lti.launch.LtiError;
import org.imsglobal.lti.launch.LtiLaunch;
import org.imsglobal.lti.launch.LtiVerificationResult;

public class BasicLTIUtil {
    private static Logger M_log = Logger.getLogger(BasicLTIUtil.class.toString());
    private static boolean verbosePrint = false;
    public static final String BASICLTI_SUBMIT = "ext_basiclti_submit";
    private static final Pattern CUSTOM_REGEX = Pattern.compile("[^A-Za-z0-9]");
    private static final String UNDERSCORE = "_";

    public static void dPrint(String str) {
        if (verbosePrint) {
            System.out.println(str);
        }
        M_log.fine(str);
    }

    public static LtiVerificationResult validateMessage(HttpServletRequest request, String URL2, String oauth_secret) {
        OAuthMessage oam = OAuthServlet.getMessage((HttpServletRequest)request, (String)URL2);
        String oauth_consumer_key = null;
        try {
            oauth_consumer_key = oam.getConsumerKey();
        }
        catch (Exception e) {
            return new LtiVerificationResult(false, LtiError.BAD_REQUEST, "Unable to find consumer key in message");
        }
        SimpleOAuthValidator oav = new SimpleOAuthValidator();
        OAuthConsumer cons = new OAuthConsumer("about:blank#OAuth+CallBack+NotUsed", oauth_consumer_key, oauth_secret, null);
        OAuthAccessor acc = new OAuthAccessor(cons);
        String base_string = null;
        try {
            base_string = OAuthSignatureMethod.getBaseString((OAuthMessage)oam);
        }
        catch (IOException e) {
            return new LtiVerificationResult(false, LtiError.BAD_REQUEST, "Unable to find base string");
        }
        catch (URISyntaxException e) {
            return new LtiVerificationResult(false, LtiError.BAD_REQUEST, "Unable to find base string");
        }
        try {
            oav.validateMessage(oam, acc);
        }
        catch (Exception e) {
            if (base_string != null) {
                return new LtiVerificationResult(false, LtiError.BAD_REQUEST, "Failed to validate: " + e.getLocalizedMessage() + "\nBase String\n" + base_string);
            }
            return new LtiVerificationResult(false, LtiError.BAD_REQUEST, "Failed to validate: " + e.getLocalizedMessage());
        }
        return new LtiVerificationResult(true, new LtiLaunch(request));
    }

    public static String validateDescriptor(String descriptor) {
        if (descriptor == null) {
            return null;
        }
        if (descriptor.indexOf("<basic_lti_link") < 0) {
            return null;
        }
        Map<String, Object> tm = XMLMap.getFullMap(descriptor.trim());
        if (tm == null) {
            return null;
        }
        String ltiSecureLaunch = XMLMap.getString(tm, "/basic_lti_link/secure_launch_url");
        if (ltiSecureLaunch != null && ltiSecureLaunch.trim().length() > 0) {
            return ltiSecureLaunch;
        }
        String ltiLaunch = XMLMap.getString(tm, "/basic_lti_link/launch_url");
        if (ltiLaunch != null && ltiLaunch.trim().length() > 0) {
            return ltiLaunch;
        }
        return null;
    }

    public static Map<String, String> cleanupProperties(Map<String, String> rawProperties) {
        return BasicLTIUtil.cleanupProperties(rawProperties, null);
    }

    public static Map<String, String> cleanupProperties(Map<String, String> rawProperties, String[] blackList) {
        HashMap<String, String> newProp = new HashMap<String, String>(rawProperties.size());
        for (String okey : rawProperties.keySet()) {
            String value;
            String key = okey.trim();
            if (blackList != null) {
                boolean blackListed = false;
                for (String blackKey : blackList) {
                    if (!blackKey.equals(key)) continue;
                    blackListed = true;
                    break;
                }
                if (blackListed) continue;
            }
            if ((value = rawProperties.get(key)) == null || "".equals(value)) continue;
            if (BasicLTIUtil.isSpecifiedPropertyName(key)) {
                newProp.put(key, value);
                continue;
            }
            newProp.put(BasicLTIUtil.adaptToCustomPropertyName(key), value);
        }
        return newProp;
    }

    public static Properties cleanupProperties(Properties rawProperties) {
        Map<String, String> map = BasicLTIUtil.cleanupProperties(BasicLTIUtil.convertToMap(rawProperties), null);
        return BasicLTIUtil.convertToProperties(map);
    }

    public static boolean isSpecifiedPropertyName(String propertyName) {
        boolean found = false;
        if (propertyName.startsWith("custom_")) {
            return true;
        }
        if (propertyName.startsWith("ext_")) {
            return true;
        }
        if (propertyName.startsWith("oauth_")) {
            return true;
        }
        for (String key : BasicLTIConstants.validPropertyNames) {
            if (!key.equals(propertyName)) continue;
            found = true;
            break;
        }
        return found;
    }

    public static String adaptToCustomPropertyName(String propertyName) {
        if (propertyName == null || "".equals(propertyName)) {
            throw new IllegalArgumentException("propertyName cannot be null");
        }
        String customName = propertyName.toLowerCase();
        if (!(customName = CUSTOM_REGEX.matcher(customName).replaceAll(UNDERSCORE)).startsWith("custom_")) {
            customName = "custom_" + customName;
        }
        return customName;
    }

    public static Properties signProperties(Properties postProp, String url, String method, String oauth_consumer_key, String oauth_consumer_secret, String org_id, String org_desc, String org_url) {
        Map<String, String> signedMap = BasicLTIUtil.signProperties(BasicLTIUtil.convertToMap(postProp), url, method, oauth_consumer_key, oauth_consumer_secret, org_id, org_desc, org_url, null, null);
        return BasicLTIUtil.convertToProperties(signedMap);
    }

    public static Map<String, String> signProperties(Map<String, String> postProp, String url, String method, String oauth_consumer_key, String oauth_consumer_secret, String tool_consumer_instance_guid, String tool_consumer_instance_description, String tool_consumer_instance_url, String tool_consumer_instance_name, String tool_consumer_instance_contact_email) {
        if ((postProp = BasicLTIUtil.cleanupProperties(postProp)).get("lti_version") == null) {
            postProp.put("lti_version", "LTI-1p0");
        }
        if (postProp.get("lti_message_type") == null) {
            postProp.put("lti_message_type", "basic-lti-launch-request");
        }
        if (postProp.get(BASICLTI_SUBMIT) == null) {
            postProp.put(BASICLTI_SUBMIT, "Launch Endpoint with BasicLTI Data");
        }
        if (tool_consumer_instance_guid != null) {
            postProp.put("tool_consumer_instance_guid", tool_consumer_instance_guid);
        }
        if (tool_consumer_instance_description != null) {
            postProp.put("tool_consumer_instance_description", tool_consumer_instance_description);
        }
        if (tool_consumer_instance_url != null) {
            postProp.put("tool_consumer_instance_url", tool_consumer_instance_url);
        }
        if (tool_consumer_instance_name != null) {
            postProp.put("tool_consumer_instance_name", tool_consumer_instance_name);
        }
        if (tool_consumer_instance_contact_email != null) {
            postProp.put("tool_consumer_instance_contact_email", tool_consumer_instance_contact_email);
        }
        if (postProp.get("oauth_callback") == null) {
            postProp.put("oauth_callback", "about:blank");
        }
        if (oauth_consumer_key == null || oauth_consumer_secret == null) {
            BasicLTIUtil.dPrint("No signature generated in signProperties");
            return postProp;
        }
        OAuthMessage oam = new OAuthMessage(method, url, postProp.entrySet());
        OAuthConsumer cons = new OAuthConsumer("about:blank", oauth_consumer_key, oauth_consumer_secret, null);
        OAuthAccessor acc = new OAuthAccessor(cons);
        try {
            oam.addRequiredParameters(acc);
            List params = oam.getParameters();
            HashMap<String, String> nextProp = new HashMap<String, String>();
            for (Map.Entry entry : params) {
                nextProp.put((String)entry.getKey(), (String)entry.getValue());
            }
            return nextProp;
        }
        catch (OAuthException e) {
            M_log.warning("BasicLTIUtil.signProperties OAuth Exception " + e.getMessage());
            throw new Error(e);
        }
        catch (IOException e) {
            M_log.warning("BasicLTIUtil.signProperties IO Exception " + e.getMessage());
            throw new Error(e);
        }
        catch (URISyntaxException e) {
            M_log.warning("BasicLTIUtil.signProperties URI Syntax Exception " + e.getMessage());
            throw new Error(e);
        }
    }

    public static boolean checkProperties(Properties postProp, String url, String method, String oauth_consumer_key, String oauth_consumer_secret) {
        return BasicLTIUtil.checkProperties(BasicLTIUtil.convertToMap(postProp), url, method, oauth_consumer_key, oauth_consumer_secret);
    }

    public static boolean checkProperties(Map<String, String> postProp, String url, String method, String oauth_consumer_key, String oauth_consumer_secret) {
        OAuthMessage oam = new OAuthMessage(method, url, postProp.entrySet());
        OAuthConsumer cons = new OAuthConsumer("about:blank", oauth_consumer_key, oauth_consumer_secret, null);
        SimpleOAuthValidator oav = new SimpleOAuthValidator();
        OAuthAccessor acc = new OAuthAccessor(cons);
        String base_string = null;
        try {
            base_string = OAuthSignatureMethod.getBaseString((OAuthMessage)oam);
        }
        catch (Exception e) {
            M_log.warning(e.getLocalizedMessage());
            base_string = null;
            return false;
        }
        try {
            oav.validateMessage(oam, acc);
        }
        catch (Exception e) {
            M_log.warning("Provider failed to validate message");
            M_log.warning(e.getLocalizedMessage());
            if (base_string != null) {
                M_log.warning(base_string);
            }
            return false;
        }
        return true;
    }

    public static String postLaunchHTML(Properties cleanProperties, String endpoint, boolean debug) {
        Map<String, String> map = BasicLTIUtil.convertToMap(cleanProperties);
        return BasicLTIUtil.postLaunchHTML(map, endpoint, debug);
    }

    public static String postLaunchHTML(Map<String, String> cleanProperties, String endpoint, boolean debug) {
        String value;
        String key;
        if (cleanProperties == null || cleanProperties.isEmpty()) {
            throw new IllegalArgumentException("cleanProperties == null || cleanProperties.isEmpty()");
        }
        if (endpoint == null) {
            throw new IllegalArgumentException("endpoint == null");
        }
        Map<String, String> newMap = null;
        newMap = debug ? new TreeMap<String, String>(cleanProperties) : cleanProperties;
        StringBuilder text = new StringBuilder();
        text.append("<div id=\"ltiLaunchFormSubmitArea\">\n");
        text.append("<form action=\"");
        text.append(endpoint);
        text.append("\" name=\"ltiLaunchForm\" id=\"ltiLaunchForm\" method=\"post\" ");
        text.append(" encType=\"application/x-www-form-urlencoded\" accept-charset=\"utf-8\">\n");
        for (Map.Entry<String, String> entry : newMap.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            if (value == null) continue;
            key = BasicLTIUtil.htmlspecialchars(key);
            value = BasicLTIUtil.htmlspecialchars(value);
            if (key.equals(BASICLTI_SUBMIT)) {
                text.append("<input type=\"submit\" name=\"");
            } else {
                text.append("<input type=\"hidden\" name=\"");
            }
            text.append(key);
            text.append("\" value=\"");
            text.append(value);
            text.append("\"/>\n");
        }
        text.append("</form>\n");
        text.append("</div>\n");
        text.append("<script type=\"text/javascript\">\n");
        text.append("if (window.top!=window.self) {\n");
        text.append("  theform = document.getElementById('ltiLaunchForm');\n");
        text.append("  if ( theform && theform.action ) {\n");
        text.append("   formAction = theform.action;\n");
        text.append("   ourUrl = window.location.href;\n");
        text.append("   if ( formAction.indexOf('http://') == 0 && ourUrl.indexOf('https://') == 0 ) {\n");
        text.append("      theform.target = '_blank';\n");
        text.append("      window.console && console.log('Launching http from https in new window!');\n");
        text.append("    }\n");
        text.append("  }\n");
        text.append("}\n");
        text.append("</script>\n");
        if (debug) {
            text.append("<pre>\n");
            text.append("<b>BasicLTI Endpoint</b>\n");
            text.append(endpoint);
            text.append("\n\n");
            text.append("<b>BasicLTI Parameters:</b>\n");
            for (Map.Entry<String, String> entry : newMap.entrySet()) {
                key = entry.getKey();
                value = entry.getValue();
                if (value == null) continue;
                text.append(BasicLTIUtil.htmlspecialchars(key));
                text.append("=");
                text.append(BasicLTIUtil.htmlspecialchars(value));
                text.append("\n");
            }
            text.append("</pre>\n");
        } else {
            text.append(" <script language=\"javascript\"> \n\tdocument.getElementById(\"ltiLaunchFormSubmitArea\").style.display = \"none\";\n\tnei = document.createElement('input');\n\tnei.setAttribute('type', 'hidden');\n\tnei.setAttribute('name', 'ext_basiclti_submit');\n\tnei.setAttribute('value', '" + newMap.get(BASICLTI_SUBMIT) + "');\n" + "\tdocument.getElementById(\"ltiLaunchForm\").appendChild(nei);\n" + "\tdocument.ltiLaunchForm.submit(); \n" + " </script> \n");
        }
        String htmltext = text.toString();
        return htmltext;
    }

    public static boolean parseDescriptor(Properties launch_info, Properties postProp, String descriptor) {
        Map<String, Object> tm = null;
        try {
            tm = XMLMap.getFullMap(descriptor.trim());
        }
        catch (Exception e) {
            M_log.warning("BasicLTIUtil exception parsing BasicLTI descriptor: " + e.getMessage());
            return false;
        }
        if (tm == null) {
            M_log.warning("Unable to parse XML in parseDescriptor");
            return false;
        }
        String launch_url = StringUtils.stripToNull((String)XMLMap.getString(tm, "/basic_lti_link/launch_url"));
        String secure_launch_url = StringUtils.stripToNull((String)XMLMap.getString(tm, "/basic_lti_link/secure_launch_url"));
        if (launch_url == null && secure_launch_url == null) {
            return false;
        }
        BasicLTIUtil.setProperty(launch_info, "launch_url", launch_url);
        BasicLTIUtil.setProperty(launch_info, "secure_launch_url", secure_launch_url);
        BasicLTIUtil.setProperty(launch_info, "key", StringUtils.stripToNull((String)XMLMap.getString(tm, "/basic_lti_link/x-secure/launch_key")));
        BasicLTIUtil.setProperty(launch_info, "secret", StringUtils.stripToNull((String)XMLMap.getString(tm, "/basic_lti_link/x-secure/launch_secret")));
        List<Map<String, Object>> theList = XMLMap.getList(tm, "/basic_lti_link/custom/parameter");
        for (Map<String, Object> setting : theList) {
            BasicLTIUtil.dPrint("Setting=" + setting);
            String key = XMLMap.getString(setting, "/!key");
            String value = XMLMap.getString(setting, "/");
            if (key == null || value == null) continue;
            key = "custom_" + BasicLTIUtil.mapKeyName(key);
            BasicLTIUtil.dPrint("key=" + key + " val=" + value);
            postProp.setProperty(key, value);
        }
        return true;
    }

    public static boolean parseDescriptor(Map<String, String> launch_info, Map<String, String> postProp, String descriptor) {
        Map<String, Object> tm = null;
        try {
            tm = XMLMap.getFullMap(descriptor.trim());
        }
        catch (Exception e) {
            M_log.warning("BasicLTIUtil exception parsing BasicLTI descriptor: " + e.getMessage());
            return false;
        }
        if (tm == null) {
            M_log.warning("Unable to parse XML in parseDescriptor");
            return false;
        }
        String launch_url = StringUtils.stripToNull((String)XMLMap.getString(tm, "/basic_lti_link/launch_url"));
        String secure_launch_url = StringUtils.stripToNull((String)XMLMap.getString(tm, "/basic_lti_link/secure_launch_url"));
        if (launch_url == null && secure_launch_url == null) {
            return false;
        }
        BasicLTIUtil.setProperty(launch_info, "launch_url", launch_url);
        BasicLTIUtil.setProperty(launch_info, "secure_launch_url", secure_launch_url);
        BasicLTIUtil.setProperty(launch_info, "key", StringUtils.stripToNull((String)XMLMap.getString(tm, "/basic_lti_link/x-secure/launch_key")));
        BasicLTIUtil.setProperty(launch_info, "secret", StringUtils.stripToNull((String)XMLMap.getString(tm, "/basic_lti_link/x-secure/launch_secret")));
        List<Map<String, Object>> theList = XMLMap.getList(tm, "/basic_lti_link/custom/parameter");
        for (Map<String, Object> setting : theList) {
            BasicLTIUtil.dPrint("Setting=" + setting);
            String key = XMLMap.getString(setting, "/!key");
            String value = XMLMap.getString(setting, "/");
            if (key == null || value == null) continue;
            key = "custom_" + BasicLTIUtil.mapKeyName(key);
            BasicLTIUtil.dPrint("key=" + key + " val=" + value);
            postProp.put(key, value);
        }
        return true;
    }

    public static String prepareForExport(String descriptor) {
        Map<String, Object> tm = null;
        try {
            tm = XMLMap.getFullMap(descriptor.trim());
        }
        catch (Exception e) {
            M_log.warning("BasicLTIUtil exception parsing BasicLTI descriptor" + e.getMessage());
            return null;
        }
        if (tm == null) {
            M_log.warning("Unable to parse XML in prepareForExport");
            return null;
        }
        XMLMap.removeSubMap(tm, "/basic_lti_link/x-secure");
        String retval = XMLMap.getXML(tm, true);
        return retval;
    }

    public static String mapKeyName(String keyname) {
        StringBuffer sb = new StringBuffer();
        if (keyname == null) {
            return null;
        }
        if ((keyname = keyname.trim()).length() < 1) {
            return null;
        }
        for (int i = 0; i < keyname.length(); ++i) {
            Character ch = Character.valueOf(Character.toLowerCase(keyname.charAt(i)));
            if (Character.isLetter(ch.charValue()) || Character.isDigit(ch.charValue())) {
                sb.append(ch);
                continue;
            }
            sb.append('_');
        }
        return sb.toString();
    }

    public static void setProperty(Map<String, String> map, String key, String value) {
        if (value != null && !"".equals(value)) {
            map.put(key, value);
        }
    }

    public static void setProperty(Properties props, String key, String value) {
        if (value == null) {
            return;
        }
        if (value.trim().length() < 1) {
            return;
        }
        props.setProperty(key, value);
    }

    public static String htmlspecialchars(String input) {
        if (input == null) {
            return null;
        }
        String retval = input.replace("&", "&amp;");
        retval = retval.replace("\"", "&quot;");
        retval = retval.replace("<", "&lt;");
        retval = retval.replace(">", "&gt;");
        retval = retval.replace(">", "&gt;");
        retval = retval.replace("=", "&#61;");
        return retval;
    }

    public static String getRealPath(String servletUrl, String extUrl) {
        Pattern pat = Pattern.compile("^https??://[^/]*");
        Matcher m = pat.matcher(extUrl);
        if (m.find()) {
            extUrl = m.group(0);
        }
        String retval = pat.matcher(servletUrl).replaceFirst(extUrl);
        return retval;
    }

    public static String getRealPath(HttpServletRequest request, String extUrl) {
        String URLstr = request.getRequestURL().toString();
        String retval = BasicLTIUtil.getRealPath(URLstr, extUrl);
        return retval;
    }

    public static Map<String, String> convertToMap(Properties properties) {
        HashMap<Object, Object> map = new HashMap<Object, Object>(properties);
        return map;
    }

    public static Properties convertToProperties(Map<String, String> map) {
        Properties properties = new Properties();
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                properties.setProperty(entry.getKey(), entry.getValue());
            }
        }
        return properties;
    }
}

