/*
 * Decompiled with CFR 0.152.
 */
package org.imsglobal.lti.launch;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthException;
import net.oauth.OAuthMessage;
import oauth.signpost.commonshttp.CommonsHttpOAuthConsumer;
import oauth.signpost.exception.OAuthCommunicationException;
import oauth.signpost.exception.OAuthExpectationFailedException;
import oauth.signpost.exception.OAuthMessageSignerException;
import oauth.signpost.http.HttpParameters;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.imsglobal.lti.launch.LtiSigner;
import org.imsglobal.lti.launch.LtiSigningException;

public class LtiOauthSigner
implements LtiSigner {
    private MessageDigest md;

    public LtiOauthSigner() {
        try {
            this.md = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not construct new instance of LtiOauthSigner", e);
        }
    }

    public LtiOauthSigner(MessageDigest md) {
        this.md = md;
    }

    @Override
    public HttpRequest sign(HttpRequest request, String key, String secret) throws LtiSigningException {
        CommonsHttpOAuthConsumer signer = new CommonsHttpOAuthConsumer(key, secret);
        try {
            String body = this.getRequestBody(request);
            String bodyHash = new String(Base64.encodeBase64((byte[])this.md.digest(body.getBytes())));
            HttpParameters params = new HttpParameters();
            params.put("oauth_body_hash", URLEncoder.encode(bodyHash, "UTF-8"));
            signer.setAdditionalParameters(params);
            signer.sign((Object)request);
        }
        catch (OAuthMessageSignerException e) {
            throw new LtiSigningException("Exception encountered while singing Lti request...", (Exception)((Object)e));
        }
        catch (OAuthExpectationFailedException e) {
            throw new LtiSigningException("Exception encountered while singing Lti request...", (Exception)((Object)e));
        }
        catch (OAuthCommunicationException e) {
            throw new LtiSigningException("Exception encountered while singing Lti request...", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new LtiSigningException("Exception encountered while singing Lti request...", e);
        }
        return request;
    }

    @Override
    public Map<String, String> signParameters(Map<String, String> parameters, String key, String secret, String url, String method) throws LtiSigningException {
        OAuthMessage oam = new OAuthMessage(method, url, parameters.entrySet());
        OAuthConsumer cons = new OAuthConsumer(null, key, secret, null);
        OAuthAccessor acc = new OAuthAccessor(cons);
        try {
            oam.addRequiredParameters(acc);
            HashMap<String, String> signedParameters = new HashMap<String, String>();
            for (Map.Entry param : oam.getParameters()) {
                signedParameters.put((String)param.getKey(), (String)param.getValue());
            }
            return signedParameters;
        }
        catch (OAuthException e) {
            throw new LtiSigningException("Error signing LTI request.", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new LtiSigningException("Error signing LTI request.", e);
        }
        catch (URISyntaxException e) {
            throw new LtiSigningException("Error signing LTI request.", e);
        }
    }

    private String getRequestBody(HttpRequest req) throws IOException {
        if (req instanceof HttpEntityEnclosingRequest) {
            HttpEntity body = ((HttpEntityEnclosingRequest)req).getEntity();
            if (body == null) {
                return "";
            }
            return IOUtils.toString((InputStream)body.getContent());
        }
        return "";
    }
}

