/*
 * Decompiled with CFR 0.152.
 */
package org.imsglobal.pox;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthMessage;
import net.oauth.SimpleOAuthValidator;
import net.oauth.server.OAuthServlet;
import net.oauth.signature.OAuthSignatureMethod;
import oauth.signpost.commonshttp.CommonsHttpOAuthConsumer;
import oauth.signpost.exception.OAuthException;
import oauth.signpost.http.HttpParameters;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.imsglobal.lti.XMLMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class IMSPOXRequest {
    private static final Logger Log = Logger.getLogger(IMSPOXRequest.class.getName());
    public static final String MAJOR_SUCCESS = "success";
    public static final String MAJOR_FAILURE = "failure";
    public static final String MAJOR_UNSUPPORTED = "unsupported";
    public static final String MAJOR_PROCESSING = "processing";
    public static final String[] validMajor = new String[]{"success", "failure", "unsupported", "processing"};
    public static final String SEVERITY_ERROR = "error";
    public static final String SEVERITY_WARNING = "warning";
    public static final String SEVERITY_STATUS = "status";
    public static final String[] validSeverity = new String[]{"error", "warning", "status"};
    public static final String MINOR_FULLSUCCESS = "fullsuccess";
    public static final String MINOR_NOSOURCEDIDS = "nosourcedids";
    public static final String MINOR_IDALLOC = "idalloc";
    public static final String MINOR_OVERFLOWFAIL = "overflowfail";
    public static final String MINOR_IDALLOCINUSEFAIL = "idallocinusefail";
    public static final String MINOR_INVALIDDATAFAIL = "invaliddata";
    public static final String MINOR_INCOMPLETEDATA = "incompletedata";
    public static final String MINOR_PARTIALSTORAGE = "partialdatastorage";
    public static final String MINOR_UNKNOWNOBJECT = "unknownobject";
    public static final String MINOR_DELETEFAILURE = "deletefailure";
    public static final String MINOR_TARGETREADFAILURE = "targetreadfailure";
    public static final String MINOR_SAVEPOINTERROR = "savepointerror";
    public static final String MINOR_SAVEPOINTSYNCERROR = "savepointsyncerror";
    public static final String MINOR_UNKNOWNQUERY = "unknownquery";
    public static final String MINOR_UNKNOWNVOCAB = "unknownvocab";
    public static final String MINOR_TARGETISBUSY = "targetisbusy";
    public static final String MINOR_UNKNOWNEXTENSION = "unknownextension";
    public static final String MINOR_UNAUTHORIZEDREQUEST = "unauthorizedrequest";
    public static final String MINOR_LINKFAILURE = "linkfailure";
    public static final String MINOR_UNSUPPORTED = "unsupported";
    public static final String[] validMinor = new String[]{"fullsuccess", "nosourcedids", "idalloc", "overflowfail", "idallocinusefail", "invaliddata", "incompletedata", "partialdatastorage", "unknownobject", "deletefailure", "targetreadfailure", "savepointerror", "savepointsyncerror", "unknownquery", "unknownvocab", "targetisbusy", "unknownextension", "unauthorizedrequest", "linkfailure", "unsupported"};
    public Document postDom = null;
    public Element bodyElement = null;
    public Element headerElement = null;
    public String postBody = null;
    private String header = null;
    private String oauth_body_hash = null;
    private String oauth_consumer_key = null;
    public boolean valid = false;
    private String operation = null;
    public String errorMessage = null;
    public String base_string = null;
    private Map<String, String> bodyMap = null;
    private Map<String, String> headerMap = null;
    static final String fatalMessage = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<imsx_POXEnvelopeResponse xmlns = \"http://www.imsglobal.org/services/ltiv1p1/xsd/imsoms_v1p0\">\n    <imsx_POXHeader>\n        <imsx_POXResponseHeaderInfo>\n            <imsx_version>V1.0</imsx_version>\n            <imsx_messageIdentifier>%s</imsx_messageIdentifier>\n            <imsx_statusInfo>\n                <imsx_codeMajor>failure</imsx_codeMajor>\n                <imsx_severity>error</imsx_severity>\n                <imsx_description>%s</imsx_description>\n                <imsx_operationRefIdentifier>%s</imsx_operationRefIdentifier>            </imsx_statusInfo>\n        </imsx_POXResponseHeaderInfo>\n    </imsx_POXHeader>\n    <imsx_POXBody/>\n</imsx_POXEnvelopeResponse>";
    static final String responseMessage = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<imsx_POXEnvelopeResponse xmlns = \"http://www.imsglobal.org/services/ltiv1p1/xsd/imsoms_v1p0\">\n  <imsx_POXHeader>\n    <imsx_POXResponseHeaderInfo>\n      <imsx_version>V1.0</imsx_version>\n      <imsx_messageIdentifier>%s</imsx_messageIdentifier>\n      <imsx_statusInfo>\n        <imsx_codeMajor>%s</imsx_codeMajor>\n        <imsx_severity>%s</imsx_severity>\n        <imsx_description>%s</imsx_description>\n        <imsx_messageRefIdentifier>%s</imsx_messageRefIdentifier>\n        <imsx_operationRefIdentifier>%s</imsx_operationRefIdentifier>%s\n      </imsx_statusInfo>\n    </imsx_POXResponseHeaderInfo>\n  </imsx_POXHeader>\n  <imsx_POXBody>\n%s%s  </imsx_POXBody>\n</imsx_POXEnvelopeResponse>";
    public static final String replaceResultMessage = "<?xml version = \"1.0\" encoding = \"UTF-8\"?><imsx_POXEnvelopeRequest xmlns=\"http://www.imsglobal.org/services/ltiv1p1/xsd/imsoms_v1p0\">\t<imsx_POXHeader>\t\t<imsx_POXRequestHeaderInfo>\t\t\t<imsx_version>V1.0</imsx_version>\t\t</imsx_POXRequestHeaderInfo>\t</imsx_POXHeader>\t<imsx_POXBody>\t\t<replaceResultRequest>\t\t\t<resultRecord>\t\t\t\t<sourcedGUID>\t\t\t\t\t<sourcedId>%s</sourcedId>\t\t\t\t</sourcedGUID>\t\t\t\t<result>\t\t\t\t\t<resultScore>\t\t\t\t\t\t<textString>%s</textString>\t\t\t\t\t</resultScore>\t\t\t\t\t%s\t\t\t\t</result>\t\t\t</resultRecord>\t\t</replaceResultRequest>\t</imsx_POXBody></imsx_POXEnvelopeRequest>";
    static final String resultDataText = "<resultData><text>%s</text></resultData>";
    static final String resultDataUrl = "<resultData><url>%s</url></resultData>";

    public String getOperation() {
        return this.operation;
    }

    public String getOAuthConsumerKey() {
        return this.oauth_consumer_key;
    }

    public String getHeaderVersion() {
        return this.getHeaderItem("/imsx_version");
    }

    public String getHeaderMessageIdentifier() {
        return this.getHeaderItem("/imsx_messageIdentifier");
    }

    public String getHeaderItem(String path) {
        if (this.getHeaderMap() == null) {
            return null;
        }
        return this.headerMap.get(path);
    }

    public Map<String, String> getHeaderMap() {
        if (this.headerMap != null) {
            return this.headerMap;
        }
        if (this.headerElement == null) {
            return null;
        }
        this.headerMap = XMLMap.getMap(this.headerElement);
        return this.headerMap;
    }

    public Map<String, String> getBodyMap() {
        if (this.bodyMap != null) {
            return this.bodyMap;
        }
        if (this.bodyElement == null) {
            return null;
        }
        this.bodyMap = XMLMap.getMap(this.bodyElement);
        return this.bodyMap;
    }

    public String getPostBody() {
        return this.postBody;
    }

    public IMSPOXRequest(String oauth_consumer_key, String oauth_secret, HttpServletRequest request) {
        this.loadFromRequest(request);
        if (!this.valid) {
            return;
        }
        this.validateRequest(oauth_consumer_key, oauth_secret, request);
    }

    public IMSPOXRequest(HttpServletRequest request) {
        this.loadFromRequest(request);
    }

    public IMSPOXRequest(String bodyString) {
        this.postBody = bodyString;
        this.parsePostBody();
    }

    public void loadFromRequest(HttpServletRequest request) {
        String contentType = request.getContentType();
        if (!"application/xml".equals(contentType)) {
            this.errorMessage = "Content Type must be application/xml";
            Log.info(this.errorMessage + "\n" + contentType);
            return;
        }
        this.setAuthHeader(request.getHeader("Authorization"));
        if (this.oauth_body_hash == null) {
            this.errorMessage = "Did not find oauth_body_hash";
            Log.info(this.errorMessage + "\n" + this.header);
            return;
        }
        try {
            BufferedReader in = request.getReader();
            this.postBody = IMSPOXRequest.readPostBody(in);
        }
        catch (Exception e) {
            this.errorMessage = "Could not read message body:" + e.getMessage();
            return;
        }
        this.validatePostBody();
        if (this.errorMessage != null) {
            return;
        }
        this.parsePostBody();
    }

    public void setAuthHeader(String header) {
        this.header = header;
        this.oauth_body_hash = null;
        if (header != null) {
            String[] parms;
            if (header.startsWith("OAuth ")) {
                header = header.substring(5);
            }
            for (String parm : parms = header.split(",")) {
                String[] pieces;
                if ((parm = parm.trim()).startsWith("oauth_body_hash=")) {
                    pieces = parm.split("\"");
                    this.oauth_body_hash = URLDecoder.decode(pieces[1]);
                }
                if (!parm.startsWith("oauth_consumer_key=")) continue;
                pieces = parm.split("\"");
                this.oauth_consumer_key = URLDecoder.decode(pieces[1]);
            }
        }
    }

    public static String readPostBody(Reader in) throws IOException {
        int read;
        char[] buffer = new char[65536];
        StringBuilder out = new StringBuilder();
        do {
            if ((read = in.read(buffer, 0, buffer.length)) <= 0) continue;
            out.append(buffer, 0, read);
        } while (read >= 0);
        return out.toString();
    }

    public static String getBodyHash(String postBody) throws GeneralSecurityException {
        MessageDigest md = MessageDigest.getInstance("SHA1");
        md.update(postBody.getBytes());
        byte[] output = Base64.encodeBase64((byte[])md.digest());
        return new String(output);
    }

    public void validatePostBody() {
        try {
            String hash = IMSPOXRequest.getBodyHash(this.postBody);
            if (!hash.equals(this.oauth_body_hash)) {
                this.errorMessage = "Body hash does not match header";
                return;
            }
        }
        catch (Exception e) {
            this.errorMessage = "Could not compute body hash";
            return;
        }
    }

    public void parsePostBody() {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.postDom = db.parse(new ByteArrayInputStream(this.postBody.getBytes()));
        }
        catch (Exception e) {
            this.errorMessage = "Could not parse XML: " + e.getMessage();
            return;
        }
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            XPathExpression expr = xpath.compile("/imsx_POXEnvelopeRequest/imsx_POXBody/*");
            Object result = expr.evaluate(this.postDom, XPathConstants.NODESET);
            NodeList nodes = (NodeList)result;
            this.bodyElement = (Element)nodes.item(0);
            this.operation = this.bodyElement.getNodeName();
            expr = xpath.compile("/imsx_POXEnvelopeRequest/imsx_POXHeader/*");
            result = expr.evaluate(this.postDom, XPathConstants.NODESET);
            nodes = (NodeList)result;
            this.headerElement = (Element)nodes.item(0);
        }
        catch (XPathExpressionException e) {
            this.errorMessage = "Could not parse XPATH: " + e.getMessage();
            return;
        }
        catch (Exception e) {
            this.errorMessage = "Could not parse input XML: " + e.getMessage();
            return;
        }
        if (this.operation == null || this.bodyElement == null) {
            this.errorMessage = "Could not find operation";
            return;
        }
        this.valid = true;
    }

    public void validateRequest(String oauth_consumer_key, String oauth_secret, HttpServletRequest request) {
        this.validateRequest(oauth_consumer_key, oauth_secret, request, null);
    }

    public void validateRequest(String oauth_consumer_key, String oauth_secret, HttpServletRequest request, String URL2) {
        this.valid = false;
        OAuthMessage oam = OAuthServlet.getMessage((HttpServletRequest)request, (String)URL2);
        SimpleOAuthValidator oav = new SimpleOAuthValidator();
        OAuthConsumer cons = new OAuthConsumer("about:blank#OAuth+CallBack+NotUsed", oauth_consumer_key, oauth_secret, null);
        OAuthAccessor acc = new OAuthAccessor(cons);
        try {
            this.base_string = OAuthSignatureMethod.getBaseString((OAuthMessage)oam);
        }
        catch (Exception e) {
            this.base_string = null;
        }
        try {
            oav.validateMessage(oam, acc);
        }
        catch (Exception e) {
            this.errorMessage = "Launch fails OAuth validation: " + e.getMessage();
            return;
        }
        this.valid = true;
    }

    public static String fetchTag(Element element, String tag) {
        try {
            Element e;
            NodeList elements = element.getElementsByTagName(tag);
            int numElements = elements.getLength();
            if (numElements > 0 && (e = (Element)elements.item(0)).hasChildNodes()) {
                return e.getFirstChild().getNodeValue();
            }
        }
        catch (Throwable t) {
            Log.warning(t.getMessage());
        }
        return null;
    }

    public boolean inArray(String[] theArray, String theString) {
        if (theString == null) {
            return false;
        }
        for (String str : theArray) {
            if (!theString.equals(str)) continue;
            return true;
        }
        return false;
    }

    public static String getFatalResponse(String description) {
        return IMSPOXRequest.getFatalResponse(description, "unknown");
    }

    public static String getFatalResponse(String description, String message_id) {
        Date dt = new Date();
        String messageId = "" + dt.getTime();
        return String.format(fatalMessage, StringEscapeUtils.escapeXml((String)messageId), StringEscapeUtils.escapeXml((String)description), StringEscapeUtils.escapeXml((String)message_id));
    }

    public String getResponseUnsupported(String desc) {
        return this.getResponse(desc, "unsupported", null, null, null, null);
    }

    public String getResponseFailure(String desc, Properties minor) {
        return this.getResponse(desc, null, null, null, minor, null);
    }

    public String getResponseFailure(String desc, Properties minor, String bodyString) {
        return this.getResponse(desc, null, null, null, minor, bodyString);
    }

    public String getResponseSuccess(String desc, String bodyString) {
        return this.getResponse(desc, MAJOR_SUCCESS, null, null, null, bodyString);
    }

    public String getResponse(String description, String major, String severity, String messageId, Properties minor, String bodyString) {
        int pos;
        StringBuffer internalError = new StringBuffer();
        if (major == null) {
            major = MAJOR_FAILURE;
        }
        if (severity == null && MAJOR_PROCESSING.equals(major)) {
            severity = SEVERITY_STATUS;
        }
        if (severity == null && MAJOR_SUCCESS.equals(major)) {
            severity = SEVERITY_STATUS;
        }
        if (severity == null) {
            severity = SEVERITY_ERROR;
        }
        if (messageId == null) {
            Date dt = new Date();
            messageId = "" + dt.getTime();
        }
        StringBuffer sb = new StringBuffer();
        if (minor != null && minor.size() > 0) {
            for (Object okey : minor.keySet()) {
                String key = (String)okey;
                String value = minor.getProperty(key);
                if (key == null || value == null) continue;
                if (!this.inArray(validMinor, value)) {
                    if (internalError.length() > 0) {
                        sb.append(", ");
                    }
                    internalError.append("Invalid imsx_codeMinorFieldValue=" + major);
                    continue;
                }
                if (sb.length() == 0) {
                    sb.append("\n        <imsx_codeMinor>\n");
                }
                sb.append("          <imsx_codeMinorField>\n            <imsx_codeMinorFieldName>");
                sb.append(key);
                sb.append("</imsx_codeMinorFieldName>\n            <imsx_codeMinorFieldValue>");
                sb.append(StringEscapeUtils.escapeXml((String)value));
                sb.append("</imsx_codeMinorFieldValue>\n          </imsx_codeMinorField>\n");
            }
            if (sb.length() > 0) {
                sb.append("        </imsx_codeMinor>");
            }
        }
        String minorString = sb.toString();
        if (!this.inArray(validMajor, major)) {
            if (internalError.length() > 0) {
                sb.append(", ");
            }
            internalError.append("Invalid imsx_codeMajor=" + major);
        }
        if (!this.inArray(validSeverity, severity)) {
            if (internalError.length() > 0) {
                sb.append(", ");
            }
            internalError.append("Invalid imsx_severity=" + major);
        }
        if (internalError.length() > 0) {
            description = description + " (Internal error: " + internalError.toString() + ")";
            Log.warning(internalError.toString());
        }
        if (bodyString == null) {
            bodyString = "";
        }
        if (bodyString.startsWith("<?xml") && (pos = bodyString.indexOf("<", 1)) > 0) {
            bodyString = bodyString.substring(pos);
        }
        bodyString = bodyString.trim();
        String newLine = "";
        if (bodyString.length() > 0) {
            newLine = "\n";
        }
        return String.format(responseMessage, StringEscapeUtils.escapeXml((String)messageId), StringEscapeUtils.escapeXml((String)major), StringEscapeUtils.escapeXml((String)severity), StringEscapeUtils.escapeXml((String)description), StringEscapeUtils.escapeXml((String)this.getHeaderMessageIdentifier()), StringEscapeUtils.escapeXml((String)this.operation), StringEscapeUtils.escapeXml((String)minorString), bodyString, newLine);
    }

    public static void sendReplaceResult(String url, String key, String secret, String sourcedid, String score) throws IOException, OAuthException, GeneralSecurityException {
        IMSPOXRequest.sendReplaceResult(url, key, secret, sourcedid, score, null);
    }

    public static void sendReplaceResult(String url, String key, String secret, String sourcedid, String score, String resultData) throws IOException, OAuthException, GeneralSecurityException {
        IMSPOXRequest.sendReplaceResult(url, key, secret, sourcedid, score, resultData, false);
    }

    public static void sendReplaceResult(String url, String key, String secret, String sourcedid, String score, String resultData, Boolean isUrl) throws IOException, OAuthException, GeneralSecurityException {
        DefaultHttpClient client = new DefaultHttpClient();
        HttpPost request = IMSPOXRequest.buildReplaceResult(url, key, secret, sourcedid, score, resultData, isUrl);
        HttpResponse response = client.execute((HttpUriRequest)request);
        if (response.getStatusLine().getStatusCode() >= 400) {
            throw new HttpResponseException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase());
        }
    }

    public static HttpPost buildReplaceResult(String url, String key, String secret, String sourcedid, String score, String resultData, Boolean isUrl) throws IOException, OAuthException, GeneralSecurityException {
        String dataXml = "";
        if (resultData != null) {
            String format = isUrl != false ? resultDataUrl : resultDataText;
            dataXml = String.format(format, StringEscapeUtils.escapeXml((String)resultData));
        }
        String xml = String.format(replaceResultMessage, StringEscapeUtils.escapeXml((String)sourcedid), StringEscapeUtils.escapeXml((String)score), dataXml);
        HttpParameters parameters = new HttpParameters();
        String hash = IMSPOXRequest.getBodyHash(xml);
        parameters.put("oauth_body_hash", URLEncoder.encode(hash, "UTF-8"));
        CommonsHttpOAuthConsumer signer = new CommonsHttpOAuthConsumer(key, secret);
        HttpPost request = new HttpPost(url);
        request.setHeader("Content-Type", "application/xml");
        request.setEntity((HttpEntity)new StringEntity(xml, "UTF-8"));
        signer.setAdditionalParameters(parameters);
        signer.sign((Object)request);
        return request;
    }
}

