/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.monitoring;

import java.util.Vector;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ComplexActivity;
import org.lamsfoundation.lams.learningdesign.ContributionTypes;
import org.lamsfoundation.lams.learningdesign.SimpleActivity;
import org.lamsfoundation.lams.learningdesign.ToolActivity;
import org.lamsfoundation.lams.learningdesign.strategy.ComplexActivityStrategy;
import org.lamsfoundation.lams.learningdesign.strategy.IContributionTypeStrategy;
import org.lamsfoundation.lams.learningdesign.strategy.SimpleActivityStrategy;
import org.lamsfoundation.lams.monitoring.dto.ContributeActivityDTO;
import org.lamsfoundation.lams.tool.exception.LamsToolServiceException;
import org.lamsfoundation.lams.tool.service.ILamsCoreToolService;
import org.lamsfoundation.lams.util.WebUtil;

public class ContributeDTOFactory {
    public static ContributeActivityDTO getContributeActivityDTO(Long lessonID, SimpleActivity activity, ILamsCoreToolService toolService) throws LamsToolServiceException {
        ContributeActivityDTO dto = null;
        SimpleActivityStrategy strategy = activity.getSimpleActivityStrategy();
        if (strategy != null) {
            dto = ContributeDTOFactory.addContributionURLS(lessonID, (Activity)activity, (IContributionTypeStrategy)strategy, toolService);
        }
        return dto;
    }

    private static ContributeActivityDTO addContributionURLS(Long lessonID, Activity activity, IContributionTypeStrategy strategy, ILamsCoreToolService toolService) {
        ContributeActivityDTO dto = null;
        Integer[] contributionType = strategy.getContributionType();
        if (contributionType.length > 0) {
            dto = new ContributeActivityDTO(activity);
            for (int i = 0; i < contributionType.length; ++i) {
                Integer contributionTypeEntry = contributionType[i];
                String url = ContributeDTOFactory.getURL(lessonID, activity, contributionTypeEntry, toolService);
                dto.addContribution(contributionTypeEntry, url);
            }
        }
        return dto;
    }

    private static String getURL(Long lessonID, Activity activity, Integer contributionTypeEntry, ILamsCoreToolService toolService) throws LamsToolServiceException {
        String url = null;
        if (activity.isToolActivity()) {
            ToolActivity toolActivity = (ToolActivity)activity;
            if (contributionTypeEntry.equals(ContributionTypes.MODERATION)) {
                url = toolService.getToolModerateURL(toolActivity);
            }
        }
        if (url == null) {
            url = toolService.getToolContributionURL(lessonID, activity);
        }
        return url != null ? WebUtil.convertToFullURL(url) : null;
    }

    public static ContributeActivityDTO getContributeActivityDTO(Long lessonID, ComplexActivity activity, ILamsCoreToolService toolService, Vector<ContributeActivityDTO> childActivities) {
        ContributeActivityDTO dto = null;
        ComplexActivityStrategy strategy = activity.getComplexActivityStrategy();
        if (strategy != null) {
            dto = ContributeDTOFactory.addContributionURLS(lessonID, (Activity)activity, (IContributionTypeStrategy)strategy, toolService);
            if (childActivities != null && childActivities.size() > 0) {
                if (dto == null) {
                    dto = new ContributeActivityDTO((Activity)activity);
                }
                dto.setChildActivities(childActivities);
            }
        }
        return dto;
    }
}

