/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.monitoring.quartz.job;

import java.util.Collection;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.events.IEventNotificationService;
import org.lamsfoundation.lams.monitoring.quartz.job.MonitoringJob;
import org.lamsfoundation.lams.monitoring.service.IMonitoringService;
import org.lamsfoundation.lams.usermanagement.User;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerContext;
import org.quartz.SchedulerException;
import org.springframework.context.ApplicationContext;

public class EmailScheduleMessageJob
extends MonitoringJob {
    private static Logger log = Logger.getLogger(EmailScheduleMessageJob.class);

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        IMonitoringService monitoringService = this.getMonitoringService(context);
        IEventNotificationService eventNotificationService = this.getEventNotificationService(context);
        JobDataMap properties = context.getJobDetail().getJobDataMap();
        String emailBody = (String)properties.get("emailBody");
        int searchType = (Integer)properties.get("searchType");
        Long lessonId = (Long)properties.get("lessonID");
        Integer orgId = (Integer)properties.get("organisationID");
        Long activityId = (Long)properties.get("activityID");
        Integer xDaystoFinish = (Integer)properties.get("daysToDeadline");
        String[] lessonIds = (String[])properties.get("lessonIDs");
        Collection<User> users = this.getMonitoringService(context).getUsersByEmailNotificationSearchType(searchType, lessonId, lessonIds, activityId, xDaystoFinish, orgId);
        for (User user : users) {
            boolean isHtmlFormat = false;
            int userId = user.getUserId();
            log.debug((Object)("Sending scheduled email to user [" + userId + "]."));
            eventNotificationService.sendMessage(null, Integer.valueOf(userId), IEventNotificationService.DELIVERY_METHOD_MAIL, monitoringService.getMessageService().getMessage("event.emailnotifications.email.subject", new Object[0]), emailBody, isHtmlFormat);
        }
    }

    private IEventNotificationService getEventNotificationService(JobExecutionContext context) throws JobExecutionException {
        try {
            String CONTEXT_NAME = "context.central";
            SchedulerContext sc = context.getScheduler().getContext();
            ApplicationContext cxt = (ApplicationContext)sc.get((Object)"context.central");
            return (IEventNotificationService)cxt.getBean("eventNotificationService");
        }
        catch (SchedulerException e) {
            throw new JobExecutionException("Failed look up the Scheduler" + e.toString());
        }
    }
}

