/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.monitoring.quartz.job;

import org.apache.log4j.Logger;
import org.lamsfoundation.lams.monitoring.quartz.job.MonitoringJob;
import org.lamsfoundation.lams.monitoring.service.IMonitoringService;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class FinishScheduleLessonJob
extends MonitoringJob {
    private static Logger log = Logger.getLogger(FinishScheduleLessonJob.class);

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        IMonitoringService monitoringService = this.getMonitoringService(context);
        JobDataMap properties = context.getJobDetail().getJobDataMap();
        long lessonId = (Long)properties.get("lessonID");
        Integer userId = (Integer)properties.get("userID");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Lesson [" + lessonId + "] is suspending..."));
        }
        monitoringService.suspendLesson(lessonId, userId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Lesson [" + lessonId + "] suspended"));
        }
    }
}

