/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.monitoring.service;

import java.io.IOException;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.authoring.service.IAuthoringService;
import org.lamsfoundation.lams.dao.IBaseDAO;
import org.lamsfoundation.lams.learning.service.ICoreLearnerService;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.BranchingActivity;
import org.lamsfoundation.lams.learningdesign.ChosenGrouping;
import org.lamsfoundation.lams.learningdesign.ComplexActivity;
import org.lamsfoundation.lams.learningdesign.GateActivity;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.GroupingActivity;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.ScheduleGateActivity;
import org.lamsfoundation.lams.learningdesign.SequenceActivity;
import org.lamsfoundation.lams.learningdesign.ToolActivity;
import org.lamsfoundation.lams.learningdesign.Transition;
import org.lamsfoundation.lams.learningdesign.dao.IActivityDAO;
import org.lamsfoundation.lams.learningdesign.dao.IGroupDAO;
import org.lamsfoundation.lams.learningdesign.dao.IGroupUserDAO;
import org.lamsfoundation.lams.learningdesign.dao.IGroupingDAO;
import org.lamsfoundation.lams.learningdesign.dao.ILearningDesignDAO;
import org.lamsfoundation.lams.learningdesign.dao.ITransitionDAO;
import org.lamsfoundation.lams.lesson.CompletedActivityProgress;
import org.lamsfoundation.lams.lesson.LearnerProgress;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.LessonClass;
import org.lamsfoundation.lams.lesson.dao.ILearnerProgressDAO;
import org.lamsfoundation.lams.lesson.dao.ILessonClassDAO;
import org.lamsfoundation.lams.lesson.dao.ILessonDAO;
import org.lamsfoundation.lams.lesson.dto.LessonDetailsDTO;
import org.lamsfoundation.lams.lesson.service.ILessonService;
import org.lamsfoundation.lams.lesson.service.LessonServiceException;
import org.lamsfoundation.lams.logevent.service.ILogEventService;
import org.lamsfoundation.lams.monitoring.dto.ContributeActivityDTO;
import org.lamsfoundation.lams.monitoring.service.ContributeActivitiesProcessor;
import org.lamsfoundation.lams.monitoring.service.IMonitoringService;
import org.lamsfoundation.lams.monitoring.service.MonitoringServiceException;
import org.lamsfoundation.lams.tool.ToolSession;
import org.lamsfoundation.lams.tool.exception.LamsToolServiceException;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.tool.service.ILamsCoreToolService;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.OrganisationType;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.Workspace;
import org.lamsfoundation.lams.usermanagement.WorkspaceFolder;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.dto.UserFlashDTO;
import org.lamsfoundation.lams.usermanagement.exception.UserAccessDeniedException;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.usermanagement.util.LastNameAlphabeticComparator;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.DateUtil;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.audit.AuditService;
import org.lamsfoundation.lams.util.wddx.FlashMessage;
import org.lamsfoundation.lams.util.wddx.WDDXProcessor;
import org.lamsfoundation.lams.util.wddx.WDDXProcessorConversionException;
import org.lamsfoundation.lams.util.wddx.WDDXTAGS;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class MonitoringService
implements IMonitoringService,
ApplicationContextAware {
    private static Logger log = Logger.getLogger(MonitoringService.class);
    private static final long numMilliSecondsInADay = 86400000L;
    private static final String AUDIT_LEARNER_PORTFOLIO_SET = "audit.learner.portfolio.set";
    private static final String AUDIT_LESSON_CREATED_KEY = "audit.lesson.created";
    private static final int DEFAULT_LEARNER_PROGRESS_BATCH_SIZE = 15;
    private ILessonDAO lessonDAO;
    private ILessonClassDAO lessonClassDAO;
    private ITransitionDAO transitionDAO;
    private IActivityDAO activityDAO;
    private IBaseDAO baseDAO;
    private ILearningDesignDAO learningDesignDAO;
    private IGroupingDAO groupingDAO;
    private IGroupDAO groupDAO;
    private IGroupUserDAO groupUserDAO;
    private ILearnerProgressDAO learnerProgressDAO;
    private IAuthoringService authoringService;
    private ICoreLearnerService learnerService;
    private ILessonService lessonService;
    private ILamsCoreToolService lamsCoreToolService;
    private IUserManagementService userManagementService;
    private Scheduler scheduler;
    private ApplicationContext applicationContext;
    private MessageService messageService;
    private AuditService auditService;
    private ILogEventService logEventService;
    private static final String FORCE_COMPLETE_STOP_MESSAGE_ACTIVITY_DONE = "force.complete.stop.message.activity.done";
    private static final String FORCE_COMPLETE_STOP_MESSAGE_GROUPING_ERROR = "force.complete.stop.message.grouping.error";
    private static final String FORCE_COMPLETE_STOP_MESSAGE_GROUPING = "force.complete.stop.message.grouping";
    private static final String FORCE_COMPLETE_STOP_MESSAGE_GATE = "force.complete.stop.message.gate";
    private static final String FORCE_COMPLETE_STOP_MESSAGE_COMPLETED_TO_ACTIVITY = "force.complete.stop.message.completed.to.activity";
    private static final String FORCE_COMPLETE_STOP_MESSAGE_COMPLETED_TO_END = "force.complete.stop.message.completed.to.end";
    private static final String FORCE_COMPLETE_STOP_MESSAGE_STOPPED_UNEXPECTEDLY = "force.complete.stop.message.stopped.unexpectedly";

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    @Override
    public MessageService getMessageService() {
        return this.messageService;
    }

    public void setUserManagementService(IUserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    public void setLearningDesignDAO(ILearningDesignDAO learningDesignDAO) {
        this.learningDesignDAO = learningDesignDAO;
    }

    public void setTransitionDAO(ITransitionDAO transitionDAO) {
        this.transitionDAO = transitionDAO;
    }

    public void setLearnerService(ICoreLearnerService learnerService) {
        this.learnerService = learnerService;
    }

    public void setLessonService(ILessonService lessonService) {
        this.lessonService = lessonService;
    }

    public void setAuthoringService(IAuthoringService authoringService) {
        this.authoringService = authoringService;
    }

    public void setLessonClassDAO(ILessonClassDAO lessonClassDAO) {
        this.lessonClassDAO = lessonClassDAO;
    }

    public void setLessonDAO(ILessonDAO lessonDAO) {
        this.lessonDAO = lessonDAO;
    }

    public void setLearnerProgressDAO(ILearnerProgressDAO learnerProgressDAO) {
        this.learnerProgressDAO = learnerProgressDAO;
    }

    public void setBaseDAO(IBaseDAO baseDAO) {
        this.baseDAO = baseDAO;
    }

    public void setGroupDAO(IGroupDAO groupDAO) {
        this.groupDAO = groupDAO;
    }

    public void setGroupUserDAO(IGroupUserDAO groupUserDAO) {
        this.groupUserDAO = groupUserDAO;
    }

    public void setGroupingDAO(IGroupingDAO groupingDAO) {
        this.groupingDAO = groupingDAO;
    }

    public void setLamsCoreToolService(ILamsCoreToolService lamsToolService) {
        this.lamsCoreToolService = lamsToolService;
    }

    public void setActivityDAO(IActivityDAO activityDAO) {
        this.activityDAO = activityDAO;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void setAuditService(AuditService auditService) {
        this.auditService = auditService;
    }

    public void setLogEventService(ILogEventService logEventService) {
        this.logEventService = logEventService;
    }

    private void auditAction(String messageKey, Object[] args) {
        String message = this.messageService.getMessage(messageKey, args);
        this.auditService.log("Monitoring", message);
    }

    @Override
    public void checkOwnerOrStaffMember(Integer userId, Long lessonId, String actionDescription) {
        this.checkOwnerOrStaffMember(userId, this.lessonDAO.getLesson(lessonId), actionDescription);
    }

    @Override
    public void checkOwnerOrStaffMember(Integer userId, Lesson lesson, String actionDescription) {
        User user = (User)this.baseDAO.find(User.class, (Serializable)userId);
        if (lesson.getUser() != null && lesson.getUser().getUserId().equals(userId)) {
            return;
        }
        Organisation course = lesson.getOrganisation();
        if (OrganisationType.CLASS_TYPE.equals(course.getOrganisationType().getOrganisationTypeId())) {
            course = course.getParentOrganisation();
        }
        boolean isUserGroupManager = this.userManagementService.isUserInRole(userId, course.getOrganisationId(), "GROUP MANAGER");
        if (lesson == null || lesson.getLessonClass() == null || !lesson.getLessonClass().isStaffMember(user) && !isUserGroupManager) {
            throw new UserAccessDeniedException("User " + userId + " may not " + actionDescription + " for lesson " + lesson.getLessonId());
        }
    }

    @Override
    public Lesson initializeLesson(String lessonName, String lessonDescription, long learningDesignId, Integer organisationId, Integer userID, String customCSV, Boolean enableLessonIntro, Boolean displayDesignImage, Boolean learnerExportAvailable, Boolean learnerPresenceAvailable, Boolean learnerImAvailable, Boolean liveEditEnabled, Boolean enableLessonNotifications, Boolean learnerRestart, Integer scheduledNumberDaysToLessonFinish, Long precedingLessonId) {
        LearningDesign originalLearningDesign = this.authoringService.getLearningDesign(new Long(learningDesignId));
        if (originalLearningDesign == null) {
            throw new MonitoringServiceException("Learning design for id=" + learningDesignId + " is missing. Unable to initialize lesson.");
        }
        Lesson precedingLesson = precedingLessonId == null ? null : this.lessonDAO.getLesson(precedingLessonId);
        WorkspaceFolder runSeqFolder = null;
        int MAX_DEEP_LEVEL_FOLDER = 50;
        if (organisationId != null) {
            Organisation org = (Organisation)this.baseDAO.find(Organisation.class, (Serializable)organisationId);
            for (int idx = 0; idx < MAX_DEEP_LEVEL_FOLDER && org != null && runSeqFolder == null; ++idx) {
                Workspace workspace = org.getWorkspace();
                if (workspace != null) {
                    runSeqFolder = workspace.getDefaultRunSequencesFolder();
                }
                if (runSeqFolder != null) continue;
                org = org.getParentOrganisation();
            }
        }
        User user = userID != null ? (User)this.baseDAO.find(User.class, (Serializable)userID) : null;
        Lesson initializedLesson = this.initializeLesson(lessonName, lessonDescription, originalLearningDesign, user, runSeqFolder, 2, customCSV, enableLessonIntro, displayDesignImage, learnerExportAvailable, learnerPresenceAvailable, learnerImAvailable, liveEditEnabled, enableLessonNotifications, learnerRestart, scheduledNumberDaysToLessonFinish, precedingLesson);
        Long initializedLearningDesignId = initializedLesson.getLearningDesign().getLearningDesignId();
        this.logEventService.logEvent(Integer.valueOf(2), userID, initializedLearningDesignId, initializedLesson.getLessonId(), null);
        return initializedLesson;
    }

    @Override
    public Lesson initializeLessonForPreview(String lessonName, String lessonDescription, long learningDesignId, Integer userID, String customCSV, Boolean learnerPresenceAvailable, Boolean learnerImAvailable, Boolean liveEditEnabled) {
        LearningDesign originalLearningDesign = this.authoringService.getLearningDesign(new Long(learningDesignId));
        if (originalLearningDesign == null) {
            throw new MonitoringServiceException("Learning design for id=" + learningDesignId + " is missing. Unable to initialize lesson.");
        }
        User user = userID != null ? (User)this.baseDAO.find(User.class, (Serializable)userID) : null;
        return this.initializeLesson(lessonName, lessonDescription, originalLearningDesign, user, null, 3, customCSV, false, false, false, learnerPresenceAvailable, learnerImAvailable, liveEditEnabled, true, false, null, null);
    }

    @Override
    public Lesson initializeLessonWithoutLDcopy(String lessonName, String lessonDescription, long learningDesignID, User user, String customCSV, Boolean enableLessonIntro, Boolean displayDesignImage, Boolean learnerExportAvailable, Boolean learnerPresenceAvailable, Boolean learnerImAvailable, Boolean liveEditEnabled, Boolean enableLessonNotifications, Boolean learnerRestart, Integer scheduledNumberDaysToLessonFinish, Lesson precedingLesson) {
        LearningDesign learningDesign = this.authoringService.getLearningDesign(Long.valueOf(learningDesignID));
        if (learningDesign == null) {
            throw new MonitoringServiceException("Learning design for id=" + learningDesignID + " is missing. Unable to initialize lesson.");
        }
        Lesson lesson = this.createNewLesson(lessonName, lessonDescription, user, learningDesign, enableLessonIntro, displayDesignImage, learnerExportAvailable, learnerPresenceAvailable, learnerImAvailable, liveEditEnabled, enableLessonNotifications, learnerRestart, scheduledNumberDaysToLessonFinish, precedingLesson);
        this.auditAction(AUDIT_LESSON_CREATED_KEY, new Object[]{lessonName, learningDesign.getTitle(), learnerExportAvailable});
        return lesson;
    }

    public Lesson initializeLesson(String lessonName, String lessonDescription, LearningDesign originalLearningDesign, User user, WorkspaceFolder workspaceFolder, int copyType, String customCSV, Boolean enableLessonIntro, Boolean displayDesignImage, Boolean learnerExportAvailable, Boolean learnerPresenceAvailable, Boolean learnerImAvailable, Boolean liveEditEnabled, Boolean enableLessonNotifications, Boolean learnerRestart, Integer scheduledNumberDaysToLessonFinish, Lesson precedingLesson) {
        LearningDesign copiedLearningDesign = this.authoringService.copyLearningDesign(originalLearningDesign, new Integer(copyType), user, workspaceFolder, true, null, customCSV);
        this.authoringService.saveLearningDesign(copiedLearningDesign);
        String title = lessonName != null ? lessonName : copiedLearningDesign.getTitle();
        String string = title = title != null ? title : "Unknown Lesson";
        if (title.length() > 254) {
            title = title.substring(0, 254);
        }
        Lesson lesson = this.createNewLesson(title, lessonDescription, user, copiedLearningDesign, enableLessonIntro, displayDesignImage, learnerExportAvailable, learnerPresenceAvailable, learnerImAvailable, liveEditEnabled, enableLessonNotifications, learnerRestart, scheduledNumberDaysToLessonFinish, precedingLesson);
        this.auditAction(AUDIT_LESSON_CREATED_KEY, new Object[]{lessonName, copiedLearningDesign.getTitle(), learnerExportAvailable});
        return lesson;
    }

    @Override
    public String initializeLesson(Integer creatorUserId, String lessonPacket) throws Exception {
        FlashMessage flashMessage = null;
        try {
            Hashtable table = (Hashtable)WDDXProcessor.deserialize((String)lessonPacket);
            String title = WDDXProcessor.convertToString((String)"lessonName", table.get("lessonName"));
            String desc = WDDXProcessor.convertToString((String)"lessonDescription", table.get("lessonDescription"));
            int copyType = WDDXProcessor.convertToInt((String)"copyType", table.get("copyType"));
            Integer organisationId = WDDXProcessor.convertToInteger((String)"organisationID", table.get("organisationID"));
            long ldId = WDDXProcessor.convertToLong((String)"learningDesignID", table.get("learningDesignID"));
            String customCSV = WDDXProcessor.convertToString((String)"customCSV", table.get("customCSV"));
            Boolean enableLessonIntro = WDDXProcessor.convertToBoolean((String)"enableLessonIntro", table.get("enableLessonIntro"));
            Boolean displayDesignImage = WDDXProcessor.convertToBoolean((String)"displayDesignImage", table.get("displayDesignImage"));
            boolean learnerExportAvailable = WDDXProcessor.convertToBoolean((String)"learnerExportPortfolio", table.get("learnerExportPortfolio"));
            boolean learnerPresenceAvailable = WDDXProcessor.convertToBoolean((String)"enablePresence", table.get("enablePresence"));
            boolean learnerImAvailable = WDDXProcessor.convertToBoolean((String)"enableIm", table.get("enableIm"));
            boolean liveEditEnabled = WDDXProcessor.convertToBoolean((String)"enableLiveEdit", table.get("enableLiveEdit"));
            Boolean enableLessonNotifications = WDDXProcessor.convertToBoolean((String)"enableLessonNotifications", table.get("enableLessonNotifications"));
            Integer scheduledNumberDaysToLessonFinish = WDDXProcessor.convertToInteger((String)"scheduledNumberDaysToLessonFinish", table.get("scheduledNumberDaysToLessonFinish"));
            Long precedingLessonId = WDDXProcessor.convertToLong((String)"organisationID", table.get("precedingLessonID"));
            Lesson newLesson = null;
            newLesson = copyType == 3 ? this.initializeLessonForPreview(title, desc, ldId, creatorUserId, customCSV, learnerPresenceAvailable, learnerImAvailable, liveEditEnabled) : this.initializeLesson(title, desc, ldId, organisationId, creatorUserId, customCSV, enableLessonIntro, displayDesignImage, learnerExportAvailable, learnerPresenceAvailable, learnerImAvailable, liveEditEnabled, enableLessonNotifications, false, scheduledNumberDaysToLessonFinish, precedingLessonId);
            if (newLesson != null) {
                flashMessage = new FlashMessage("initializeLesson", (Object)newLesson.getLessonId());
            }
            return flashMessage.serializeMessage();
        }
        catch (Exception e) {
            log.error((Object)"Exception occured trying to create a lesson class ", (Throwable)e);
            throw new Exception(e);
        }
    }

    @Override
    public Lesson createLessonClassForLesson(long lessonId, Organisation organisation, String learnerGroupName, List<User> organizationUsers, String staffGroupName, List<User> staffs, Integer userId) {
        Lesson newLesson = this.lessonDAO.getLesson(new Long(lessonId));
        if (newLesson == null) {
            throw new MonitoringServiceException("Lesson for id=" + lessonId + " is missing. Unable to create class for lesson.");
        }
        this.checkOwnerOrStaffMember(userId, newLesson, "create lesson class");
        if (newLesson.isLessonStarted()) {
            this.lessonService.setLearners(newLesson, organizationUsers);
            this.lessonService.setStaffMembers(newLesson, staffs);
        } else {
            LessonClass oldLessonClass = newLesson.getLessonClass();
            LessonClass newLessonClass = this.createLessonClass(organisation, learnerGroupName, organizationUsers, staffGroupName, staffs, newLesson);
            newLessonClass.setLesson(newLesson);
            newLesson.setLessonClass(newLessonClass);
            newLesson.setOrganisation(organisation);
            this.lessonDAO.updateLesson(newLesson);
            if (oldLessonClass != null) {
                this.lessonClassDAO.deleteLessonClass(oldLessonClass);
            }
        }
        return newLesson;
    }

    @Override
    public void startLessonOnSchedule(long lessonId, Date startDate, Integer userId) {
        Lesson requestedLesson = this.lessonDAO.getLesson(new Long(lessonId));
        if (requestedLesson == null) {
            throw new MonitoringServiceException("Lesson for id=" + lessonId + " is missing. Unable to start lesson.");
        }
        this.checkOwnerOrStaffMember(userId, requestedLesson, "start lesson on schedule");
        if (requestedLesson.isLessonStarted()) {
            log.error((Object)("Lesson for id=" + lessonId + " has been started. Unable to schedule lesson start."));
            return;
        }
        if (requestedLesson.getScheduleStartDate() != null) {
            log.error((Object)("Lesson for id=" + lessonId + " is already scheduled and cannot be rescheduled."));
            return;
        }
        User user = (User)this.baseDAO.find(User.class, (Serializable)userId);
        TimeZone userTimeZone = TimeZone.getTimeZone(user.getTimeZone());
        Date tzStartLessonDate = DateUtil.convertFromTimeZoneToDefault((TimeZone)userTimeZone, (Date)startDate);
        JobDetail startLessonJob = this.getStartScheduleLessonJob();
        startLessonJob.setName("startLessonOnSchedule:" + lessonId);
        startLessonJob.setDescription(requestedLesson.getLessonName() + ":" + (requestedLesson.getUser() == null ? "" : requestedLesson.getUser().getFullName()));
        startLessonJob.getJobDataMap().put((Object)"lessonID", (Object)new Long(lessonId));
        startLessonJob.getJobDataMap().put((Object)"userID", (Object)new Integer(userId));
        SimpleTrigger startLessonTrigger = new SimpleTrigger("startLessonOnScheduleTrigger:" + lessonId, "DEFAULT", tzStartLessonDate);
        try {
            requestedLesson.setScheduleStartDate(tzStartLessonDate);
            this.scheduler.scheduleJob(startLessonJob, (Trigger)startLessonTrigger);
            this.setLessonState(requestedLesson, Lesson.NOT_STARTED_STATE);
        }
        catch (SchedulerException e) {
            throw new MonitoringServiceException("Error occurred at [startLessonOnSchedule]- fail to start scheduling", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start lesson  [" + lessonId + "] on schedule is configured"));
        }
    }

    @Override
    public void finishLessonOnSchedule(long lessonId, int scheduledNumberDaysToLessonFinish, Integer userId) {
        Lesson requestedLesson = this.lessonDAO.getLesson(new Long(lessonId));
        if (requestedLesson == null) {
            throw new MonitoringServiceException("Lesson for id=" + lessonId + " is missing. Unable to start lesson.");
        }
        this.checkOwnerOrStaffMember(userId, requestedLesson, "finish lesson on schedule");
        String triggerName = "finishLessonOnScheduleTrigger:" + lessonId;
        boolean alreadyScheduled = false;
        try {
            alreadyScheduled = this.scheduler.getTrigger(triggerName, "DEFAULT") != null;
        }
        catch (SchedulerException e) {
            log.error((Object)e);
        }
        SimpleTrigger finishLessonTrigger = null;
        String finishLessonJobName = "finishLessonOnSchedule:" + lessonId;
        JobDetail finishLessonJob = null;
        Date endDate = null;
        if (scheduledNumberDaysToLessonFinish > 0) {
            Date startDate;
            Date date = startDate = requestedLesson.getStartDateTime() != null ? requestedLesson.getStartDateTime() : requestedLesson.getScheduleStartDate();
            if (startDate == null) {
                throw new MonitoringServiceException("Lesson with id=" + lessonId + " neither has been started nor scheduled to start. Unable to schedule lesson's finish.");
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(startDate);
            calendar.add(5, scheduledNumberDaysToLessonFinish);
            endDate = calendar.getTime();
            if (endDate.before(new Date())) {
                throw new IllegalArgumentException("Lesson scheduled finish date is already in the past");
            }
            if (!alreadyScheduled) {
                finishLessonJob = this.getFinishScheduleLessonJob();
                finishLessonJob.setName(finishLessonJobName);
                finishLessonJob.setDescription(requestedLesson.getLessonName() + ":" + (requestedLesson.getUser() == null ? "" : requestedLesson.getUser().getFullName()));
                finishLessonJob.getJobDataMap().put((Object)"lessonID", (Object)new Long(lessonId));
                finishLessonJob.getJobDataMap().put((Object)"userID", (Object)new Integer(userId));
            }
            finishLessonTrigger = new SimpleTrigger(triggerName, "DEFAULT", endDate);
            finishLessonTrigger.setJobName(finishLessonJobName);
        }
        try {
            requestedLesson.setScheduleEndDate(endDate);
            this.lessonDAO.updateLesson(requestedLesson);
            if (alreadyScheduled) {
                if (scheduledNumberDaysToLessonFinish > 0) {
                    this.scheduler.rescheduleJob(triggerName, "DEFAULT", finishLessonTrigger);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Finish lesson  [" + lessonId + "] job has been rescheduled to " + endDate));
                    }
                } else {
                    this.scheduler.deleteJob(finishLessonJobName, "DEFAULT");
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Finish lesson  [" + lessonId + "] job has been removed"));
                    }
                }
            } else if (scheduledNumberDaysToLessonFinish > 0) {
                this.scheduler.scheduleJob(finishLessonJob, finishLessonTrigger);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Finish lesson  [" + lessonId + "] job has been scheduled to " + endDate));
                }
            }
        }
        catch (SchedulerException e) {
            throw new MonitoringServiceException("Error occurred at [finishLessonOnSchedule]- fail to start scheduling", e);
        }
    }

    @Override
    public void startLesson(long lessonId, Integer userId) {
        Lesson requestedLesson;
        if (log.isDebugEnabled()) {
            log.debug((Object)("=============Starting Lesson " + lessonId + "=============="));
        }
        if ((requestedLesson = this.lessonDAO.getLesson(new Long(lessonId))) == null) {
            throw new MonitoringServiceException("Lesson for id=" + lessonId + " is missing. Unable to start lesson.");
        }
        if (requestedLesson.isLessonStarted()) {
            log.warn((Object)("Lesson for id=" + lessonId + " has been started. No need to start the lesson. The lesson was probably scheduled, and then the staff used \"Start now\". This message would have then been created by the schedule start"));
            return;
        }
        this.checkOwnerOrStaffMember(userId, requestedLesson, "create lesson class");
        Date lessonStartTime = new Date();
        LearningDesign design = requestedLesson.getLearningDesign();
        boolean designModified = false;
        for (Activity activity : design.getActivities()) {
            Integer newMaxId = this.startSystemActivity(activity, design.getMaxID(), lessonStartTime, requestedLesson.getLessonName());
            if (newMaxId != null) {
                design.setMaxID(newMaxId);
                designModified = true;
            }
            activity.setInitialised(Boolean.TRUE);
            this.activityDAO.update((Object)activity);
        }
        if (designModified) {
            this.learningDesignDAO.update((Object)design);
        }
        requestedLesson.setLessonStateId(Lesson.STARTED_STATE);
        requestedLesson.setStartDateTime(lessonStartTime);
        this.lessonDAO.updateLesson(requestedLesson);
        if (log.isDebugEnabled()) {
            log.debug((Object)("=============Lesson " + lessonId + " started==============="));
        }
        this.logEventService.logEvent(Integer.valueOf(3), userId, null, Long.valueOf(lessonId), null);
    }

    @Override
    public Integer startSystemActivity(Activity activity, Integer currentMaxId, Date lessonStartTime, String lessonName) {
        Integer newMaxId = null;
        if (activity.getActivityTypeId() == 4) {
            ScheduleGateActivity gateActivity = (ScheduleGateActivity)this.activityDAO.getActivityByActivityId(activity.getActivityId());
            if (!Boolean.TRUE.equals(gateActivity.getGateActivityCompletionBased())) {
                activity = this.runGateScheduler(gateActivity, lessonStartTime, lessonName);
            }
            activity.setInitialised(Boolean.valueOf(true));
        }
        if (activity.isBranchingActivity() && activity.getGrouping() == null) {
            ChosenGrouping grouping = new ChosenGrouping(null, null, null);
            grouping.setGroupingUIID(currentMaxId);
            grouping.getActivities().add(activity);
            activity.setGrouping((Grouping)grouping);
            activity.setGroupingUIID(currentMaxId);
            activity.setApplyGrouping(Boolean.TRUE);
            this.groupingDAO.insert((Object)grouping);
            activity.setGrouping((Grouping)grouping);
            if (log.isDebugEnabled()) {
                log.debug((Object)("startLesson: Created chosen grouping " + grouping + " for branching activity " + activity));
            }
            newMaxId = new Integer(currentMaxId + 1);
            activity.setInitialised(Boolean.valueOf(true));
        }
        return newMaxId;
    }

    @Override
    public ScheduleGateActivity runGateScheduler(ScheduleGateActivity scheduleGate, Date schedulingStartTime, String lessonName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Running scheduler for gate " + scheduleGate.getActivityId() + "..."));
        }
        JobDetail openScheduleGateJob = this.getOpenScheduleGateJob();
        JobDetail closeScheduleGateJob = this.getCloseScheduleGateJob();
        openScheduleGateJob.setName("openGate:" + scheduleGate.getActivityId());
        openScheduleGateJob.setDescription(scheduleGate.getTitle() + ":" + lessonName);
        openScheduleGateJob.getJobDataMap().put((Object)"gateId", (Object)scheduleGate.getActivityId());
        closeScheduleGateJob.setName("closeGate:" + scheduleGate.getActivityId());
        closeScheduleGateJob.getJobDataMap().put((Object)"gateId", (Object)scheduleGate.getActivityId());
        closeScheduleGateJob.setDescription(scheduleGate.getTitle() + ":" + lessonName);
        SimpleTrigger openGateTrigger = new SimpleTrigger("openGateTrigger:" + scheduleGate.getActivityId(), "DEFAULT", scheduleGate.getGateOpenTime(schedulingStartTime));
        SimpleTrigger closeGateTrigger = new SimpleTrigger("closeGateTrigger:" + scheduleGate.getActivityId(), "DEFAULT", scheduleGate.getGateCloseTime(schedulingStartTime));
        try {
            if (scheduleGate.getGateStartTimeOffset() == null && scheduleGate.getGateEndTimeOffset() == null || scheduleGate.getGateStartTimeOffset() != null && scheduleGate.getGateEndTimeOffset() == null) {
                this.scheduler.scheduleJob(openScheduleGateJob, (Trigger)openGateTrigger);
            } else if (openGateTrigger.getStartTime().before(closeGateTrigger.getStartTime())) {
                this.scheduler.scheduleJob(openScheduleGateJob, (Trigger)openGateTrigger);
                this.scheduler.scheduleJob(closeScheduleGateJob, (Trigger)closeGateTrigger);
            }
        }
        catch (SchedulerException e) {
            throw new MonitoringServiceException("Error occurred at [runGateScheduler]- fail to start scheduling", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Scheduler for Gate " + scheduleGate.getActivityId() + " started..."));
        }
        return scheduleGate;
    }

    @Override
    public void finishLesson(long lessonId, Integer userId) {
        Lesson requestedLesson = this.lessonDAO.getLesson(new Long(lessonId));
        if (requestedLesson == null) {
            throw new MonitoringServiceException("Lesson for id=" + lessonId + " is missing. Unable to set lesson to finished");
        }
        this.checkOwnerOrStaffMember(userId, requestedLesson, "finish lesson");
        this.setLessonState(requestedLesson, Lesson.FINISHED_STATE);
    }

    @Override
    public void archiveLesson(long lessonId, Integer userId) {
        Lesson requestedLesson = this.lessonDAO.getLesson(new Long(lessonId));
        if (requestedLesson == null) {
            throw new MonitoringServiceException("Lesson for id=" + lessonId + " is missing. Unable to set lesson to archived");
        }
        this.checkOwnerOrStaffMember(userId, requestedLesson, "archive lesson");
        if (!Lesson.ARCHIVED_STATE.equals(requestedLesson.getLessonStateId()) && !Lesson.REMOVED_STATE.equals(requestedLesson.getLessonStateId())) {
            this.setLessonState(requestedLesson, Lesson.ARCHIVED_STATE);
        }
    }

    @Override
    public void unarchiveLesson(long lessonId, Integer userId) {
        Lesson requestedLesson = this.lessonDAO.getLesson(new Long(lessonId));
        if (requestedLesson == null) {
            throw new MonitoringServiceException("Lesson for id=" + lessonId + " is missing. Unable to set lesson to archived");
        }
        this.checkOwnerOrStaffMember(userId, requestedLesson, "unarchive lesson");
        this.revertLessonState(requestedLesson);
    }

    @Override
    public void suspendLesson(long lessonId, Integer userId) {
        Lesson lesson = this.lessonDAO.getLesson(new Long(lessonId));
        this.checkOwnerOrStaffMember(userId, lesson, "suspend lesson");
        if (lesson == null) {
            throw new MonitoringServiceException("Lesson for id=" + lessonId + " is missing. Unable to suspend lesson.");
        }
        if (!Lesson.SUSPENDED_STATE.equals(lesson.getLessonStateId()) && !Lesson.REMOVED_STATE.equals(lesson.getLessonStateId())) {
            this.setLessonState(lesson, Lesson.SUSPENDED_STATE);
        }
    }

    @Override
    public void unsuspendLesson(long lessonId, Integer userId) {
        Lesson lesson = this.lessonDAO.getLesson(new Long(lessonId));
        this.checkOwnerOrStaffMember(userId, lesson, "unsuspend lesson");
        Integer state = lesson.getLessonStateId();
        if (!Lesson.SUSPENDED_STATE.equals(state)) {
            throw new MonitoringServiceException("Lesson is not suspended lesson. It can not be unsuspended.");
        }
        if (lesson == null) {
            throw new MonitoringServiceException("Lesson for id=" + lessonId + " is missing. Unable to suspend lesson.");
        }
        this.revertLessonState(lesson);
    }

    private void setLessonState(Lesson requestedLesson, Integer status) {
        requestedLesson.setPreviousLessonStateId(requestedLesson.getLessonStateId());
        requestedLesson.setLessonStateId(status);
        this.lessonDAO.updateLesson(requestedLesson);
        this.logEventService.logEvent(Integer.valueOf(4), requestedLesson.getUser().getUserId(), null, requestedLesson.getLessonId(), null);
    }

    private void revertLessonState(Lesson requestedLesson) {
        Integer currentStatus = requestedLesson.getLessonStateId();
        if (requestedLesson.getPreviousLessonStateId() != null) {
            if (requestedLesson.getPreviousLessonStateId().equals(Lesson.NOT_STARTED_STATE) && requestedLesson.getScheduleStartDate().before(new Date())) {
                requestedLesson.setLessonStateId(Lesson.STARTED_STATE);
            } else {
                requestedLesson.setLessonStateId(requestedLesson.getPreviousLessonStateId());
            }
            requestedLesson.setPreviousLessonStateId(null);
        } else {
            if (requestedLesson.getStartDateTime() != null && requestedLesson.getScheduleStartDate() != null) {
                requestedLesson.setLessonStateId(Lesson.STARTED_STATE);
            } else if (requestedLesson.getScheduleStartDate() != null) {
                if (requestedLesson.getScheduleStartDate().after(new Date())) {
                    requestedLesson.setLessonStateId(Lesson.NOT_STARTED_STATE);
                } else {
                    requestedLesson.setLessonStateId(Lesson.STARTED_STATE);
                }
            } else if (requestedLesson.getStartDateTime() != null) {
                requestedLesson.setLessonStateId(Lesson.STARTED_STATE);
            } else {
                requestedLesson.setLessonStateId(Lesson.CREATED);
            }
            requestedLesson.setPreviousLessonStateId(currentStatus);
        }
        this.lessonDAO.updateLesson(requestedLesson);
        this.logEventService.logEvent(Integer.valueOf(4), requestedLesson.getUser().getUserId(), null, requestedLesson.getLessonId(), null);
    }

    @Override
    public void removeLesson(long lessonId, Integer userId) {
        Lesson requestedLesson = this.lessonDAO.getLesson(new Long(lessonId));
        if (requestedLesson == null) {
            throw new MonitoringServiceException("Lesson for id=" + lessonId + " is missing. Unable to remove lesson.");
        }
        this.checkOwnerOrStaffMember(userId, requestedLesson, "remove lesson");
        this.setLessonState(requestedLesson, Lesson.REMOVED_STATE);
    }

    @Override
    public Boolean setLearnerPortfolioAvailable(long lessonId, Integer userId, Boolean learnerExportAvailable) {
        Lesson requestedLesson = this.lessonDAO.getLesson(new Long(lessonId));
        if (requestedLesson == null) {
            throw new MonitoringServiceException("Lesson for id=" + lessonId + " is missing. Unable to set learner portfolio available to " + learnerExportAvailable);
        }
        this.checkOwnerOrStaffMember(userId, requestedLesson, "set learner portfolio available");
        requestedLesson.setLearnerExportAvailable(learnerExportAvailable != null ? learnerExportAvailable : Boolean.FALSE);
        this.auditAction(AUDIT_LEARNER_PORTFOLIO_SET, new Object[]{requestedLesson.getLessonName(), requestedLesson.getLearnerExportAvailable()});
        this.lessonDAO.updateLesson(requestedLesson);
        return requestedLesson.getLearnerExportAvailable();
    }

    @Override
    public Boolean setPresenceAvailable(long lessonId, Integer userId, Boolean presenceAvailable) {
        Lesson requestedLesson = this.lessonDAO.getLesson(new Long(lessonId));
        if (requestedLesson == null) {
            throw new MonitoringServiceException("Lesson for id=" + lessonId + " is missing. Unable to set learner presence available to " + presenceAvailable);
        }
        this.checkOwnerOrStaffMember(userId, requestedLesson, "set presence available");
        requestedLesson.setLearnerPresenceAvailable(presenceAvailable != null ? presenceAvailable : Boolean.FALSE);
        this.lessonDAO.updateLesson(requestedLesson);
        return requestedLesson.getLearnerPresenceAvailable();
    }

    @Override
    public Boolean setPresenceImAvailable(long lessonId, Integer userId, Boolean presenceImAvailable) {
        Lesson requestedLesson = this.lessonDAO.getLesson(new Long(lessonId));
        if (requestedLesson == null) {
            throw new MonitoringServiceException("Lesson for id=" + lessonId + " is missing. Unable to set learner im to " + presenceImAvailable);
        }
        this.checkOwnerOrStaffMember(userId, requestedLesson, "set presence available");
        requestedLesson.setLearnerImAvailable(presenceImAvailable != null ? presenceImAvailable : Boolean.FALSE);
        this.lessonDAO.updateLesson(requestedLesson);
        return requestedLesson.getLearnerImAvailable();
    }

    @Override
    public Boolean setLiveEditEnabled(long lessonId, Integer userId, Boolean liveEditEnabled) {
        Lesson requestedLesson = this.lessonDAO.getLesson(new Long(lessonId));
        if (requestedLesson == null) {
            throw new MonitoringServiceException("Lesson for id=" + lessonId + " is missing. Unable to set live edit enabled to " + liveEditEnabled);
        }
        this.checkOwnerOrStaffMember(userId, requestedLesson, "set live edit available");
        requestedLesson.setLiveEditEnabled(liveEditEnabled != null ? liveEditEnabled : Boolean.FALSE);
        this.lessonDAO.updateLesson(requestedLesson);
        return requestedLesson.getLiveEditEnabled();
    }

    @Override
    public GateActivity openGate(Long gateId) {
        GateActivity gate = (GateActivity)this.activityDAO.getActivityByActivityId(gateId);
        if (gate != null) {
            gate.setGateOpen(new Boolean(true));
            if (gate.isScheduleGate()) {
                try {
                    this.scheduler.unscheduleJob("openGateTrigger:" + gate.getActivityId(), "DEFAULT");
                }
                catch (SchedulerException e) {
                    log.error((Object)("Error unscheduling trigger for gate activity id:" + gate.getActivityId()), (Throwable)e);
                    throw new MonitoringServiceException("Error unscheduling trigger for gate activity id:" + gate.getActivityId(), e);
                }
            }
            this.activityDAO.update((Object)gate);
        }
        return gate;
    }

    @Override
    public Boolean openTimeChart(long lessonId, Integer userId) {
        Lesson requestedLesson = this.lessonDAO.getLesson(new Long(lessonId));
        if (requestedLesson == null) {
            throw new MonitoringServiceException("Lesson for id=" + lessonId + " is missing. Unable to open.");
        }
        this.checkOwnerOrStaffMember(userId, requestedLesson, "open the time chart");
        return true;
    }

    @Override
    public GateActivity openGateForSingleUser(Long gateId, Integer userId) {
        GateActivity gate = (GateActivity)this.activityDAO.getActivityByActivityId(gateId);
        if (gate != null && userId != null && userId >= 0) {
            User user = (User)this.baseDAO.find(User.class, (Serializable)userId);
            gate.addLeaner(user, true);
            this.activityDAO.update((Object)gate);
        }
        return gate;
    }

    @Override
    public GateActivity closeGate(Long gateId) {
        GateActivity gate = (GateActivity)this.activityDAO.getActivityByActivityId(gateId);
        gate.setGateOpen(new Boolean(false));
        this.activityDAO.update((Object)gate);
        return gate;
    }

    @Override
    public String forceCompleteActivitiesByUser(Integer learnerId, Integer requesterId, long lessonId, Long activityId, boolean removeLearnerContent) {
        String stopReason;
        Lesson lesson = this.lessonDAO.getLesson(new Long(lessonId));
        this.checkOwnerOrStaffMember(requesterId, lesson, "force complete");
        User learner = (User)this.baseDAO.find(User.class, (Serializable)learnerId);
        LearnerProgress learnerProgress = this.learnerService.getProgress(learnerId, Long.valueOf(lessonId));
        Activity stopActivity = null;
        if (activityId != null) {
            SequenceActivity sequenceActivity;
            Group group;
            stopActivity = this.getActivityById(activityId);
            if (stopActivity == null) {
                throw new MonitoringServiceException("Activity missing. Activity id" + activityId);
            }
            Activity parentActivity = stopActivity.getParentActivity();
            if (parentActivity != null && parentActivity.isSequenceActivity() && ((group = (sequenceActivity = (SequenceActivity)parentActivity).getSoleGroupForBranch()) == null || !group.hasLearner(learner))) {
                return "User is not assigned to the chosen branch";
            }
            if (learnerProgress != null && (learnerProgress.getCompletedActivities().containsKey(stopActivity) || parentActivity != null && (learnerProgress.getCompletedActivities().containsKey(parentActivity) || parentActivity.getParentActivity() != null && learnerProgress.getCompletedActivities().containsKey(parentActivity.getParentActivity())))) {
                return this.forceUncompleteActivity(learnerProgress, stopActivity, removeLearnerContent);
            }
        }
        if (learnerProgress == null) {
            learnerProgress = new LearnerProgress(learner, lesson);
            learnerProgress.setStartDate((Date)new Timestamp(new Date().getTime()));
            learnerProgress.setNextActivity(lesson.getLearningDesign().getFirstActivity());
            this.baseDAO.insert((Object)learnerProgress);
        }
        Activity currentActivity = learnerProgress.getCurrentActivity();
        Activity stopPreviousActivity = null;
        if (stopActivity != null) {
            Activity firstActivity = lesson.getLearningDesign().getFirstActivity();
            if (stopActivity.equals((Object)firstActivity)) {
                learnerProgress.setCurrentActivity(firstActivity);
                if (firstActivity.getTransitionFrom() != null) {
                    learnerProgress.setNextActivity(firstActivity.getTransitionFrom().getToActivity());
                } else {
                    learnerProgress.setNextActivity(null);
                }
                learnerProgress.getAttemptedActivities().put(firstActivity, new Date());
                this.baseDAO.update((Object)learnerProgress);
                return this.messageService.getMessage(FORCE_COMPLETE_STOP_MESSAGE_COMPLETED_TO_ACTIVITY, new Object[]{firstActivity.getTitle()});
            }
            stopPreviousActivity = stopActivity.getTransitionTo().getFromActivity();
        }
        return (stopReason = this.forceCompleteActivity(learner, lessonId, learnerProgress, currentActivity, stopPreviousActivity, new ArrayList<Long>())) != null ? stopReason : this.messageService.getMessage(FORCE_COMPLETE_STOP_MESSAGE_STOPPED_UNEXPECTEDLY);
    }

    /*
     * Unable to fully structure code
     */
    private String forceCompleteActivity(User learner, Long lessonId, LearnerProgress progress, Activity activity, Activity stopActivity, ArrayList<Long> touchedActivityIds) {
        stopReason = null;
        if (activity != null) {
            activity = this.activityDAO.getActivityByActivityId(activity.getActivityId());
            touchedActivityIds.add(activity.getActivityId());
            if (activity.isGroupingActivity()) {
                groupActivity = (GroupingActivity)activity;
                grouping = groupActivity.getCreateGrouping();
                myGroup = grouping.getGroupBy(learner);
                if (myGroup == null || myGroup.isNull()) {
                    if (grouping.isRandomGrouping()) {
                        try {
                            this.lessonService.performGrouping(lessonId, groupActivity, learner);
                        }
                        catch (LessonServiceException e) {
                            MonitoringService.log.error((Object)("Force complete failed. Learner " + learner + " lessonId " + lessonId + " processing activity " + activity), (Throwable)e);
                            stopReason = this.messageService.getMessage("force.complete.stop.message.grouping.error", new Object[]{activity.getTitle()});
                        }
                        this.learnerService.completeActivity(learner.getUserId(), activity, lessonId);
                        if (MonitoringService.log.isDebugEnabled()) {
                            MonitoringService.log.debug((Object)("Grouping activity [" + activity.getActivityId() + "] is completed."));
                        }
                    } else {
                        stopReason = this.messageService.getMessage("force.complete.stop.message.grouping", new Object[]{activity.getTitle()});
                    }
                } else {
                    this.learnerService.completeActivity(learner.getUserId(), activity, lessonId);
                    if (MonitoringService.log.isDebugEnabled()) {
                        MonitoringService.log.debug((Object)("Grouping activity [" + activity.getActivityId() + "] is completed."));
                    }
                }
            } else if (activity.isGateActivity()) {
                gate = (GateActivity)activity;
                dto = this.learnerService.knockGate(gate, learner, false);
                if (dto.getAllowToPass()) {
                    this.learnerService.completeActivity(learner.getUserId(), activity, lessonId);
                    if (MonitoringService.log.isDebugEnabled()) {
                        MonitoringService.log.debug((Object)("Gate activity [" + gate.getActivityId() + "] is completed."));
                    }
                } else {
                    stopReason = this.messageService.getMessage("force.complete.stop.message.gate", new Object[]{activity.getTitle()});
                }
            } else if (activity.isToolActivity()) {
                toolActivity = (ToolActivity)activity;
                try {
                    toolSession = this.lamsCoreToolService.getToolSessionByActivity(learner, toolActivity);
                    if (toolSession == null) {
                        this.learnerService.createToolSessionsIfNecessary((Activity)toolActivity, progress);
                        toolSession = this.lamsCoreToolService.getToolSessionByActivity(learner, toolActivity);
                    }
                    this.learnerService.completeToolSession(toolSession.getToolSessionId(), new Long(learner.getUserId().longValue()));
                    this.learnerService.completeActivity(learner.getUserId(), activity, lessonId);
                    if (!MonitoringService.log.isDebugEnabled()) ** GOTO lbl70
                    MonitoringService.log.debug((Object)("Tool activity [" + activity.getActivityId() + "] is completed."));
                }
                catch (LamsToolServiceException e) {
                    throw new MonitoringServiceException(e);
                }
            } else if (activity.isBranchingActivity() || activity.isOptionsActivity()) {
                this.learnerService.completeActivity(learner.getUserId(), activity, lessonId);
            } else if (activity.isComplexActivity()) {
                complexActivity = (ComplexActivity)activity;
                allActivities = complexActivity.getActivities();
                iter = allActivities.iterator();
                while (stopReason == null && iter.hasNext()) {
                    act = (Activity)iter.next();
                    stopReason = this.forceCompleteActivity(learner, lessonId, progress, act, stopActivity, touchedActivityIds);
                }
                MonitoringService.log.debug((Object)("Complex activity [" + activity.getActivityId() + "] is completed."));
            }
        }
lbl70:
        // 13 sources

        if (stopReason == null) {
            learnerProgress = this.learnerService.getProgress(learner.getUserId(), lessonId);
            if (stopActivity != null && learnerProgress.getCompletedActivities().containsKey(stopActivity)) {
                stopReason = this.messageService.getMessage("force.complete.stop.message.completed.to.activity", new Object[]{activity.getTitle()});
                this.learnerService.createToolSessionsIfNecessary(stopActivity, learnerProgress);
            } else {
                nextActivity = learnerProgress.getNextActivity();
                stopReason = nextActivity == null || activity != null && nextActivity.getActivityId().equals(activity.getActivityId()) != false ? this.messageService.getMessage("force.complete.stop.message.completed.to.end") : (touchedActivityIds.contains(nextActivity.getActivityId()) != false ? null : this.forceCompleteActivity(learner, lessonId, learnerProgress, nextActivity, stopActivity, touchedActivityIds));
            }
        }
        return stopReason;
    }

    private String forceUncompleteActivity(LearnerProgress learnerProgress, Activity targetActivity, boolean removeLearnerContent) {
        User learner = learnerProgress.getUser();
        Activity currentActivity = learnerProgress.getCurrentActivity();
        HashSet<Activity> uncompleteActivities = new HashSet<Activity>();
        uncompleteActivities.add(targetActivity);
        if (currentActivity == null) {
            currentActivity = learnerProgress.getLesson().getLearningDesign().getFirstActivity();
            while (currentActivity.getTransitionFrom() != null) {
                currentActivity = currentActivity.getTransitionFrom().getToActivity();
            }
            uncompleteActivities.add(currentActivity);
        }
        CompletedActivityProgress completedActivityProgress = (CompletedActivityProgress)learnerProgress.getCompletedActivities().get(targetActivity);
        Activity previousActivity = null;
        Activity targetParentActivity = targetActivity.getParentActivity();
        if (targetParentActivity != null) {
            uncompleteActivities.add(targetParentActivity);
            if (targetParentActivity.getParentActivity() != null) {
                targetParentActivity = targetParentActivity.getParentActivity();
                uncompleteActivities.add(targetParentActivity);
            }
            if (completedActivityProgress == null) {
                completedActivityProgress = (CompletedActivityProgress)learnerProgress.getCompletedActivities().get(targetParentActivity);
            }
        }
        if (targetActivity.getTransitionTo() == null) {
            if (targetParentActivity != null && targetParentActivity.getTransitionTo() != null) {
                previousActivity = targetParentActivity.getTransitionTo().getFromActivity();
            }
        } else {
            previousActivity = targetActivity.getTransitionTo().getFromActivity();
        }
        learnerProgress.setLessonComplete(Byte.valueOf((byte)0));
        learnerProgress.setFinishDate(null);
        learnerProgress.setPreviousActivity(previousActivity);
        learnerProgress.setCurrentActivity(targetActivity);
        learnerProgress.setNextActivity(targetActivity);
        HashSet<Activity> groupings = new HashSet<Activity>();
        while (!currentActivity.equals((Object)targetActivity)) {
            Transition transitionTo;
            uncompleteActivities.add(currentActivity);
            if (currentActivity.isComplexActivity()) {
                if (currentActivity.equals((Object)targetParentActivity)) {
                    currentActivity = targetActivity;
                    while (currentActivity.getTransitionFrom() != null) {
                        currentActivity = currentActivity.getTransitionFrom().getToActivity();
                    }
                    continue;
                }
                for (Activity childActivity : ((ComplexActivity)currentActivity).getActivities()) {
                    uncompleteActivities.add(childActivity);
                    if (childActivity.isComplexActivity()) {
                        uncompleteActivities.addAll(((ComplexActivity)childActivity).getActivities());
                    }
                    if (!childActivity.isSequenceActivity()) continue;
                    groupings.add(childActivity);
                }
            }
            if ((transitionTo = currentActivity.getTransitionTo()) == null) {
                if (currentActivity.getParentActivity() == null) {
                    if (previousActivity == null && currentActivity.equals((Object)targetActivity)) continue;
                    throw new MonitoringServiceException("Target activity was not found sequence. Activity id: " + targetActivity.getActivityId());
                }
                if ((currentActivity = currentActivity.getParentActivity()).getParentActivity() == null) continue;
                currentActivity = currentActivity.getParentActivity();
                continue;
            }
            currentActivity = transitionTo.getFromActivity();
            if (!currentActivity.isGroupingActivity()) continue;
            groupings.add(currentActivity);
        }
        for (Activity activity : uncompleteActivities) {
            learnerProgress.getAttemptedActivities().remove(activity);
            learnerProgress.getCompletedActivities().remove(activity);
            if (!removeLearnerContent || !activity.isToolActivity()) continue;
            this.lamsCoreToolService.notifyToolToDeleteLearnerContent((ToolActivity)activity, learner.getUserId());
        }
        learnerProgress.getAttemptedActivities().put(targetActivity, completedActivityProgress.getStartDate());
        if (targetParentActivity != null) {
            learnerProgress.getAttemptedActivities().put(targetParentActivity, completedActivityProgress.getStartDate());
            targetParentActivity = targetActivity.getParentActivity();
            if (targetParentActivity != null) {
                learnerProgress.getAttemptedActivities().put(targetParentActivity, completedActivityProgress.getStartDate());
            }
        }
        this.learnerProgressDAO.updateLearnerProgress(learnerProgress);
        for (Activity activity : groupings) {
            if (activity.isGroupingActivity()) {
                GroupingActivity groupingActivity = (GroupingActivity)this.getActivityById(activity.getActivityId());
                Grouping grouping = groupingActivity.getCreateGrouping();
                if (!grouping.doesLearnerExist(learner)) continue;
                Group group = grouping.getGroupBy(learner);
                group.getUsers().remove(learner);
                this.groupDAO.saveGroup(group);
                continue;
            }
            if (activity.isSequenceActivity()) {
                SequenceActivity sequenceActivity = (SequenceActivity)this.getActivityById(activity.getActivityId());
                Group group = sequenceActivity.getSoleGroupForBranch();
                if (group == null || !group.hasLearner(learner)) continue;
                this.removeUsersFromBranch(sequenceActivity.getActivityId(), new String[]{learner.getUserId().toString()});
                continue;
            }
            log.warn((Object)("Unknow activity type marked for ungrouping: " + activity.getActivityId()));
        }
        if (targetParentActivity != null) {
            this.learnerService.createToolSessionsIfNecessary(targetActivity, learnerProgress);
            Activity precedingUncompleteActivity = null;
            Activity precedingActivity = targetActivity;
            while (precedingActivity.getTransitionTo() != null) {
                precedingActivity = precedingActivity.getTransitionTo().getFromActivity();
                if (learnerProgress.getCompletedActivities().containsKey(precedingActivity)) continue;
                precedingUncompleteActivity = precedingActivity;
            }
            if (precedingUncompleteActivity != null) {
                return this.forceCompleteActivity(learner, learnerProgress.getLesson().getLessonId(), learnerProgress, precedingUncompleteActivity, previousActivity, new ArrayList<Long>());
            }
        }
        return this.messageService.getMessage(FORCE_COMPLETE_STOP_MESSAGE_COMPLETED_TO_ACTIVITY, new Object[]{targetActivity.getTitle()});
    }

    @Override
    public String getLessonDetails(Long lessonID, Integer userID) throws IOException {
        Lesson lesson = this.lessonDAO.getLesson(new Long(lessonID));
        this.checkOwnerOrStaffMember(userID, lesson, "get lesson deatils");
        User user = (User)this.baseDAO.find(User.class, (Serializable)userID);
        LessonDetailsDTO dto = this.lessonService.getLessonDetails(lessonID);
        Locale userLocale = new Locale(user.getLocale().getLanguageIsoCode(), user.getLocale().getCountryIsoCode());
        TimeZone tz = TimeZone.getTimeZone(user.getTimeZone());
        SimpleDateFormat sfm = new SimpleDateFormat("yyyyMMdd_HHmmss");
        if (dto.getCreateDateTime() != WDDXTAGS.DATE_NULL_VALUE && dto.getCreateDateTime() != null) {
            dto.setCreateDateTimeStr(sfm.format(dto.getCreateDateTime()));
        }
        SimpleDateFormat indfm = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss", userLocale);
        if (dto.getStartDateTime() != WDDXTAGS.DATE_NULL_VALUE && dto.getStartDateTime() != null) {
            Date tzStartDate = DateUtil.convertToTimeZoneFromDefault((TimeZone)tz, (Date)dto.getStartDateTime());
            dto.setStartDateTimeStr(indfm.format(tzStartDate) + " " + tz.getDisplayName(userLocale));
        }
        if (dto.getScheduleStartDate() != WDDXTAGS.DATE_NULL_VALUE && dto.getScheduleStartDate() != null) {
            Date tzScheduleDate = DateUtil.convertToTimeZoneFromDefault((TimeZone)tz, (Date)dto.getScheduleStartDate());
            dto.setScheduleStartDateStr(indfm.format(tzScheduleDate) + " " + tz.getDisplayName(userLocale));
        }
        log.debug((Object)dto.toString());
        log.debug((Object)dto.getLiveEditEnabled());
        FlashMessage flashMessage = dto != null ? new FlashMessage("getLessonDetails", (Object)dto) : new FlashMessage("getLessonDetails", (Object)this.messageService.getMessage("NO.SUCH.LESSON", new Object[]{lessonID}), 1);
        return flashMessage.serializeMessage();
    }

    @Override
    public String getLessonLearners(Long lessonID, Integer userID) throws IOException {
        FlashMessage flashMessage;
        Lesson lesson = this.lessonDAO.getLesson(lessonID);
        this.checkOwnerOrStaffMember(userID, lesson, "get lesson learners");
        Vector<UserFlashDTO> lessonLearners = new Vector<UserFlashDTO>();
        if (lesson != null) {
            for (User user : lesson.getLessonClass().getLearners()) {
                lessonLearners.add(user.getUserFlashDTO());
            }
            flashMessage = new FlashMessage("getLessonLearners", lessonLearners);
        } else {
            flashMessage = new FlashMessage("getLessonLearners", (Object)this.messageService.getMessage("NO.SUCH.LESSON", new Object[]{lessonID}), 1);
        }
        return flashMessage.serializeMessage();
    }

    @Override
    public String getLessonStaff(Long lessonID, Integer userID) throws IOException {
        FlashMessage flashMessage;
        Lesson lesson = this.lessonDAO.getLesson(lessonID);
        this.checkOwnerOrStaffMember(userID, lesson, "get lesson staff");
        Vector<UserFlashDTO> lessonStaff = new Vector<UserFlashDTO>();
        if (lesson != null) {
            for (User user : lesson.getLessonClass().getStaffGroup().getUsers()) {
                lessonStaff.add(user.getUserFlashDTO());
            }
            flashMessage = new FlashMessage("getLessonStaff", lessonStaff);
        } else {
            flashMessage = new FlashMessage("getLessonStaff", (Object)this.messageService.getMessage("NO.SUCH.LESSON", new Object[]{lessonID}), 1);
        }
        return flashMessage.serializeMessage();
    }

    @Override
    public Collection<User> getUsersByEmailNotificationSearchType(int searchType, Long lessonId, String[] lessonIds, Long activityId, Integer xDaystoFinish, Integer orgId) {
        Lesson lesson = null;
        if (lessonId != null) {
            lesson = this.learnerService.getLesson(lessonId);
        }
        Collection<Object> users = new LinkedList();
        switch (searchType) {
            case 0: {
                users = lesson.getAllLearners();
                break;
            }
            case 1: {
                Set allUsers = lesson.getAllLearners();
                List<User> usersCompletedLesson = this.getUsersCompletedLesson(lessonId);
                users = CollectionUtils.subtract((Collection)allUsers, usersCompletedLesson);
                break;
            }
            case 2: 
            case 7: {
                users = this.getUsersCompletedLesson(lessonId);
                break;
            }
            case 3: 
            case 8: {
                Set allUsers = lesson.getAllLearners();
                List usersStartedLesson = this.lessonService.getActiveLessonLearners(lessonId);
                users = CollectionUtils.subtract((Collection)allUsers, (Collection)usersStartedLesson);
                break;
            }
            case 4: {
                users = this.lessonService.getActiveLessonLearners(lessonId);
                break;
            }
            case 5: {
                Activity activity = this.learnerService.getActivity(activityId);
                Set allUsers = lesson.getAllLearners();
                List usersAttemptedActivity = this.lessonService.getLearnersHaveAttemptedActivity(activity);
                users = CollectionUtils.subtract((Collection)allUsers, (Collection)usersAttemptedActivity);
                break;
            }
            case 6: {
                Date now = new Date();
                Calendar currentTimePlusXDays = Calendar.getInstance();
                currentTimePlusXDays.setTime(now);
                currentTimePlusXDays.add(5, xDaystoFinish);
                Date scheduleEndDate = lesson.getScheduleEndDate();
                if (scheduleEndDate != null) {
                    if (!now.before(scheduleEndDate) || !currentTimePlusXDays.getTime().after(scheduleEndDate)) break;
                    users = lesson.getAllLearners();
                    break;
                }
                if (!lesson.isScheduledToCloseForIndividuals()) break;
                users = this.groupUserDAO.getUsersWithLessonEndingSoonerThan(lesson, currentTimePlusXDays.getTime());
                break;
            }
            case 9: {
                List allUSers = this.learnerService.getUserManagementService().getUsersFromOrganisation(orgId);
                TreeSet usersStartedAtLest1Lesson = new TreeSet();
                Organisation org = (Organisation)this.learnerService.getUserManagementService().findById(Organisation.class, (Serializable)orgId);
                Set lessons = org.getLessons();
                for (Lesson les : lessons) {
                    Activity firstActivity = les.getLearningDesign().getFirstActivity();
                    List usersStartedFirstActivity = this.learnerProgressDAO.getLearnersHaveAttemptedActivity(firstActivity);
                    usersStartedAtLest1Lesson.addAll(usersStartedFirstActivity);
                }
                users = CollectionUtils.subtract((Collection)allUSers, usersStartedAtLest1Lesson);
                break;
            }
            case 10: {
                int i = 0;
                for (String lessonIdStr : lessonIds) {
                    lessonId = Long.parseLong(lessonIdStr);
                    List<User> completedLesson = this.getUsersCompletedLesson(lessonId);
                    users = i++ == 0 ? completedLesson : CollectionUtils.intersection(users, completedLesson);
                }
                break;
            }
            case 11: {
                users = new TreeSet();
                for (String lessonIdStr : lessonIds) {
                    lessonId = Long.parseLong(lessonIdStr);
                    lesson = this.learnerService.getLesson(lessonId);
                    users.addAll(lesson.getAllLearners());
                }
                for (String lessonIdStr : lessonIds) {
                    lessonId = Long.parseLong(lessonIdStr);
                    List<User> completedLesson = this.getUsersCompletedLesson(lessonId);
                    users = CollectionUtils.subtract(users, completedLesson);
                }
                break;
            }
        }
        TreeSet<User> sortedUsers = new TreeSet<User>(new Comparator<User>(){

            @Override
            public int compare(User usr0, User usr1) {
                return (usr0.getFirstName() + usr0.getLastName() + usr0.getLogin()).compareTo(usr1.getFirstName() + usr1.getLastName() + usr1.getLogin());
            }
        });
        sortedUsers.addAll(users);
        return sortedUsers;
    }

    private List<User> getUsersCompletedLesson(Long lessonId) {
        LinkedList<User> usersCompletedLesson = new LinkedList<User>();
        List completedLearnerProgresses = this.learnerProgressDAO.getCompletedLearnerProgressForLesson(lessonId);
        for (LearnerProgress learnerProgress : completedLearnerProgresses) {
            usersCompletedLesson.add(learnerProgress.getUser());
        }
        return usersCompletedLesson;
    }

    @Override
    public String getLearningDesignDetails(Long lessonID) throws IOException {
        Lesson lesson = this.lessonDAO.getLesson(lessonID);
        return this.authoringService.getLearningDesignDetails(lesson.getLearningDesign().getLearningDesignId(), "");
    }

    @Override
    public Activity getActivityById(Long activityId) {
        return this.activityDAO.getActivityByActivityId(activityId);
    }

    @Override
    public Activity getActivityById(Long activityId, Class clasz) {
        return this.activityDAO.getActivityByActivityId(activityId, clasz);
    }

    @Override
    public GroupingActivity getGroupingActivityById(Long activityID) {
        Activity activity = this.getActivityById(activityID);
        if (activity == null) {
            String error = "Activity missing. ActivityID was " + activityID;
            log.error((Object)error);
            throw new MonitoringServiceException(error);
        }
        if (!activity.isGroupingActivity()) {
            String error = "Activity should have been GroupingActivity but was a different kind of activity. " + activity;
            log.error((Object)error);
            throw new MonitoringServiceException(error);
        }
        return (GroupingActivity)activity;
    }

    @Override
    public List<ContributeActivityDTO> getAllContributeActivityDTO(Long lessonID) {
        Vector<ContributeActivityDTO> result = null;
        Lesson lesson = this.lessonDAO.getLesson(lessonID);
        if (lesson != null) {
            ContributeActivitiesProcessor processor = new ContributeActivitiesProcessor(lesson.getLearningDesign(), lessonID, this.activityDAO, this.lamsCoreToolService);
            processor.parseLearningDesign();
            result = processor.getMainActivityList();
        }
        return result;
    }

    @Override
    public String getLearnerActivityURL(Long lessonID, Long activityID, Integer learnerUserID, Integer requestingUserId) throws IOException, LamsToolServiceException {
        Lesson lesson = this.lessonDAO.getLesson(lessonID);
        this.checkOwnerOrStaffMember(requestingUserId, lesson, "get monitoring learner progress url");
        Activity activity = this.activityDAO.getActivityByActivityId(activityID);
        User learner = (User)this.baseDAO.find(User.class, (Serializable)learnerUserID);
        String url = null;
        if (activity == null || learner == null) {
            log.error((Object)("getLearnerActivityURL activity or user missing. Activity ID " + activityID + " activity " + activity + " userID " + learnerUserID + " user " + learner));
        } else if (activity.isToolActivity()) {
            url = this.lamsCoreToolService.getToolLearnerProgressURL(lessonID, activity, learner);
        } else if (activity.isOptionsActivity() || activity.isParallelActivity()) {
            url = "monitoring/complexProgress.do?activityID=" + activityID + "&" + "lessonID" + "=" + lessonID + "&" + "userID" + "=" + learnerUserID;
        } else if (activity.isSystemToolActivity()) {
            url = this.lamsCoreToolService.getToolLearnerProgressURL(lessonID, activity, learner);
        }
        log.debug((Object)("url: " + url));
        return url;
    }

    @Override
    public String getActivityMonitorURL(Long lessonID, Long activityID, String contentFolderID, Integer userID) throws IOException, LamsToolServiceException {
        Lesson lesson = this.lessonDAO.getLesson(lessonID);
        this.checkOwnerOrStaffMember(userID, lesson, "get activity define later url");
        Activity activity = this.activityDAO.getActivityByActivityId(activityID);
        if (activity == null) {
            log.error((Object)("getActivityMonitorURL activity missing. Activity ID " + activityID + " activity " + activity));
        } else if (activity.isToolActivity() || activity.isSystemToolActivity()) {
            return this.lamsCoreToolService.getToolMonitoringURL(lessonID, activity) + "&contentFolderID=" + contentFolderID;
        }
        return null;
    }

    @Override
    public String moveLesson(Long lessonID, Integer targetWorkspaceFolderID, Integer userID) throws IOException {
        FlashMessage flashMessage;
        Lesson lesson = this.lessonDAO.getLesson(lessonID);
        if (lesson != null) {
            if (lesson.getUser().getUserId().equals(userID)) {
                WorkspaceFolder workspaceFolder = (WorkspaceFolder)this.baseDAO.find(WorkspaceFolder.class, (Serializable)targetWorkspaceFolderID);
                if (workspaceFolder != null) {
                    LearningDesign learningDesign = lesson.getLearningDesign();
                    learningDesign.setWorkspaceFolder(workspaceFolder);
                    this.learningDesignDAO.update((Object)learningDesign);
                    flashMessage = new FlashMessage("moveLesson", (Object)targetWorkspaceFolderID);
                } else {
                    flashMessage = FlashMessage.getNoSuchWorkspaceFolderExsists((String)"moveLesson", (Integer)targetWorkspaceFolderID);
                }
            } else {
                flashMessage = FlashMessage.getUserNotAuthorized((String)"moveLesson", (Integer)userID);
            }
        } else {
            flashMessage = new FlashMessage("moveLesson", (Object)this.messageService.getMessage("NO.SUCH.LESSON", new Object[]{lessonID}), 1);
        }
        return flashMessage.serializeMessage();
    }

    @Override
    public String renameLesson(Long lessonID, String newName, Integer userID) throws IOException {
        FlashMessage flashMessage;
        Lesson lesson = this.lessonDAO.getLesson(lessonID);
        if (lesson != null) {
            if (lesson.getUser().getUserId().equals(userID)) {
                lesson.setLessonName(newName);
                this.lessonDAO.updateLesson(lesson);
                flashMessage = new FlashMessage("renameLesson", (Object)newName);
            } else {
                flashMessage = FlashMessage.getUserNotAuthorized((String)"renameLesson", (Integer)userID);
            }
        } else {
            flashMessage = new FlashMessage("renameLesson", (Object)this.messageService.getMessage("NO.SUCH.LESSON", new Object[]{lessonID}), 1);
        }
        return flashMessage.serializeMessage();
    }

    @Override
    public String releaseGate(Long activityID) throws IOException {
        FlashMessage flashMessage;
        GateActivity gate = (GateActivity)this.activityDAO.getActivityByActivityId(activityID);
        if (gate == null) {
            flashMessage = new FlashMessage("releaseGate", (Object)this.messageService.getMessage("INVALID.ACTIVITYID", new Object[]{activityID}), 1);
        } else {
            gate = this.openGate(activityID);
            flashMessage = new FlashMessage("releaseGate", (Object)gate.getGateOpen());
        }
        return flashMessage.serializeMessage();
    }

    @Override
    public void performChosenGrouping(GroupingActivity groupingActivity, List groups) throws LessonServiceException {
        Grouping grouping = groupingActivity.getCreateGrouping();
        if (!grouping.isChosenGrouping()) {
            log.error((Object)("GroupingActivity [" + groupingActivity.getActivityId() + "] does not have chosen grouping."));
            throw new MonitoringServiceException("GroupingActivity [" + groupingActivity.getActivityId() + "] is not chosen grouping.");
        }
        try {
            Iterator<Object> iter = groups.iterator();
            TreeMap<Long, Hashtable> sortedMap = new TreeMap<Long, Hashtable>(new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    return ((Long)arg0).compareTo((Long)arg1);
                }
            });
            while (iter.hasNext()) {
                Hashtable group = (Hashtable)iter.next();
                Long orderId = WDDXProcessor.convertToLong((Hashtable)group, (String)"orderID");
                sortedMap.put(orderId, group);
            }
            iter = sortedMap.values().iterator();
            int orderId = 0;
            while (iter.hasNext()) {
                Hashtable group = (Hashtable)iter.next();
                List learnerIdList = (List)group.get("learners");
                String groupName = WDDXProcessor.convertToString((Hashtable)group, (String)"groupName");
                ArrayList<User> learners = new ArrayList<User>();
                for (int idx = 0; idx < learnerIdList.size(); ++idx) {
                    User user = (User)this.baseDAO.find(User.class, (Serializable)Integer.valueOf(((Double)learnerIdList.get(idx)).intValue()));
                    learners.add(user);
                }
                log.debug((Object)("Performing grouping for " + groupName + "..."));
                this.lessonService.performGrouping(groupingActivity, groupName, learners);
                log.debug((Object)("Finish grouping for " + groupName));
                ++orderId;
            }
            log.debug((Object)("Persist grouping for [" + grouping.getGroupingId() + "]..."));
            this.groupingDAO.update((Object)grouping);
            log.debug((Object)("Persist grouping for [" + grouping.getGroupingId() + "] success."));
        }
        catch (WDDXProcessorConversionException e) {
            throw new MonitoringServiceException("Perform chosen grouping occurs error when parsing WDDX package:" + e.getMessage());
        }
    }

    private LessonClass createLessonClass(Organisation organisation, String learnerGroupName, List<User> organizationUsers, String staffGroupName, List<User> staffs, Lesson newLesson) {
        LessonClass newLessonClass = this.createNewLessonClass(newLesson.getLearningDesign());
        this.lessonClassDAO.saveLessonClass(newLessonClass);
        newLessonClass.setStaffGroup(Group.createStaffGroup((Grouping)newLessonClass, (String)staffGroupName, new HashSet<User>(staffs)));
        newLessonClass.getGroups().add(Group.createLearnerGroup((Grouping)newLessonClass, (String)learnerGroupName, new HashSet<User>(organizationUsers)));
        this.lessonClassDAO.updateLessonClass(newLessonClass);
        return newLessonClass;
    }

    private Lesson createNewLesson(String lessonName, String lessonDescription, User user, LearningDesign copiedLearningDesign, Boolean enableLessonIntro, Boolean displayDesignImage, Boolean learnerExportAvailable, Boolean learnerPresenceAvailable, Boolean learnerImAvailable, Boolean liveEditEnabled, Boolean enableLessonNotifications, Boolean learnerRestart, Integer scheduledNumberDaysToLessonFinish, Lesson precedingLesson) {
        Lesson newLesson = Lesson.createNewLessonWithoutClass((String)lessonName, (String)lessonDescription, (User)user, (LearningDesign)copiedLearningDesign, (Boolean)enableLessonIntro, (Boolean)displayDesignImage, (Boolean)learnerExportAvailable, (Boolean)learnerPresenceAvailable, (Boolean)learnerImAvailable, (Boolean)liveEditEnabled, (Boolean)enableLessonNotifications, (Boolean)learnerRestart, (Integer)scheduledNumberDaysToLessonFinish);
        if (precedingLesson != null) {
            HashSet<Lesson> precedingLessons = new HashSet<Lesson>();
            precedingLessons.add(precedingLesson);
            newLesson.setPrecedingLessons(precedingLessons);
        }
        this.lessonDAO.saveLesson(newLesson);
        return newLesson;
    }

    private LessonClass createNewLessonClass(LearningDesign copiedLearningDesign) {
        HashSet activities = new HashSet(copiedLearningDesign.getActivities());
        LessonClass newLessonClass = new LessonClass(null, new HashSet(), activities, null, null);
        return newLessonClass;
    }

    @Override
    public void initToolSessionIfSuitable(ToolActivity activity, Lesson lesson) {
        if (activity.getApplyGrouping().equals(Boolean.FALSE) && activity.getParentBranch() == null) {
            activity.setToolSessions(new HashSet());
            try {
                Set newToolSessions = this.lamsCoreToolService.createToolSessions(lesson.getAllLearners(), activity, lesson);
                for (ToolSession toolSession : newToolSessions) {
                    this.lamsCoreToolService.notifyToolsToCreateSession(toolSession, activity);
                    activity.getToolSessions().add(toolSession);
                }
            }
            catch (LamsToolServiceException e) {
                String error = "Unable to initialise tool session. Fail to call tool services. Error was " + e.getMessage();
                log.error((Object)error, (Throwable)e);
                throw new MonitoringServiceException(error, e);
            }
            catch (ToolException e) {
                String error = "Unable to initialise tool session. Tool encountered an error. Error was " + e.getMessage();
                log.error((Object)error, (Throwable)e);
                throw new MonitoringServiceException(error, e);
            }
        }
    }

    private JobDetail getOpenScheduleGateJob() {
        return (JobDetail)this.applicationContext.getBean("openScheduleGateJob");
    }

    private JobDetail getStartScheduleLessonJob() {
        return (JobDetail)this.applicationContext.getBean("startScheduleLessonJob");
    }

    private JobDetail getFinishScheduleLessonJob() {
        return (JobDetail)this.applicationContext.getBean("finishScheduleLessonJob");
    }

    private JobDetail getCloseScheduleGateJob() {
        return (JobDetail)this.applicationContext.getBean("closeScheduleGateJob");
    }

    @Override
    public Lesson createPreviewClassForLesson(int userID, long lessonID) throws UserAccessDeniedException {
        User user = (User)this.baseDAO.find(User.class, (Serializable)Integer.valueOf(userID));
        if (user == null) {
            throw new UserAccessDeniedException("User " + userID + " not found");
        }
        LinkedList<User> learners = new LinkedList<User>();
        learners.add(user);
        LinkedList<User> staffs = new LinkedList<User>();
        staffs.add(user);
        return this.createLessonClassForLesson(lessonID, null, "Learner Group", learners, "Staff Group", staffs, userID);
    }

    @Override
    public void deletePreviewLesson(long lessonID) {
        Lesson lesson = this.lessonDAO.getLesson(new Long(lessonID));
        this.deletePreviewLesson(lesson);
    }

    private void deletePreviewLesson(Lesson lesson) {
        if (lesson != null) {
            if (lesson.isPreviewLesson()) {
                List toolSessions = this.lamsCoreToolService.getToolSessionsByLesson(lesson);
                if (toolSessions != null && toolSessions.size() > 0) {
                    for (ToolSession toolSession : toolSessions) {
                        this.lamsCoreToolService.deleteToolSession(toolSession);
                    }
                } else {
                    log.debug((Object)"deletePreviewLesson: Removing tool sessions - none exist");
                }
                LearningDesign ld = lesson.getLearningDesign();
                this.lessonDAO.deleteLesson(lesson);
                this.authoringService.deleteLearningDesign(ld);
            } else {
                log.warn((Object)("Unable to delete lesson as lesson is not a preview lesson. Learning design copy type was " + lesson.getLearningDesign().getCopyTypeID()));
            }
        }
    }

    @Override
    public int deleteAllOldPreviewLessons() {
        int numDays = Configuration.getAsInt((String)ConfigurationKeys.PREVIEW_CLEANUP_NUM_DAYS);
        if (numDays <= 0) {
            log.error((Object)("deleteAllOldPreviewSessions: number of days invalid (" + numDays + "). See configuration file (option " + ConfigurationKeys.PREVIEW_CLEANUP_NUM_DAYS + " Unable to delete any preview lessons"));
            return 0;
        }
        int numDeleted = 0;
        long newestDateToKeep = System.currentTimeMillis() - (long)numDays * 86400000L;
        Date date = new Date(newestDateToKeep);
        log.info((Object)("Deleting all preview lessons before " + date.toString() + " (server time) (" + newestDateToKeep + ")"));
        List sessions = this.lessonDAO.getPreviewLessonsBeforeDate(date);
        for (Lesson lesson : sessions) {
            try {
                this.deletePreviewLesson(lesson);
                ++numDeleted;
            }
            catch (Exception e) {
                log.error((Object)("Unable to delete lesson " + lesson.getLessonId() + " due to exception."), (Throwable)e);
            }
        }
        return numDeleted;
    }

    @Override
    public SortedSet<User> getClassMembersNotGrouped(Long lessonID, Long activityID, boolean useCreateGrouping) {
        Activity activity = this.getActivityById(activityID);
        Grouping grouping = this.getGroupingForActivity(activity, useCreateGrouping, "getClassMembersNotGrouped");
        Lesson lesson = this.lessonDAO.getLesson(lessonID);
        if (lesson == null) {
            String error = "Lesson missing. LessonID was " + lessonID + " Activity id was " + activityID;
            log.error((Object)error);
            throw new MonitoringServiceException(error);
        }
        Set learners = lesson.getAllLearners();
        if (log.isDebugEnabled()) {
            log.debug((Object)("getClassMembersNotGrouped: Lesson " + lessonID + " has " + learners.size() + " learners."));
        }
        for (Group group : grouping.getGroups()) {
            learners.removeAll(group.getUsers());
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("getClassMembersNotGrouped: Group " + group.getGroupId() + " has " + group.getUsers().size() + " members."));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getClassMembersNotGrouped: Lesson " + lessonID + " has " + learners.size() + " learners."));
        }
        TreeSet<User> sortedUsers = new TreeSet<User>((Comparator<User>)new LastNameAlphabeticComparator());
        sortedUsers.addAll(learners);
        return sortedUsers;
    }

    private Grouping getGroupingForActivity(Activity activity, boolean useCreateGrouping, String methodName) {
        if (useCreateGrouping && (activity == null || !activity.isGroupingActivity())) {
            String error = methodName + ": Trying to use the create grouping option but the activity isn't a grouping activity. Activity was " + activity;
            log.error((Object)error);
            throw new MonitoringServiceException(error);
        }
        Grouping grouping = null;
        if (useCreateGrouping) {
            GroupingActivity groupingActivity = (GroupingActivity)activity;
            grouping = groupingActivity.getCreateGrouping();
        } else {
            grouping = activity.getGrouping();
        }
        if (grouping == null) {
            String error = methodName + ": Grouping activity missing grouping. Activity was " + activity;
            log.error((Object)error);
            throw new MonitoringServiceException(error);
        }
        return grouping;
    }

    @Override
    public Group addGroup(Long activityID, String name, boolean overrideMaxNumberOfGroups) throws LessonServiceException, MonitoringServiceException {
        Activity activity = this.getActivityById(activityID);
        Grouping grouping = this.getGroupingForActivity(activity, true, "addGroup");
        if (overrideMaxNumberOfGroups && grouping.getMaxNumberOfGroups() != null && grouping.getMaxNumberOfGroups() > 0 && grouping.getGroups() != null && grouping.getGroups().size() >= grouping.getMaxNumberOfGroups()) {
            boolean usedForBranching = grouping.isUsedForBranching();
            if (!usedForBranching) {
                log.info((Object)("Setting max number of groups to null for grouping " + grouping + " we have been asked to add a group in excess of the max number of groups (probably via the Chosen Grouping screen)."));
                grouping.setMaxNumberOfGroups(null);
            } else {
                log.error((Object)("Request made to add a group which would be more than the max number of groups for the grouping " + grouping + ". This grouping is used for branching so we can't increase the max group number."));
                throw new MonitoringServiceException("Cannot increase the number of groups for the grouping " + grouping + " as this grouping is used for a branching activity.");
            }
        }
        return this.lessonService.createGroup(grouping, name);
    }

    @Override
    public void removeGroup(Long activityID, Long groupId) throws LessonServiceException {
        Activity activity = this.getActivityById(activityID);
        Grouping grouping = this.getGroupingForActivity(activity, true, "removeGroup");
        this.lessonService.removeGroup(grouping, groupId);
    }

    @Override
    public void addUsersToGroup(Long activityID, Long groupId, String[] learnerIDs) throws LessonServiceException {
        Activity activity = this.getActivityById(activityID);
        Grouping grouping = this.getGroupingForActivity(activity, true, "addUsersToGroup");
        ArrayList<User> learners = this.createUserList(activityID, learnerIDs, "add");
        this.lessonService.performGrouping(grouping, groupId, learners);
    }

    private ArrayList<User> createUserList(Long activityIDForErrorMessage, String[] learnerIDs, String addRemoveTextForErrorMessage) {
        ArrayList<User> learners = new ArrayList<User>();
        for (String strlearnerID : learnerIDs) {
            boolean added = false;
            try {
                Integer learnerID = new Integer(Integer.parseInt(strlearnerID));
                User learner = (User)this.baseDAO.find(User.class, (Serializable)learnerID);
                if (learner != null) {
                    learners.add(learner);
                    added = true;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (added) continue;
            log.warn((Object)("Unable to " + addRemoveTextForErrorMessage + " learner " + strlearnerID + " for group in related to activity " + activityIDForErrorMessage + " as learner cannot be found."));
        }
        return learners;
    }

    @Override
    public void addUsersToBranch(Long sequenceActivityID, String[] learnerIDs) throws LessonServiceException {
        SequenceActivity branch = (SequenceActivity)this.getActivityById(sequenceActivityID);
        if (branch == null) {
            String error = "addUsersToBranch: Branch missing. ActivityID was " + sequenceActivityID;
            log.error((Object)error);
            throw new MonitoringServiceException(error);
        }
        Group group = branch.getSoleGroupForBranch();
        Grouping grouping = null;
        if (group == null) {
            Activity parentActivity = branch.getParentActivity();
            if (parentActivity == null || !parentActivity.isBranchingActivity()) {
                String error = "addUsersToBranch: Branching activity missing or not a branching activity. Branch was " + branch + " parent activity was " + parentActivity;
                log.error((Object)error);
                throw new MonitoringServiceException(error);
            }
            BranchingActivity branchingActivity = (BranchingActivity)this.getActivityById(parentActivity.getActivityId());
            grouping = branchingActivity.getGrouping();
            LearningDesign design = branchingActivity.getLearningDesign();
            group = this.lessonService.createGroup(grouping, branch.getTitle());
            this.groupingDAO.insert((Object)group);
            Integer nextUIID = new Integer(design.getMaxID() + 1);
            group.setGroupUIID(nextUIID);
            nextUIID = new Integer(nextUIID + 1);
            group.allocateBranchToGroup(nextUIID, branch, branchingActivity);
            this.groupingDAO.update((Object)group);
            design.setMaxID(new Integer(nextUIID + 1));
            this.learningDesignDAO.update((Object)design);
        } else {
            grouping = group.getGrouping();
        }
        ArrayList<User> learners = this.createUserList(sequenceActivityID, learnerIDs, "add");
        this.lessonService.performGrouping(grouping, group.getGroupId(), learners);
    }

    @Override
    public void removeUsersFromGroup(Long activityID, Long groupId, String[] learnerIDs) throws LessonServiceException {
        Activity activity = this.getActivityById(activityID);
        Grouping grouping = this.getGroupingForActivity(activity, true, "removeUsersFromGroup");
        ArrayList<User> learners = this.createUserList(activityID, learnerIDs, "remove");
        this.lessonService.removeLearnersFromGroup(grouping, groupId, learners);
    }

    @Override
    public void removeUsersFromBranch(Long sequenceActivityID, String[] learnerIDs) throws LessonServiceException {
        SequenceActivity branch = (SequenceActivity)this.getActivityById(sequenceActivityID);
        if (branch == null) {
            String error = "addUsersToBranch: Branch missing. ActivityID was " + sequenceActivityID;
            log.error((Object)error);
            throw new MonitoringServiceException(error);
        }
        Group group = branch.getSoleGroupForBranch();
        Grouping grouping = null;
        if (group != null) {
            grouping = group.getGrouping();
            ArrayList<User> learners = this.createUserList(sequenceActivityID, learnerIDs, "remove");
            this.lessonService.removeLearnersFromGroup(grouping, group.getGroupId(), learners);
        } else {
            log.warn((Object)("Trying to remove users " + learnerIDs + " from branch " + branch + " but no group exists for this branch, so the users can't be in the group!"));
        }
    }

    @Override
    public void addGroupToBranch(Long sequenceActivityID, String[] groupIDs) throws LessonServiceException {
        SequenceActivity branch = (SequenceActivity)this.getActivityById(sequenceActivityID);
        if (branch == null) {
            String error = "addGroupToBranch: Branch missing. ActivityID was " + sequenceActivityID;
            log.error((Object)error);
            throw new MonitoringServiceException(error);
        }
        Activity parentActivity = branch.getParentActivity();
        if (parentActivity == null || !parentActivity.isBranchingActivity()) {
            String error = "addUsersToBranch: Branching activity missing or not a branching activity. Branch was " + branch + " parent activity was " + parentActivity;
            log.error((Object)error);
            throw new MonitoringServiceException(error);
        }
        BranchingActivity branchingActivity = (BranchingActivity)this.getActivityById(parentActivity.getActivityId());
        Grouping grouping = branchingActivity.getGrouping();
        LearningDesign design = branchingActivity.getLearningDesign();
        Integer nextUIID = new Integer(design.getMaxID() + 1);
        for (String groupIDString : groupIDs) {
            Long groupID = Long.parseLong(groupIDString);
            Group group = null;
            Iterator groupIterator = grouping.getGroups().iterator();
            while (groupIterator.hasNext() && group == null) {
                Group obj = (Group)groupIterator.next();
                if (!obj.getGroupId().equals(groupID)) continue;
                group = obj;
            }
            if (group == null) {
                String error = "addGroupToBranch: Group missing. Group ID was " + groupIDString;
                log.error((Object)error);
                throw new MonitoringServiceException(error);
            }
            group.allocateBranchToGroup(nextUIID, branch, branchingActivity);
            this.groupingDAO.update(group);
        }
        design.setMaxID(new Integer(nextUIID + 1));
        this.learningDesignDAO.update((Object)design);
    }

    @Override
    public void removeGroupFromBranch(Long sequenceActivityID, String[] groupIDs) throws LessonServiceException {
        SequenceActivity branch = (SequenceActivity)this.getActivityById(sequenceActivityID);
        if (branch == null) {
            String error = "addUsersToBranch: Branch missing. ActivityID was " + sequenceActivityID;
            log.error((Object)error);
            throw new MonitoringServiceException(error);
        }
        Activity parentActivity = branch.getParentActivity();
        if (parentActivity == null || !parentActivity.isBranchingActivity()) {
            String error = "addUsersToBranch: Branching activity missing or not a branching activity. Branch was " + branch + " parent activity was " + parentActivity;
            log.error((Object)error);
            throw new MonitoringServiceException(error);
        }
        BranchingActivity branchingActivity = (BranchingActivity)this.getActivityById(parentActivity.getActivityId());
        Grouping grouping = branchingActivity.getGrouping();
        for (String groupIDString : groupIDs) {
            Long groupID = Long.parseLong(groupIDString);
            Group group = null;
            Iterator groupIterator = grouping.getGroups().iterator();
            while (groupIterator.hasNext() && group == null) {
                Group obj = (Group)groupIterator.next();
                if (!obj.getGroupId().equals(groupID)) continue;
                group = obj;
            }
            if (group == null) {
                String error = "removeGroupFromBranch: Group missing. Group ID was " + groupIDString;
                log.error((Object)error);
                throw new MonitoringServiceException(error);
            }
            if (this.isActivityAttempted((Activity)branch)) {
                log.warn((Object)("removeGroupFromBranch: A group member has already started the branch. Unable to remove the group from the branch. Group ID was " + groupIDString));
                continue;
            }
            branch.removeGroupFromBranch(group);
            this.activityDAO.update((Object)branch);
        }
    }

    @Override
    public boolean isActivityAttempted(Activity activity) {
        Integer numAttempted = this.lessonService.getCountLearnersHaveAttemptedActivity(activity);
        if (log.isDebugEnabled()) {
            log.debug((Object)("isActivityAttempted: num attempts for activity " + activity.getActivityId() + " is " + numAttempted));
        }
        return numAttempted != null && numAttempted > 0;
    }

    @Override
    public SortedSet<Group> getGroupsNotAssignedToBranch(Long branchingActivityID) throws LessonServiceException {
        BranchingActivity branchingActivity = (BranchingActivity)this.getActivityById(branchingActivityID);
        if (branchingActivity == null) {
            String error = "getGroupsNotAssignedToBranch: Branching Activity missing missing. ActivityID was " + branchingActivityID;
            log.error((Object)error);
            throw new MonitoringServiceException(error);
        }
        TreeSet<Group> unassignedGroups = new TreeSet<Group>();
        Grouping grouping = branchingActivity.getGrouping();
        for (Group group : grouping.getGroups()) {
            if (group.getBranchActivities() != null && group.getBranchActivities().size() != 0) continue;
            unassignedGroups.add(group);
        }
        return unassignedGroups;
    }

    @Override
    public List<User> getLearnersHaveAttemptedActivity(Activity activity) throws LessonServiceException {
        return this.lessonService.getLearnersHaveAttemptedActivity(activity);
    }

    @Override
    public LearnerProgress getLearnerProgress(Integer learnerId, Long lessonId) {
        return this.learnerService.getProgress(learnerId, lessonId);
    }

    @Override
    public void setGroupName(Long groupID, String name) {
        Group group = this.groupDAO.getGroupById(groupID);
        group.setGroupName(name);
        this.groupDAO.saveGroup(group);
    }

    @Override
    public Organisation getOrganisation(Integer organisationId) {
        return (Organisation)this.baseDAO.find(Organisation.class, (Serializable)organisationId);
    }

    @Override
    public int cloneLessons(String[] lessonIds, Boolean addAllStaff, Boolean addAllLearners, String[] staffIds, String[] learnerIds, Organisation group) throws MonitoringServiceException {
        int result = 0;
        for (String l : lessonIds) {
            Lesson lesson = this.lessonService.getLesson(Long.valueOf(l));
            if (lesson != null) {
                HttpSession ss = SessionManager.getSession();
                if (ss == null) continue;
                UserDTO userDto = (UserDTO)ss.getAttribute("user");
                if (userDto != null) {
                    if (!addAllStaff.booleanValue() && staffIds.length > 0 || addAllStaff.booleanValue()) {
                        String staffGroupName = group.getName() + " Staff";
                        List<User> staffUsers = this.createStaffGroup(group.getOrganisationId(), addAllStaff, staffIds);
                        if (!addAllLearners.booleanValue() && learnerIds.length > 0 || addAllLearners.booleanValue()) {
                            String learnerGroupName = group.getName() + " Learners";
                            List<User> learnerUsers = this.createLearnerGroup(group.getOrganisationId(), addAllLearners, learnerIds);
                            Lesson newLesson = this.initializeLesson(lesson.getLessonName(), lesson.getLessonDescription(), lesson.getLearningDesign().getLearningDesignId(), group.getOrganisationId(), userDto.getUserID(), null, lesson.isEnableLessonIntro(), lesson.isDisplayDesignImage(), lesson.getLearnerExportAvailable(), lesson.getLearnerPresenceAvailable(), lesson.getLearnerImAvailable(), lesson.getLiveEditEnabled(), lesson.getEnableLessonNotifications(), lesson.getLearnerRestart(), null, null);
                            newLesson = this.createLessonClassForLesson(newLesson.getLessonId(), group, learnerGroupName, learnerUsers, staffGroupName, staffUsers, userDto.getUserID());
                            this.startLesson(newLesson.getLessonId(), staffUsers.get(0).getUserId());
                            ++result;
                            continue;
                        }
                        throw new MonitoringServiceException("No learners specified, can't create any Lessons.");
                    }
                    throw new MonitoringServiceException("No staff specified, can't create any Lessons.");
                }
                throw new MonitoringServiceException("No UserDTO in session, can't create any Lessons.");
            }
            throw new MonitoringServiceException("Couldn't find Lesson based on id=" + l);
        }
        return result;
    }

    private List<User> createLearnerGroup(Integer groupId, Boolean addAllLearners, String[] learnerIds) {
        ArrayList<User> learnerUsers = new ArrayList<User>();
        if (addAllLearners.booleanValue()) {
            Vector learnerVector = this.userManagementService.getUsersFromOrganisationByRole(groupId, "LEARNER", false, true);
            learnerUsers.addAll(learnerVector);
        } else {
            User user = null;
            for (String l : learnerIds) {
                user = (User)this.userManagementService.findById(User.class, (Serializable)Integer.valueOf(Integer.parseInt(l)));
                if (user != null) {
                    learnerUsers.add(user);
                    continue;
                }
                log.error((Object)("Couldn't find User based on id=" + l));
            }
        }
        return learnerUsers;
    }

    private List<User> createStaffGroup(Integer groupId, Boolean addAllStaff, String[] staffIds) {
        ArrayList<User> staffUsers = new ArrayList<User>();
        if (addAllStaff.booleanValue()) {
            Vector staffVector = this.userManagementService.getUsersFromOrganisationByRole(groupId, "MONITOR", false, true);
            staffUsers.addAll(staffVector);
        } else {
            User user = null;
            for (String s : staffIds) {
                user = (User)this.userManagementService.findById(User.class, (Serializable)Integer.valueOf(Integer.parseInt(s)));
                if (user != null) {
                    staffUsers.add(user);
                    continue;
                }
                log.error((Object)("Couldn't find User based on id=" + s));
            }
        }
        return staffUsers;
    }
}

