/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.monitoring.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.BranchActivityEntry;
import org.lamsfoundation.lams.learningdesign.BranchingActivity;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.learningdesign.SequenceActivity;
import org.lamsfoundation.lams.monitoring.dto.BranchDTO;
import org.lamsfoundation.lams.monitoring.dto.BranchingDTO;
import org.lamsfoundation.lams.monitoring.service.IMonitoringService;
import org.lamsfoundation.lams.monitoring.service.MonitoringServiceProxy;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;

public class BranchingAction
extends LamsDispatchAction {
    protected static final String VIEW_BRANCHES_SCREEN = "viewBranches";
    protected static final String CHOSEN_SELECTION_SCREEN = "chosenSelection";
    public static final String PARAM_BRANCHING_DTO = "branching";
    public static final String PARAM_SHOW_GROUP_NAME = "showGroupName";
    public static final String PARAM_LOCAL_FILES = "localFiles";
    public static final String PARAM_MAY_DELETE = "mayDelete";
    public static final String PARAM_MODULE_LANGUAGE_XML = "languageXML";
    protected static final String PARAM_VIEW_MODE = "viewMode";

    public ActionForward exportPortfolio(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        long activityId = WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID");
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        BranchingActivity activity = (BranchingActivity)monitoringService.getActivityById(activityId, BranchingActivity.class);
        return this.viewBranching(activity, lessonId, true, mapping, request, monitoringService);
    }

    public ActionForward viewBranching(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        long activityId = WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID");
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        BranchingActivity activity = (BranchingActivity)monitoringService.getActivityById(activityId, BranchingActivity.class);
        return this.viewBranching(activity, lessonId, false, mapping, request, monitoringService);
    }

    protected ActionForward viewBranching(BranchingActivity activity, Long lessonId, boolean useLocalFiles, ActionMapping mapping, HttpServletRequest request, IMonitoringService monitoringService) throws IOException, ServletException {
        request.setAttribute("activityID", (Object)activity.getActivityId());
        request.setAttribute("lessonID", (Object)lessonId);
        request.setAttribute("title", (Object)activity.getTitle());
        request.setAttribute(PARAM_LOCAL_FILES, (Object)useLocalFiles);
        request.setAttribute(PARAM_MODULE_LANGUAGE_XML, (Object)this.getLanguageXML());
        request.setAttribute(PARAM_MAY_DELETE, (Object)Boolean.FALSE);
        request.setAttribute(PARAM_VIEW_MODE, (Object)Boolean.TRUE);
        BranchingDTO dto = this.getBranchingDTO(activity, monitoringService);
        request.setAttribute(PARAM_BRANCHING_DTO, (Object)dto);
        request.setAttribute(PARAM_SHOW_GROUP_NAME, (Object)activity.isGroupBranchingActivity());
        if (log.isDebugEnabled()) {
            log.debug((Object)("viewBranching: Branching activity " + dto));
        }
        return mapping.findForward(CHOSEN_SELECTION_SCREEN);
    }

    private BranchingDTO getBranchingDTO(BranchingActivity activity, IMonitoringService monitoringService) {
        BranchingDTO dto = new BranchingDTO();
        dto.setBranchActivityId(activity.getActivityId());
        dto.setBranchActivityName(activity.getTitle());
        TreeSet<BranchDTO> branches = new TreeSet<BranchDTO>();
        for (Activity childActivity : activity.getActivities()) {
            SequenceActivity branch = (SequenceActivity)monitoringService.getActivityById(childActivity.getActivityId(), SequenceActivity.class);
            Set mappingEntries = branch.getBranchEntries();
            TreeSet<Group> groups = new TreeSet<Group>();
            if (activity.isChosenBranchingActivity() || activity.isGroupBranchingActivity()) {
                for (BranchActivityEntry entry : mappingEntries) {
                    Group group = entry.getGroup();
                    groups.add(group);
                }
            } else {
                Group group = new Group();
                if (group.getUsers() == null) {
                    group.setUsers(new HashSet());
                }
                List<User> learners = monitoringService.getLearnersHaveAttemptedActivity((Activity)branch);
                group.getUsers().addAll(learners);
                groups.add(group);
            }
            branches.add(new BranchDTO(branch, groups));
        }
        dto.setBranches(branches);
        return dto;
    }

    protected String getLanguageXML() {
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        MessageService messageService = monitoringService.getMessageService();
        ArrayList<String> languageCollection = new ArrayList<String>();
        languageCollection.add(new String("button.finished"));
        languageCollection.add(new String("label.branching.non.allocated.users.heading"));
        languageCollection.add(new String("label.grouping.status"));
        languageCollection.add(new String("label.grouping.learners"));
        languageCollection.add(new String("error.title"));
        languageCollection.add(new String("label.branching.popup.drag.selection.message"));
        String languageOutput = "<xml><language>";
        for (int i = 0; i < languageCollection.size(); ++i) {
            languageOutput = languageOutput + "<entry key='" + (String)languageCollection.get(i) + "'><name>" + messageService.getMessage((String)languageCollection.get(i)) + "</name></entry>";
        }
        languageOutput = languageOutput + "</language></xml>";
        return languageOutput;
    }
}

