/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.monitoring.web;

import java.io.IOException;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.tomcat.util.json.JSONArray;
import org.apache.tomcat.util.json.JSONException;
import org.apache.tomcat.util.json.JSONObject;
import org.lamsfoundation.lams.events.IEventNotificationService;
import org.lamsfoundation.lams.learning.service.ICoreLearnerService;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.util.LessonComparator;
import org.lamsfoundation.lams.monitoring.dto.EmailScheduleMessageJobDTO;
import org.lamsfoundation.lams.monitoring.service.IMonitoringService;
import org.lamsfoundation.lams.monitoring.service.MonitoringServiceProxy;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.DateUtil;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class EmailNotificationsAction
extends LamsDispatchAction {
    private static final String TRIGGER_PREFIX_NAME = "emailMessageOnScheduleTrigger:";
    private static IEventNotificationService eventNotificationService;
    private static IUserManagementService userManagementService;

    public ActionForward getLessonView(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ICoreLearnerService learnerService = MonitoringServiceProxy.getLearnerService(this.getServlet().getServletContext());
        long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        Lesson lesson = learnerService.getLesson(Long.valueOf(lessonId));
        Set activities = lesson.getLearningDesign().getActivities();
        request.setAttribute("lesson", (Object)lesson);
        request.setAttribute("activities", (Object)activities);
        return mapping.findForward("lessonView");
    }

    public ActionForward getCourseView(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ICoreLearnerService learnerService = MonitoringServiceProxy.getLearnerService(this.getServlet().getServletContext());
        int orgId = WebUtil.readIntParam((HttpServletRequest)request, (String)"organisationID");
        Organisation org = (Organisation)learnerService.getUserManagementService().findById(Organisation.class, (Serializable)Integer.valueOf(orgId));
        TreeSet<Lesson> lessons = new TreeSet<Lesson>((Comparator<Lesson>)new LessonComparator());
        for (Lesson lesson : org.getLessons()) {
            if (Lesson.REMOVED_STATE.equals(lesson.getLessonStateId()) || Lesson.FINISHED_STATE.equals(lesson.getLessonStateId())) continue;
            lessons.add(lesson);
        }
        Lesson firstLesson = null;
        Iterator lessonIter = lessons.iterator();
        if (lessonIter.hasNext()) {
            firstLesson = (Lesson)lessonIter.next();
        }
        request.setAttribute("org", (Object)org);
        request.setAttribute("lessons", lessons);
        request.setAttribute("firstLesson", (Object)firstLesson);
        return mapping.findForward("courseView");
    }

    public ActionForward showScheduledEmails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, SchedulerException {
        String[] triggerNames;
        this.getUserManagementService();
        Scheduler scheduler = this.getScheduler();
        TreeSet<EmailScheduleMessageJobDTO> scheduleList = new TreeSet<EmailScheduleMessageJobDTO>();
        Long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID", (boolean)true);
        boolean isLessonNotifications = lessonId != null;
        Integer organisationId = WebUtil.readIntParam((HttpServletRequest)request, (String)"organisationID", (boolean)true);
        for (String triggerName : triggerNames = scheduler.getTriggerNames("DEFAULT")) {
            Object jobOrganisationId;
            Object jobLessonId;
            if (!triggerName.startsWith(TRIGGER_PREFIX_NAME)) continue;
            Trigger trigger = scheduler.getTrigger(triggerName, "DEFAULT");
            JobDetail jobDetail = scheduler.getJobDetail(trigger.getJobName(), "DEFAULT");
            JobDataMap jobDataMap = jobDetail.getJobDataMap();
            if (isLessonNotifications ? (jobLessonId = jobDataMap.get((Object)"lessonID")) == null || !lessonId.equals(jobLessonId) : (jobOrganisationId = jobDataMap.get((Object)"organisationID")) == null || !organisationId.equals(jobOrganisationId)) continue;
            Date triggerDate = trigger.getNextFireTime();
            String emailBody = WebUtil.convertNewlines((String)((String)jobDataMap.get((Object)"emailBody")));
            int searchType = (Integer)jobDataMap.get((Object)"searchType");
            EmailScheduleMessageJobDTO emailScheduleJobDTO = new EmailScheduleMessageJobDTO();
            emailScheduleJobDTO.setTriggerDate(triggerDate);
            emailScheduleJobDTO.setEmailBody(emailBody);
            emailScheduleJobDTO.setSearchType(searchType);
            scheduleList.add(emailScheduleJobDTO);
        }
        request.setAttribute("scheduleList", scheduleList);
        request.setAttribute("lessonID", (Object)lessonId);
        request.setAttribute("organisationID", (Object)organisationId);
        return mapping.findForward("scheduledEmailList");
    }

    public ActionForward emailUsers(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, JSONException {
        JSONObject JSONObject2 = new JSONObject();
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        this.getEventNotificationService();
        String emailBody = WebUtil.readStrParam((HttpServletRequest)request, (String)"emailBody");
        Long scheduleDateParameter = WebUtil.readLongParam((HttpServletRequest)request, (String)"scheduleDate", (boolean)true);
        if (scheduleDateParameter == null) {
            String[] userIdStrs;
            boolean isSuccessfullySent = true;
            for (String userIdStr : userIdStrs = request.getParameterValues("userId")) {
                int userId = Integer.parseInt(userIdStr);
                boolean isHtmlFormat = false;
                isSuccessfullySent &= eventNotificationService.sendMessage(null, Integer.valueOf(userId), IEventNotificationService.DELIVERY_METHOD_MAIL, monitoringService.getMessageService().getMessage("event.emailnotifications.email.subject", new Object[0]), emailBody, isHtmlFormat);
            }
            JSONObject2.put("isSuccessfullySent", isSuccessfullySent);
        } else {
            try {
                Calendar now = Calendar.getInstance();
                Date scheduleDateTeacherTimezone = new Date(scheduleDateParameter);
                HttpSession ss = SessionManager.getSession();
                UserDTO teacher = (UserDTO)ss.getAttribute("user");
                TimeZone teacherTimeZone = teacher.getTimeZone();
                Date scheduleDate = DateUtil.convertFromTimeZoneToDefault((TimeZone)teacherTimeZone, (Date)scheduleDateTeacherTimezone);
                JobDetail emailScheduleMessageJob = this.getEmailScheduleMessageJob();
                emailScheduleMessageJob.setName("emailScheduleMessageJob:" + now.getTimeInMillis());
                emailScheduleMessageJob.setDescription("schedule email message to user(s)");
                emailScheduleMessageJob.getJobDataMap().put("emailBody", emailBody);
                this.copySearchParametersFromRequestToMap(request, (Map)emailScheduleMessageJob.getJobDataMap());
                SimpleTrigger startLessonTrigger = new SimpleTrigger(TRIGGER_PREFIX_NAME + now.getTimeInMillis(), "DEFAULT", scheduleDate);
                Scheduler scheduler = this.getScheduler();
                scheduler.scheduleJob(emailScheduleMessageJob, (Trigger)startLessonTrigger);
                JSONObject2.put("isSuccessfullyScheduled", true);
                log.debug((Object)("Emails have been successfully scheduled to be sent on " + scheduleDate + " [search type is " + request.getParameter("searchType") + "]"));
            }
            catch (SchedulerException e) {
                log.error((Object)"Error occurred at [emailScheduleMessage]- fail to email scheduling", (Throwable)e);
            }
        }
        response.setContentType("application/json;charset=utf-8");
        response.getWriter().print(JSONObject2);
        return null;
    }

    public ActionForward getUsers(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, JSONException {
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        ICoreLearnerService learnerService = MonitoringServiceProxy.getLearnerService(this.getServlet().getServletContext());
        HashMap map = new HashMap();
        this.copySearchParametersFromRequestToMap(request, map);
        int searchType = (Integer)map.get("searchType");
        Long lessonId = (Long)map.get("lessonID");
        Integer orgId = (Integer)map.get("organisationID");
        Long activityId = (Long)map.get("activityID");
        Integer xDaystoFinish = (Integer)map.get("daysToDeadline");
        String[] lessonIds = (String[])map.get("lessonIDs");
        Collection<User> users = monitoringService.getUsersByEmailNotificationSearchType(searchType, lessonId, lessonIds, activityId, xDaystoFinish, orgId);
        JSONArray cellarray = new JSONArray();
        JSONObject responcedata = new JSONObject();
        responcedata.put("total", (Object)("" + users.size()));
        responcedata.put("page", (Object)"1");
        responcedata.put("records", (Object)("" + users.size()));
        for (User user : users) {
            JSONArray cell = new JSONArray();
            cell.put((Object)(StringEscapeUtils.escapeHtml((String)user.getFirstName()) + " " + StringEscapeUtils.escapeHtml((String)user.getLastName()) + " [" + StringEscapeUtils.escapeHtml((String)user.getLogin()) + "]"));
            JSONObject cellobj = new JSONObject();
            cellobj.put("id", (Object)("" + user.getUserId()));
            cellobj.put("cell", (Object)cell);
            cellarray.put((Object)cellobj);
        }
        responcedata.put("rows", (Object)cellarray);
        response.setContentType("application/json;charset=utf-8");
        response.getWriter().print(new String(responcedata.toString()));
        return null;
    }

    private void copySearchParametersFromRequestToMap(HttpServletRequest request, Map map) {
        int searchType = WebUtil.readIntParam((HttpServletRequest)request, (String)"searchType");
        Assert.notNull((Object)searchType);
        map.put("searchType", searchType);
        switch (searchType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                Long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
                Assert.notNull((Object)lessonId);
                map.put("lessonID", lessonId);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                Integer organisationId = WebUtil.readIntParam((HttpServletRequest)request, (String)"organisationID");
                Assert.notNull((Object)organisationId);
                map.put("organisationID", organisationId);
            }
        }
        switch (searchType) {
            case 5: {
                Long activityId = WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID");
                Assert.notNull((Object)activityId);
                map.put("activityID", activityId);
                break;
            }
            case 6: {
                Integer xDaystoFinish = WebUtil.readIntParam((HttpServletRequest)request, (String)"daysToDeadline");
                Assert.notNull((Object)xDaystoFinish);
                map.put("daysToDeadline", xDaystoFinish);
                break;
            }
            case 7: 
            case 8: {
                Long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
                Assert.notNull((Object)lessonId);
                map.put("lessonID", lessonId);
                break;
            }
            case 10: 
            case 11: {
                String[] lessonIds = request.getParameterValues("lessonID");
                Assert.notNull((Object)lessonIds);
                map.put("lessonIDs", lessonIds);
            }
        }
    }

    private IEventNotificationService getEventNotificationService() {
        if (eventNotificationService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            eventNotificationService = (IEventNotificationService)ctx.getBean("eventNotificationService");
        }
        return eventNotificationService;
    }

    private IUserManagementService getUserManagementService() {
        if (userManagementService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            userManagementService = (IUserManagementService)ctx.getBean("userManagementService");
        }
        return userManagementService;
    }

    private JobDetail getEmailScheduleMessageJob() {
        WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
        return (JobDetail)ctx.getBean("emailScheduleMessageJob");
    }

    private Scheduler getScheduler() {
        WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
        return (Scheduler)ctx.getBean("scheduler");
    }
}

