/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.monitoring.web;

import java.io.IOException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.lamsfoundation.lams.learning.service.ICoreLearnerService;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.GateActivity;
import org.lamsfoundation.lams.learningdesign.ScheduleGateActivity;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.monitoring.service.IMonitoringService;
import org.lamsfoundation.lams.monitoring.service.MonitoringServiceException;
import org.lamsfoundation.lams.monitoring.service.MonitoringServiceProxy;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;

public class GateAction
extends LamsDispatchAction {
    private IMonitoringService monitoringService;
    private ICoreLearnerService learnerService;
    private static final String VIEW_SYNCH_GATE = "viewSynchGate";
    private static final String VIEW_PERMISSION_GATE = "viewPermissionGate";
    private static final String VIEW_SCHEDULE_GATE = "viewScheduleGate";
    private static final String VIEW_CONDITION_GATE = "viewConditionGate";
    private static final String ACTIVITY_FORM_FIELD = "activityId";
    private static final String TOTAL_LEARNERS_FORM_FIELD = "totalLearners";
    public static final String READ_ONLY = "readOnly";
    public static final String LOCAL_FILES = "localFiles";
    private static final String USER_ID = "userId";

    public ActionForward viewGate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        DynaActionForm gateForm = (DynaActionForm)form;
        Long gateIdLong = WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID", (boolean)true);
        if (gateIdLong == null) {
            gateIdLong = (Long)gateForm.get(ACTIVITY_FORM_FIELD);
        }
        long gateId = gateIdLong != null ? gateIdLong : -1L;
        this.monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        this.learnerService = MonitoringServiceProxy.getLearnerService(this.getServlet().getServletContext());
        GateActivity gate = (GateActivity)this.monitoringService.getActivityById(gateId);
        if (gate == null) {
            throw new MonitoringServiceException("Gate activity missing. Activity id" + gateId);
        }
        int totalLearners = this.learnerService.getLearnersForGate(gate).size();
        gateForm.set(TOTAL_LEARNERS_FORM_FIELD, (Object)new Integer(totalLearners));
        gateForm.set(ACTIVITY_FORM_FIELD, (Object)gateIdLong);
        gateForm.set(LOCAL_FILES, (Object)Boolean.FALSE);
        return this.findViewByGateType(mapping, gateForm, gate);
    }

    public ActionForward openGate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        DynaActionForm gateForm = (DynaActionForm)form;
        GateActivity gate = this.monitoringService.openGate((Long)gateForm.get(ACTIVITY_FORM_FIELD));
        return this.findViewByGateType(mapping, gateForm, gate);
    }

    public ActionForward openGateForSingleUser(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        DynaActionForm gateForm = (DynaActionForm)form;
        Long gateIdLong = (Long)gateForm.get(ACTIVITY_FORM_FIELD);
        Integer userId = (Integer)gateForm.get(USER_ID);
        GateActivity gate = this.monitoringService.openGateForSingleUser(gateIdLong, userId);
        return this.findViewByGateType(mapping, gateForm, gate);
    }

    public ActionForward exportPortfolio(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        DynaActionForm gateForm = (DynaActionForm)form;
        ActionForward forward = this.viewGate(mapping, form, request, response);
        gateForm.set(READ_ONLY, (Object)Boolean.TRUE);
        gateForm.set(LOCAL_FILES, (Object)Boolean.TRUE);
        return forward;
    }

    private ActionForward findViewByGateType(ActionMapping mapping, DynaActionForm gateForm, GateActivity gate) {
        gateForm.set(READ_ONLY, (Object)Boolean.FALSE);
        gateForm.set("gate", null);
        gateForm.set("waitingLearners", null);
        gateForm.set("waitingLearnerList", null);
        gateForm.set("allowedToPassLearnerList", null);
        gateForm.set("forbiddenLearnerList", null);
        gateForm.set("startingTime", null);
        gateForm.set("endingTime", null);
        Set waitingLearnersList = gate.getWaitingLearners();
        gateForm.set("gate", (Object)gate);
        gateForm.set("waitingLearners", (Object)new Integer(waitingLearnersList.size()));
        if (gate.isSynchGate()) {
            return mapping.findForward(VIEW_SYNCH_GATE);
        }
        if (gate.isScheduleGate()) {
            return this.viewScheduleGate(mapping, gateForm, (ScheduleGateActivity)gate);
        }
        if (gate.isPermissionGate() || gate.isSystemGate() || gate.isConditionGate()) {
            gateForm.set("waitingLearnerList", (Object)waitingLearnersList);
            gateForm.set("allowedToPassLearnerList", (Object)gate.getAllowedToPassLearners());
            List forbiddenUsers = this.learnerService.getLearnersForGate(gate);
            forbiddenUsers.removeAll(gate.getAllowedToPassLearners());
            gateForm.set("forbiddenLearnerList", (Object)forbiddenUsers);
            if (gate.isConditionGate()) {
                return mapping.findForward(VIEW_CONDITION_GATE);
            }
            return mapping.findForward(VIEW_PERMISSION_GATE);
        }
        throw new MonitoringServiceException("Invalid gate activity. gate id [" + gate.getActivityId() + "] - the type [" + gate.getActivityTypeId() + "] is not a gate type");
    }

    private ActionForward viewScheduleGate(ActionMapping mapping, DynaActionForm gateForm, ScheduleGateActivity scheduleGate) {
        if (Boolean.TRUE.equals(scheduleGate.getGateActivityCompletionBased())) {
            gateForm.set("activityCompletionBased", (Object)true);
        } else {
            this.learnerService = MonitoringServiceProxy.getLearnerService(this.getServlet().getServletContext());
            Lesson lesson = this.learnerService.getLessonByActivity((Activity)scheduleGate);
            GregorianCalendar startingTime = new GregorianCalendar(TimeZone.getDefault());
            startingTime.setTime(lesson.getStartDateTime());
            ((Calendar)startingTime).add(12, scheduleGate.getGateStartTimeOffset().intValue());
            gateForm.set("startingTime", (Object)startingTime.getTime());
        }
        return mapping.findForward(VIEW_SCHEDULE_GATE);
    }
}

