/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.monitoring.web;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.tomcat.util.json.JSONException;
import org.apache.tomcat.util.json.JSONObject;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.learningdesign.GroupComparator;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.GroupingActivity;
import org.lamsfoundation.lams.lesson.service.LessonServiceException;
import org.lamsfoundation.lams.monitoring.service.IMonitoringService;
import org.lamsfoundation.lams.monitoring.service.MonitoringServiceException;
import org.lamsfoundation.lams.monitoring.service.MonitoringServiceProxy;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.util.LastNameAlphabeticComparator;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.lamsfoundation.lams.web.session.SessionManager;

public class GroupingAJAXAction
extends LamsDispatchAction {
    private static final String CHOSEN_GROUPING_SCREEN = "chosenGrouping";
    private static final String VIEW_GROUPS_SCREEN = "viewGroups";
    private static final String PARAM_ACTIVITY_TITLE = "title";
    private static final String PARAM_ACTIVITY_DESCRIPTION = "description";
    public static final String PARAM_MAX_NUM_GROUPS = "maxNumberOfGroups";
    public static final String PARAM_NAME = "name";
    public static final String PARAM_GROUPS = "groups";
    public static final String PARAM_MEMBERS = "members";
    public static final String PARAM_MAY_DELETE = "mayDelete";
    public static final String PARAM_USED_FOR_BRANCHING = "usedForBranching";
    public static final String PARAM_MODULE_LANGUAGE_XML = "languageXML";
    public static final String PARAM_VIEW_MODE = "viewMode";

    private Integer getUserId(HttpServletRequest request) {
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        return user != null ? user.getUserID() : null;
    }

    private Grouping getGrouping(GroupingActivity activity) {
        Grouping grouping = activity.getCreateGrouping();
        if (grouping == null) {
            String error = "Grouping activity missing grouping. Activity was " + activity + " Grouping was " + grouping;
            LamsDispatchAction.log.error((Object)error);
            throw new MonitoringServiceException(error);
        }
        return grouping;
    }

    public ActionForward startGrouping(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Long activityID = WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID");
        Long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        GroupingActivity activity = monitoringService.getGroupingActivityById(activityID);
        Grouping grouping = activity.getCreateGrouping();
        if (grouping == null) {
            String error = "Grouping activity missing grouping. Activity was " + activity;
            LamsDispatchAction.log.error((Object)error);
            throw new MonitoringServiceException(error);
        }
        request.setAttribute("activityID", (Object)activityID);
        request.setAttribute("lessonID", (Object)lessonId);
        request.setAttribute(PARAM_ACTIVITY_TITLE, (Object)activity.getTitle());
        request.setAttribute(PARAM_ACTIVITY_DESCRIPTION, (Object)activity.getDescription());
        request.setAttribute(PARAM_MODULE_LANGUAGE_XML, (Object)this.getLanguageXML());
        if (grouping.isChosenGrouping()) {
            Set groups = grouping.getGroups();
            Iterator iter = groups.iterator();
            boolean mayDelete = true;
            while (mayDelete && iter.hasNext()) {
                Group group = (Group)iter.next();
                mayDelete = group.mayBeDeleted();
            }
            boolean usedForBranching = grouping.isUsedForBranching();
            request.setAttribute(PARAM_MAY_DELETE, (Object)mayDelete);
            request.setAttribute(PARAM_USED_FOR_BRANCHING, (Object)usedForBranching);
            request.setAttribute(PARAM_MAX_NUM_GROUPS, (Object)grouping.getMaxNumberOfGroups());
            request.setAttribute(PARAM_VIEW_MODE, (Object)Boolean.FALSE);
            return mapping.findForward(CHOSEN_GROUPING_SCREEN);
        }
        request.setAttribute(PARAM_MAY_DELETE, (Object)Boolean.FALSE);
        request.setAttribute(PARAM_VIEW_MODE, (Object)Boolean.TRUE);
        return mapping.findForward(VIEW_GROUPS_SCREEN);
    }

    public ActionForward getGroups(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Long activityID = WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID");
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        GroupingActivity activity = monitoringService.getGroupingActivityById(activityID);
        Grouping grouping = this.getGrouping(activity);
        TreeSet<Group> sortedGroups = new TreeSet<Group>((Comparator<Group>)new GroupComparator());
        sortedGroups.addAll(grouping.getGroups());
        String groupOutput = this.buildGroupsStringXML(sortedGroups);
        this.writeAJAXResponse(response, groupOutput);
        return null;
    }

    public ActionForward getClassMembersNotGrouped(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Long activityID = WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID");
        Long lessonID = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        SortedSet<User> users = monitoringService.getClassMembersNotGrouped(lessonID, activityID, true);
        String groupOutput = this.buildUserStringXML(-1L, users);
        this.writeAJAXResponse(response, groupOutput);
        return null;
    }

    public ActionForward getGroupMembers(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Long activityID = WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID");
        Long groupID = WebUtil.readLongParam((HttpServletRequest)request, (String)"groupID");
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        GroupingActivity activity = monitoringService.getGroupingActivityById(activityID);
        Grouping grouping = this.getGrouping(activity);
        Set groups = grouping.getGroups();
        Iterator iter = groups.iterator();
        Group group = null;
        while (group == null && iter.hasNext()) {
            Group candidateGroup = (Group)iter.next();
            if (!groupID.equals(candidateGroup.getGroupId())) continue;
            group = candidateGroup;
        }
        if (group == null) {
            String error = "Group cannot be found. Activity was " + activity + " Grouping was " + grouping + " Grouping ID was " + groupID;
            LamsDispatchAction.log.error((Object)error);
            throw new MonitoringServiceException(error);
        }
        Set users = group.getUsers();
        TreeSet<User> sortedUsers = new TreeSet<User>((Comparator<User>)new LastNameAlphabeticComparator());
        sortedUsers.addAll(users);
        String userOutput = this.buildUserStringXML(groupID, sortedUsers);
        this.writeAJAXResponse(response, userOutput);
        return null;
    }

    private String buildUserString(SortedSet<User> sortedUsers) {
        String userOutput = "";
        boolean first = true;
        for (User user : sortedUsers) {
            Integer userID = user.getUserId();
            String lastName = user.getLastName();
            String firstName = user.getFirstName();
            if (!first) {
                userOutput = userOutput + ";";
            } else {
                first = false;
            }
            userOutput = userOutput + userID + "," + lastName + "," + firstName;
        }
        return userOutput;
    }

    private String buildUserStringXML(long groupId, SortedSet<User> sortedUsers) {
        String userOutput = "<xml>";
        userOutput = userOutput + "<groupID>" + groupId + "</groupID>";
        userOutput = userOutput + "<users>";
        for (User user : sortedUsers) {
            Integer userID = user.getUserId();
            String lastName = user.getLastName();
            String firstName = user.getFirstName();
            userOutput = userOutput + "<user>";
            userOutput = userOutput + "<id>" + userID + "</id>";
            userOutput = userOutput + "<firstName>" + firstName + "</firstName>";
            userOutput = userOutput + "<lastName>" + lastName + "</lastName>";
            userOutput = userOutput + "<displayName>" + firstName + " " + lastName + "</displayName>";
            userOutput = userOutput + "</user>";
        }
        userOutput = userOutput + "</users></xml>";
        return userOutput;
    }

    private String buildGroupsString(Set<Group> sortedGroups) {
        String groupOutput = "";
        boolean first = true;
        for (Group group : sortedGroups) {
            Long groupId = group.getGroupId();
            String name = group.getGroupName();
            Integer numberOfMembers = group.getUsers().size();
            if (!first) {
                groupOutput = groupOutput + ";";
            } else {
                first = false;
            }
            groupOutput = groupOutput + groupId + "," + name + "," + numberOfMembers;
        }
        return groupOutput;
    }

    private String buildGroupsStringXML(Set<Group> sortedGroups) {
        String groupOutput = "<xml><groups>";
        for (Group group : sortedGroups) {
            Long groupId = group.getGroupId();
            String name = group.getGroupName();
            Integer numberOfMembers = group.getUsers().size();
            groupOutput = groupOutput + "<group>";
            groupOutput = groupOutput + "<id>" + groupId + "</id>";
            groupOutput = groupOutput + "<name>" + name + "</name>";
            groupOutput = groupOutput + "<numberOfMembers>" + numberOfMembers + "</numberOfMembers>";
            groupOutput = groupOutput + "</group>";
        }
        groupOutput = groupOutput + "</groups></xml>";
        return groupOutput;
    }

    private String buildAddGroupStringXML(Group group) {
        String groupOutput = "<xml><group>";
        groupOutput = groupOutput + "<id>" + group.getGroupId() + "</id>";
        groupOutput = groupOutput + "<name>" + group.getGroupName() + "</name>";
        groupOutput = groupOutput + "</group></xml>";
        return groupOutput;
    }

    private String buildRemoveGroupStringXML(Long groupID) {
        String groupOutput = "<xml><group>";
        groupOutput = groupOutput + "<id>" + groupID + "</id>";
        groupOutput = groupOutput + "</group></xml>";
        return groupOutput;
    }

    private String buildChangeGroupNameStringXML(Long groupID, String name) {
        String groupOutput = "<xml><group>";
        groupOutput = groupOutput + "<id>" + groupID + "</id>";
        groupOutput = groupOutput + "<newName>" + name + "</newName>";
        groupOutput = groupOutput + "</group></xml>";
        return groupOutput;
    }

    private String getLanguageXML() {
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        MessageService messageService = monitoringService.getMessageService();
        ArrayList<String> languageCollection = new ArrayList<String>();
        languageCollection.add(new String("button.finished"));
        languageCollection.add(new String("label.grouping.non.grouped.users.heading"));
        languageCollection.add(new String("label.grouping.status"));
        languageCollection.add(new String("label.grouping.functions"));
        languageCollection.add(new String("label.grouping.popup.change.group.name"));
        languageCollection.add(new String("label.grouping.popup.change.group.name.field"));
        languageCollection.add(new String("label.grouping.learners"));
        languageCollection.add(new String("label.grouping.popup.delete.group"));
        languageCollection.add(new String("label.grouping.popup.delete.group.message"));
        languageCollection.add(new String("button.ok"));
        languageCollection.add(new String("button.cancel"));
        languageCollection.add(new String("button.yes"));
        languageCollection.add(new String("button.no"));
        languageCollection.add(new String("error.title"));
        languageCollection.add(new String("label.grouping.max.num.in.group.heading"));
        languageCollection.add(new String("label.grouping.popup.drag.selection.message"));
        languageCollection.add(new String("label.grouping.general.instructions.branching"));
        languageCollection.add(new String("label.grouping.popup.viewmode.message"));
        String languageOutput = "<xml><language>";
        for (int i = 0; i < languageCollection.size(); ++i) {
            languageOutput = languageOutput + "<entry key='" + (String)languageCollection.get(i) + "'><name>" + messageService.getMessage((String)languageCollection.get(i)) + "</name></entry>";
        }
        languageOutput = languageOutput + "</language></xml>";
        return languageOutput;
    }

    public ActionForward addGroup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, LessonServiceException {
        Long activityID = WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID");
        String name = WebUtil.readStrParam((HttpServletRequest)request, (String)PARAM_NAME);
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        Group group = monitoringService.addGroup(activityID, name, true);
        String groupResponse = this.buildAddGroupStringXML(group);
        this.writeAJAXResponse(response, groupResponse);
        return null;
    }

    public ActionForward removeGroup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, LessonServiceException {
        Long activityID = WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID");
        Long groupID = WebUtil.readLongParam((HttpServletRequest)request, (String)"groupID");
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        monitoringService.removeGroup(activityID, groupID);
        String responseString = this.buildRemoveGroupStringXML(groupID);
        this.writeAJAXResponse(response, responseString);
        return null;
    }

    public ActionForward addMembers(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, LessonServiceException {
        Long activityID = WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID");
        Long groupID = WebUtil.readLongParam((HttpServletRequest)request, (String)"groupID");
        String members = WebUtil.readStrParam((HttpServletRequest)request, (String)PARAM_MEMBERS, (boolean)true);
        if (members != null) {
            String[] membersSplit = members.split(",");
            IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
            monitoringService.addUsersToGroup(activityID, groupID, membersSplit);
        }
        this.writeAJAXOKResponse(response);
        return null;
    }

    public ActionForward changeGroupName(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, LessonServiceException {
        Long groupID = WebUtil.readLongParam((HttpServletRequest)request, (String)"groupID");
        String name = WebUtil.readStrParam((HttpServletRequest)request, (String)PARAM_NAME, (boolean)true);
        if (name != null) {
            IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
            monitoringService.setGroupName(groupID, name);
        }
        String reponseSting = this.buildChangeGroupNameStringXML(groupID, name);
        this.writeAJAXResponse(response, reponseSting);
        return null;
    }

    public ActionForward removeMembers(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, LessonServiceException {
        Long activityID = WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID");
        Long groupID = WebUtil.readLongParam((HttpServletRequest)request, (String)"groupID");
        String members = WebUtil.readStrParam((HttpServletRequest)request, (String)PARAM_MEMBERS, (boolean)true);
        if (members != null) {
            String[] membersSplit = members.split(",");
            IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
            monitoringService.removeUsersFromGroup(activityID, groupID, membersSplit);
        }
        this.writeAJAXOKResponse(response);
        return null;
    }

    public ActionForward addMembersJSON(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws JSONException, IOException {
        User exampleUser;
        GroupingActivity groupingActivity;
        Grouping grouping;
        Group group;
        response.setContentType("application/json;charset=utf-8");
        JSONObject responseJSON = new JSONObject();
        boolean result = true;
        Long activityID = WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID");
        String membersParam = WebUtil.readStrParam((HttpServletRequest)request, (String)PARAM_MEMBERS, (boolean)true);
        String[] members = StringUtils.isBlank((String)membersParam) ? null : membersParam.split(",");
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        if (members != null && !(group = (grouping = (groupingActivity = monitoringService.getGroupingActivityById(activityID)).getCreateGrouping()).getGroupBy(exampleUser = (User)MonitoringServiceProxy.getUserManagementService(this.getServlet().getServletContext()).findById(User.class, (Serializable)Integer.valueOf(members[0])))).isNull()) {
            result = group.mayBeDeleted();
            if (result) {
                if (LamsDispatchAction.log.isDebugEnabled()) {
                    LamsDispatchAction.log.debug((Object)("Removing users " + membersParam.toString() + " from group " + group.getGroupId() + " in activity " + activityID));
                }
                try {
                    monitoringService.removeUsersFromGroup(activityID, group.getGroupId(), members);
                }
                catch (LessonServiceException e) {
                    LamsDispatchAction.log.error((Object)e);
                    result = false;
                }
            }
            if (!result) {
                responseJSON.put("locked", true);
            }
        }
        Long groupID = WebUtil.readLongParam((HttpServletRequest)request, (String)"groupID", (boolean)true);
        if (result && (groupID == null || groupID > 0L)) {
            if (groupID == null) {
                Group group2;
                String name = WebUtil.readStrParam((HttpServletRequest)request, (String)PARAM_NAME);
                if (LamsDispatchAction.log.isDebugEnabled()) {
                    LamsDispatchAction.log.debug((Object)("Creating group with name \"" + name + "\" in activity " + activityID));
                }
                if ((group2 = monitoringService.addGroup(activityID, name, true)) == null) {
                    result = false;
                } else {
                    groupID = group2.getGroupId();
                    responseJSON.put("groupId", (Object)groupID);
                }
            }
            if (result && members != null) {
                if (LamsDispatchAction.log.isDebugEnabled()) {
                    LamsDispatchAction.log.debug((Object)("Adding users " + membersParam.toString() + " to group " + groupID + " in activity " + activityID));
                }
                try {
                    monitoringService.addUsersToGroup(activityID, groupID, members);
                }
                catch (LessonServiceException e) {
                    LamsDispatchAction.log.error((Object)e);
                    result = false;
                }
            }
        }
        responseJSON.put("result", result);
        response.getWriter().write(responseJSON.toString());
        return null;
    }

    public ActionForward changeGroupNameJSON(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Long groupID = WebUtil.readLongParam((HttpServletRequest)request, (String)"groupID");
        String name = WebUtil.readStrParam((HttpServletRequest)request, (String)PARAM_NAME);
        if (name != null) {
            if (LamsDispatchAction.log.isDebugEnabled()) {
                LamsDispatchAction.log.debug((Object)("Renaming group  " + groupID + " to \"" + name + "\""));
            }
            IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
            monitoringService.setGroupName(groupID, name);
        }
        return null;
    }

    public ActionForward removeGroupJSON(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws JSONException, IOException {
        response.setContentType("application/json;charset=utf-8");
        Long activityID = WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID");
        Long groupID = WebUtil.readLongParam((HttpServletRequest)request, (String)"groupID");
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        boolean result = true;
        Group group = (Group)MonitoringServiceProxy.getUserManagementService(this.getServlet().getServletContext()).findById(Group.class, (Serializable)groupID);
        result = group.mayBeDeleted();
        if (result) {
            try {
                if (LamsDispatchAction.log.isDebugEnabled()) {
                    LamsDispatchAction.log.debug((Object)("Removing group  " + groupID + " from activity " + activityID));
                }
                monitoringService.removeGroup(activityID, groupID);
            }
            catch (LessonServiceException e) {
                LamsDispatchAction.log.error((Object)e);
                result = false;
            }
        }
        JSONObject responseJSON = new JSONObject();
        responseJSON.put("result", result);
        response.getWriter().write(responseJSON.toString());
        return null;
    }
}

