/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.monitoring.web;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.tomcat.util.json.JSONArray;
import org.apache.tomcat.util.json.JSONException;
import org.apache.tomcat.util.json.JSONObject;
import org.lamsfoundation.lams.authoring.service.IAuthoringService;
import org.lamsfoundation.lams.learning.service.ICoreLearnerService;
import org.lamsfoundation.lams.learning.web.bean.ActivityURL;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.exception.LearningDesignException;
import org.lamsfoundation.lams.lesson.LearnerProgress;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.dto.LessonDetailsDTO;
import org.lamsfoundation.lams.lesson.service.ILessonService;
import org.lamsfoundation.lams.lesson.util.LearnerProgressComparator;
import org.lamsfoundation.lams.lesson.util.LearnerProgressNameComparator;
import org.lamsfoundation.lams.monitoring.dto.ContributeActivityDTO;
import org.lamsfoundation.lams.monitoring.service.IMonitoringService;
import org.lamsfoundation.lams.monitoring.service.MonitoringServiceProxy;
import org.lamsfoundation.lams.timezone.service.ITimezoneService;
import org.lamsfoundation.lams.tool.exception.LamsToolServiceException;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.exception.UserAccessDeniedException;
import org.lamsfoundation.lams.usermanagement.exception.UserException;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.DateUtil;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.util.audit.IAuditService;
import org.lamsfoundation.lams.util.wddx.FlashMessage;
import org.lamsfoundation.lams.util.wddx.WDDXTAGS;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class MonitoringAction
extends LamsDispatchAction {
    private static final String PREVIEW_DELETED_REPORT_SCREEN = "previewdeleted";
    private static final String NOT_SUPPORTED_SCREEN = "notsupported";
    private static final String TIME_CHART_SCREEN = "timeChart";
    private static final String ERROR = "error";
    private static final DateFormat LESSON_SCHEDULING_DATETIME_FORMAT = new SimpleDateFormat("MM/dd/yy HH:mm");
    private static IAuditService auditService;
    private static ITimezoneService timezoneService;
    private static ILessonService lessonService;

    private Integer getUserId() {
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        return user != null ? user.getUserID() : null;
    }

    private FlashMessage handleException(Exception e, String methodKey, IMonitoringService monitoringService) {
        LamsDispatchAction.log.error((Object)("Exception thrown " + methodKey), (Throwable)e);
        auditService = this.getAuditService();
        auditService.log(MonitoringAction.class.getName() + ":" + methodKey, e.toString());
        if (e instanceof UserAccessDeniedException) {
            return new FlashMessage(methodKey, (Object)monitoringService.getMessageService().getMessage("error.user.noprivilege"), 1);
        }
        Object[] msg = new String[]{e.getMessage()};
        return new FlashMessage(methodKey, (Object)monitoringService.getMessageService().getMessage("error.system.error", msg), 2);
    }

    private FlashMessage handleCriticalError(String methodKey, String messageKey, IMonitoringService monitoringService) {
        String message = monitoringService.getMessageService().getMessage(messageKey);
        LamsDispatchAction.log.error((Object)("Error occured " + methodKey + " error "));
        auditService = this.getAuditService();
        auditService.log(MonitoringAction.class.getName() + ":" + methodKey, message);
        return new FlashMessage(methodKey, (Object)message, 2);
    }

    private ActionForward redirectToURL(ActionMapping mapping, HttpServletResponse response, String url) throws IOException {
        if (url != null) {
            String fullURL = WebUtil.convertToFullURL((String)url);
            response.sendRedirect(response.encodeRedirectURL(fullURL));
            return null;
        }
        return mapping.findForward(NOT_SUPPORTED_SCREEN);
    }

    public ActionForward initializeLesson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String desc;
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        String title = WebUtil.readStrParam((HttpServletRequest)request, (String)"lessonName");
        if (title == null) {
            title = "lesson";
        }
        if ((desc = WebUtil.readStrParam((HttpServletRequest)request, (String)"lessonDescription", (boolean)true)) == null) {
            desc = "description";
        }
        Integer organisationId = WebUtil.readIntParam((HttpServletRequest)request, (String)"organisationID", (boolean)true);
        long ldId = WebUtil.readLongParam((HttpServletRequest)request, (String)"learningDesignID");
        Integer copyType = WebUtil.readIntParam((HttpServletRequest)request, (String)"copyType", (boolean)true);
        String customCSV = request.getParameter("customCSV");
        Boolean learnerExportAvailable = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"learnerExportPortfolio", (boolean)false);
        Boolean learnerPresenceAvailable = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"learnerPresenceAvailable", (boolean)false);
        Boolean learnerImAvailable = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"learnerImAvailable", (boolean)false);
        Boolean liveEditEnabled = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"liveEditEnabled", (boolean)false);
        Boolean learnerRestart = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"learnerRestart", (boolean)false);
        Lesson newLesson = null;
        newLesson = copyType != null && copyType.equals(3) ? monitoringService.initializeLessonForPreview(title, desc, ldId, this.getUserId(), customCSV, learnerPresenceAvailable, learnerImAvailable, liveEditEnabled) : monitoringService.initializeLesson(title, desc, ldId, organisationId, this.getUserId(), customCSV, false, false, learnerExportAvailable, learnerPresenceAvailable, learnerImAvailable, liveEditEnabled, false, learnerRestart, null, null);
        PrintWriter writer = response.getWriter();
        writer.println(newLesson.getLessonId());
        return null;
    }

    public ActionForward startLesson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        monitoringService.startLesson(lessonId, this.getUserId());
        response.setContentType("text/plain;charset=utf-8");
        response.getWriter().write("true");
        return null;
    }

    public ActionForward createLessonClass(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        int organisationId = WebUtil.readIntParam((HttpServletRequest)request, (String)"organisationID");
        Integer userID = WebUtil.readIntParam((HttpServletRequest)request, (String)"userID");
        long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        IUserManagementService userManagementService = MonitoringServiceProxy.getUserManagementService(this.getServlet().getServletContext());
        Organisation organisation = (Organisation)userManagementService.findById(Organisation.class, (Serializable)Integer.valueOf(organisationId));
        String learnerGroupName = organisation.getName() + " learners";
        String staffGroupName = organisation.getName() + " staff";
        List<User> learners = this.parseUserList(request, "learners");
        List<User> staff = this.parseUserList(request, "monitors");
        monitoringService.createLessonClassForLesson(lessonId, organisation, learnerGroupName, learners, staffGroupName, staff, userID);
        return null;
    }

    public ActionForward addLesson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, ParseException {
        String lessonName = request.getParameter("lessonName");
        int organisationId = WebUtil.readIntParam((HttpServletRequest)request, (String)"organisationID");
        long ldId = WebUtil.readLongParam((HttpServletRequest)request, (String)"learningDesignID");
        boolean introEnable = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"introEnable", (boolean)false);
        String introDescription = introEnable ? request.getParameter("introDescription") : null;
        boolean introImage = introEnable && WebUtil.readBooleanParam((HttpServletRequest)request, (String)"introImage", (boolean)false);
        boolean startMonitor = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"startMonitor", (boolean)false);
        boolean enableLiveEdit = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"liveEditEnable", (boolean)false);
        boolean notificationsEnable = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"notificationsEnable", (boolean)false);
        boolean portfolioEnable = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"portfolioEnable", (boolean)false);
        boolean presenceEnable = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"presenceEnable", (boolean)false);
        boolean imEnable = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"imEnable", (boolean)false);
        Integer splitNumberLessons = WebUtil.readIntParam((HttpServletRequest)request, (String)"splitNumberLessons", (boolean)true);
        boolean schedulingEnable = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"schedulingEnable", (boolean)false);
        Date schedulingDatetime = schedulingEnable ? LESSON_SCHEDULING_DATETIME_FORMAT.parse(request.getParameter("schedulingDatetime")) : null;
        boolean learnerRestart = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"learnerRestart", (boolean)false);
        boolean precedingLessonEnable = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"precedingLessonEnable", (boolean)false);
        Long precedingLessonId = precedingLessonEnable ? WebUtil.readLongParam((HttpServletRequest)request, (String)"precedingLessonId", (boolean)true) : null;
        boolean timeLimitEnable = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"timeLimitEnable", (boolean)false);
        Integer timeLimitDays = WebUtil.readIntParam((HttpServletRequest)request, (String)"timeLimitDays", (boolean)true);
        boolean timeLimitIndividualField = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"timeLimitIndividual", (boolean)false);
        Integer timeLimitIndividual = timeLimitEnable && timeLimitIndividualField ? timeLimitDays : null;
        Integer timeLimitLesson = timeLimitEnable && !timeLimitIndividualField ? timeLimitDays : null;
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        IUserManagementService userManagementService = MonitoringServiceProxy.getUserManagementService(this.getServlet().getServletContext());
        Organisation organisation = (Organisation)userManagementService.findById(Organisation.class, (Serializable)Integer.valueOf(organisationId));
        Integer userId = this.getUserId();
        User creator = (User)userManagementService.findById(User.class, (Serializable)userId);
        ArrayList<User> learners = this.parseUserList(request, "learners");
        String learnerGroupName = organisation.getName() + " learners";
        List<User> staff = this.parseUserList(request, "monitors");
        if (!staff.contains(creator)) {
            staff.add(creator);
        }
        String staffGroupName = organisation.getName() + " staff";
        ArrayList<User> lessonInstanceLearners = splitNumberLessons == null ? learners : new ArrayList<User>(learners.size() / splitNumberLessons + 1);
        for (int lessonIndex = 1; lessonIndex <= (splitNumberLessons == null ? 1 : splitNumberLessons); ++lessonIndex) {
            String lessonInstanceName = lessonName;
            String learnerGroupInstanceName = learnerGroupName;
            String staffGroupInstanceName = staffGroupName;
            if (splitNumberLessons != null) {
                lessonInstanceName = lessonInstanceName + " " + lessonIndex;
                learnerGroupInstanceName = learnerGroupInstanceName + " " + lessonIndex;
                staffGroupInstanceName = staffGroupInstanceName + " " + lessonIndex;
                lessonInstanceLearners.clear();
                for (int learnerIndex = lessonIndex - 1; learnerIndex < learners.size(); learnerIndex += splitNumberLessons.intValue()) {
                    lessonInstanceLearners.add((User)learners.get(learnerIndex));
                }
            }
            if (LamsDispatchAction.log.isDebugEnabled()) {
                LamsDispatchAction.log.debug((Object)("Creating lesson " + (splitNumberLessons == null ? "" : "(" + lessonIndex + "/" + splitNumberLessons + ") ") + "\"" + lessonInstanceName + "\""));
            }
            Lesson lesson = monitoringService.initializeLesson(lessonInstanceName, introDescription, ldId, organisationId, userId, null, introEnable, introImage, portfolioEnable, presenceEnable, imEnable, enableLiveEdit, notificationsEnable, learnerRestart, timeLimitIndividual, precedingLessonId);
            monitoringService.createLessonClassForLesson(lesson.getLessonId(), organisation, learnerGroupInstanceName, lessonInstanceLearners, staffGroupInstanceName, staff, userId);
            if (startMonitor) continue;
            if (schedulingDatetime == null) {
                monitoringService.startLesson(lesson.getLessonId(), userId);
            } else {
                monitoringService.startLessonOnSchedule(lesson.getLessonId(), schedulingDatetime, userId);
            }
            if (timeLimitLesson == null) continue;
            monitoringService.finishLessonOnSchedule(lesson.getLessonId(), timeLimitLesson, userId);
        }
        return null;
    }

    public ActionForward startOnScheduleLesson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ParseException {
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        String dateStr = WebUtil.readStrParam((HttpServletRequest)request, (String)"lessonStartDate");
        Date startDate = LESSON_SCHEDULING_DATETIME_FORMAT.parse(dateStr);
        monitoringService.startLessonOnSchedule(lessonId, startDate, this.getUserId());
        return null;
    }

    public ActionForward archiveLesson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        monitoringService.archiveLesson(lessonId, this.getUserId());
        return null;
    }

    public ActionForward unarchiveLesson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        monitoringService.unarchiveLesson(lessonId, this.getUserId());
        return null;
    }

    public ActionForward suspendLesson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        monitoringService.suspendLesson(lessonId, this.getUserId());
        return null;
    }

    public ActionForward unsuspendLesson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        monitoringService.unsuspendLesson(lessonId, this.getUserId());
        return null;
    }

    public ActionForward removeLesson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, JSONException, ServletException {
        JSONObject jsonObject = new JSONObject();
        Object removeLessonResult = Boolean.TRUE.toString();
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        try {
            long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
            monitoringService.removeLesson(lessonId, this.getUserId());
        }
        catch (Exception e) {
            FlashMessage flashMessage = this.handleException(e, "removeLesson", monitoringService);
            removeLessonResult = flashMessage.getMessageValue();
        }
        jsonObject.put("removeLesson", removeLessonResult);
        response.setContentType("application/json;charset=utf-8");
        response.getWriter().print(jsonObject);
        return null;
    }

    public ActionForward forceComplete(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        Long activityId = null;
        String actId = request.getParameter("activityID");
        if (actId != null) {
            try {
                activityId = new Long(Long.parseLong(actId));
            }
            catch (Exception e) {
                activityId = null;
            }
        }
        long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        Integer learnerId = new Integer(WebUtil.readIntParam((HttpServletRequest)request, (String)"learnerID"));
        Integer requesterId = this.getUserId();
        boolean removeLearnerContent = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"removeContent", (boolean)false);
        String message = monitoringService.forceCompleteActivitiesByUser(learnerId, requesterId, lessonId, activityId, removeLearnerContent);
        if (LamsDispatchAction.log.isDebugEnabled()) {
            LamsDispatchAction.log.debug((Object)("Force complete for learner " + learnerId + " lesson " + lessonId + ". " + message));
        }
        PrintWriter writer = response.getWriter();
        writer.println(message);
        return null;
    }

    public ActionForward getLessonLearners(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String wddxPacket;
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        try {
            Long lessonID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID"));
            wddxPacket = monitoringService.getLessonLearners(lessonID, this.getUserId());
        }
        catch (Exception e) {
            wddxPacket = this.handleException(e, "getLessonLearners", monitoringService).serializeMessage();
        }
        PrintWriter writer = response.getWriter();
        writer.println(wddxPacket);
        return null;
    }

    public ActionForward getClassMembers(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, JSONException {
        long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        String role = WebUtil.readStrParam((HttpServletRequest)request, (String)"role");
        boolean getMonitors = "MONITOR".equalsIgnoreCase(role);
        boolean classOnly = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"classOnly", (boolean)true);
        Lesson lesson = this.getLessonService().getLesson(Long.valueOf(lessonId));
        Set classUsers = getMonitors ? lesson.getLessonClass().getStaffGroup().getUsers() : lesson.getLessonClass().getLearners();
        JSONArray responseJSON = new JSONArray();
        for (User user : classUsers) {
            JSONObject userJSON = WebUtil.userToJSON((User)user);
            if (!classOnly) {
                userJSON.put("classMember", true);
                if (lesson.getUser().equals((Object)user)) {
                    userJSON.put("lessonCreator", true);
                }
            }
            responseJSON.put((Object)userJSON);
        }
        if (!classOnly) {
            IUserManagementService userManagementService = MonitoringServiceProxy.getUserManagementService(this.getServlet().getServletContext());
            Vector orgUsers = userManagementService.getUsersFromOrganisationByRole(lesson.getOrganisation().getOrganisationId(), getMonitors ? "MONITOR" : "LEARNER", false, true);
            for (User user : orgUsers) {
                if (classUsers.contains(user)) continue;
                JSONObject userJSON = WebUtil.userToJSON((User)user);
                userJSON.put("classMember", false);
                responseJSON.put((Object)userJSON);
            }
        }
        response.setContentType("application/json;charset=utf-8");
        response.getWriter().write(responseJSON.toString());
        return null;
    }

    public ActionForward updateLessonClass(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, JSONException {
        long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        Lesson lesson = this.getLessonService().getLesson(Long.valueOf(lessonId));
        List<User> removedLearners = this.parseUserList(request, "removedLearners");
        for (User removedLearner : removedLearners) {
            this.getLessonService().removeLearnerProgress(Long.valueOf(lessonId), removedLearner.getUserId());
            if (!LamsDispatchAction.log.isDebugEnabled()) continue;
            LamsDispatchAction.log.debug((Object)("Removed progress for user ID: " + removedLearner.getUserId() + " in lesson ID: " + lessonId));
        }
        List<User> learners = this.parseUserList(request, "learners");
        this.getLessonService().setLearners(lesson, learners);
        List<User> staff = this.parseUserList(request, "monitors");
        this.getLessonService().setStaffMembers(lesson, staff);
        return null;
    }

    public ActionForward getLessonStaff(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String wddxPacket;
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        try {
            Long lessonID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID"));
            wddxPacket = monitoringService.getLessonStaff(lessonID, this.getUserId());
        }
        catch (Exception e) {
            wddxPacket = this.handleException(e, "getLessonStaff", monitoringService).serializeMessage();
        }
        PrintWriter writer = response.getWriter();
        writer.println(wddxPacket);
        return null;
    }

    public ActionForward getLearningDesignDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String wddxPacket;
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        try {
            Long lessonID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID"));
            wddxPacket = monitoringService.getLearningDesignDetails(lessonID);
        }
        catch (Exception e) {
            wddxPacket = this.handleException(e, "getLearningDesignDetails", monitoringService).serializeMessage();
        }
        PrintWriter writer = response.getWriter();
        writer.println(wddxPacket);
        return null;
    }

    public ActionForward getDictionaryXML(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        MessageService messageService = monitoringService.getMessageService();
        String module = WebUtil.readStrParam((HttpServletRequest)request, (String)"module", (boolean)false);
        ArrayList<String> languageCollection = new ArrayList<String>();
        if (module.equals("timechart")) {
            languageCollection.add(new String("sys.error"));
            languageCollection.add(new String("chart.btn.activity.split"));
            languageCollection.add(new String("chart.btn_completion.rate"));
            languageCollection.add(new String("chart.series.completed.time"));
            languageCollection.add(new String("chart.series.average.time"));
            languageCollection.add(new String("chart.series.duration"));
            languageCollection.add(new String("chart.legend.average"));
            languageCollection.add(new String("show.average.checkbox"));
            languageCollection.add(new String("search.learner.textbox"));
            languageCollection.add(new String("chart.learner.linear.axis.title"));
            languageCollection.add(new String("chart.learner.category.axis.title"));
            languageCollection.add(new String("chart.learner.datatip.average"));
            languageCollection.add(new String("label.learner"));
            languageCollection.add(new String("time.chart.panel.title"));
            languageCollection.add(new String("chart.time.format.hours"));
            languageCollection.add(new String("chart.time.format.minutes"));
            languageCollection.add(new String("chart.time.format.seconds"));
            languageCollection.add(new String("label.completed"));
            languageCollection.add(new String("advanced.tab.form.validation.schedule.date.error"));
            languageCollection.add(new String("alert.no.learner.data"));
        }
        String languageOutput = "<xml><language>";
        for (int i = 0; i < languageCollection.size(); ++i) {
            languageOutput = languageOutput + "<entry key='" + (String)languageCollection.get(i) + "'><name>" + messageService.getMessage((String)languageCollection.get(i)) + "</name></entry>";
        }
        languageOutput = languageOutput + "</language></xml>";
        response.setContentType("text/xml");
        response.setCharacterEncoding("UTF-8");
        response.getWriter().print(languageOutput);
        return null;
    }

    public ActionForward getLearnerActivityURL(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, LamsToolServiceException {
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        Integer learnerUserID = new Integer(WebUtil.readIntParam((HttpServletRequest)request, (String)"userID"));
        Long activityID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID"));
        Long lessonID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID"));
        String url = monitoringService.getLearnerActivityURL(lessonID, activityID, learnerUserID, this.getUserId());
        return this.redirectToURL(mapping, response, url);
    }

    public ActionForward getActivityMonitorURL(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, LamsToolServiceException {
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        Long activityID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID"));
        Long lessonID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID"));
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        String url = monitoringService.getActivityMonitorURL(lessonID, activityID, contentFolderID, this.getUserId());
        return this.redirectToURL(mapping, response, url);
    }

    public ActionForward moveLesson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        String wddxPacket = null;
        try {
            Long lessonID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID"));
            Integer userID = this.getUserId();
            Integer targetWorkspaceFolderID = new Integer(WebUtil.readIntParam((HttpServletRequest)request, (String)"folderID"));
            wddxPacket = monitoringService.moveLesson(lessonID, targetWorkspaceFolderID, userID);
        }
        catch (Exception e) {
            FlashMessage flashMessage = this.handleException(e, "moveLesson", monitoringService);
            wddxPacket = flashMessage.serializeMessage();
        }
        PrintWriter writer = response.getWriter();
        writer.println(wddxPacket);
        return null;
    }

    public ActionForward monitorLesson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Short sequenceTabInfoShowCount;
        Long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        LessonDetailsDTO lessonDTO = this.getLessonService().getLessonDetails(lessonId);
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        if (lessonDTO.getCreateDateTime() != null && lessonDTO.getCreateDateTime() != WDDXTAGS.DATE_NULL_VALUE) {
            SimpleDateFormat sfm = new SimpleDateFormat("yyyyMMdd_HHmmss");
            lessonDTO.setCreateDateTimeStr(sfm.format(lessonDTO.getCreateDateTime()));
        }
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        monitoringService.checkOwnerOrStaffMember(user.getUserID(), lessonId, "monitor lesson");
        List<ContributeActivityDTO> contributeActivities = monitoringService.getAllContributeActivityDTO(lessonId);
        if (contributeActivities != null) {
            ArrayList<ContributeActivityDTO> requiredContributeActivities = new ArrayList<ContributeActivityDTO>();
            for (ContributeActivityDTO contributeActivityDTO : contributeActivities) {
                if (contributeActivityDTO.getContributeEntries() == null) continue;
                for (ContributeActivityDTO.ContributeEntry contributeEntry : contributeActivityDTO.getContributeEntries()) {
                    if (!contributeEntry.getIsRequired().booleanValue()) continue;
                    requiredContributeActivities.add(contributeActivityDTO);
                }
            }
            if (!requiredContributeActivities.isEmpty()) {
                request.setAttribute("contributeActivities", requiredContributeActivities);
            }
        }
        if ((sequenceTabInfoShowCount = (Short)ss.getAttribute("sequenceTabInfoShowCount")) == null) {
            sequenceTabInfoShowCount = 0;
        }
        if (sequenceTabInfoShowCount < 2) {
            Short i$ = sequenceTabInfoShowCount;
            Short s = sequenceTabInfoShowCount = Short.valueOf((short)(sequenceTabInfoShowCount + 1));
            ss.setAttribute("sequenceTabInfoShowCount", (Object)sequenceTabInfoShowCount);
            request.setAttribute("sequenceTabShowInfo", (Object)true);
        }
        IUserManagementService userManagementService = MonitoringServiceProxy.getUserManagementService(this.getServlet().getServletContext());
        Organisation organisation = (Organisation)userManagementService.findById(Organisation.class, (Serializable)lessonDTO.getOrganisationID());
        request.setAttribute("notificationsAvailable", (Object)organisation.getEnableCourseNotifications());
        request.setAttribute("lesson", (Object)lessonDTO);
        return mapping.findForward("monitorLesson");
    }

    public ActionForward getLearnerProgressPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws JSONException, IOException {
        long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        String searchPhrase = request.getParameter("searchPhrase");
        Integer pageNumber = WebUtil.readIntParam((HttpServletRequest)request, (String)"pageNumber", (boolean)true);
        if (pageNumber == null) {
            pageNumber = 1;
        }
        boolean isProgressSorted = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"isProgressSorted", (boolean)false);
        JSONObject responseJSON = new JSONObject();
        Lesson lesson = this.getLessonService().getLesson(Long.valueOf(lessonId));
        ArrayList learnerProgresses = new ArrayList(lesson.getLearnerProgresses());
        Collections.sort(learnerProgresses, isProgressSorted ? new LearnerProgressComparator() : new LearnerProgressNameComparator());
        if (!StringUtils.isBlank((String)searchPhrase)) {
            LinkedHashSet<LearnerProgress> searchResult = new LinkedHashSet<LearnerProgress>();
            String[] searchPhrases = searchPhrase.split(";");
            for (int searchPhraseIndex = 0; searchPhraseIndex < searchPhrases.length; ++searchPhraseIndex) {
                searchPhrases[searchPhraseIndex] = searchPhrases[searchPhraseIndex].trim().toLowerCase();
            }
            for (LearnerProgress learnerProgress : learnerProgresses) {
                User learner = learnerProgress.getUser();
                StringBuilder learnerDisplayName = new StringBuilder(learner.getFirstName().toLowerCase()).append(" ").append(learner.getLastName().toLowerCase()).append(" ").append(learner.getLogin().toLowerCase());
                for (String searchPhrasePiece : searchPhrases) {
                    if (StringUtils.isBlank((String)searchPhrasePiece) || learnerDisplayName.indexOf(searchPhrasePiece) == -1) continue;
                    searchResult.add(learnerProgress);
                }
            }
            learnerProgresses.clear();
            learnerProgresses.addAll(searchResult);
        }
        int toIndex = Math.min(pageNumber * 10, learnerProgresses.size());
        int fromIndex = Math.min((pageNumber - 1) * 10, Math.max(toIndex - 10, 0));
        for (LearnerProgress learnerProgress : learnerProgresses.subList(fromIndex, toIndex)) {
            responseJSON.append("learners", (Object)WebUtil.userToJSON((User)learnerProgress.getUser()));
        }
        responseJSON.put("numberActiveLearners", learnerProgresses.size());
        response.setContentType("application/json;charset=utf-8");
        response.getWriter().print(responseJSON.toString());
        return null;
    }

    public ActionForward getLearnerProgress(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws JSONException, IOException {
        Integer learnerId = WebUtil.readIntParam((HttpServletRequest)request, (String)"userID", (boolean)true);
        Integer monitorId = null;
        if (learnerId == null) {
            learnerId = this.getUserId();
        } else {
            monitorId = this.getUserId();
        }
        Long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        ICoreLearnerService learnerService = MonitoringServiceProxy.getLearnerService(this.getServlet().getServletContext());
        Object[] ret = learnerService.getStructuredActivityURLs(learnerId, lessonId);
        JSONObject responseJSON = new JSONObject();
        responseJSON.put("currentActivityId", ret[1]);
        responseJSON.put("isPreview", ret[2]);
        for (ActivityURL activity : (List)ret[0]) {
            if (activity.getFloating()) {
                for (ActivityURL childActivity : activity.getChildActivities()) {
                    responseJSON.append("support", (Object)this.activityProgressToJSON(childActivity, null, lessonId, learnerId, monitorId));
                }
                continue;
            }
            responseJSON.append("activities", (Object)this.activityProgressToJSON(activity, (Long)ret[1], lessonId, learnerId, monitorId));
        }
        response.setContentType("application/json;charset=utf-8");
        response.getWriter().print(responseJSON.toString());
        return null;
    }

    public ActionForward getLessonDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, JSONException {
        Date startOrScheduleDate;
        long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        JSONObject responseJSON = new JSONObject();
        Lesson lesson = this.getLessonService().getLesson(Long.valueOf(lessonId));
        LessonDetailsDTO lessonDetails = lesson.getLessonDetails();
        String contentFolderId = lessonDetails.getContentFolderID();
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        Locale userLocale = new Locale(user.getLocaleLanguage(), user.getLocaleCountry());
        responseJSON.put("learningDesignID", (Object)lessonDetails.getLearningDesignID());
        responseJSON.put("numberPossibleLearners", (Object)lessonDetails.getNumberPossibleLearners());
        responseJSON.put("lessonStateID", (Object)lessonDetails.getLessonStateID());
        Date date = startOrScheduleDate = lesson.getStartDateTime() == null ? lesson.getScheduleStartDate() : lesson.getStartDateTime();
        if (startOrScheduleDate != null) {
            SimpleDateFormat indfm = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss", userLocale);
            Date tzStartDate = DateUtil.convertToTimeZoneFromDefault((TimeZone)user.getTimeZone(), (Date)startOrScheduleDate);
            responseJSON.put("startDate", (Object)(indfm.format(tzStartDate) + " " + user.getTimeZone().getDisplayName(userLocale)));
        }
        response.setContentType("application/json;charset=utf-8");
        response.getWriter().write(responseJSON.toString());
        return null;
    }

    public ActionForward getLessonProgress(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws JSONException, IOException {
        long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        Long branchingActivityId = WebUtil.readLongParam((HttpServletRequest)request, (String)"branchingActivityID", (boolean)true);
        Lesson lesson = this.getLessonService().getLesson(Long.valueOf(lessonId));
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        Integer monitorUserId = this.getUserId();
        LessonDetailsDTO lessonDetails = lesson.getLessonDetails();
        String contentFolderId = lessonDetails.getContentFolderID();
        TreeMap<Long, JSONObject> activitiesMap = new TreeMap<Long, JSONObject>();
        for (Activity activity : lesson.getLearningDesign().getActivities()) {
            if (branchingActivityId != null && !MonitoringAction.isBranchingChild(branchingActivityId, activity)) continue;
            Long activityId = activity.getActivityId();
            JSONObject activityJSON = new JSONObject();
            activityJSON.put("id", (Object)activityId);
            if (activity.isBranchingActivity()) {
                activityJSON.put("isBranching", true);
            } else {
                String monitorUrl = monitoringService.getActivityMonitorURL(lessonId, activityId, contentFolderId, monitorUserId);
                if (monitorUrl != null) {
                    activityJSON.put("url", (Object)monitorUrl);
                }
            }
            activitiesMap.put(activityId, activityJSON);
        }
        JSONObject responseJSON = new JSONObject();
        for (LearnerProgress learnerProgress : lesson.getLearnerProgresses()) {
            User learner = learnerProgress.getUser();
            if (learnerProgress.isComplete()) {
                JSONObject learnerJSON = WebUtil.userToJSON((User)learner);
                responseJSON.append("completedLearners", (Object)learnerJSON);
                continue;
            }
            Activity currentActivity = learnerProgress.getCurrentActivity();
            if (currentActivity == null || branchingActivityId != null && !MonitoringAction.isBranchingChild(branchingActivityId, currentActivity)) continue;
            JSONObject learnerJSON = WebUtil.userToJSON((User)learner);
            Long currentActivityId = currentActivity.getActivityId();
            Activity parentActivity = currentActivity.getParentActivity();
            Long targetActivityId = branchingActivityId != null || parentActivity == null || parentActivity.getParentActivity() == null || !parentActivity.getParentActivity().isBranchingActivity() ? currentActivity.getActivityId() : parentActivity.getParentActivity().getActivityId();
            JSONObject targetActivityJSON = (JSONObject)activitiesMap.get(targetActivityId);
            targetActivityJSON.append("learners", (Object)learnerJSON);
        }
        responseJSON.put("activities", (Object)new JSONArray(activitiesMap.values()));
        responseJSON.put("numberPossibleLearners", (Object)lessonDetails.getNumberPossibleLearners());
        response.setContentType("application/json;charset=utf-8");
        response.getWriter().write(responseJSON.toString());
        return null;
    }

    public ActionForward releaseGate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        String wddxPacket = null;
        try {
            Long activityID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID"));
            wddxPacket = monitoringService.releaseGate(activityID);
        }
        catch (Exception e) {
            FlashMessage flashMessage = this.handleException(e, "releaseGate", monitoringService);
            wddxPacket = flashMessage.serializeMessage();
        }
        PrintWriter writer = response.getWriter();
        writer.println(wddxPacket);
        return null;
    }

    public ActionForward startPreviewLesson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        FlashMessage flashMessage = null;
        try {
            Integer userID = this.getUserId();
            long lessonID = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
            if (new Long(lessonID) != null) {
                monitoringService.createPreviewClassForLesson(userID, lessonID);
                monitoringService.startLesson(lessonID, this.getUserId());
                flashMessage = new FlashMessage("startPreviewSession", (Object)new Long(lessonID));
            } else {
                flashMessage = this.handleCriticalError("startPreviewSession", "error.system.error", monitoringService);
            }
        }
        catch (Exception e) {
            flashMessage = this.handleException(e, "startPreviewSession", monitoringService);
        }
        PrintWriter writer = response.getWriter();
        writer.println(flashMessage.serializeMessage());
        return null;
    }

    public ActionForward startLiveEdit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws LearningDesignException, UserException, IOException {
        long learningDesignId = WebUtil.readLongParam((HttpServletRequest)request, (String)"ldId");
        Integer userID = this.getUserId();
        IAuthoringService authoringService = MonitoringServiceProxy.getAuthoringService(this.getServlet().getServletContext());
        if (authoringService.setupEditOnFlyLock(Long.valueOf(learningDesignId), userID)) {
            authoringService.setupEditOnFlyGate(Long.valueOf(learningDesignId), userID);
        } else {
            response.getWriter().write("Someone else is editing the design at the moment.");
        }
        return null;
    }

    private IAuditService getAuditService() {
        if (auditService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            auditService = (IAuditService)ctx.getBean("auditService");
        }
        return auditService;
    }

    private ITimezoneService getTimezoneService() {
        if (timezoneService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            timezoneService = (ITimezoneService)ctx.getBean("timezoneService");
        }
        return timezoneService;
    }

    private ILessonService getLessonService() {
        if (lessonService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            lessonService = (ILessonService)ctx.getBean("lessonService");
        }
        return lessonService;
    }

    public ActionForward learnerExportPortfolioAvailable(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        Long lessonID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID"));
        Integer userID = this.getUserId();
        Boolean learnerExportPortfolioAvailable = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"learnerExportPortfolio", (boolean)false);
        monitoringService.setLearnerPortfolioAvailable(lessonID, userID, learnerExportPortfolioAvailable);
        return null;
    }

    public ActionForward presenceAvailable(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        Long lessonID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID"));
        Integer userID = this.getUserId();
        Boolean presenceAvailable = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"presenceAvailable", (boolean)false);
        monitoringService.setPresenceAvailable(lessonID, userID, presenceAvailable);
        if (!presenceAvailable.booleanValue()) {
            monitoringService.setPresenceImAvailable(lessonID, userID, false);
        }
        return null;
    }

    public ActionForward presenceImAvailable(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        Long lessonID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID"));
        Integer userID = this.getUserId();
        Boolean presenceImAvailable = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"presenceImAvailable", (boolean)false);
        monitoringService.setPresenceImAvailable(lessonID, userID, presenceImAvailable);
        return null;
    }

    public ActionForward viewTimeChart(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        try {
            long lessonID = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
            monitoringService.openTimeChart(lessonID, this.getUserId());
            request.setAttribute("lessonID", (Object)lessonID);
            request.setAttribute("learnerID", (Object)WebUtil.readLongParam((HttpServletRequest)request, (String)"learnerID", (boolean)true));
        }
        catch (Exception e) {
            request.setAttribute("errorName", (Object)"MonitoringAction");
            request.setAttribute("errorMessage", (Object)e.getMessage());
            return mapping.findForward(ERROR);
        }
        return mapping.findForward(TIME_CHART_SCREEN);
    }

    private JSONObject activityProgressToJSON(ActivityURL activity, Long currentActivityId, Long lessonId, Integer learnerId, Integer monitorId) throws JSONException, IOException {
        JSONObject activityJSON = new JSONObject();
        activityJSON.put("id", (Object)activity.getActivityId());
        activityJSON.put("name", (Object)activity.getTitle());
        activityJSON.put("status", (int)(activity.getActivityId().equals(currentActivityId) ? (byte)0 : activity.getStatus()));
        String url = activity.getUrl();
        if (url != null && monitorId != null) {
            IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
            url = Configuration.get((String)ConfigurationKeys.SERVER_URL) + "monitoring/monitoring.do?method=getLearnerActivityURL&lessonID=" + lessonId + "&activityID=" + activity.getActivityId() + "&userID=" + learnerId;
        }
        if (url != null) {
            String serverUrl;
            if (url.startsWith("learner.do")) {
                url = "learning/" + url;
            }
            if (!url.startsWith(serverUrl = Configuration.get((String)ConfigurationKeys.SERVER_URL))) {
                url = serverUrl + url;
            }
            activityJSON.put("url", (Object)url);
        }
        String actType = activity.getType().toLowerCase();
        String type = "a";
        if (actType.contains("gate")) {
            type = "g";
        } else if (actType.contains("options")) {
            type = "o";
        } else if (actType.contains("branching")) {
            type = "b";
        }
        activityJSON.put("type", (Object)type);
        if (activity.getChildActivities() != null) {
            for (ActivityURL childActivity : activity.getChildActivities()) {
                activityJSON.append("childActivities", (Object)this.activityProgressToJSON(childActivity, currentActivityId, lessonId, learnerId, monitorId));
            }
        }
        return activityJSON;
    }

    private List<User> parseUserList(HttpServletRequest request, String paramName) {
        IUserManagementService userManagementService = MonitoringServiceProxy.getUserManagementService(this.getServlet().getServletContext());
        String userIdList = request.getParameter(paramName);
        String[] userIdArray = userIdList.split(",");
        ArrayList<User> result = new ArrayList<User>(userIdArray.length);
        for (String userId : userIdArray) {
            if (StringUtils.isBlank((String)userId)) continue;
            User user = (User)userManagementService.findById(User.class, (Serializable)Integer.valueOf(userId));
            result.add(user);
        }
        return result;
    }

    private static boolean isBranchingChild(Long branchingActivityId, Activity activity) {
        if (branchingActivityId == null || activity == null) {
            return false;
        }
        Activity parentActivity = activity.getParentActivity();
        return parentActivity != null && parentActivity.getParentActivity() != null && parentActivity.getParentActivity().getActivityId().equals(branchingActivityId);
    }
}

