/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.monitoring.web;

import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.SequenceActivity;
import org.lamsfoundation.lams.monitoring.service.IMonitoringService;
import org.lamsfoundation.lams.monitoring.service.MonitoringServiceProxy;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;

public class SequenceAction
extends LamsDispatchAction {
    public static final String VIEW_SEQUENCE = "viewSequence";
    public static final String PARAM_LEARNERS = "learners";
    public static final String PARAM_LOCAL_FILES = "localFiles";

    public ActionForward exportPortfolio(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        long activityId = WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID");
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        SequenceActivity activity = (SequenceActivity)monitoringService.getActivityById(activityId, SequenceActivity.class);
        return this.viewSequence(activity, lessonId, true, mapping, request, monitoringService);
    }

    public ActionForward viewSequence(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        long activityId = WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID");
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        SequenceActivity activity = (SequenceActivity)monitoringService.getActivityById(activityId, SequenceActivity.class);
        return this.viewSequence(activity, lessonId, false, mapping, request, monitoringService);
    }

    protected ActionForward viewSequence(SequenceActivity activity, Long lessonId, boolean useLocalFiles, ActionMapping mapping, HttpServletRequest request, IMonitoringService monitoringService) throws IOException, ServletException {
        request.setAttribute("activityID", (Object)activity.getActivityId());
        request.setAttribute("lessonID", (Object)lessonId);
        request.setAttribute("title", (Object)activity.getTitle());
        request.setAttribute(PARAM_LOCAL_FILES, (Object)useLocalFiles);
        List<User> learners = monitoringService.getLearnersHaveAttemptedActivity((Activity)activity);
        request.setAttribute(PARAM_LEARNERS, learners);
        return mapping.findForward(VIEW_SEQUENCE);
    }
}

