/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Set;
import java.util.TimeZone;
import java.util.Vector;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.GateActivity;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.LearningLibrary;
import org.lamsfoundation.lams.learningdesign.Transition;
import org.lamsfoundation.lams.learningdesign.dto.ValidationErrorDTO;
import org.lamsfoundation.lams.learningdesign.strategy.ScheduleGateActivityStrategy;
import org.lamsfoundation.lams.tool.SystemTool;
import org.lamsfoundation.lams.util.MessageService;

public class ScheduleGateActivity
extends GateActivity
implements Serializable {
    private Long gateStartTimeOffset;
    private Long gateEndTimeOffset;
    private Date gateStartDateTime;
    private Date gateEndDateTime;

    public ScheduleGateActivity(Long activityId, Integer id, String description, String title, Integer xcoord, Integer ycoord, Integer orderId, Boolean defineLater, Date createDateTime, LearningLibrary learningLibrary, Activity parentActivity, Activity libraryActivity, Integer parentUIID, LearningDesign learningDesign, Grouping grouping, Integer activityTypeId, Transition transitionTo, Transition transitionFrom, String languageFile, Boolean stopAfterActivity, Integer gateActivityLevelId, Long gateStartTimeOffset, Long gateEndTimeOffset, Set waitingLearners, SystemTool sysTool) {
        super(activityId, id, description, title, xcoord, ycoord, orderId, defineLater, createDateTime, learningLibrary, parentActivity, libraryActivity, parentUIID, learningDesign, grouping, activityTypeId, transitionTo, transitionFrom, languageFile, stopAfterActivity, gateActivityLevelId, waitingLearners, sysTool);
        if (gateStartTimeOffset != null && gateEndTimeOffset != null && gateStartTimeOffset.intValue() > gateEndTimeOffset.intValue()) {
            throw new IllegalStateException("End time offset must be larger than start time offset");
        }
        this.gateStartTimeOffset = gateStartTimeOffset;
        this.gateEndTimeOffset = gateEndTimeOffset;
        this.simpleActivityStrategy = new ScheduleGateActivityStrategy(this);
    }

    public ScheduleGateActivity() {
        this.simpleActivityStrategy = new ScheduleGateActivityStrategy(this);
    }

    public ScheduleGateActivity(Long activityId, Boolean defineLater, Date createDateTime, LearningLibrary learningLibrary, Activity parentActivity, LearningDesign learningDesign, Grouping grouping, Integer activityTypeId, Transition transitionTo, Transition transitionFrom, Integer gateActivityLevelId, Long gateStartTimeOffset, Long gateEndTimeOffset, Set waitingLearners) {
        super(activityId, defineLater, createDateTime, learningLibrary, parentActivity, learningDesign, grouping, activityTypeId, transitionTo, transitionFrom, gateActivityLevelId, waitingLearners);
        if (gateStartTimeOffset != null && gateEndTimeOffset != null && gateStartTimeOffset.intValue() > gateEndTimeOffset.intValue()) {
            throw new IllegalStateException("End time offset must be larger than start time offset");
        }
        this.gateStartTimeOffset = gateStartTimeOffset;
        this.gateEndTimeOffset = gateEndTimeOffset;
        this.simpleActivityStrategy = new ScheduleGateActivityStrategy(this);
    }

    public Activity createCopy() {
        ScheduleGateActivity newScheduleGateActivity = new ScheduleGateActivity();
        this.copyToNewActivity(newScheduleGateActivity);
        newScheduleGateActivity.setGateActivityLevelId(this.getGateActivityLevelId());
        newScheduleGateActivity.setGateOpen(new Boolean(false));
        newScheduleGateActivity.setGateEndTimeOffset(this.getGateEndTimeOffset());
        newScheduleGateActivity.setGateStartTimeOffset(this.getGateStartTimeOffset());
        newScheduleGateActivity.setGateEndDateTime(this.getGateEndDateTime());
        newScheduleGateActivity.setGateStartDateTime(this.getGateStartDateTime());
        return newScheduleGateActivity;
    }

    public Date getGateEndDateTime() {
        return this.gateEndDateTime;
    }

    public void setGateEndDateTime(Date gateEndDateTime) {
        this.gateEndDateTime = gateEndDateTime;
    }

    public Date getGateStartDateTime() {
        return this.gateStartDateTime;
    }

    public void setGateStartDateTime(Date gateStartDateTime) {
        this.gateStartDateTime = gateStartDateTime;
    }

    public Long getGateStartTimeOffset() {
        return this.gateStartTimeOffset;
    }

    public void setGateStartTimeOffset(Long gateStartTimeOffset) {
        this.gateStartTimeOffset = gateStartTimeOffset;
    }

    public Long getGateEndTimeOffset() {
        return this.gateEndTimeOffset;
    }

    public void setGateEndTimeOffset(Long gateEndTimeOffset) {
        this.gateEndTimeOffset = gateEndTimeOffset;
    }

    public Date getLessonGateOpenTime(Date lessonStartTime) {
        GregorianCalendar openTime = new GregorianCalendar(TimeZone.getDefault());
        openTime.setTime(lessonStartTime);
        if (this.isScheduledByStartTimeOffset()) {
            ((Calendar)openTime).add(12, this.getGateStartTimeOffset().intValue());
            this.setGateStartDateTime(openTime.getTime());
        } else if (this.isScheduledByStartDateTime()) {
            openTime.setTime(this.getGateStartDateTime());
        }
        return openTime.getTime();
    }

    public Date getLessonGateCloseTime(Date lessonStartTime) {
        GregorianCalendar closeTime = new GregorianCalendar(TimeZone.getDefault());
        closeTime.setTime(lessonStartTime);
        if (this.isScheduledByEndTimeOffset()) {
            ((Calendar)closeTime).add(12, this.getGateEndTimeOffset().intValue());
            this.setGateEndDateTime(closeTime.getTime());
        } else if (this.isScheduledByEndDateTime()) {
            closeTime.setTime(this.getGateEndDateTime());
        }
        return closeTime.getTime();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("activityId", (Object)this.getActivityId()).toString();
    }

    public boolean isNull() {
        return false;
    }

    public Vector validateActivity(MessageService messageService) {
        Vector<ValidationErrorDTO> listOfValidationErrors = new Vector<ValidationErrorDTO>();
        if (this.isScheduledByTimeOffset()) {
            if (this.getGateStartTimeOffset().equals(this.getGateEndTimeOffset())) {
                listOfValidationErrors.add(new ValidationErrorDTO("SG1", messageService.getMessage("validation.error.illegalScheduleGateOffsetsType1"), this.getActivityUIID()));
            } else if (this.getGateStartTimeOffset().compareTo(this.getGateEndTimeOffset()) > 0) {
                listOfValidationErrors.add(new ValidationErrorDTO("SG1", messageService.getMessage("validation.error.illegalScheduleGateOffsetsType2"), this.getActivityUIID()));
            }
        }
        return listOfValidationErrors;
    }

    private boolean isScheduledByTimeOffset() {
        return this.getGateStartTimeOffset() != null && this.getGateEndTimeOffset() != null;
    }

    private boolean isScheduledByDateTime() {
        return this.getGateStartDateTime() != null && this.getGateEndDateTime() != null;
    }

    private boolean isScheduledByStartTimeOffset() {
        return this.getGateStartTimeOffset() != null;
    }

    private boolean isScheduledByEndTimeOffset() {
        return this.getGateEndTimeOffset() != null;
    }

    private boolean isScheduledByStartDateTime() {
        return this.getGateStartDateTime() != null;
    }

    private boolean isScheduledByEndDateTime() {
        return this.getGateEndDateTime() != null;
    }

    public boolean isScheduled() {
        return this.isScheduledByTimeOffset() || this.isScheduledByDateTime();
    }
}

