/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.strategy;

import java.util.ArrayList;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.BranchingActivity;
import org.lamsfoundation.lams.learningdesign.ComplexActivity;
import org.lamsfoundation.lams.learningdesign.ContributionTypes;
import org.lamsfoundation.lams.learningdesign.strategy.ComplexActivityStrategy;
import org.lamsfoundation.lams.lesson.LearnerProgress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BranchingActivityStrategy
extends ComplexActivityStrategy {
    private static final long serialVersionUID = -1861859105441615028L;
    private BranchingActivity branchingActivity = null;

    public BranchingActivityStrategy(BranchingActivity branchingActivity) {
        this.branchingActivity = branchingActivity;
    }

    @Override
    public Activity getNextActivityByParent(ComplexActivity parent, Activity currentChild) {
        return parent;
    }

    @Override
    public boolean areChildrenCompleted(LearnerProgress learnerProgress) {
        ComplexActivity complexActivity = this.getComplexActivity();
        boolean isPreview = learnerProgress.getLesson().isPreviewLesson();
        if (complexActivity != null && complexActivity.getActivities().size() > 0) {
            for (Activity currentActivity : complexActivity.getActivities()) {
                boolean actComplete = learnerProgress.getCompletedActivities().contains(currentActivity);
                if (isPreview && !actComplete) {
                    return false;
                }
                if (isPreview || !actComplete) continue;
                return true;
            }
            return isPreview;
        }
        return true;
    }

    @Override
    protected boolean isComplete(int numOfCompletedActivities) {
        return true;
    }

    @Override
    protected ComplexActivity getComplexActivity() {
        return this.branchingActivity;
    }

    @Override
    protected void setUpContributionType(ArrayList<Integer> contributionTypes) {
        if (this.branchingActivity != null && this.branchingActivity.isChosenBranchingActivity()) {
            contributionTypes.add(ContributionTypes.CHOSEN_BRANCHING);
        }
    }
}

