/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.lesson.dao.hibernate;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.hibernate.FetchMode;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.lamsfoundation.lams.dao.hibernate.BaseDAO;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.lesson.LearnerProgress;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.dao.ILessonDAO;
import org.lamsfoundation.lams.usermanagement.User;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;

public class LessonDAO
extends BaseDAO
implements ILessonDAO {
    private static final String FIND_LESSON_BY_CREATOR = "from " + Lesson.class.getName() + " lesson where lesson.user.userId=? and lesson.lessonStateId <= 6 and " + " lesson.learningDesign.copyTypeID=" + 2;
    private static final String FIND_PREVIEW_BEFORE_START_DATE = "from " + Lesson.class.getName() + " lesson where lesson.learningDesign.copyTypeID=" + 3 + "and lesson.startDateTime is not null and lesson.startDateTime < ?";
    private static final String COUNT_ACTIVE_LEARNERS = "select count(distinct progress.user.id) from " + LearnerProgress.class.getName() + " progress" + " where progress.lesson.id = :lessonId";
    private static final String FIND_LESSON_FOR_ACTIVITY = "select lesson from " + Lesson.class.getName() + " lesson, " + Activity.class.getName() + " activity " + " where activity.activityId=:activityId and activity.learningDesign=lesson.learningDesign";

    public Lesson getLesson(Long lessonId) {
        Lesson lesson = (Lesson)this.getHibernateTemplate().get(Lesson.class, (Serializable)lessonId);
        return lesson;
    }

    public Lesson getLessonWithJoinFetchedProgress(final Long lessonId) {
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        return (Lesson)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.createCriteria(Lesson.class).add((Criterion)Expression.like((String)"lessonId", (Object)lessonId)).setFetchMode("learnerProgresses", FetchMode.JOIN).uniqueResult();
            }
        });
    }

    public List getAllLessons() {
        return this.getHibernateTemplate().loadAll(Lesson.class);
    }

    public List getActiveLessonsForLearner(final User learner) {
        List lessons = null;
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        lessons = (List)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.getNamedQuery("activeLessonsAllOrganisations");
                query.setInteger("userId", learner.getUserId().intValue());
                List result = query.list();
                return result;
            }
        });
        return lessons;
    }

    public List getActiveLessonsForLearner(final Integer learnerId, final Integer organisationId) {
        List lessons = null;
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        lessons = (List)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.getNamedQuery("activeLessons");
                query.setInteger("userId", learnerId.intValue());
                query.setInteger("organisationId", organisationId.intValue());
                List result = query.list();
                return result;
            }
        });
        return lessons;
    }

    public List getActiveLearnerByLesson(final long lessonId) {
        List learners = null;
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        learners = (List)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.getNamedQuery("activeLearners");
                query.setLong("lessonId", lessonId);
                List result = query.list();
                return result;
            }
        });
        return learners;
    }

    public Integer getCountActiveLearnerByLesson(final long lessonId) {
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        return (Integer)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.createQuery(COUNT_ACTIVE_LEARNERS);
                query.setLong("lessonId", lessonId);
                Object value = query.uniqueResult();
                return new Integer(((Number)value).intValue());
            }
        });
    }

    public void saveLesson(Lesson lesson) {
        this.getHibernateTemplate().save((Object)lesson);
    }

    public void deleteLesson(Lesson lesson) {
        this.getHibernateTemplate().delete((Object)lesson);
    }

    public void updateLesson(Lesson lesson) {
        this.getHibernateTemplate().update((Object)lesson);
    }

    public List getLessonsCreatedByUser(Integer userID) {
        List lessons = this.getHibernateTemplate().find(FIND_LESSON_BY_CREATOR, (Object)userID);
        return lessons;
    }

    public List getLessonsForMonitoring(final int userID, final int organisationID) {
        List lessons = null;
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        lessons = (List)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.getNamedQuery("lessonsForMonitoring");
                query.setInteger("userId", userID);
                query.setInteger("organisationId", organisationID);
                List result = query.list();
                return result;
            }
        });
        return lessons;
    }

    public List getPreviewLessonsBeforeDate(Date startDate) {
        List lessons = this.getHibernateTemplate().find(FIND_PREVIEW_BEFORE_START_DATE, (Object)startDate);
        return lessons;
    }

    public Lesson getLessonForActivity(final long activityId) {
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        return (Lesson)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.createQuery(FIND_LESSON_FOR_ACTIVITY);
                query.setLong("activityId", activityId);
                return query.uniqueResult();
            }
        });
    }
}

