/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.FileUtilException;
import org.lamsfoundation.lams.util.TempDirectoryFilter;

public class FileUtil {
    private static Logger log = Logger.getLogger(FileUtil.class);
    public static final String LAMS_WWW_SECURE_DIR = "secure";
    public static final String LAMS_WWW_DIR = "lams-www.war";
    private static final long numMilliSecondsInADay = 86400000L;
    protected static final String prefix = "lamstmp_";
    public static final String TEMP_DIR = System.getProperty("java.io.tmpdir");

    public static boolean deleteDirectory(File directory) {
        boolean retValue = true;
        File[] files = directory.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (file.isDirectory()) {
                    FileUtil.deleteDirectory(file);
                    continue;
                }
                if (file.delete()) continue;
                log.error((Object)("Unable to delete file " + file.getName()));
                retValue = false;
            }
        }
        if (directory.delete()) {
            return retValue;
        }
        return false;
    }

    public static boolean deleteDirectory(String directoryName) throws FileUtilException {
        boolean isDeleted = false;
        if (directoryName == null || directoryName.length() == 0) {
            throw new FileUtilException("A directory name must be specified");
        }
        File dir = new File(directoryName);
        isDeleted = FileUtil.deleteDirectory(dir);
        return isDeleted;
    }

    public static boolean isEmptyDirectory(String directoryName, boolean checkSubdirectories) throws FileUtilException {
        if (directoryName == null || directoryName.length() == 0) {
            throw new FileUtilException("A directory name must be specified");
        }
        return FileUtil.isEmptyDirectory(new File(directoryName), checkSubdirectories);
    }

    private static boolean isEmptyDirectory(File directory, boolean checkSubdirectories) throws FileUtilException {
        if (directory.exists()) {
            File[] files = directory.listFiles();
            if (files.length > 0) {
                if (!checkSubdirectories) {
                    return false;
                }
                boolean isEmpty = true;
                for (int i = 0; i < files.length && isEmpty; ++i) {
                    File file = files[i];
                    isEmpty = file.isDirectory() ? FileUtil.isEmptyDirectory(file, true) : false;
                }
                return isEmpty;
            }
            return true;
        }
        return true;
    }

    public static String createTempDirectory(String suffix) throws FileUtilException {
        String tempSysDirName = TEMP_DIR;
        if (tempSysDirName == null) {
            throw new FileUtilException("No temporary directory known to the server. [System.getProperty( \"java.io.tmpdir\" ) returns null. ]\n Cannot upload package.");
        }
        String tempDirName = tempSysDirName + File.separator + prefix + System.currentTimeMillis() + "_" + suffix;
        File tempDir = new File(tempDirName);
        int i = 0;
        while (tempDir.exists() && i < 100) {
            tempDirName = tempSysDirName + File.separator + prefix + System.currentTimeMillis() + "_" + i + suffix;
            tempDir = new File(tempDirName);
        }
        if (tempDir.exists()) {
            throw new FileUtilException("Unable to create temporary directory. The temporary filename/directory that we would use to extract files already exists: " + tempDirName);
        }
        tempDir.mkdirs();
        return tempDirName;
    }

    public static boolean createDirectory(String directoryName) throws FileUtilException {
        boolean isCreated = false;
        if (directoryName == null || directoryName.length() == 0) {
            throw new FileUtilException("A directory name must be specified");
        }
        File dir = new File(directoryName);
        isCreated = dir.exists() ? false : dir.mkdirs();
        return isCreated;
    }

    public static boolean createDirectory(String parentDirName, String subDirName) throws FileUtilException {
        String combinedDirName;
        boolean isSubDirCreated = false;
        if (parentDirName == null || parentDirName.length() == 0 || subDirName == null || subDirName.length() == 0) {
            throw new FileUtilException("A parent or subdirectory name must be specified");
        }
        File parentDir = new File(parentDirName);
        boolean isParentDirCreated = !parentDir.exists() ? FileUtil.createDirectory(parentDirName) : true;
        if (FileUtil.trailingForwardSlashPresent(parentDirName)) {
            parentDirName = FileUtil.removeTrailingForwardSlash(parentDirName);
        }
        return (isSubDirCreated = FileUtil.createDirectory(combinedDirName = parentDirName + File.separator + subDirName)) && isParentDirCreated;
    }

    public static String removeTrailingForwardSlash(String stringToModify) {
        String stringWithoutSlashAtEnd = stringToModify.substring(0, stringToModify.length() - 1);
        return stringWithoutSlashAtEnd;
    }

    public static boolean trailingForwardSlashPresent(String stringToCheck) {
        int indexOfSlash = stringToCheck.lastIndexOf("/");
        return indexOfSlash == stringToCheck.length() - 1;
    }

    public static boolean directoryExist(String directoryToCheck) {
        File dir = new File(directoryToCheck);
        return dir.exists();
    }

    private static String generateDumpFilename(String id, String extension) throws FileUtilException {
        String dumpDirectory = Configuration.get(ConfigurationKeys.LAMS_DUMP_DIR);
        if (dumpDirectory == null) {
            dumpDirectory = TEMP_DIR;
        }
        FileUtil.createDirectory(dumpDirectory);
        String dumpFilename = dumpDirectory + File.separator + id + System.currentTimeMillis() + (extension != null ? "." + extension : "");
        File dumpFile = new File(dumpFilename);
        int i = 0;
        while (dumpFile.exists() && i < 100) {
            dumpFilename = dumpDirectory + File.separator + id + System.currentTimeMillis() + "_" + i + (extension != null ? "." + extension : "");
            dumpFile = new File(dumpFilename);
        }
        if (dumpFile.exists()) {
            throw new FileUtilException("Unable to create dump file. The filename that we would use already exists: " + dumpFile);
        }
        return dumpFilename;
    }

    public static String createDumpFile(byte[] data, String id, String extension) throws FileUtilException {
        String dumpFilename = FileUtil.generateDumpFilename(id, extension);
        FileOutputStream dumpFile = null;
        try {
            dumpFile = new FileOutputStream(dumpFilename);
            ((OutputStream)dumpFile).write(data);
        }
        catch (IOException e) {
            log.error((Object)("Unable to write dump out byte array to dump file. ID: " + id + " Dump: " + data + " Exception " + e.getMessage()), (Throwable)e);
            throw new FileUtilException(e);
        }
        finally {
            try {
                if (dumpFile != null) {
                    ((OutputStream)dumpFile).close();
                }
            }
            catch (IOException e) {
                log.error((Object)("Unable to close dump file. ID: " + id + " Dump: " + data + " Exception " + e.getMessage()), (Throwable)e);
                throw new FileUtilException(e);
            }
        }
        return dumpFilename;
    }

    public static String getFileName(String fileName) {
        if (fileName == null) {
            return "";
        }
        fileName = fileName.trim();
        int dotPos = fileName.lastIndexOf("/");
        int dotPos2 = fileName.lastIndexOf("\\");
        if ((dotPos = Math.max(dotPos, dotPos2)) == -1) {
            return fileName;
        }
        return fileName.substring(dotPos + 1, fileName.length());
    }

    public static String getFileDirectory(String fileName) {
        if (fileName == null) {
            return "";
        }
        fileName = fileName.trim();
        int dotPos = fileName.lastIndexOf("/");
        int dotPos2 = fileName.lastIndexOf("\\");
        if ((dotPos = Math.max(dotPos, dotPos2)) == -1) {
            return "";
        }
        return fileName.substring(0, dotPos + 1);
    }

    public static String getFullPath(String path, String file) {
        String fullpath = path.endsWith(File.separator) ? path + file : path + File.separator + file;
        return FileUtil.makeCanonicalPath(fullpath);
    }

    public static String makeCanonicalPath(String pathfile) {
        pathfile = File.separator.indexOf("\\") != -1 ? pathfile.replaceAll("\\/", "\\\\") : pathfile.replaceAll("\\\\", File.separator);
        return pathfile;
    }

    public static void copyFile(File in, File out) throws Exception {
        FileChannel sourceChannel = new FileInputStream(in).getChannel();
        FileChannel destinationChannel = new FileOutputStream(out).getChannel();
        sourceChannel.transferTo(0L, sourceChannel.size(), destinationChannel);
        sourceChannel.close();
        destinationChannel.close();
    }

    public static String getFileExtension(String fileName) {
        if (fileName == null) {
            return "";
        }
        int dotPos = (fileName = fileName.trim()).lastIndexOf(".");
        if (dotPos == -1) {
            return "";
        }
        return fileName.substring(dotPos + 1, fileName.length());
    }

    public static boolean isExecutableFile(String filename) {
        String extname = FileUtil.getFileExtension(filename);
        log.debug((Object)("Check executable file for extension name " + extname));
        if (StringUtils.isBlank((String)extname)) {
            return false;
        }
        extname = "." + extname;
        String exeListStr = Configuration.get(ConfigurationKeys.EXE_EXTENSIONS);
        String[] extList = StringUtils.split((String)exeListStr, (char)',');
        boolean executable = false;
        for (String ext : extList) {
            if (!StringUtils.equalsIgnoreCase((String)ext, (String)extname)) continue;
            executable = true;
            break;
        }
        return executable;
    }

    public static int cleanupOldFiles(File[] directories) {
        int numDeleted = 0;
        if (directories != null) {
            for (int i = 0; i < directories.length; ++i) {
                if (FileUtil.deleteDirectory(directories[i])) {
                    log.info((Object)("Directory " + directories[i].getPath() + " deleted."));
                } else {
                    log.info((Object)("Directory " + directories[i].getPath() + " partially deleted - some directories/files could not be deleted."));
                }
                ++numDeleted;
            }
        }
        return numDeleted;
    }

    public static File[] getOldTempFiles(int numDays) throws FileUtilException {
        if (numDays < 0) {
            throw new FileUtilException("Invalid getOldTempFiles call - the parameter numDays is " + numDays + ". Must not be less than 0.");
        }
        long newestDateToKeep = System.currentTimeMillis() - (long)numDays * 86400000L;
        Date date = new Date(newestDateToKeep);
        log.info((Object)("Getting all temp zipfile expanded directories before " + date.toString() + " (server time) (" + newestDateToKeep + ")"));
        File tempSysDir = new File(TEMP_DIR);
        File[] candidates = tempSysDir.listFiles(new TempDirectoryFilter(newestDateToKeep, log));
        return candidates;
    }

    public static long calculateFileSize(File file) {
        if (file != null) {
            if (file.isFile()) {
                return file.length();
            }
            if (file.isDirectory()) {
                File[] fileList = file.listFiles();
                long totalSize = 0L;
                if (fileList != null) {
                    for (int i = 0; i < fileList.length; ++i) {
                        totalSize += FileUtil.calculateFileSize(fileList[i]);
                    }
                    return totalSize;
                }
                return 0L;
            }
        } else {
            return 0L;
        }
        return 0L;
    }

    public static String stripInvalidChars(String name) {
        name = name.replaceAll("\\\\", "");
        name = name.replaceAll("\\/", "");
        name = name.replaceAll("\\:", "");
        name = name.replaceAll("\\*", "");
        name = name.replaceAll("\\?", "");
        name = name.replaceAll("\\>", "");
        name = name.replaceAll("\\<", "");
        name = name.replaceAll("\\|", "");
        name = name.replaceAll("\\#", "");
        name = name.replaceAll("\\%", "");
        name = name.replaceAll("\\$", "");
        name = name.replaceAll("\\;", "");
        return name;
    }
}

