/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.authoring;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ChosenGrouping;
import org.lamsfoundation.lams.learningdesign.GateActivity;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.GroupingActivity;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.LearningLibrary;
import org.lamsfoundation.lams.learningdesign.License;
import org.lamsfoundation.lams.learningdesign.OptionsActivity;
import org.lamsfoundation.lams.learningdesign.ParallelActivity;
import org.lamsfoundation.lams.learningdesign.PermissionGateActivity;
import org.lamsfoundation.lams.learningdesign.RandomGrouping;
import org.lamsfoundation.lams.learningdesign.ScheduleGateActivity;
import org.lamsfoundation.lams.learningdesign.SequenceActivity;
import org.lamsfoundation.lams.learningdesign.SynchGateActivity;
import org.lamsfoundation.lams.learningdesign.ToolActivity;
import org.lamsfoundation.lams.learningdesign.Transition;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.ActivityDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.GroupDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.GroupingDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.LearningDesignDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.LearningLibraryDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.LicenseDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.TransitionDAO;
import org.lamsfoundation.lams.learningdesign.dto.AuthoringActivityDTO;
import org.lamsfoundation.lams.learningdesign.dto.GroupingDTO;
import org.lamsfoundation.lams.learningdesign.dto.LearningDesignDTO;
import org.lamsfoundation.lams.learningdesign.dto.TransitionDTO;
import org.lamsfoundation.lams.lesson.LessonClass;
import org.lamsfoundation.lams.tool.Tool;
import org.lamsfoundation.lams.tool.dao.hibernate.ToolDAO;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.WorkspaceFolder;
import org.lamsfoundation.lams.usermanagement.dao.hibernate.UserDAO;
import org.lamsfoundation.lams.usermanagement.dao.hibernate.WorkspaceFolderDAO;
import org.lamsfoundation.lams.util.wddx.WDDXProcessorConversionException;
import org.lamsfoundation.lams.util.wddx.WDDXTAGS;

public class ObjectExtractor {
    protected UserDAO userDAO = null;
    protected LearningDesignDAO learningDesignDAO = null;
    protected ActivityDAO activityDAO = null;
    protected TransitionDAO transitionDAO = null;
    protected WorkspaceFolderDAO workspaceFolderDAO = null;
    protected LearningLibraryDAO learningLibraryDAO = null;
    protected LicenseDAO licenseDAO = null;
    protected GroupingDAO groupingDAO = null;
    protected ToolDAO toolDAO = null;
    protected GroupDAO groupDAO = null;

    public ObjectExtractor(UserDAO userDAO, LearningDesignDAO learningDesignDAO, ActivityDAO activityDAO, WorkspaceFolderDAO workspaceFolderDAO, LearningLibraryDAO learningLibraryDAO, LicenseDAO licenseDAO, GroupingDAO groupingDAO, ToolDAO toolDAO, GroupDAO groupDAO, TransitionDAO transitionDAO) {
        this.userDAO = userDAO;
        this.learningDesignDAO = learningDesignDAO;
        this.activityDAO = activityDAO;
        this.workspaceFolderDAO = workspaceFolderDAO;
        this.learningLibraryDAO = learningLibraryDAO;
        this.licenseDAO = licenseDAO;
        this.groupingDAO = groupingDAO;
        this.toolDAO = toolDAO;
        this.groupDAO = groupDAO;
        this.transitionDAO = transitionDAO;
    }

    public LearningDesign extractLearningDesignObject(LearningDesignDTO learningDesignDTO) throws Exception {
        LearningDesign parent;
        WorkspaceFolder workspaceFolder;
        License license;
        User user;
        LearningDesign learningDesign = LearningDesignDTO.extractLearningDesign((LearningDesignDTO)learningDesignDTO);
        if (learningDesignDTO.getUserID() != null && !learningDesignDTO.getUserID().equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER) && (user = this.userDAO.getUserById(learningDesignDTO.getUserID())) != null) {
            learningDesign.setUser(user);
        }
        if (!learningDesignDTO.getLicenseID().equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG) && (license = this.licenseDAO.getLicenseByID(learningDesignDTO.getLicenseID())) != null) {
            learningDesign.setLicense(license);
        }
        if (!learningDesignDTO.getWorkspaceFolderID().equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER) && (workspaceFolder = this.workspaceFolderDAO.getWorkspaceFolderByID(learningDesignDTO.getWorkspaceFolderID())) != null) {
            learningDesign.setWorkspaceFolder(workspaceFolder);
        }
        if (!learningDesignDTO.getParentLearningDesignID().equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG) && (parent = this.learningDesignDAO.getLearningDesignById(learningDesignDTO.getParentLearningDesignID())) != null) {
            learningDesign.setParentLearningDesign(parent);
        }
        this.learningDesignDAO.insert((Object)learningDesign);
        this.parseActivities(learningDesignDTO, learningDesign);
        this.parseTransitions(learningDesignDTO, learningDesign);
        this.calculateFirstActivity(learningDesignDTO.getFirstActivityUIID(), learningDesign);
        return learningDesign;
    }

    private void parseActivities(LearningDesignDTO learningDesignDTO, LearningDesign learningDesign) throws WDDXProcessorConversionException {
        HashSet<Activity> set = new HashSet<Activity>();
        if (learningDesignDTO.getActivities() != null) {
            ArrayList table = learningDesignDTO.getActivities();
            Iterator iterator = table.iterator();
            while (iterator.hasNext()) {
                Hashtable activityDetails = (Hashtable)iterator.next();
                AuthoringActivityDTO authoringActivityDTO = new AuthoringActivityDTO(activityDetails);
                Activity activity = this.extractActivityObject(authoringActivityDTO, learningDesign);
                this.activityDAO.insert((Object)activity);
                set.add(activity);
            }
        }
        learningDesign.setActivities(set);
        this.learningDesignDAO.update((Object)learningDesign);
    }

    private void parseTransitions(LearningDesignDTO learningDesignDTO, LearningDesign learningDesign) throws WDDXProcessorConversionException {
        HashSet<Transition> set = new HashSet<Transition>();
        if (learningDesignDTO.getTransitions() != null) {
            ArrayList table = learningDesignDTO.getTransitions();
            Iterator iterator = table.iterator();
            while (iterator.hasNext()) {
                Hashtable transitionDetails = (Hashtable)iterator.next();
                TransitionDTO transitionDTO = new TransitionDTO(transitionDetails);
                Transition transition = this.extractTransitionObject(transitionDTO, learningDesign);
                this.transitionDAO.insert((Object)transition);
                set.add(transition);
            }
        }
        learningDesign.setTransitions(set);
        this.learningDesignDAO.update((Object)learningDesign);
    }

    public void calculateFirstActivity(Integer firstID, LearningDesign design) throws Exception {
        Activity flashFirstActivity = this.activityDAO.getActivityByUIID(firstID, design);
        design.setFirstActivity(flashFirstActivity);
        this.learningDesignDAO.update((Object)design);
    }

    public Activity extractActivityObject(AuthoringActivityDTO authoringActivityDTO, LearningDesign design) {
        Activity libraryActivity;
        LearningLibrary library;
        Object activityObject = Activity.getActivityInstance((int)authoringActivityDTO.getActivityTypeID());
        this.processActivityType(activityObject, authoringActivityDTO);
        Activity activity = (Activity)activityObject;
        activity.setActivityUIID(authoringActivityDTO.getActivityUIID());
        activity.setDescription(authoringActivityDTO.getDescription());
        activity.setTitle(authoringActivityDTO.getTitle());
        activity.setHelpText(authoringActivityDTO.getHelpText());
        activity.setXcoord(authoringActivityDTO.getXcoord());
        activity.setYcoord(authoringActivityDTO.getYcoord());
        if (authoringActivityDTO.getParentUIID() != null && !authoringActivityDTO.getParentUIID().equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            Activity parentActivity = this.activityDAO.getActivityByUIID(authoringActivityDTO.getParentUIID(), design);
            if (parentActivity != null) {
                activity.setParentActivity(parentActivity);
            }
            activity.setParentUIID(authoringActivityDTO.getParentUIID());
        }
        activity.setActivityTypeId(authoringActivityDTO.getActivityTypeID());
        if (authoringActivityDTO.getGroupingID() != null && !authoringActivityDTO.getGroupingID().equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            Grouping grouping = this.groupingDAO.getGroupingById(authoringActivityDTO.getGroupingID());
            if (grouping != null) {
                activity.setGrouping(grouping);
            }
            activity.setGroupingUIID(authoringActivityDTO.getGroupingUIID());
        }
        activity.setOrderId(authoringActivityDTO.getOrderID());
        activity.setDefineLater(authoringActivityDTO.getDefineLater());
        activity.setLearningDesign(design);
        if (authoringActivityDTO.getLearningLibraryID() != null && !authoringActivityDTO.getLearningLibraryID().equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG) && (library = this.learningLibraryDAO.getLearningLibraryById(authoringActivityDTO.getLearningLibraryID())) != null) {
            activity.setLearningLibrary(library);
        }
        activity.setCreateDateTime(authoringActivityDTO.getCreateDateTime());
        activity.setRunOffline(authoringActivityDTO.getRunOffline());
        activity.setActivityCategoryID(authoringActivityDTO.getActivityCategoryID());
        activity.setLibraryActivityUiImage(authoringActivityDTO.getLibraryActivityUiImage());
        if (authoringActivityDTO.getLibraryActivityID() != null && !authoringActivityDTO.getLibraryActivityID().equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG) && (libraryActivity = this.activityDAO.getActivityByActivityId(authoringActivityDTO.getLibraryActivityID())) != null) {
            activity.setLibraryActivity(libraryActivity);
        }
        activity.setApplyGrouping(authoringActivityDTO.getApplyGrouping());
        activity.setGroupingSupportType(authoringActivityDTO.getGroupingSupportType());
        return activity;
    }

    private void processActivityType(Object activity, AuthoringActivityDTO authoringActivityDTO) {
        if (activity instanceof GroupingActivity) {
            this.buildGroupingActivity((GroupingActivity)activity, authoringActivityDTO);
        } else if (activity instanceof ToolActivity) {
            this.buildToolActivity((ToolActivity)activity, authoringActivityDTO);
        } else if (activity instanceof GateActivity) {
            this.buildGateActivity(activity, authoringActivityDTO);
        } else {
            this.buildComplexActivity(activity, authoringActivityDTO);
        }
    }

    private void buildComplexActivity(Object activity, AuthoringActivityDTO authoringActivityDTO) {
        if (activity instanceof OptionsActivity) {
            this.buildOptionsActivity((OptionsActivity)activity, authoringActivityDTO);
        } else if (activity instanceof ParallelActivity) {
            this.buildParallelActivity((ParallelActivity)activity, authoringActivityDTO);
        } else {
            this.buildSequenceActivity((SequenceActivity)activity, authoringActivityDTO);
        }
    }

    private void buildGroupingActivity(GroupingActivity groupingActivity, AuthoringActivityDTO authoringActivityDTO) {
        Integer groupingType = authoringActivityDTO.getGroupingType();
        Grouping grouping = this.extractGroupingObject(authoringActivityDTO.getGroupingDTO());
        groupingActivity.setCreateGrouping(grouping);
        groupingActivity.setCreateGroupingUIID(grouping.getGroupingUIID());
    }

    private void buildOptionsActivity(OptionsActivity optionsActivity, AuthoringActivityDTO authoringActivityDTO) {
        optionsActivity.setMaxNumberOfOptions(authoringActivityDTO.getMaxOptions());
        optionsActivity.setMinNumberOfOptions(authoringActivityDTO.getMinOptions());
        optionsActivity.setOptionsInstructions(authoringActivityDTO.getOptionsInstructions());
    }

    private void buildParallelActivity(ParallelActivity activity, AuthoringActivityDTO authoringActivityDTO) {
    }

    private void buildSequenceActivity(SequenceActivity activity, AuthoringActivityDTO authoringActivityDTO) {
    }

    private void buildToolActivity(ToolActivity toolActivity, AuthoringActivityDTO authoringActivityDTO) {
        toolActivity.setToolContentId(authoringActivityDTO.getToolContentID());
        Tool tool = this.toolDAO.getToolByID(authoringActivityDTO.getToolID());
        toolActivity.setTool(tool);
    }

    private void buildGateActivity(Object activity, AuthoringActivityDTO authoringActivityDTO) {
        if (activity instanceof SynchGateActivity) {
            this.buildSynchGateActivity((SynchGateActivity)activity, authoringActivityDTO);
        } else if (activity instanceof PermissionGateActivity) {
            this.buildPermissionGateActivity((PermissionGateActivity)activity, authoringActivityDTO);
        } else {
            ObjectExtractor.buildScheduleGateActivity((ScheduleGateActivity)activity, authoringActivityDTO);
        }
        GateActivity gateActivity = (GateActivity)activity;
        gateActivity.setGateActivityLevelId(authoringActivityDTO.getGateActivityLevelID());
        gateActivity.setGateOpen(authoringActivityDTO.getGateOpen());
    }

    private void buildSynchGateActivity(SynchGateActivity activity, AuthoringActivityDTO authoringActivityDTO) {
    }

    private void buildPermissionGateActivity(PermissionGateActivity activity, AuthoringActivityDTO authoringActivityDTO) {
    }

    private static void buildScheduleGateActivity(ScheduleGateActivity activity, AuthoringActivityDTO authoringActivityDTO) {
        activity.setGateStartDateTime(authoringActivityDTO.getGateStartDateTime());
        activity.setGateEndDateTime(authoringActivityDTO.getGateEndDateTime());
        activity.setGateStartTimeOffset(authoringActivityDTO.getGateStartTimeOffset());
        activity.setGateEndTimeOffset(authoringActivityDTO.getGateEndTimeOffset());
    }

    public Grouping extractGroupingObject(GroupingDTO groupingDTO) {
        Object object = Grouping.getGroupingInstance((Integer)groupingDTO.getGroupingType());
        if (object instanceof RandomGrouping) {
            this.createRandomGrouping((RandomGrouping)object, groupingDTO);
        } else if (object instanceof ChosenGrouping) {
            this.createChosenGrouping((ChosenGrouping)object, groupingDTO);
        } else {
            this.createLessonClass((LessonClass)object, groupingDTO);
        }
        Grouping grouping = (Grouping)object;
        grouping.setGroupingUIID(groupingDTO.getGroupingUIID());
        grouping.setMaxNumberOfGroups(groupingDTO.getMaxNumberOfGroups());
        this.groupingDAO.insert((Object)grouping);
        return grouping;
    }

    private void createRandomGrouping(RandomGrouping randomGrouping, GroupingDTO groupingDTO) {
        randomGrouping.setLearnersPerGroup(groupingDTO.getLearnersPerGroup());
        randomGrouping.setNumberOfGroups(groupingDTO.getNumberOfGroups());
    }

    private void createChosenGrouping(ChosenGrouping chosenGrouping, GroupingDTO groupingDTO) {
    }

    private void createLessonClass(LessonClass lessonClass, GroupingDTO groupingDTO) {
        Group group = this.groupDAO.getGroupById(groupingDTO.getStaffGroupID());
        if (group != null) {
            lessonClass.setStaffGroup(group);
        }
    }

    private Transition extractTransitionObject(TransitionDTO transitionDTO, LearningDesign learningDesign) {
        Transition transition = new Transition();
        transition.setTransitionUIID(transitionDTO.getTransitionUIID());
        if (transitionDTO.getToUIID() != null) {
            Activity toActivity = this.activityDAO.getActivityByUIID(transitionDTO.getToUIID(), learningDesign);
            transition.setToActivity(toActivity);
            transition.setToUIID(transitionDTO.getToUIID());
        }
        if (transitionDTO.getFromUIID() != null) {
            Activity fromActivity = this.activityDAO.getActivityByUIID(transitionDTO.getFromUIID(), learningDesign);
            transition.setFromActivity(fromActivity);
            transition.setFromUIID(transitionDTO.getFromUIID());
        }
        transition.setDescription(transitionDTO.getDescription());
        transition.setTitle(transitionDTO.getTitle());
        transition.setCreateDateTime(transitionDTO.getCreateDateTime());
        transition.setLearningDesign(learningDesign);
        return transition;
    }
}

