/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.security;

import java.lang.reflect.Constructor;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.security.NestableGroup;
import org.lamsfoundation.lams.security.SimpleGroup;
import org.lamsfoundation.lams.security.SimplePrincipal;

public class AbstractServerLoginModule
implements LoginModule {
    protected Subject subject;
    protected CallbackHandler callbackHandler;
    protected Map sharedState;
    protected Map options;
    protected Logger log = Logger.getLogger((Class)(class$org$lamsfoundation$lams$security$AbstractServerLoginModule == null ? (class$org$lamsfoundation$lams$security$AbstractServerLoginModule = AbstractServerLoginModule.class$("org.lamsfoundation.lams.security.AbstractServerLoginModule")) : class$org$lamsfoundation$lams$security$AbstractServerLoginModule));
    protected boolean useFirstPass;
    protected boolean loginOk;
    protected String principalClassName;
    protected Principal unauthenticatedIdentity;
    static /* synthetic */ Class class$org$lamsfoundation$lams$security$AbstractServerLoginModule;
    static /* synthetic */ Class class$java$lang$String;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        this.log = Logger.getLogger(this.getClass());
        this.log.info((Object)"initialize");
        String passwordStacking = (String)options.get("password-stacking");
        if (passwordStacking != null && passwordStacking.equalsIgnoreCase("useFirstPass")) {
            this.useFirstPass = true;
        }
        this.principalClassName = (String)options.get("principalClass");
        String name = (String)options.get("unauthenticatedIdentity");
        if (name != null) {
            try {
                this.unauthenticatedIdentity = this.createIdentity(name);
                this.log.info((Object)("Saw unauthenticatedIdentity=" + name));
            }
            catch (Exception e) {
                this.log.warn((Object)"Failed to create custom unauthenticatedIdentity", (Throwable)e);
            }
        }
    }

    public boolean login() throws LoginException {
        this.log.info((Object)"login");
        this.loginOk = false;
        if (this.useFirstPass) {
            try {
                Object identity = this.sharedState.get("javax.security.auth.login.name");
                Object credential = this.sharedState.get("javax.security.auth.login.password");
                if (identity != null && credential != null) {
                    this.loginOk = true;
                    return true;
                }
            }
            catch (Exception e) {
                this.log.error((Object)"login failed", (Throwable)e);
            }
        }
        return false;
    }

    public boolean commit() throws LoginException {
        this.log.info((Object)("commit, loginOk=" + this.loginOk));
        if (!this.loginOk) {
            return false;
        }
        Set<Principal> principals = this.subject.getPrincipals();
        Principal identity = this.getIdentity();
        principals.add(identity);
        Group[] roleSets = this.getRoleSets();
        for (int g = 0; g < roleSets.length; ++g) {
            Group group = roleSets[g];
            String name = group.getName();
            Group subjectGroup = this.createGroup(name, principals);
            if (subjectGroup instanceof NestableGroup) {
                SimpleGroup tmp = new SimpleGroup("Roles");
                subjectGroup.addMember((Principal)tmp);
                subjectGroup = tmp;
            }
            Enumeration members = group.members();
            while (members.hasMoreElements()) {
                Principal role = (Principal)members.nextElement();
                subjectGroup.addMember(role);
            }
        }
        return true;
    }

    public boolean abort() throws LoginException {
        this.log.info((Object)"abort");
        return true;
    }

    public boolean logout() throws LoginException {
        this.log.info((Object)"logout");
        Principal identity = this.getIdentity();
        Set<Principal> principals = this.subject.getPrincipals();
        principals.remove(identity);
        return true;
    }

    protected Principal getIdentity() {
        return null;
    }

    protected Group[] getRoleSets() throws LoginException {
        return null;
    }

    protected boolean getUseFirstPass() {
        return this.useFirstPass;
    }

    protected Principal getUnauthenticatedIdentity() {
        return this.unauthenticatedIdentity;
    }

    protected Group createGroup(String name, Set principals) {
        SimpleGroup roles = null;
        Iterator iter = principals.iterator();
        while (iter.hasNext()) {
            Group grp;
            Object next = iter.next();
            if (!(next instanceof Group) || !(grp = (Group)next).getName().equals(name)) continue;
            roles = grp;
            break;
        }
        if (roles == null) {
            roles = new SimpleGroup(name);
            principals.add(roles);
        }
        return roles;
    }

    protected Principal createIdentity(String username) throws Exception {
        Principal p = null;
        if (this.principalClassName == null) {
            p = new SimplePrincipal(username);
        } else {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = loader.loadClass(this.principalClassName);
            Class[] ctorSig = new Class[]{class$java$lang$String == null ? (class$java$lang$String = AbstractServerLoginModule.class$("java.lang.String")) : class$java$lang$String};
            Constructor<?> ctor = clazz.getConstructor(ctorSig);
            Object[] ctorArgs = new Object[]{username};
            p = (Principal)ctor.newInstance(ctorArgs);
        }
        return p;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

