/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.workspace.dao;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import org.lamsfoundation.lams.contentrepository.ICredentials;
import org.lamsfoundation.lams.contentrepository.ITicket;
import org.lamsfoundation.lams.contentrepository.NodeKey;
import org.lamsfoundation.lams.contentrepository.SimpleCredentials;
import org.lamsfoundation.lams.usermanagement.WorkspaceFolder;
import org.lamsfoundation.lams.workspace.WorkspaceFolderContent;
import org.lamsfoundation.lams.workspace.service.BaseWorkspaceTest;

public class TestWorkspaceFolderContentDAO
extends BaseWorkspaceTest {
    protected WorkspaceFolder workspaceFolder;
    protected String workspaceUser = "workspaceManager";
    protected String password = "flashClient";
    protected String workspaceName = "FlashClientsWorkspace";
    protected ICredentials credentials;
    protected ITicket ticket;

    public TestWorkspaceFolderContentDAO(String string) {
        super(string);
    }

    public void testInsertWorkspaceFolderContent() {
        this.workspaceFolder = this.workspaceFolderDAO.getWorkspaceFolderByID(new Integer(4));
        WorkspaceFolderContent workspaceFolderContent = new WorkspaceFolderContent(WorkspaceFolderContent.CONTENT_TYPE_FILE, this.testFileString, "Test Description", new Date(), new Date(), "TXT", this.workspaceFolder);
        this.workspaceFolderContentDAO.insert((Object)workspaceFolderContent);
        TestWorkspaceFolderContentDAO.assertNotNull((Object)workspaceFolderContent.getFolderContentID());
    }

    public void testGetContentByWorkspaceFolder() {
        List list = this.workspaceFolderContentDAO.getContentByWorkspaceFolder(new Long(3L));
        TestWorkspaceFolderContentDAO.assertEquals((int)list.size(), (int)4);
    }

    public void testGetContentByTypeFromWorkspaceFolder() {
        List list = this.workspaceFolderContentDAO.getContentByTypeFromWorkspaceFolder(new Long(3L), "TXT");
        TestWorkspaceFolderContentDAO.assertEquals((int)list.size(), (int)2);
    }

    public void testAddFlashClientWorkspaceCredentials() throws Exception {
        this.credentials = new SimpleCredentials(this.workspaceUser, this.password.toCharArray());
        this.ticket = this.repositoryService.login(this.credentials, this.workspaceName);
        TestWorkspaceFolderContentDAO.assertNotNull((String)("Add workspace succeeded - can login to workspace. Ticket is " + this.ticket), (Object)this.ticket);
        this.testAddFile(this.ticket);
    }

    private void testAddFile(ITicket iTicket) throws Exception {
        WorkspaceFolderContent workspaceFolderContent = this.workspaceFolderContentDAO.getWorkspaceFolderContentByID(new Long(7L));
        FileInputStream fileInputStream = new FileInputStream(this.testFileString);
        NodeKey nodeKey = this.repositoryService.addFileItem(iTicket, (InputStream)fileInputStream, workspaceFolderContent.getName(), workspaceFolderContent.getMimeType(), null);
        workspaceFolderContent.setUuid(nodeKey.getUuid());
        workspaceFolderContent.setVersionID(nodeKey.getVersion());
        this.workspaceFolderContentDAO.update((Object)workspaceFolderContent);
        TestWorkspaceFolderContentDAO.assertNotNull((Object)workspaceFolderContent.getUuid());
    }

    public void testUpdateFile() throws Exception {
        WorkspaceFolderContent workspaceFolderContent = this.workspaceFolderContentDAO.getWorkspaceFolderContentByID(new Long(7L));
        FileInputStream fileInputStream = new FileInputStream(this.testFileString);
        this.credentials = new SimpleCredentials(this.workspaceUser, this.password.toCharArray());
        this.ticket = this.repositoryService.login(this.credentials, this.workspaceName);
        NodeKey nodeKey = this.repositoryService.updateFileItem(this.ticket, workspaceFolderContent.getUuid(), workspaceFolderContent.getName(), (InputStream)fileInputStream, workspaceFolderContent.getMimeType(), null);
        workspaceFolderContent.setVersionID(nodeKey.getVersion());
        workspaceFolderContent.setUuid(nodeKey.getUuid());
        this.workspaceFolderContentDAO.update((Object)workspaceFolderContent);
        System.out.println(nodeKey.getVersion() + ": " + workspaceFolderContent.getVersionID());
    }
}

