/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.workspace.service;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import org.lamsfoundation.lams.contentrepository.service.IRepositoryService;
import org.lamsfoundation.lams.contentrepository.service.RepositoryProxy;
import org.lamsfoundation.lams.learningdesign.dao.ILearningDesignDAO;
import org.lamsfoundation.lams.test.AbstractLamsTestCase;
import org.lamsfoundation.lams.usermanagement.dao.IWorkspaceFolderDAO;
import org.lamsfoundation.lams.workspace.dao.IWorkspaceFolderContentDAO;
import org.lamsfoundation.lams.workspace.service.WorkspaceManagementService;

public class BaseWorkspaceTest
extends AbstractLamsTestCase {
    private static final String testFileContents = System.getProperty("This is a testfile.");
    protected String testFileString = null;
    protected WorkspaceManagementService workspaceManagementService;
    protected IWorkspaceFolderDAO workspaceFolderDAO;
    protected IWorkspaceFolderContentDAO workspaceFolderContentDAO;
    protected ILearningDesignDAO learningDesignDAO;
    protected IRepositoryService repositoryService;

    public BaseWorkspaceTest(String string) {
        super(string);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.workspaceManagementService = (WorkspaceManagementService)this.context.getBean("workspaceManagementService");
        this.workspaceFolderDAO = (IWorkspaceFolderDAO)this.context.getBean("workspaceFolderDAO");
        this.workspaceFolderContentDAO = (IWorkspaceFolderContentDAO)this.context.getBean("workspaceFolderContentDAO");
        this.learningDesignDAO = (ILearningDesignDAO)this.context.getBean("learningDesignDAO");
        this.repositoryService = RepositoryProxy.getLocalRepositoryService();
        this.testFileString = this.getTestFileLocation();
    }

    protected String[] getContextConfigLocation() {
        return new String[]{"org/lamsfoundation/lams/contentrepository/applicationContext.xml", "org/lamsfoundation/lams/localApplicationContext.xml", "org/lamsfoundation/lams/authoring/authoringApplicationContext.xml", "org/lamsfoundation/lams/workspace/workspaceApplicationContext.xml"};
    }

    protected String getHibernateSessionFactoryName() {
        return "coreSessionFactory";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTestFileLocation() throws FileNotFoundException {
        Object object;
        if (this.testFileString == null) {
            object = System.getProperty("java.io.tmpdir");
            this.testFileString = (String)object + File.separator + "test.txt";
        }
        object = ((Object)((Object)this)).getClass();
        synchronized (object) {
            File file = new File(this.testFileString);
            if (!file.exists()) {
                FileWriter fileWriter = null;
                try {
                    fileWriter = new FileWriter(file);
                    fileWriter.write(testFileContents);
                }
                catch (IOException iOException) {
                    BaseWorkspaceTest.fail((String)("Unable to write out test file " + iOException.getMessage()));
                    iOException.printStackTrace();
                }
                finally {
                    try {
                        fileWriter.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return this.testFileString;
    }
}

