/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.workspace.service;

import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.lamsfoundation.lams.contentrepository.NodeKey;
import org.lamsfoundation.lams.usermanagement.WorkspaceFolder;
import org.lamsfoundation.lams.workspace.WorkspaceFolderContent;
import org.lamsfoundation.lams.workspace.service.BaseWorkspaceTest;
import org.lamsfoundation.lams.workspace.service.WorkspaceManagementService;
import org.springframework.orm.hibernate.HibernateObjectRetrievalFailureException;

public class TestWorkspaceManagement
extends BaseWorkspaceTest {
    private static final Integer MACQ_UNI_WORKSPACE_FOLDER = new Integer(2);
    private static final Integer MELCOE_WORKSPACE_FOLDER = new Integer(3);
    private static final Integer LAMS_WORKSPACE_FOLDER = new Integer(4);
    private static final Integer MANPREETS_WORKSPACE_FOLDER = new Integer(6);
    private static final Integer TO_DELETE_WORKSPACE_FOLDER = new Integer(7);
    private static final Long LONG_DELETE_WORKSPACE_FOLDER = new Long(7L);
    private static final Integer DOCUMENTS_WORKSPACE_FOLDER = new Integer(8);
    private static final Long LONG_DOCUMENTS_WORKSPACE_FOLDER = new Long(8L);
    private static final Integer PICTURES_WORKSPACE_FOLDER = new Integer(9);
    private static final Integer MANPREETS_WORKSPACE = new Integer(6);
    private static final Integer USER_ID = new Integer(4);
    private static final Long LD_ID = new Long(2L);

    public TestWorkspaceManagement(String string) {
        super(string);
    }

    public void testGetAccessibleWorkspaceFolders() throws IOException {
        String string = this.workspaceManagementService.getAccessibleWorkspaceFolders(USER_ID);
        System.out.println("User Accessible folders: " + string);
    }

    public void testGetFolderContents() throws Exception {
        String string = this.workspaceManagementService.getFolderContents(USER_ID, LAMS_WORKSPACE_FOLDER, WorkspaceManagementService.AUTHORING);
        System.out.println("FolderContents:" + string);
    }

    public void testCopyFolder() throws IOException {
        String string = this.workspaceManagementService.copyFolder(MACQ_UNI_WORKSPACE_FOLDER, DOCUMENTS_WORKSPACE_FOLDER, USER_ID);
        Map map = this.extractIdMapFromWDDXPacket(string);
        TestWorkspaceManagement.assertTrue((String)"Two ids returned as expected", (map != null && map.size() == 2 ? 1 : 0) != 0);
        Double d = (Double)map.get("workspaceFolderID");
        Double d2 = (Double)map.get("workspaceID");
        TestWorkspaceManagement.assertEquals((String)"workspace id in packet as expected", (long)d2.longValue(), (long)MANPREETS_WORKSPACE.longValue());
        WorkspaceFolder workspaceFolder = this.workspaceFolderDAO.getWorkspaceFolderByID(new Integer(d.intValue()));
        TestWorkspaceManagement.assertNotNull((Object)workspaceFolder);
        TestWorkspaceManagement.assertEquals((Object)workspaceFolder.getParentWorkspaceFolder().getWorkspaceFolderId(), (Object)DOCUMENTS_WORKSPACE_FOLDER);
        TestWorkspaceManagement.assertEquals((Object)workspaceFolder.getWorkspaceID(), (Object)MANPREETS_WORKSPACE);
    }

    public void testDeleteFolder() throws Exception {
        String string = "testDeleteFolder";
        String string2 = this.workspaceManagementService.createFolderForFlash(MANPREETS_WORKSPACE_FOLDER, string, USER_ID);
        Map map = this.extractIdMapFromWDDXPacket(string2);
        TestWorkspaceManagement.assertNotNull((Object)map);
        Double d = (Double)map.get("folderID");
        String string3 = (String)map.get("name");
        TestWorkspaceManagement.assertTrue((String)("Folder name starts with " + string + ". May have an added 'C'"), (boolean)string3.startsWith(string));
        Integer n = new Integer(d.intValue());
        String string4 = this.workspaceManagementService.deleteFolder(n, USER_ID);
        try {
            this.workspaceFolderDAO.getWorkspaceFolderByID(n);
            TestWorkspaceManagement.fail((String)"Exception should be raised because this object has already been deleted");
        }
        catch (HibernateObjectRetrievalFailureException hibernateObjectRetrievalFailureException) {
            TestWorkspaceManagement.assertTrue((boolean)true);
        }
    }

    public void testMoveFolder() throws Exception {
        WorkspaceFolder workspaceFolder = this.workspaceFolderDAO.getWorkspaceFolderByID(MANPREETS_WORKSPACE_FOLDER);
        TestWorkspaceManagement.assertNotNull((Object)workspaceFolder);
        int n = workspaceFolder.getParentWorkspaceFolder().getWorkspaceFolderId() + 1;
        if (n > PICTURES_WORKSPACE_FOLDER) {
            n = MACQ_UNI_WORKSPACE_FOLDER;
        }
        String string = this.workspaceManagementService.moveFolder(MANPREETS_WORKSPACE_FOLDER, new Integer(n), USER_ID);
        WorkspaceFolder workspaceFolder2 = this.workspaceFolderDAO.getWorkspaceFolderByID(MANPREETS_WORKSPACE_FOLDER);
        TestWorkspaceManagement.assertEquals((int)workspaceFolder2.getParentWorkspaceFolder().getWorkspaceFolderId(), (int)n);
    }

    public void testCreateWorkspaceFolderContent() throws Exception {
        String string = "testCreateWorkspaceFolderContent" + System.currentTimeMillis();
        String string2 = this.workspaceManagementService.createWorkspaceFolderContent(WorkspaceFolderContent.CONTENT_TYPE_FILE, string, "Manpreet's Description", new Date(), new Date(), MELCOE_WORKSPACE_FOLDER, "TXT", this.testFileString);
        System.out.println(string2);
        NodeKey nodeKey = this.extractNodeKeyFromWDDXPacket(string2);
        TestWorkspaceManagement.assertNotNull((String)"New content is uuid is populated", (Object)nodeKey.getUuid());
        TestWorkspaceManagement.assertTrue((String)"New content is version 1", (nodeKey.getVersion() != null && nodeKey.getVersion() == 1L ? 1 : 0) != 0);
    }

    public void testUpdateWorkspaceFolderContent() throws Exception {
        String string = "testUpdateWorkspaceFolderContent" + System.currentTimeMillis();
        String string2 = this.workspaceManagementService.createWorkspaceFolderContent(WorkspaceFolderContent.CONTENT_TYPE_FILE, string, "This content is to be updated.", new Date(), new Date(), DOCUMENTS_WORKSPACE_FOLDER, "TXT", this.testFileString);
        System.out.print(string2);
        NodeKey nodeKey = this.extractNodeKeyFromWDDXPacket(string2);
        Map map = this.extractIdMapFromWDDXPacket(string2);
        Double d = (Double)map.get("folderContentID");
        TestWorkspaceManagement.assertNotNull((String)"New content is uuid is populated", (Object)nodeKey.getUuid());
        TestWorkspaceManagement.assertTrue((String)"New content is version 1", (nodeKey.getVersion() != null && nodeKey.getVersion() == 1L ? 1 : 0) != 0);
        TestWorkspaceManagement.assertTrue((String)"New content is in document folder", (d != null && d.intValue() == DOCUMENTS_WORKSPACE_FOLDER.intValue() ? 1 : 0) != 0);
        WorkspaceFolderContent workspaceFolderContent = this.getMatchingContent(nodeKey, LONG_DOCUMENTS_WORKSPACE_FOLDER);
        TestWorkspaceManagement.assertNotNull((String)"Matching content found", (Object)workspaceFolderContent);
        Long l = workspaceFolderContent.getFolderContentID();
        this.workspaceManagementService.updateWorkspaceFolderContent(l, this.testFileString);
        this.workspaceManagementService.updateWorkspaceFolderContent(l, this.testFileString);
        this.workspaceManagementService.updateWorkspaceFolderContent(l, this.testFileString);
        string2 = this.workspaceManagementService.updateWorkspaceFolderContent(l, this.testFileString);
        System.out.print(string2);
        WorkspaceFolderContent workspaceFolderContent2 = this.workspaceFolderContentDAO.getWorkspaceFolderContentByID(l);
        nodeKey = this.extractNodeKeyFromWDDXPacket(string2);
        TestWorkspaceManagement.assertTrue((String)"ids returned", (nodeKey != null ? 1 : 0) != 0);
        TestWorkspaceManagement.assertEquals((String)"content is version 5", (long)nodeKey.getVersion(), (long)5L);
        TestWorkspaceManagement.assertEquals((String)"packet uuid matches content value", (Object)workspaceFolderContent2.getUuid(), (Object)nodeKey.getUuid());
        TestWorkspaceManagement.assertEquals((String)"packet version matches content value", (Object)workspaceFolderContent2.getVersionID(), (Object)nodeKey.getVersion());
        String string3 = this.workspaceManagementService.deleteContentWithVersion(nodeKey.getUuid(), nodeKey.getVersion(), l);
        nodeKey = this.extractNodeKeyFromWDDXPacket(string2);
        TestWorkspaceManagement.assertEquals((String)"packet has deleted version 5", (long)nodeKey.getVersion(), (long)5L);
        WorkspaceFolderContent workspaceFolderContent3 = this.workspaceFolderContentDAO.getWorkspaceFolderContentByID(l);
        TestWorkspaceManagement.assertEquals((long)workspaceFolderContent3.getVersionID(), (long)4L);
        TestWorkspaceManagement.assertEquals((String)"packet uuid matches content value", (Object)workspaceFolderContent3.getUuid(), (Object)nodeKey.getUuid());
        TestWorkspaceManagement.assertEquals((String)"content value has current max version", (long)workspaceFolderContent3.getVersionID(), (long)4L);
    }

    public void testDeleteWorkspaceFolderContent() throws Exception {
        String string = "testDeleteWorkspaceFolderContent" + System.currentTimeMillis();
        String string2 = this.workspaceManagementService.createWorkspaceFolderContent(WorkspaceFolderContent.CONTENT_TYPE_FILE, string, "This content is to be deleted.", new Date(), new Date(), DOCUMENTS_WORKSPACE_FOLDER, "TXT", this.testFileString);
        NodeKey nodeKey = this.extractNodeKeyFromWDDXPacket(string2);
        TestWorkspaceManagement.assertNotNull((String)"New content is uuid is populated", (Object)nodeKey.getUuid());
        TestWorkspaceManagement.assertTrue((String)"New content is version 1", (nodeKey.getVersion() != null && nodeKey.getVersion() == 1L ? 1 : 0) != 0);
        WorkspaceFolderContent workspaceFolderContent = this.getMatchingContent(nodeKey, LONG_DOCUMENTS_WORKSPACE_FOLDER);
        TestWorkspaceManagement.assertNotNull((String)"Matching content found", (Object)workspaceFolderContent);
        TestWorkspaceManagement.assertEquals((Object)workspaceFolderContent.getVersionID(), (Object)nodeKey.getVersion());
        System.out.print(string2);
        Long l = workspaceFolderContent.getFolderContentID();
        String string3 = this.workspaceManagementService.deleteWorkspaceFolderContent(l);
        try {
            this.workspaceFolderContentDAO.getWorkspaceFolderContentByID(l);
            TestWorkspaceManagement.fail((String)"Exception should be raised because this object has already been deleted");
        }
        catch (HibernateObjectRetrievalFailureException hibernateObjectRetrievalFailureException) {
            TestWorkspaceManagement.assertTrue((boolean)true);
        }
        TestWorkspaceManagement.assertNull((String)"Deleted content can't be found via getContentByWorkspaceFolder()", (Object)this.getMatchingContent(nodeKey, LONG_DOCUMENTS_WORKSPACE_FOLDER));
    }

    private WorkspaceFolderContent getMatchingContent(NodeKey nodeKey, Long l) {
        TestWorkspaceManagement.assertNotNull((Object)nodeKey);
        TestWorkspaceManagement.assertNotNull((Object)l);
        List list = this.workspaceFolderContentDAO.getContentByWorkspaceFolder(l);
        TestWorkspaceManagement.assertNotNull((Object)list);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            WorkspaceFolderContent workspaceFolderContent = (WorkspaceFolderContent)iterator.next();
            if (!workspaceFolderContent.getUuid().equals(nodeKey.getUuid())) continue;
            return workspaceFolderContent;
        }
        return null;
    }

    public NodeKey extractNodeKeyFromWDDXPacket(String string) {
        Map map = this.extractIdMapFromWDDXPacket(string);
        Double d = (Double)map.get("uuid");
        TestWorkspaceManagement.assertNotNull((Object)d);
        Double d2 = (Double)map.get("version");
        TestWorkspaceManagement.assertNotNull((Object)d2);
        return new NodeKey(new Long(d.longValue()), new Long(d2.longValue()));
    }
}

