/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.workspace.service;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.Vector;
import org.lamsfoundation.lams.authoring.service.IAuthoringService;
import org.lamsfoundation.lams.contentrepository.AccessDeniedException;
import org.lamsfoundation.lams.contentrepository.FileException;
import org.lamsfoundation.lams.contentrepository.ICredentials;
import org.lamsfoundation.lams.contentrepository.ITicket;
import org.lamsfoundation.lams.contentrepository.IVersionedNode;
import org.lamsfoundation.lams.contentrepository.InvalidParameterException;
import org.lamsfoundation.lams.contentrepository.ItemNotFoundException;
import org.lamsfoundation.lams.contentrepository.LoginException;
import org.lamsfoundation.lams.contentrepository.NodeKey;
import org.lamsfoundation.lams.contentrepository.WorkspaceNotFoundException;
import org.lamsfoundation.lams.contentrepository.service.IRepositoryService;
import org.lamsfoundation.lams.contentrepository.service.RepositoryProxy;
import org.lamsfoundation.lams.contentrepository.service.SimpleCredentials;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.dao.ILearningDesignDAO;
import org.lamsfoundation.lams.usermanagement.Role;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.UserOrganisation;
import org.lamsfoundation.lams.usermanagement.UserOrganisationRole;
import org.lamsfoundation.lams.usermanagement.Workspace;
import org.lamsfoundation.lams.usermanagement.WorkspaceFolder;
import org.lamsfoundation.lams.usermanagement.dao.IOrganisationDAO;
import org.lamsfoundation.lams.usermanagement.dao.IUserDAO;
import org.lamsfoundation.lams.usermanagement.dao.IUserOrganisationDAO;
import org.lamsfoundation.lams.usermanagement.dao.IWorkspaceDAO;
import org.lamsfoundation.lams.usermanagement.dao.IWorkspaceFolderDAO;
import org.lamsfoundation.lams.usermanagement.dto.UserAccessFoldersDTO;
import org.lamsfoundation.lams.usermanagement.exception.UserException;
import org.lamsfoundation.lams.usermanagement.exception.WorkspaceFolderException;
import org.lamsfoundation.lams.util.wddx.FlashMessage;
import org.lamsfoundation.lams.util.wddx.WDDXTAGS;
import org.lamsfoundation.lams.workspace.WorkspaceFolderContent;
import org.lamsfoundation.lams.workspace.dao.IWorkspaceFolderContentDAO;
import org.lamsfoundation.lams.workspace.dto.FolderContentDTO;
import org.lamsfoundation.lams.workspace.dto.UpdateContentDTO;
import org.lamsfoundation.lams.workspace.service.IWorkspaceManagementService;

public class WorkspaceManagementService
implements IWorkspaceManagementService {
    private FlashMessage flashMessage;
    public static final Integer AUTHORING = new Integer(1);
    public static final Integer MONITORING = new Integer(2);
    protected IUserDAO userDAO;
    protected ILearningDesignDAO learningDesignDAO;
    protected IWorkspaceFolderDAO workspaceFolderDAO;
    protected IWorkspaceDAO workspaceDAO;
    protected IOrganisationDAO organisationDAO;
    protected IUserOrganisationDAO userOrganisationDAO;
    protected IWorkspaceFolderContentDAO workspaceFolderContentDAO;
    protected IAuthoringService authoringService;
    protected IRepositoryService repositoryService;

    public void setWorkspaceFolderContentDAO(IWorkspaceFolderContentDAO workspaceFolderContentDAO) {
        this.workspaceFolderContentDAO = workspaceFolderContentDAO;
    }

    public void setAuthoringService(IAuthoringService authoringService) {
        this.authoringService = authoringService;
    }

    public void setOrganisationDAO(IOrganisationDAO organisationDAO) {
        this.organisationDAO = organisationDAO;
    }

    public void setWorkspaceDAO(IWorkspaceDAO workspaceDAO) {
        this.workspaceDAO = workspaceDAO;
    }

    public void setWorkspaceFolderDAO(IWorkspaceFolderDAO workspaceFolderDAO) {
        this.workspaceFolderDAO = workspaceFolderDAO;
    }

    public void setLearningDesignDAO(ILearningDesignDAO learningDesignDAO) {
        this.learningDesignDAO = learningDesignDAO;
    }

    public void setUserDAO(IUserDAO userDAO) {
        this.userDAO = userDAO;
    }

    public void setUserOrganisationDAO(IUserOrganisationDAO userOrganisationDAO) {
        this.userOrganisationDAO = userOrganisationDAO;
    }

    public String deleteFolder(Integer folderID, Integer userID) throws IOException {
        WorkspaceFolder workspaceFolder = this.workspaceFolderDAO.getWorkspaceFolderByID(folderID);
        User user = this.userDAO.getUserById(userID);
        if (user != null) {
            if (!this.getPermissions(workspaceFolder, user).equals(WorkspaceFolder.OWNER_ACCESS)) {
                this.flashMessage = FlashMessage.getUserNotAuthorized((String)"deleteFolder", (Integer)userID);
            } else if (workspaceFolder != null) {
                if (this.isRootFolder(workspaceFolder)) {
                    this.flashMessage = new FlashMessage("deleteFolder", (Object)"Cannot delete this folder as it is the Root folder.", 1);
                } else if (!workspaceFolder.isEmpty()) {
                    this.flashMessage = new FlashMessage("deleteFolder", (Object)("Cannot delete folder with folder_id of: " + folderID + " as it is not empty. Please delete its contents first."), 1);
                } else {
                    this.workspaceFolderDAO.delete((Object)workspaceFolder);
                    this.flashMessage = new FlashMessage("deleteFolder", (Object)("Folder deleted:" + folderID));
                }
            } else {
                this.flashMessage = FlashMessage.getNoSuchWorkspaceFolderExsists((String)"deleteFolder", (Integer)folderID);
            }
        } else {
            this.flashMessage = FlashMessage.getNoSuchUserExists((String)"deleteFolder", (Integer)userID);
        }
        return this.flashMessage.serializeMessage();
    }

    private boolean isRootFolder(WorkspaceFolder workspaceFolder) {
        try {
            Workspace workspace = this.workspaceDAO.getWorkspaceByRootFolderID(workspaceFolder.getWorkspaceFolderId());
            return workspace != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getFolderContents(Integer userID, Integer workspaceFolderID, Integer mode) throws Exception {
        User user = this.userDAO.getUserById(userID);
        WorkspaceFolder workspaceFolder = null;
        Integer permissions = null;
        if (user != null) {
            workspaceFolder = this.workspaceFolderDAO.getWorkspaceFolderByID(workspaceFolderID);
            if (workspaceFolder != null) {
                permissions = this.getPermissions(workspaceFolder, user);
                if (permissions != WorkspaceFolder.NO_ACCESS) {
                    Vector repositoryContent;
                    Vector contentDTO = new Vector();
                    this.getFolderContent(workspaceFolder, permissions, mode, contentDTO);
                    if (workspaceFolder.hasSubFolders()) {
                        this.getSubFolderDetails(workspaceFolder, permissions, contentDTO);
                    }
                    if ((repositoryContent = this.getContentsFromRepository(new Long(workspaceFolderID.intValue()), permissions)) != null) {
                        contentDTO.addAll(repositoryContent);
                    }
                    this.flashMessage = new FlashMessage("getFolderContents", (Object)this.createFolderContentPacket(workspaceFolder, contentDTO));
                } else {
                    this.flashMessage = new FlashMessage("getFolderContents", (Object)("Access Denied for user with user_id:" + userID), 1);
                }
            } else {
                this.flashMessage = new FlashMessage("getFolderContents", (Object)("No such workspaceFolder with workspace_folder_id of:" + workspaceFolderID + " exists"), 1);
            }
        } else {
            this.flashMessage = FlashMessage.getNoSuchUserExists((String)"getFolderContents", (Integer)userID);
        }
        return this.flashMessage.serializeMessage();
    }

    private void getFolderContent(WorkspaceFolder workspaceFolder, Integer permissions, Integer mode, Vector contentDTO) {
        Integer parentFolderId = workspaceFolder.getParentWorkspaceFolder() != null ? workspaceFolder.getParentWorkspaceFolder().getWorkspaceFolderId() : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
        List designs = null;
        designs = mode == AUTHORING ? this.learningDesignDAO.getAllLearningDesignsInFolder(workspaceFolder.getWorkspaceFolderId()) : this.learningDesignDAO.getAllValidLearningDesignsInFolder(workspaceFolder.getWorkspaceFolderId());
        this.getFolderContentDTO(designs, permissions, contentDTO);
    }

    private void getSubFolderDetails(WorkspaceFolder workspaceFolder, Integer permissions, Vector subFolderContent) {
        Iterator iterator = workspaceFolder.getChildWorkspaceFolders().iterator();
        while (iterator.hasNext()) {
            WorkspaceFolder subFolder = (WorkspaceFolder)iterator.next();
            subFolderContent.add(new FolderContentDTO(subFolder, permissions));
        }
    }

    public Integer getPermissions(WorkspaceFolder workspaceFolder, User user) {
        Integer permission = null;
        WorkspaceFolder userRootFolder = user.getWorkspace().getRootFolder();
        permission = this.isUserOwner(workspaceFolder, user) ? WorkspaceFolder.OWNER_ACCESS : (this.isSubFolder(workspaceFolder, userRootFolder) ? (this.isRunSequencesFolder(workspaceFolder, user) ? WorkspaceFolder.READ_ACCESS : WorkspaceFolder.OWNER_ACCESS) : (this.isParentOrganisationFolder(workspaceFolder, user) ? WorkspaceFolder.MEMBERSHIP_ACCESS : (user.hasMemberAccess(workspaceFolder) ? WorkspaceFolder.MEMBERSHIP_ACCESS : WorkspaceFolder.NO_ACCESS)));
        return permission;
    }

    private boolean isSubFolder(WorkspaceFolder workspaceFolder, WorkspaceFolder rootFolder) {
        List subFolders = this.workspaceFolderDAO.getWorkspaceFolderByParentFolder(rootFolder.getWorkspaceFolderId());
        Iterator iterator = subFolders.iterator();
        while (iterator.hasNext()) {
            WorkspaceFolder subFolder = (WorkspaceFolder)iterator.next();
            if (subFolder.getWorkspaceFolderId() != workspaceFolder.getWorkspaceFolderId()) continue;
            return true;
        }
        return false;
    }

    public boolean isRunSequencesFolder(WorkspaceFolder workspaceFolder, User user) {
        WorkspaceFolder runSequencesFolder = this.workspaceFolderDAO.getRunSequencesFolderForUser(user.getUserId());
        return workspaceFolder.getWorkspaceFolderId() == runSequencesFolder.getWorkspaceFolderId();
    }

    public boolean isParentOrganisationFolder(WorkspaceFolder workspaceFolder, User user) {
        WorkspaceFolder parentOrganisationFolder = user.getBaseOrganisation().getWorkspace().getRootFolder();
        return parentOrganisationFolder.getWorkspaceFolderId() == workspaceFolder.getWorkspaceFolderId();
    }

    private Vector getFolderContentDTO(List designs, Integer permissions, Vector folderContent) {
        Iterator iterator = designs.iterator();
        while (iterator.hasNext()) {
            LearningDesign design = (LearningDesign)iterator.next();
            folderContent.add(new FolderContentDTO(design, permissions));
        }
        return folderContent;
    }

    private Hashtable createFolderContentPacket(WorkspaceFolder workspaceFolder, Vector contents) {
        Hashtable<String, Serializable> packet = new Hashtable<String, Serializable>();
        packet.put("parentWorkspaceFolderID", workspaceFolder.getParentWorkspaceFolder().getWorkspaceFolderId());
        packet.put("workspaceFolderID", workspaceFolder.getWorkspaceFolderId());
        packet.put("contents", contents);
        return packet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String copyFolder(Integer folderID, Integer newFolderID, Integer userID) throws IOException {
        try {
            if (this.isUserAuthorized(newFolderID, userID)) {
                WorkspaceFolder workspaceFolder = this.workspaceFolderDAO.getWorkspaceFolderByID(folderID);
                if (workspaceFolder == null) throw new WorkspaceFolderException();
                WorkspaceFolder newFolder = this.createFolder(newFolderID, workspaceFolder.getName(), userID);
                this.copyRootContent(workspaceFolder, newFolder, userID);
                if (workspaceFolder.hasSubFolders()) {
                    this.createSubFolders(workspaceFolder, newFolder, userID);
                }
                this.flashMessage = new FlashMessage("copyFolder", (Object)this.createCopyFolderPacket(newFolder));
                return this.flashMessage.serializeMessage();
            } else {
                this.flashMessage = FlashMessage.getUserNotAuthorized((String)"copyFolder", (Integer)userID);
            }
            return this.flashMessage.serializeMessage();
        }
        catch (UserException ue) {
            this.flashMessage = FlashMessage.getNoSuchUserExists((String)"copyFolder", (Integer)userID);
            return this.flashMessage.serializeMessage();
        }
        catch (WorkspaceFolderException we) {
            this.flashMessage = FlashMessage.getNoSuchWorkspaceFolderExsists((String)"copyFolder", (Integer)folderID);
        }
        return this.flashMessage.serializeMessage();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isUserAuthorized(Integer folderID, Integer userID) throws UserException, WorkspaceFolderException {
        boolean authorized = false;
        User user = this.userDAO.getUserById(userID);
        if (user == null) throw new UserException();
        WorkspaceFolder targetParent = this.workspaceFolderDAO.getWorkspaceFolderByID(folderID);
        if (targetParent == null) throw new WorkspaceFolderException();
        Integer permissions = this.getPermissions(targetParent, user);
        if (permissions.equals(WorkspaceFolder.NO_ACCESS)) return authorized;
        if (permissions.equals(WorkspaceFolder.READ_ACCESS)) return authorized;
        return true;
    }

    private Hashtable createCopyFolderPacket(WorkspaceFolder workspaceFolder) {
        Hashtable<String, Integer> packet = new Hashtable<String, Integer>();
        packet.put("workspaceFolderID", workspaceFolder.getWorkspaceFolderId());
        packet.put("workspaceID", workspaceFolder.getWorkspaceID());
        return packet;
    }

    public boolean isUserOwner(WorkspaceFolder workspaceFolder, User user) {
        List folders = this.workspaceFolderDAO.getWorkspaceFolderByUser(user.getUserId());
        if (folders != null && folders.size() != 0) {
            Iterator iterator = folders.iterator();
            while (iterator.hasNext()) {
                WorkspaceFolder folder = (WorkspaceFolder)iterator.next();
                if (folder.getWorkspaceFolderId() != workspaceFolder.getWorkspaceFolderId()) continue;
                return true;
            }
        }
        return false;
    }

    public void copyRootContent(WorkspaceFolder workspaceFolder, WorkspaceFolder targetWorkspaceFolder, Integer userID) throws UserException {
        User user = this.userDAO.getUserById(userID);
        if (user == null) {
            throw new UserException("No such user with a userID of " + userID + "exists");
        }
        List designs = this.learningDesignDAO.getAllLearningDesignsInFolder(workspaceFolder.getWorkspaceFolderId());
        if (designs != null && designs.size() != 0) {
            Iterator iterator = designs.iterator();
            while (iterator.hasNext()) {
                LearningDesign design = (LearningDesign)iterator.next();
                this.authoringService.copyLearningDesign(design, new Integer(1), user, targetWorkspaceFolder);
            }
        }
    }

    public WorkspaceFolder createFolder(Integer parentFolderID, String name, Integer userID) throws UserException, WorkspaceFolderException {
        WorkspaceFolder parentFolder = this.workspaceFolderDAO.getWorkspaceFolderByID(parentFolderID);
        User user = null;
        Workspace workspace = null;
        if (parentFolder != null) {
            boolean nameExists = true;
            while (nameExists && (nameExists = this.ifNameExists(parentFolder, name))) {
                name = name + "C";
            }
            user = this.userDAO.getUserById(userID);
            if (user != null) {
                workspace = user.getWorkspace();
                WorkspaceFolder workspaceFolder = new WorkspaceFolder(name, workspace.getWorkspaceId(), parentFolder, userID, new Date(), new Date(), WorkspaceFolder.NORMAL);
                this.workspaceFolderDAO.insert((Object)workspaceFolder);
                return workspaceFolder;
            }
            throw new UserException("No such user with userID of " + userID + "exists");
        }
        throw new WorkspaceFolderException("No such workspaceFolder with a workspace_folder_id of " + parentFolderID + " exists");
    }

    public String createFolderForFlash(Integer parentFolderID, String name, Integer userID) throws IOException {
        try {
            WorkspaceFolder newFolder = this.createFolder(parentFolderID, name, userID);
            Hashtable<String, Object> table = new Hashtable<String, Object>();
            table.put("folderID", newFolder.getWorkspaceFolderId());
            table.put("name", newFolder.getName());
            this.flashMessage = new FlashMessage("createFolderForFlash", table);
        }
        catch (WorkspaceFolderException we) {
            this.flashMessage = FlashMessage.getNoSuchWorkspaceFolderExsists((String)"createFolderForFlash", (Integer)parentFolderID);
        }
        catch (UserException ue) {
            this.flashMessage = FlashMessage.getNoSuchUserExists((String)"createFolderForFlash", (Integer)userID);
        }
        return this.flashMessage.serializeMessage();
    }

    private boolean ifNameExists(WorkspaceFolder targetFolder, String folderName) {
        List folders = this.workspaceFolderDAO.getWorkspaceFolderByParentFolder(targetFolder.getWorkspaceFolderId());
        if (folders != null && folders.size() != 0) {
            Iterator iterator = folders.iterator();
            while (iterator.hasNext()) {
                WorkspaceFolder folder = (WorkspaceFolder)iterator.next();
                if (!folder.getName().equalsIgnoreCase(folderName)) continue;
                return true;
            }
        }
        return false;
    }

    public void createSubFolders(WorkspaceFolder workspaceFolder, WorkspaceFolder newFolder, Integer userID) throws UserException, WorkspaceFolderException {
        Iterator subFoldersIterator = workspaceFolder.getChildWorkspaceFolders().iterator();
        while (subFoldersIterator.hasNext()) {
            WorkspaceFolder subFolder = (WorkspaceFolder)subFoldersIterator.next();
            WorkspaceFolder newSubFolder = this.createFolder(newFolder.getWorkspaceFolderId(), subFolder.getName(), userID);
            this.copyRootContent(subFolder, newSubFolder, userID);
            if (!subFolder.hasSubFolders()) continue;
            this.createSubFolders(subFolder, newSubFolder, userID);
        }
    }

    public String deleteLearningDesign(Long learningDesignID, Integer userID) throws IOException {
        User user = this.userDAO.getUserById(userID);
        if (user != null) {
            LearningDesign learningDesign = this.learningDesignDAO.getLearningDesignById(learningDesignID);
            if (learningDesign != null) {
                if (learningDesign.getUser().getUserId().equals(user.getUserId())) {
                    if (learningDesign.getReadOnly().booleanValue()) {
                        this.flashMessage = new FlashMessage("deleteLearningDesign", (Object)("Cannot delete design with learning_design_id of:" + learningDesignID + " as it is READ ONLY."), 1);
                    } else {
                        List list = this.learningDesignDAO.getLearningDesignsByParent(learningDesignID);
                        if (list == null || list.size() == 0) {
                            this.learningDesignDAO.delete((Object)learningDesign);
                            this.flashMessage = new FlashMessage("deleteLearningDesign", (Object)("Learning Design deleted: " + learningDesignID));
                        } else {
                            this.flashMessage = new FlashMessage("deleteLearningDesign", (Object)("Cannot delete design with learning_design_id of:" + learningDesignID + " as it is a PARENT."), 1);
                        }
                    }
                } else {
                    this.flashMessage = FlashMessage.getUserNotAuthorized((String)"deleteLearningDesign", (Integer)userID);
                }
            } else {
                this.flashMessage = FlashMessage.getNoSuchLearningDesignExists((String)"deleteLearningDesign", (Long)learningDesignID);
            }
        } else {
            this.flashMessage = FlashMessage.getNoSuchUserExists((String)"deleteLearningDesign", (Integer)userID);
        }
        return this.flashMessage.serializeMessage();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String moveFolder(Integer currentFolderID, Integer targetFolderID, Integer userID) throws IOException {
        try {
            if (this.isUserAuthorized(targetFolderID, userID)) {
                WorkspaceFolder currentFolder = this.workspaceFolderDAO.getWorkspaceFolderByID(currentFolderID);
                if (currentFolder == null) throw new WorkspaceFolderException();
                WorkspaceFolder targetFolder = this.workspaceFolderDAO.getWorkspaceFolderByID(targetFolderID);
                currentFolder.setParentWorkspaceFolder(targetFolder);
                this.workspaceFolderDAO.update((Object)currentFolder);
                this.flashMessage = new FlashMessage("moveFolder", (Object)currentFolderID);
                return this.flashMessage.serializeMessage();
            } else {
                this.flashMessage = FlashMessage.getUserNotAuthorized((String)"moveFolder", (Integer)userID);
            }
            return this.flashMessage.serializeMessage();
        }
        catch (UserException ue) {
            this.flashMessage = FlashMessage.getNoSuchUserExists((String)"moveFolder", (Integer)userID);
            return this.flashMessage.serializeMessage();
        }
        catch (WorkspaceFolderException we) {
            this.flashMessage = FlashMessage.getNoSuchWorkspaceFolderExsists((String)"moveFolder", (Integer)targetFolderID);
        }
        return this.flashMessage.serializeMessage();
    }

    private ITicket getRepositoryLoginTicket() {
        this.repositoryService = RepositoryProxy.getLocalRepositoryService();
        SimpleCredentials credentials = new SimpleCredentials("workspaceManager", "flashClient".toCharArray());
        try {
            ITicket ticket = this.repositoryService.login((ICredentials)credentials, "FlashClientsWorkspace");
            return ticket;
        }
        catch (AccessDeniedException ae) {
            ae.printStackTrace();
            return null;
        }
        catch (WorkspaceNotFoundException we) {
            we.printStackTrace();
            return null;
        }
        catch (LoginException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String createWorkspaceFolderContent(Integer contentTypeID, String name, String description, Date createDateTime, Date lastModifiedDate, Integer workspaceFolderID, String mimeType, String path) throws Exception {
        WorkspaceFolder workspaceFolder = this.workspaceFolderDAO.getWorkspaceFolderByID(workspaceFolderID);
        if (workspaceFolder != null) {
            WorkspaceFolderContent workspaceFolderContent = new WorkspaceFolderContent(contentTypeID, name, description, createDateTime, lastModifiedDate, mimeType, workspaceFolder);
            this.workspaceFolderContentDAO.insert((Object)workspaceFolderContent);
            try {
                FileInputStream stream = new FileInputStream(path);
                NodeKey nodeKey = this.addFileToRepository(stream, name, mimeType);
                workspaceFolderContent.setUuid(nodeKey.getUuid());
                workspaceFolderContent.setVersionID(nodeKey.getVersion());
                this.workspaceFolderContentDAO.update((Object)workspaceFolderContent);
                UpdateContentDTO contentDTO = new UpdateContentDTO(nodeKey.getUuid(), nodeKey.getVersion(), new Long(workspaceFolder.getWorkspaceFolderId().longValue()));
                this.flashMessage = new FlashMessage("createWorkspaceFolderContent", (Object)contentDTO);
            }
            catch (AccessDeniedException ae) {
                this.flashMessage = new FlashMessage("createWorkspaceFolderContent", (Object)("Exception occured while creating workspaceFolderContent: " + ae.getMessage()), 2);
            }
            catch (FileException fe) {
                this.flashMessage = new FlashMessage("createWorkspaceFolderContent", (Object)("Exception occured while creating workspaceFolderContent: " + fe.getMessage()), 2);
            }
            catch (InvalidParameterException ip) {
                this.flashMessage = new FlashMessage("createWorkspaceFolderContent", (Object)("Exception occured while creating workspaceFolderContent: " + ip.getMessage()), 2);
            }
        } else {
            this.flashMessage = FlashMessage.getNoSuchWorkspaceFolderExsists((String)"createWorkspaceFolderContent", (Integer)workspaceFolderID);
        }
        return this.flashMessage.serializeMessage();
    }

    public String updateWorkspaceFolderContent(Long folderContentID, String path) throws Exception {
        FileInputStream stream = new FileInputStream(path);
        WorkspaceFolderContent workspaceFolderContent = this.workspaceFolderContentDAO.getWorkspaceFolderContentByID(folderContentID);
        if (workspaceFolderContent != null) {
            NodeKey nodeKey = this.updateFileInRepository(workspaceFolderContent, stream);
            UpdateContentDTO contentDTO = new UpdateContentDTO(nodeKey.getUuid(), nodeKey.getVersion(), folderContentID);
            this.flashMessage = new FlashMessage("updateWorkspaceFolderContent", (Object)contentDTO);
        } else {
            this.flashMessage = FlashMessage.getNoSuchWorkspaceFolderContentExsists((String)"updateWorkspaceFolderContent", (Long)folderContentID);
        }
        return this.flashMessage.serializeMessage();
    }

    private NodeKey addFileToRepository(InputStream stream, String fileName, String mimeType) throws AccessDeniedException, FileException, InvalidParameterException {
        ITicket ticket = this.getRepositoryLoginTicket();
        NodeKey nodeKey = this.repositoryService.addFileItem(ticket, stream, fileName, mimeType, null);
        return nodeKey;
    }

    private NodeKey updateFileInRepository(WorkspaceFolderContent workspaceFolderContent, InputStream stream) throws Exception {
        ITicket ticket = this.getRepositoryLoginTicket();
        NodeKey nodeKey = this.repositoryService.updateFileItem(ticket, workspaceFolderContent.getUuid(), workspaceFolderContent.getName(), stream, workspaceFolderContent.getMimeType(), null);
        workspaceFolderContent.setUuid(nodeKey.getUuid());
        workspaceFolderContent.setVersionID(nodeKey.getVersion());
        this.workspaceFolderContentDAO.update((Object)workspaceFolderContent);
        return nodeKey;
    }

    public String deleteContentWithVersion(Long uuid, Long versionToBeDeleted, Long folderContentID) throws Exception {
        WorkspaceFolderContent workspaceFolderContent = this.workspaceFolderContentDAO.getWorkspaceFolderContentByID(folderContentID);
        Long databaseVersion = workspaceFolderContent.getVersionID();
        ITicket ticket = this.getRepositoryLoginTicket();
        String[] files = null;
        try {
            files = this.repositoryService.deleteVersion(ticket, uuid, versionToBeDeleted);
        }
        catch (ItemNotFoundException ie) {
            this.flashMessage = new FlashMessage("deleteContentWithVersion", (Object)("No such content with versionID of " + versionToBeDeleted + " found in repository"), 1);
            return this.flashMessage.serializeMessage();
        }
        try {
            IVersionedNode latestAvailableNode = this.repositoryService.getFileItem(ticket, uuid, null);
            Long latestAvailableVersion = latestAvailableNode.getVersion();
            if (databaseVersion.equals(versionToBeDeleted)) {
                workspaceFolderContent.setVersionID(latestAvailableVersion);
                this.workspaceFolderContentDAO.update((Object)workspaceFolderContent);
            }
            this.flashMessage = new FlashMessage("deleteContentWithVersion", (Object)"Content Successfully deleted");
        }
        catch (ItemNotFoundException ie) {
            this.workspaceFolderContentDAO.delete((Object)workspaceFolderContent);
            this.flashMessage = new FlashMessage("deleteContentWithVersion", (Object)"Content Successfully deleted");
        }
        return this.flashMessage.serializeMessage();
    }

    public String deleteWorkspaceFolderContent(Long folderContentID) throws Exception {
        WorkspaceFolderContent workspaceFolderContent = this.workspaceFolderContentDAO.getWorkspaceFolderContentByID(folderContentID);
        if (workspaceFolderContent != null) {
            Long uuid = workspaceFolderContent.getUuid();
            Long versionID = workspaceFolderContent.getVersionID();
            ITicket ticket = this.getRepositoryLoginTicket();
            String[] files = this.repositoryService.deleteNode(ticket, uuid);
            this.workspaceFolderContentDAO.delete((Object)workspaceFolderContent);
            this.flashMessage = new FlashMessage("deleteWorkspaceFolderContent", (Object)"Content deleted");
        } else {
            this.flashMessage = FlashMessage.getNoSuchWorkspaceFolderContentExsists((String)"deleteWorkspaceFolderContent", (Long)folderContentID);
        }
        return this.flashMessage.serializeMessage();
    }

    private Vector getContentsFromRepository(Long workspaceFolderID, Integer permissions) throws Exception {
        List content = this.workspaceFolderContentDAO.getContentByWorkspaceFolder(workspaceFolderID);
        if (content.size() == 0) {
            return null;
        }
        ITicket ticket = this.getRepositoryLoginTicket();
        Vector<FolderContentDTO> repositoryContent = new Vector<FolderContentDTO>();
        Iterator contentIterator = content.iterator();
        while (contentIterator.hasNext()) {
            WorkspaceFolderContent workspaceFolderContent = (WorkspaceFolderContent)contentIterator.next();
            SortedSet set = this.repositoryService.getVersionHistory(ticket, workspaceFolderContent.getUuid());
            repositoryContent.add(new FolderContentDTO(permissions, workspaceFolderContent, set));
        }
        return repositoryContent;
    }

    public String getAccessibleWorkspaceFolders(Integer userID) throws IOException {
        User user = this.userDAO.getUserById(userID);
        Hashtable<String, Object> table = new Hashtable<String, Object>();
        Vector<UserAccessFoldersDTO> workspaces = new Vector<UserAccessFoldersDTO>();
        if (user != null) {
            table.put("PRIVATE", new UserAccessFoldersDTO(user.getWorkspace().getRootFolder()));
            table.put("RUN_SEQUENCES", new UserAccessFoldersDTO(this.workspaceFolderDAO.getRunSequencesFolderForUser(user.getUserId())));
            List userMemberships = this.userOrganisationDAO.getUserOrganisationsByUser(user);
            if (userMemberships != null) {
                Iterator memberships = userMemberships.iterator();
                while (memberships.hasNext()) {
                    UserOrganisation member = (UserOrganisation)memberships.next();
                    Set roles = member.getUserOrganisationRoles();
                    if (!this.hasWriteAccess(roles)) continue;
                    workspaces.add(new UserAccessFoldersDTO(member.getOrganisation().getWorkspace().getRootFolder()));
                }
                table.put("ORGANISATIONS", workspaces);
                this.flashMessage = new FlashMessage("getAccessibleWorkspaceFolders", table);
            } else {
                this.flashMessage = new FlashMessage("getAccessibleWorkspaceFolders", (Object)("User with user_id of: " + userID + " is not a member of any organisation"), 1);
            }
        } else {
            this.flashMessage = FlashMessage.getNoSuchUserExists((String)"getAccessibleWorkspaceFolders", (Integer)userID);
        }
        return this.flashMessage.serializeMessage();
    }

    private boolean hasWriteAccess(Set roles) {
        boolean access = false;
        Iterator roleIterator = roles.iterator();
        while (roleIterator.hasNext()) {
            UserOrganisationRole userOrganisationRole = (UserOrganisationRole)roleIterator.next();
            Role role = userOrganisationRole.getRole();
            if (!role.isAuthor() && !role.isStaff() && !role.isTeacher()) continue;
            access = true;
        }
        return access;
    }

    public String moveLearningDesign(Long learningDesignID, Integer targetWorkspaceFolderID, Integer userID) throws IOException {
        try {
            if (this.isUserAuthorized(targetWorkspaceFolderID, userID)) {
                LearningDesign learningDesign = this.learningDesignDAO.getLearningDesignById(learningDesignID);
                if (learningDesign != null) {
                    WorkspaceFolder workspaceFolder = this.workspaceFolderDAO.getWorkspaceFolderByID(targetWorkspaceFolderID);
                    if (workspaceFolder != null) {
                        learningDesign.setWorkspaceFolder(workspaceFolder);
                        this.learningDesignDAO.update((Object)learningDesign);
                        this.flashMessage = new FlashMessage("moveLearningDesign", (Object)targetWorkspaceFolderID);
                    } else {
                        this.flashMessage = FlashMessage.getNoSuchWorkspaceFolderExsists((String)"moveLearningDesign", (Integer)targetWorkspaceFolderID);
                    }
                } else {
                    this.flashMessage = FlashMessage.getNoSuchLearningDesignExists((String)"moveLearningDesign", (Long)learningDesignID);
                }
            } else {
                this.flashMessage = FlashMessage.getUserNotAuthorized((String)"moveLearningDesign", (Integer)userID);
            }
        }
        catch (UserException ue) {
            this.flashMessage = FlashMessage.getNoSuchUserExists((String)"moveLearningDesign", (Integer)userID);
        }
        catch (WorkspaceFolderException we) {
            this.flashMessage = FlashMessage.getNoSuchWorkspaceFolderExsists((String)"moveLearningDesign", (Integer)targetWorkspaceFolderID);
        }
        return this.flashMessage.serializeMessage();
    }

    public String renameWorkspaceFolder(Integer workspaceFolderID, String newName, Integer userID) throws IOException {
        try {
            WorkspaceFolder folder = this.workspaceFolderDAO.getWorkspaceFolderByID(workspaceFolderID);
            if (folder != null) {
                WorkspaceFolder parent = folder.getParentWorkspaceFolder();
                if (parent != null) {
                    if (this.isUserAuthorized(workspaceFolderID, userID)) {
                        if (!this.ifNameExists(parent, newName)) {
                            folder.setName(newName);
                            this.workspaceFolderDAO.update((Object)folder);
                            this.flashMessage = new FlashMessage("renameWorkspaceFolder", (Object)newName);
                        } else {
                            this.flashMessage = new FlashMessage("renameWorkspaceFolder", (Object)("A folder with given name '" + newName + "' already exists."), 1);
                        }
                    } else {
                        this.flashMessage = FlashMessage.getUserNotAuthorized((String)"renameWorkspaceFolder", (Integer)userID);
                    }
                } else {
                    this.flashMessage = new FlashMessage("renameWorkspaceFolder", (Object)"Cannot rename the ROOT folder", 1);
                }
            } else {
                this.flashMessage = FlashMessage.getNoSuchWorkspaceFolderExsists((String)"renameWorkspaceFolder", (Integer)workspaceFolderID);
            }
        }
        catch (UserException ue) {
            this.flashMessage = FlashMessage.getNoSuchUserExists((String)"renameWorkspaceFolder", (Integer)userID);
        }
        catch (WorkspaceFolderException we) {
            this.flashMessage = FlashMessage.getNoSuchWorkspaceFolderExsists((String)"renameWorkspaceFolder", (Integer)workspaceFolderID);
        }
        return this.flashMessage.serializeMessage();
    }

    public String renameLearningDesign(Long learningDesignID, String title, Integer userID) throws IOException {
        LearningDesign design = this.learningDesignDAO.getLearningDesignById(learningDesignID);
        Integer folderID = null;
        try {
            if (design != null) {
                folderID = design.getWorkspaceFolder().getWorkspaceFolderId();
                if (this.isUserAuthorized(folderID, userID)) {
                    design.setTitle(title);
                    this.learningDesignDAO.update((Object)design);
                    this.flashMessage = new FlashMessage("renameLearningDesign", (Object)title);
                } else {
                    this.flashMessage = FlashMessage.getUserNotAuthorized((String)"renameLearningDesign", (Integer)userID);
                }
            } else {
                this.flashMessage = FlashMessage.getNoSuchLearningDesignExists((String)"renameLearningDesign", (Long)learningDesignID);
            }
        }
        catch (UserException ue) {
            this.flashMessage = FlashMessage.getNoSuchUserExists((String)"renameWorkspaceFolder", (Integer)userID);
        }
        catch (WorkspaceFolderException we) {
            this.flashMessage = FlashMessage.getNoSuchWorkspaceFolderExsists((String)"renameWorkspaceFolder", (Integer)folderID);
        }
        return this.flashMessage.serializeMessage();
    }

    public String getWorkspace(Integer userID) throws IOException {
        User user = this.userDAO.getUserById(userID);
        if (user != null) {
            Workspace workspace = user.getWorkspace();
            this.flashMessage = new FlashMessage("getWorkspace", (Object)workspace.getWorkspaceDTO());
        } else {
            this.flashMessage = FlashMessage.getNoSuchUserExists((String)"getWorkspace", (Integer)userID);
        }
        return this.flashMessage.serializeMessage();
    }
}

