/*
 * Decompiled with CFR 0.152.
 */
package com.allaire.wddx;

import com.allaire.wddx.WddxDeserializationException;
import com.allaire.wddx.WddxElement;
import org.xml.sax.AttributeList;

class StringHandler
extends WddxElement {
    private static final String CHAR_ELEMENT_NAME = "char";
    private static final String CODE_ATTRIBUTE_NAME = "code";
    private StringBuffer m_buffer = new StringBuffer();

    StringHandler() {
    }

    public void onEndElement() throws WddxDeserializationException {
        this.setValue(this.m_buffer.toString());
    }

    public void onCharacters(char[] ch, int start, int length) throws WddxDeserializationException {
        this.m_buffer.append(ch, start, length);
    }

    public void onBeforeChild(String name, AttributeList attributes) throws WddxDeserializationException {
        String code;
        if (!name.equals(CHAR_ELEMENT_NAME)) {
            this.throwException("Invalid element " + name + " inside a string element");
        }
        if ((code = attributes.getValue(CODE_ATTRIBUTE_NAME)) == null) {
            this.throwException("code attribute is not present for element char");
        }
        try {
            this.m_buffer.append((char)Integer.parseInt(code, 16));
        }
        catch (NumberFormatException e) {
            this.throwException("Bad character code in char element code= attribute.", e);
        }
    }
}

