/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.dao.hibernate;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.lamsfoundation.lams.dao.IBaseDAO;
import org.springframework.stereotype.Repository;

@Repository
public class LAMSBaseDAO
implements IBaseDAO {
    private static final String SELECT = "from ";
    private static final String DELETE = "delete ";
    private static final String WHERE = " where ";
    private static final String AND = " and ";
    private static final String SPACE = " ";
    private static final String SPOT = ".";
    private static final String EQUAL_TO_WHAT = "=?";
    private static final String LIKE_WHAT = " like ?";
    private static Logger log = Logger.getLogger(LAMSBaseDAO.class);
    private SessionFactory sessionFactory;

    @Override
    public void insert(Object object) {
        this.getSession().save(object);
    }

    @Override
    public void update(Object object) {
        this.getSession().update(object);
    }

    @Override
    public void insertOrUpdate(Object object) {
        this.getSession().saveOrUpdate(object);
    }

    @Override
    public void insertOrUpdateAll(Collection objects) {
        if (objects != null) {
            for (Object object : objects) {
                this.getSession().saveOrUpdate(object);
            }
        }
    }

    @Override
    public void update(String queryString) {
        this.doBulkUpdate(queryString, new Object[0]);
    }

    @Override
    public void update(String queryString, Object value) {
        this.doBulkUpdate(queryString, value);
    }

    @Override
    public void update(String queryString, Object[] values) {
        this.doBulkUpdate(queryString, values);
    }

    @Override
    public void update(Class clazz, String propertyToChange, Object newValue, String conditionProperty, Object conditionValue) {
    }

    @Override
    public void update(Class clazz, String propertyToChange, Object newValue, Map<String, Object> conditions) {
    }

    @Override
    public void update(Class clazz, Map<String, Object> newValues, String conditionProperty, Object conditionValue) {
    }

    @Override
    public void update(Class clazz, Map<String, Object> newValues, Map<String, Object> conditions) {
    }

    @Override
    public void updateAnythingLike(Class clazz, Object newValues, Object conditions) {
    }

    @Override
    public void flush() {
        this.getSession().flush();
    }

    @Override
    public void delete(Object object) {
        this.getSession().delete(object);
    }

    @Override
    public void deleteAll(Class clazz) {
        String queryString = this.buildQueryString(clazz, DELETE);
        this.doBulkUpdate(queryString, new Object[0]);
    }

    @Override
    public void deleteAll(Collection objects) {
        this.doDeleteAll(objects);
    }

    @Override
    public void deleteById(Class clazz, Serializable id) {
        this.delete(this.find(clazz, id));
    }

    @Override
    public void deleteByProperty(Class clazz, String name, Object value) {
        String queryString = this.buildQueryString(clazz, name, DELETE);
        this.doBulkUpdate(queryString, value);
    }

    @Override
    public void deleteByProperties(Class clazz, Map<String, Object> properties) {
        Qv qv = this.buildQueryString(clazz, properties, DELETE, EQUAL_TO_WHAT);
        this.doBulkUpdate(qv.queryString, qv.values);
    }

    @Override
    public void deleteAnythingLike(Object object) {
        try {
            Qv qv = this.buildQueryString(object, DELETE);
            this.doBulkUpdate(qv.queryString, qv.values);
        }
        catch (Exception e) {
            log.debug((Object)e);
        }
    }

    @Override
    public Object find(Class clazz, Serializable id) {
        return this.getSession().get(clazz, id);
    }

    @Override
    public List findAll(Class clazz) {
        return this.loadAll(clazz);
    }

    @Override
    public List findByProperty(Class clazz, String name, Object value) {
        String queryString = this.buildQueryString(clazz, name, SELECT);
        return this.doFind(queryString, value);
    }

    @Override
    public List findByProperties(Class clazz, Map<String, Object> properties) {
        Qv qv = this.buildQueryString(clazz, properties, SELECT, EQUAL_TO_WHAT);
        return this.doFind(qv.queryString, qv.values);
    }

    @Override
    public List findAnythingLike(Object object) {
        return this.doFindByExample(null, object, -1, -1);
    }

    private String buildQueryString(Class clazz, String operation) {
        StringBuilder queryString = new StringBuilder(operation).append(clazz.getSimpleName());
        return queryString.toString();
    }

    private String buildQueryString(Class clazz, String name, String operation) {
        String clazzName = clazz.getSimpleName();
        String objName = this.createObjectName(clazzName);
        StringBuilder queryString = new StringBuilder(operation).append(clazzName).append(SPACE).append(objName).append(WHERE).append(objName).append(SPOT).append(name).append(EQUAL_TO_WHAT);
        return queryString.toString();
    }

    @Override
    public List find(String queryString) {
        return this.doFind(queryString, new Object[0]);
    }

    @Override
    public List find(String queryString, Object value) {
        return this.doFind(queryString, value);
    }

    @Override
    public List find(String queryString, Object[] values) {
        return this.doFind(queryString, values);
    }

    @Override
    public List findByNamedQuery(String queryName) {
        return this.doFindByNamedQuery(queryName, new Object[0]);
    }

    @Override
    public List findByNamedQuery(String queryName, Object value) {
        return this.doFindByNamedQuery(queryName, value);
    }

    @Override
    public List findByNamedQuery(String queryName, Object[] values) {
        return this.doFindByNamedQuery(queryName, values);
    }

    @Override
    public List searchByStringProperty(Class clazz, String name, String pattern) {
        return null;
    }

    @Override
    public List searchByStringProperties(Class clazz, Map<String, String> properties) {
        HashMap<String, Object> p = new HashMap<String, Object>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            p.put(entry.getKey(), entry.getValue());
        }
        Qv qv = this.buildQueryString(clazz, p, SELECT, LIKE_WHAT);
        return this.doFind(qv.queryString, qv.values);
    }

    @Override
    public List searchByNumberSpan(Class clazz, String name, Integer min, Boolean minIncluded, Integer max, Boolean maxIncluded) {
        return null;
    }

    private Qv buildQueryString(Class clazz, Map<String, Object> properties, String operation, String condition) {
        String clazzName = clazz.getSimpleName();
        String objName = this.createObjectName(clazzName);
        StringBuilder queryString = new StringBuilder(operation).append(clazzName).append(SPACE).append(objName).append(WHERE);
        Object[] values = new Object[properties.size()];
        int i = 0;
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            queryString.append(objName).append(SPOT).append(entry.getKey()).append(condition);
            if (i != properties.size() - 1) {
                queryString.append(AND);
            }
            values[i] = entry.getValue();
            ++i;
        }
        return new Qv(queryString.toString(), values);
    }

    private Qv buildQueryString(Object obj, String operation) throws Exception {
        String clazzName = obj.getClass().getSimpleName();
        String objName = this.createObjectName(clazzName);
        StringBuilder queryString = new StringBuilder(operation).append(clazzName).append(SPACE).append(objName).append(WHERE);
        Field[] fields = obj.getClass().getDeclaredFields();
        ArrayList<Object> values = new ArrayList<Object>();
        for (int i = 0; i < fields.length; ++i) {
            String name = fields[i].getName();
            Method readMethod = this.getReadMethod(fields[i], name, obj.getClass());
            Object value = readMethod.invoke(obj, new Object[0]);
            if (value == null) continue;
            queryString.append(objName).append(SPOT).append(name).append(EQUAL_TO_WHAT);
            if (i != fields.length - 1) {
                queryString.append(AND);
            }
            values.add(value);
        }
        return new Qv(queryString.toString(), values.toArray());
    }

    private Method getReadMethod(Field field, String fieldName, Class clazz) throws Exception {
        String convertedName = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        if (field.getType().getSimpleName().equals("Boolean")) {
            return clazz.getDeclaredMethod("is" + convertedName, new Class[0]);
        }
        return clazz.getDeclaredMethod("get" + convertedName, new Class[0]);
    }

    private String createObjectName(String clazzName) {
        return clazzName.substring(0, 1).toLowerCase();
    }

    @Override
    public void initialize(Object proxy) {
        Hibernate.initialize((Object)proxy);
    }

    @Override
    public long countAll(Class clazz) {
        String query = "select count(*) from " + clazz.getSimpleName();
        List<?> list = this.doFind(query, new Object[0]);
        if (list != null && list.size() > 0) {
            return (Long)list.get(0);
        }
        return 0L;
    }

    @Override
    public long countByProperties(Class clazz, Map<String, Object> properties) {
        Qv qv = this.buildQueryString(clazz, properties, SELECT, EQUAL_TO_WHAT);
        String query = "select count(*) " + qv.queryString;
        List<?> list = this.doFind(query, qv.values);
        if (list != null && list.size() > 0) {
            return (Long)list.get(0);
        }
        return 0L;
    }

    protected Session getSession() {
        return this.sessionFactory.getCurrentSession();
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public List<?> doFind(String queryString, Object ... values) {
        Query queryObject = this.getSession().createQuery(queryString);
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                queryObject.setParameter(i, values[i]);
            }
        }
        return queryObject.list();
    }

    public int doBulkUpdate(String queryString, Object ... values) {
        Query queryObject = this.getSession().createQuery(queryString);
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                queryObject.setParameter(i, values[i]);
            }
        }
        return queryObject.executeUpdate();
    }

    public List<?> doFindByNamedQuery(String queryName, Object ... values) {
        Query queryObject = this.getSession().getNamedQuery(queryName);
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                queryObject.setParameter(i, values[i]);
            }
        }
        return queryObject.list();
    }

    public <T> List<T> doFindByExample(String entityName, T exampleEntity, int firstResult, int maxResults) {
        if (exampleEntity == null) {
            throw new IllegalArgumentException("Example entity must not be null");
        }
        Criteria executableCriteria = entityName != null ? this.getSession().createCriteria(entityName) : this.getSession().createCriteria(exampleEntity.getClass());
        executableCriteria.add((Criterion)Example.create(exampleEntity));
        if (firstResult >= 0) {
            executableCriteria.setFirstResult(firstResult);
        }
        if (maxResults > 0) {
            executableCriteria.setMaxResults(maxResults);
        }
        return executableCriteria.list();
    }

    public <T> List<T> findByExample(String entityName, T exampleEntity, int firstResult, int maxResults) {
        if (exampleEntity == null) {
            throw new IllegalArgumentException("Example entity must not be null");
        }
        Criteria executableCriteria = entityName != null ? this.getSession().createCriteria(entityName) : this.getSession().createCriteria(exampleEntity.getClass());
        executableCriteria.add((Criterion)Example.create(exampleEntity));
        if (firstResult >= 0) {
            executableCriteria.setFirstResult(firstResult);
        }
        if (maxResults > 0) {
            executableCriteria.setMaxResults(maxResults);
        }
        return executableCriteria.list();
    }

    public <T> List<T> loadAll(Class<T> entityClass) {
        Criteria criteria = this.getSession().createCriteria(entityClass);
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        return criteria.list();
    }

    public void doDeleteAll(Collection<?> entities) {
        for (Object entity : entities) {
            this.getSession().delete(entity);
        }
    }

    public List<?> doFindByNamedParam(String queryString, String[] paramNames, Object[] values) {
        if (paramNames.length != values.length) {
            throw new IllegalArgumentException("Length of paramNames array must match length of values array");
        }
        Query queryObject = this.getSession().createQuery(queryString);
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                this.applyNamedParameterToQuery(queryObject, paramNames[i], values[i]);
            }
        }
        return queryObject.list();
    }

    private void applyNamedParameterToQuery(Query queryObject, String paramName, Object value) throws HibernateException {
        if (value instanceof Collection) {
            queryObject.setParameterList(paramName, (Collection)value);
        } else if (value instanceof Object[]) {
            queryObject.setParameterList(paramName, (Object[])value);
        } else {
            queryObject.setParameter(paramName, value);
        }
    }

    public List<?> doFindByNamedQueryAndNamedParam(String queryName, String paramName, Object value) {
        return this.doFindByNamedQueryAndNamedParam(queryName, new String[]{paramName}, new Object[]{value});
    }

    public List<?> doFindByNamedQueryAndNamedParam(String queryName, String[] paramNames, Object[] values) {
        if (values != null && (paramNames == null || paramNames.length != values.length)) {
            throw new IllegalArgumentException("Length of paramNames array must match length of values array");
        }
        Query queryObject = this.getSession().getNamedQuery(queryName);
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                this.applyNamedParameterToQuery(queryObject, paramNames[i], values[i]);
            }
        }
        return queryObject.list();
    }

    public void saveObject(Object o) {
        this.getSession().saveOrUpdate(o);
    }

    public Object getObject(Class clazz, Serializable id) {
        Object o = this.getSession().get(clazz, id);
        return o;
    }

    public List getObjects(Class clazz) {
        return this.loadAll(clazz);
    }

    public void removeObject(Class clazz, Serializable id) {
        this.getSession().delete(this.getObject(clazz, id));
    }

    public void releaseFromCache(Object o) {
        this.getSessionFactory().getCurrentSession().evict(o);
    }

    private static class Qv {
        String queryString;
        Object[] values;

        Qv(String queryString, Object[] values) {
            this.queryString = queryString;
            this.values = values;
        }
    }
}

