/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.events;

import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.events.Subscription;

public abstract class AbstractDeliveryMethod {
    protected final short id;
    protected long sendTimeout = Long.MAX_VALUE;
    protected final Map<Long, String> errors = new HashMap<Long, String>();
    protected static final long ERROR_SILENCE_TIMEOUT = 5000L;

    protected AbstractDeliveryMethod(short id) throws InvalidParameterException {
        this.id = id;
    }

    protected abstract String send(Integer var1, Integer var2, String var3, String var4, boolean var5) throws InvalidParameterException;

    protected abstract Logger getLog();

    protected abstract boolean lastOperationFailed(Subscription var1);

    public boolean equals(Object o) {
        return o instanceof AbstractDeliveryMethod && ((AbstractDeliveryMethod)o).id == this.id;
    }

    public short getId() {
        return this.id;
    }

    public long getSendTimeout() {
        return this.sendTimeout;
    }

    public void setSendTimeout(long sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    protected synchronized void logError(String error) {
        Iterator<Map.Entry<Long, String>> errorIterator = this.errors.entrySet().iterator();
        boolean logError = true;
        long currentTime = System.currentTimeMillis();
        long silencePeriod = currentTime - 5000L;
        while (errorIterator.hasNext()) {
            Map.Entry<Long, String> entry = errorIterator.next();
            if (entry.getKey() < silencePeriod) {
                errorIterator.remove();
                continue;
            }
            if (!error.equals(entry.getValue())) continue;
            logError = false;
        }
        if (logError) {
            this.errors.put(currentTime, error);
            this.getLog().error((Object)("Error while notifying users: " + error));
        }
    }
}

