/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.integration.security;

import com.warrenstrange.googleauth.GoogleAuthenticator;
import io.undertow.Handlers;
import io.undertow.server.session.Session;
import io.undertow.servlet.ServletExtension;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.HttpSessionImpl;
import java.security.AccessController;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.usermanagement.service.UserManagementService;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SsoHandler
implements ServletExtension {
    private static IUserManagementService userManagementService = null;
    protected static final String SESSION_KEY = "io.undertow.servlet.form.auth.redirect.location";
    public static final String NO_FLUSH_FLAG = "noFlush";

    public void handleDeployment(DeploymentInfo deploymentInfo, ServletContext servletContext) {
        SessionManager.setServletContext(servletContext);
        deploymentInfo.addOuterHandlerChainWrapper(handler -> Handlers.path().addPrefixPath("/", handler).addExactPath("/j_security_check", exchange -> {
            User user;
            ServletRequestContext context = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
            HttpServletRequest request = (HttpServletRequest)context.getServletRequest();
            if (SessionManager.getJvmRoute() == null) {
                SsoHandler.setJvmRoute(request);
            }
            HttpSession session = request.getSession();
            String redirectURL = request.getParameter("redirectURL");
            if (!StringUtils.isBlank((String)redirectURL)) {
                SsoHandler.handleRedirectBack(context, redirectURL);
            }
            UserDTO userDTO = null;
            String login = request.getParameter("j_username");
            if (!StringUtils.isBlank((String)login) && (user = this.getUserManagementService(session.getServletContext()).getUserByLogin(login)) != null) {
                userDTO = user.getUserDTO();
                if (request.getRemoteUser() == null && user.isTwoFactorAuthenticationEnabled().booleanValue() && user.getTwoFactorAuthenticationSecret() != null) {
                    String verificationCodeStr = request.getParameter("verificationCode");
                    int verificationCode = NumberUtils.toInt((String)verificationCodeStr);
                    GoogleAuthenticator gAuth = new GoogleAuthenticator();
                    boolean isCodeValid = gAuth.authorize(user.getTwoFactorAuthenticationSecret(), verificationCode);
                    if (!isCodeValid) {
                        session.setAttribute("login", (Object)login);
                        String password = request.getParameter("j_password");
                        session.setAttribute("password", (Object)password);
                        String redirectUrl = "/lams/loginTwoFactorAuth.jsp" + (verificationCodeStr == null ? "" : "?failed=true");
                        HttpServletResponse response = (HttpServletResponse)context.getServletResponse();
                        response.sendRedirect(redirectUrl);
                        return;
                    }
                }
            }
            SessionManager.removeSessionByID(session.getId(), false);
            request.changeSessionId();
            SessionManager.startSession(request);
            handler.handleRequest(exchange);
            if (!StringUtils.isBlank((String)login) && login.equals(request.getRemoteUser())) {
                session.setAttribute("user", (Object)userDTO);
                HttpSession existingSession = SessionManager.getSessionForLogin(login);
                if (existingSession != null) {
                    existingSession.setAttribute(NO_FLUSH_FLAG, (Object)true);
                    SessionManager.removeSessionByLogin(login, true);
                }
                SessionManager.addSession(login, session);
            }
            SessionManager.endSession();
        }));
    }

    protected static void handleRedirectBack(ServletRequestContext context, String redirectURL) {
        if (redirectURL.contains("\n") || redirectURL.contains("\r")) {
            throw new SecurityException("redirectURL contains forbidden characters: \\n or \\r. Possible HTTP Response Splitting attack.");
        }
        HttpSessionImpl httpSession = context.getCurrentServletContext().getSession(context.getExchange(), true);
        if (httpSession != null) {
            Session session = System.getSecurityManager() == null ? httpSession.getSession() : (Session)AccessController.doPrivileged(new HttpSessionImpl.UnwrapSessionAction((HttpSession)httpSession));
            session.setAttribute(SESSION_KEY, (Object)redirectURL);
        }
    }

    protected static void setJvmRoute(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return;
        }
        for (Cookie cookie : cookies) {
            int index;
            if (!cookie.getName().equals("JSESSIONID") || (index = cookie.getValue().indexOf(46)) <= 0) continue;
            SessionManager.setJvmRoute(cookie.getValue().substring(index + 1));
            return;
        }
    }

    protected IUserManagementService getUserManagementService(ServletContext context) {
        if (userManagementService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)context);
            userManagementService = (UserManagementService)ctx.getBean("userManagementService");
        }
        return userManagementService;
    }
}

