/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.integration.util;

import java.util.LinkedList;
import java.util.List;

public class LtiUtils {
    public static final String OAUTH_CONSUMER_KEY = "oauth_consumer_key";

    public static boolean isAdmin(String roles) {
        LinkedList<String> rolesToSearchFor = new LinkedList<String>();
        rolesToSearchFor.add("urn:lti:role:ims/lis/Administrator");
        rolesToSearchFor.add("urn:lti:sysrole:ims/lis/SysAdmin");
        rolesToSearchFor.add("urn:lti:sysrole:ims/lis/Administrator");
        rolesToSearchFor.add("urn:lti:instrole:ims/lis/Administrator");
        return LtiUtils.hasRole(roles, rolesToSearchFor);
    }

    public static boolean isStaff(String roles) {
        LinkedList<String> rolesToSearchFor = new LinkedList<String>();
        rolesToSearchFor.add("urn:lti:role:ims/lis/Instructor");
        rolesToSearchFor.add("urn:lti:role:ims/lis/ContentDeveloper");
        rolesToSearchFor.add("urn:lti:role:ims/lis/TeachingAssistant");
        return LtiUtils.hasRole(roles, rolesToSearchFor);
    }

    public static boolean isLearner(String roles) {
        LinkedList<String> rolesToSearchFor = new LinkedList<String>();
        rolesToSearchFor.add("urn:lti:role:ims/lis/Learner");
        return LtiUtils.hasRole(roles, rolesToSearchFor);
    }

    private static boolean hasRole(String roles, List<String> rolesToSearchFor) {
        String[] roleArray = roles.split(",");
        boolean hasRole = false;
        block0: for (String role : roleArray) {
            for (String roleToSearchFor : rolesToSearchFor) {
                if (!role.equals(roleToSearchFor)) continue;
                hasRole = true;
                continue block0;
            }
        }
        return hasRole;
    }
}

