/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.dao.hibernate;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.lamsfoundation.lams.dao.hibernate.LAMSBaseDAO;
import org.lamsfoundation.lams.learningdesign.GroupUser;
import org.lamsfoundation.lams.learningdesign.dao.IGroupUserDAO;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.usermanagement.User;
import org.springframework.stereotype.Repository;

@Repository
public class GroupUserDAO
extends LAMSBaseDAO
implements IGroupUserDAO {
    private static final String GET_USERS_BY_LESSON_AND_TIME = "SELECT DISTINCT gu.user FROM " + GroupUser.class.getName() + " AS gu WHERE gu.group.grouping.groupingId=? AND (gu.scheduledLessonEndDate IS NOT NULL) AND (NOW() < gu.scheduledLessonEndDate) AND (? > gu.scheduledLessonEndDate)";

    @Override
    public GroupUser getGroupUser(Lesson lesson, Integer userId) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("group.grouping.groupingId", lesson.getLessonClass().getGroupingId());
        properties.put("user.userId", userId);
        List list = this.findByProperties(GroupUser.class, properties);
        if (list == null || list.size() == 0) {
            return null;
        }
        return (GroupUser)list.get(0);
    }

    @Override
    public List<User> getUsersWithLessonEndingSoonerThan(Lesson lesson, Date timeToScheduledLessonEnd) {
        return this.doFind(GET_USERS_BY_LESSON_AND_TIME, lesson.getLessonClass().getGroupingId(), timeToScheduledLessonEnd);
    }

    @Override
    public void saveGroupUser(GroupUser groupUser) {
        this.getSession().save((Object)groupUser);
    }
}

