/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.dao.hibernate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.lamsfoundation.lams.dao.hibernate.LAMSBaseDAO;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ChosenGrouping;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.GroupingActivity;
import org.lamsfoundation.lams.learningdesign.LearnerChoiceGrouping;
import org.lamsfoundation.lams.learningdesign.RandomGrouping;
import org.lamsfoundation.lams.learningdesign.dao.IGroupingDAO;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.stereotype.Repository;

@Repository
public class GroupingDAO
extends LAMSBaseDAO
implements IGroupingDAO {
    private static final String GROUPINGS_FOR_LEARNING_DESIGN_VIA_CREATE = "select grouping from " + Grouping.class.getName() + " grouping, " + GroupingActivity.class.getName() + " grouping_activity " + " where grouping_activity.learningDesign.id = ? " + " and grouping_activity.createGrouping = grouping";
    private static final String GROUPINGS_FOR_LEARNING_DESIGN_VIA_GROUPING = "select grouping from " + Grouping.class.getName() + " grouping, " + Activity.class.getName() + " activity " + " where activity.learningDesign.id = ? " + " and activity.grouping = grouping";

    @Override
    public Grouping getGroupingById(Long groupingID) {
        Grouping grouping = (Grouping)super.find(Grouping.class, groupingID);
        return this.getNonCGLibGrouping(grouping);
    }

    @Override
    public List<Grouping> getGroupingsByLearningDesign(Long learningDesignId) {
        List<?> groupingsA = this.doFind(GROUPINGS_FOR_LEARNING_DESIGN_VIA_CREATE, learningDesignId);
        List<?> groupingsB = this.doFind(GROUPINGS_FOR_LEARNING_DESIGN_VIA_GROUPING, learningDesignId);
        HashMap<Long, Grouping> realGroupings = new HashMap<Long, Grouping>();
        for (Grouping element : groupingsA) {
            realGroupings.put(element.getGroupingId(), this.getNonCGLibGrouping(element));
        }
        for (Grouping element : groupingsB) {
            if (realGroupings.containsKey(element.getGroupingId())) continue;
            realGroupings.put(element.getGroupingId(), this.getNonCGLibGrouping(element));
        }
        return new ArrayList<Grouping>(realGroupings.values());
    }

    private Grouping getNonCGLibGrouping(Grouping grouping) {
        if (grouping != null) {
            if (grouping.isRandomGrouping()) {
                return (Grouping)super.find(RandomGrouping.class, grouping.getGroupingId());
            }
            if (grouping.isChosenGrouping()) {
                return (Grouping)super.find(ChosenGrouping.class, grouping.getGroupingId());
            }
            if (grouping.isLearnerChoiceGrouping()) {
                return (Grouping)super.find(LearnerChoiceGrouping.class, grouping.getGroupingId());
            }
            throw new DataRetrievalFailureException("Unable to get grouping as the grouping type is unknown or missing. Grouping object is " + grouping);
        }
        return null;
    }
}

