/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.lesson;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.lamsfoundation.lams.gradebook.GradebookUserLesson;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.lesson.LessonClass;
import org.lamsfoundation.lams.lesson.dto.LessonDetailsDTO;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.User;

public class Lesson
implements Serializable {
    private static final long serialVersionUID = 5733920851084229175L;
    public static final Integer CREATED = new Integer(1);
    public static final Integer NOT_STARTED_STATE = new Integer(2);
    public static final Integer STARTED_STATE = new Integer(3);
    public static final Integer SUSPENDED_STATE = new Integer(4);
    public static final Integer FINISHED_STATE = new Integer(5);
    public static final Integer ARCHIVED_STATE = new Integer(6);
    public static final Integer REMOVED_STATE = new Integer(7);
    private Long lessonId;
    private Integer version;
    private String lessonName;
    private Date createDateTime;
    private Date startDateTime;
    private Date endDateTime;
    private Date scheduleStartDate;
    private Date scheduleEndDate;
    private Integer scheduledNumberDaysToLessonFinish;
    private User user;
    private Integer lessonStateId;
    private Integer previousLessonStateId;
    private LearningDesign learningDesign;
    private LessonClass lessonClass;
    private Organisation organisation;
    private Set learnerProgresses;
    private Set<GradebookUserLesson> gradebookUserLessons;
    private Boolean enableLessonIntro;
    private String lessonDescription;
    private Boolean displayDesignImage;
    private Boolean lockedForEdit;
    private Boolean learnerPresenceAvailable;
    private Boolean learnerImAvailable;
    private Boolean liveEditEnabled;
    private Boolean enableLessonNotifications;
    private Boolean marksReleased;
    private Boolean forceLearnerRestart;
    private Boolean allowLearnerRestart;
    private Set<Lesson> precedingLessons;
    private Set<Lesson> succeedingLessons;

    public Lesson() {
    }

    public Lesson(String name, String description, Date createDateTime, User user, Integer lessonStateId, Integer previousLessonStateId, LearningDesign learningDesign, Set learnerProgresses, Boolean enableLessonIntro, Boolean displayDesignImage, Boolean learnerPresenceAvailable, Boolean learnerImAvailable, Boolean liveEditEnabled, Boolean enableLessonNotifications, Boolean forceLearnerRestart, Boolean allowLearnerRestart, Integer scheduledNumberDaysTolessonFinish) {
        this(null, name, description, createDateTime, null, null, user, lessonStateId, previousLessonStateId, enableLessonIntro, displayDesignImage, false, learningDesign, null, null, learnerProgresses, learnerPresenceAvailable, learnerImAvailable, liveEditEnabled, enableLessonNotifications, forceLearnerRestart, allowLearnerRestart, scheduledNumberDaysTolessonFinish);
    }

    public Lesson(Long lessonId, String name, String description, Date createDateTime, Date startDateTime, Date endDateTime, User user, Integer lessonStateId, Integer previousLessonStateId, Boolean enableLessonIntro, Boolean displayDesignImage, Boolean lockedForEdit, LearningDesign learningDesign, LessonClass lessonClass, Organisation organisation, Set learnerProgresses, Boolean learnerPresenceAvailable, Boolean learnerImAvailable, Boolean liveEditEnabled, Boolean enableLessonNotifications, Boolean forceLearnerRestart, Boolean allowLearnerRestart, Integer scheduledNumberDaysToLessonFinish) {
        this.lessonId = lessonId;
        this.lessonName = name;
        this.lessonDescription = description;
        this.createDateTime = createDateTime;
        this.startDateTime = startDateTime;
        this.endDateTime = endDateTime;
        this.user = user;
        this.lessonStateId = lessonStateId;
        this.previousLessonStateId = previousLessonStateId;
        this.enableLessonIntro = enableLessonIntro != null ? enableLessonIntro : Boolean.FALSE;
        this.displayDesignImage = displayDesignImage != null ? displayDesignImage : Boolean.FALSE;
        this.learnerPresenceAvailable = learnerPresenceAvailable != null ? learnerPresenceAvailable : Boolean.FALSE;
        this.learnerImAvailable = learnerImAvailable != null ? learnerImAvailable : Boolean.FALSE;
        this.lockedForEdit = false;
        this.learningDesign = learningDesign;
        this.lessonClass = lessonClass;
        this.organisation = organisation;
        this.learnerProgresses = learnerProgresses;
        this.liveEditEnabled = liveEditEnabled;
        this.enableLessonNotifications = enableLessonNotifications;
        this.forceLearnerRestart = forceLearnerRestart;
        this.allowLearnerRestart = allowLearnerRestart;
        this.gradebookUserLessons = new HashSet<GradebookUserLesson>();
        this.marksReleased = false;
        this.scheduledNumberDaysToLessonFinish = scheduledNumberDaysToLessonFinish;
    }

    public static Lesson createNewLessonWithoutClass(String lessonName, String lessonDescription, User user, LearningDesign ld, Boolean enableLessonIntro, Boolean displayDesignImage, Boolean learnerPresenceAvailable, Boolean learnerImAvailable, Boolean liveEditEnabled, Boolean enableLessonNotifications, Boolean forceLearnerRestart, Boolean allowLearnerRestart, Integer scheduledNumberDaysToLessonFinish) {
        return new Lesson(lessonName, lessonDescription, new Date(System.currentTimeMillis()), user, CREATED, null, ld, new HashSet(), enableLessonIntro, displayDesignImage, learnerPresenceAvailable, learnerImAvailable, liveEditEnabled, enableLessonNotifications, forceLearnerRestart, allowLearnerRestart, scheduledNumberDaysToLessonFinish);
    }

    public Long getLessonId() {
        return this.lessonId;
    }

    public void setLessonId(Long lessonId) {
        this.lessonId = lessonId;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public String getLessonName() {
        return this.lessonName;
    }

    public void setLessonName(String lessonName) {
        this.lessonName = lessonName;
    }

    public String getLessonDescription() {
        return this.lessonDescription;
    }

    public void setLessonDescription(String lessonDescription) {
        this.lessonDescription = lessonDescription;
    }

    public Date getCreateDateTime() {
        return this.createDateTime;
    }

    public void setCreateDateTime(Date createDateTime) {
        this.createDateTime = createDateTime;
    }

    public Date getStartDateTime() {
        return this.startDateTime;
    }

    public void setStartDateTime(Date startDateTime) {
        this.startDateTime = startDateTime;
    }

    public Date getEndDateTime() {
        return this.endDateTime;
    }

    public void setEndDateTime(Date endDateTime) {
        this.endDateTime = endDateTime;
    }

    public Date getScheduleEndDate() {
        return this.scheduleEndDate;
    }

    public void setScheduleEndDate(Date scheduleEndDate) {
        this.scheduleEndDate = scheduleEndDate;
    }

    public boolean isScheduledToCloseForIndividuals() {
        return this.scheduledNumberDaysToLessonFinish != null;
    }

    public Integer getScheduledNumberDaysToLessonFinish() {
        return this.scheduledNumberDaysToLessonFinish;
    }

    public void setScheduledNumberDaysToLessonFinish(Integer scheduledNumberDaysToLessonFinish) {
        this.scheduledNumberDaysToLessonFinish = scheduledNumberDaysToLessonFinish;
    }

    public Date getScheduleStartDate() {
        return this.scheduleStartDate;
    }

    public void setScheduleStartDate(Date scheduleStartDate) {
        this.scheduleStartDate = scheduleStartDate;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Integer getLessonStateId() {
        return this.lessonStateId;
    }

    public void setLessonStateId(Integer lessonStateId) {
        this.lessonStateId = lessonStateId;
    }

    public Integer getPreviousLessonStateId() {
        return this.previousLessonStateId;
    }

    public void setPreviousLessonStateId(Integer previousLessonStateId) {
        this.previousLessonStateId = previousLessonStateId;
    }

    public Boolean isEnableLessonIntro() {
        return this.enableLessonIntro;
    }

    public void setEnableLessonIntro(Boolean enableLessonIntro) {
        this.enableLessonIntro = enableLessonIntro;
    }

    public Boolean isDisplayDesignImage() {
        return this.displayDesignImage;
    }

    public void setDisplayDesignImage(Boolean displayDesignImage) {
        this.displayDesignImage = displayDesignImage;
    }

    public Boolean getLearnerPresenceAvailable() {
        return this.learnerPresenceAvailable;
    }

    public void setLearnerPresenceAvailable(Boolean learnerPresenceAvailable) {
        this.learnerPresenceAvailable = learnerPresenceAvailable;
    }

    public Boolean getLearnerImAvailable() {
        return this.learnerImAvailable;
    }

    public void setLearnerImAvailable(Boolean learnerImAvailable) {
        this.learnerImAvailable = learnerImAvailable;
    }

    public Boolean getLiveEditEnabled() {
        return this.liveEditEnabled;
    }

    public void setLiveEditEnabled(Boolean liveEditEnabled) {
        this.liveEditEnabled = liveEditEnabled;
    }

    public Boolean getEnableLessonNotifications() {
        return this.enableLessonNotifications;
    }

    public void setEnableLessonNotifications(Boolean enableLessonNotifications) {
        this.enableLessonNotifications = enableLessonNotifications;
    }

    public Boolean getLockedForEdit() {
        return this.lockedForEdit;
    }

    public void setLockedForEdit(Boolean lockedForEdit) {
        this.lockedForEdit = lockedForEdit;
    }

    public LearningDesign getLearningDesign() {
        return this.learningDesign;
    }

    public void setLearningDesign(LearningDesign learningDesign) {
        this.learningDesign = learningDesign;
    }

    public LessonClass getLessonClass() {
        return this.lessonClass;
    }

    public void setLessonClass(LessonClass lessonClass) {
        this.lessonClass = lessonClass;
    }

    public Organisation getOrganisation() {
        return this.organisation;
    }

    public void setOrganisation(Organisation organisation) {
        this.organisation = organisation;
    }

    public Set getLearnerProgresses() {
        return this.learnerProgresses;
    }

    public void setLearnerProgresses(Set learnerProgresses) {
        this.learnerProgresses = learnerProgresses;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("lessonId", (Object)this.getLessonId()).toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Lesson)) {
            return false;
        }
        Lesson castOther = (Lesson)other;
        return new EqualsBuilder().append((Object)this.getLessonId(), (Object)castOther.getLessonId()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getLessonId()).toHashCode();
    }

    public Set getAllLearners() {
        return this.lessonClass == null ? null : this.lessonClass.getLearners();
    }

    public LessonDetailsDTO getLessonDetails() {
        return new LessonDetailsDTO(this);
    }

    public boolean isPreviewLesson() {
        Integer copyTypeID = this.getLearningDesign().getCopyTypeID();
        return copyTypeID != null && 3 == copyTypeID;
    }

    public boolean isLessonStarted() {
        return this.isStarted(this.lessonStateId) || this.isStarted(this.previousLessonStateId);
    }

    private boolean isStarted(Integer stateId) {
        return stateId != null && (stateId.equals(STARTED_STATE) || stateId.equals(FINISHED_STATE) || stateId.equals(ARCHIVED_STATE) || stateId.equals(REMOVED_STATE));
    }

    public boolean isLessonAccessibleForLearner() {
        return this.lessonStateId != null && (this.lessonStateId.equals(STARTED_STATE) || this.lessonStateId.equals(FINISHED_STATE));
    }

    public Set<GradebookUserLesson> getGradebookUserLessons() {
        return this.gradebookUserLessons;
    }

    public void setGradebookUserLessons(Set<GradebookUserLesson> gradebookUserLessons) {
        this.gradebookUserLessons = gradebookUserLessons;
    }

    public Boolean getMarksReleased() {
        return this.marksReleased;
    }

    public void setMarksReleased(Boolean marksReleased) {
        this.marksReleased = marksReleased;
    }

    public Boolean getForceLearnerRestart() {
        return this.forceLearnerRestart;
    }

    public void setForceLearnerRestart(Boolean forceLearnerRestart) {
        this.forceLearnerRestart = forceLearnerRestart;
    }

    public Boolean getAllowLearnerRestart() {
        return this.allowLearnerRestart;
    }

    public void setAllowLearnerRestart(Boolean allowLearnerRestart) {
        this.allowLearnerRestart = allowLearnerRestart;
    }

    public Set<Lesson> getPrecedingLessons() {
        return this.precedingLessons;
    }

    public void setPrecedingLessons(Set<Lesson> precedingLessons) {
        this.precedingLessons = precedingLessons;
    }

    public Set<Lesson> getSucceedingLessons() {
        return this.succeedingLessons;
    }

    public void setSucceedingLessons(Set<Lesson> succeedingLessons) {
        this.succeedingLessons = succeedingLessons;
    }
}

