/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.signup.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.service.ILessonService;
import org.lamsfoundation.lams.signup.dao.ISignupDAO;
import org.lamsfoundation.lams.signup.model.SignupOrganisation;
import org.lamsfoundation.lams.signup.service.ISignupService;
import org.lamsfoundation.lams.usermanagement.AuthenticationMethod;
import org.lamsfoundation.lams.usermanagement.Role;
import org.lamsfoundation.lams.usermanagement.SupportedLocale;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;

public class SignupService
implements ISignupService {
    private ISignupDAO signupDAO;
    private IUserManagementService userManagementService;
    private ILessonService lessonService;

    @Override
    public void signupUser(User user, String context) {
        user.setTheme(this.userManagementService.getDefaultTheme());
        user.setDisabledFlag(false);
        user.setAuthenticationMethod(this.getAuthenticationMethod(AuthenticationMethod.DB));
        user.setLocale(this.getDefaultLocale());
        user.setCreateDate(new Date());
        this.userManagementService.save(user);
        SignupOrganisation signup = this.signupDAO.getSignupOrganisation(context);
        ArrayList<String> rolesList = new ArrayList<String>();
        rolesList.add(Role.ROLE_LEARNER.toString());
        if (signup.getAddAsStaff().booleanValue()) {
            rolesList.add(Role.ROLE_MONITOR.toString());
            rolesList.add(Role.ROLE_AUTHOR.toString());
        } else if (signup.getAddWithAuthor().booleanValue()) {
            rolesList.add(Role.ROLE_AUTHOR.toString());
        } else if (signup.getAddWithMonitor().booleanValue()) {
            rolesList.add(Role.ROLE_MONITOR.toString());
        }
        this.userManagementService.setRolesForUserOrganisation(user, signup.getOrganisation().getOrganisationId(), rolesList);
        if (signup.getAddToLessons().booleanValue()) {
            user = this.userManagementService.getUserByLogin(user.getLogin());
            Set lessonSet = signup.getOrganisation().getLessons();
            for (Lesson lesson : lessonSet) {
                this.lessonService.addLearner(lesson.getLessonId(), user.getUserId());
                if (!signup.getAddAsStaff().booleanValue()) continue;
                this.lessonService.addStaffMember(lesson.getLessonId(), user.getUserId());
            }
        }
    }

    @Override
    public void signinUser(String login, String context) {
        User user = this.userManagementService.getUserByLogin(login);
        SignupOrganisation signup = this.signupDAO.getSignupOrganisation(context);
        ArrayList<String> rolesList = new ArrayList<String>();
        rolesList.add(Role.ROLE_LEARNER.toString());
        if (signup.getAddAsStaff().booleanValue()) {
            rolesList.add(Role.ROLE_MONITOR.toString());
            rolesList.add(Role.ROLE_AUTHOR.toString());
        } else if (signup.getAddWithAuthor().booleanValue()) {
            rolesList.add(Role.ROLE_AUTHOR.toString());
        } else if (signup.getAddWithMonitor().booleanValue()) {
            rolesList.add(Role.ROLE_MONITOR.toString());
        }
        this.userManagementService.setRolesForUserOrganisation(user, signup.getOrganisation().getOrganisationId(), rolesList);
        if (signup.getAddToLessons().booleanValue()) {
            Set lessonSet = signup.getOrganisation().getLessons();
            for (Lesson lesson : lessonSet) {
                this.lessonService.addLearner(lesson.getLessonId(), user.getUserId());
                if (!signup.getAddAsStaff().booleanValue()) continue;
                this.lessonService.addStaffMember(lesson.getLessonId(), user.getUserId());
            }
        }
    }

    @Override
    public User getUserByLogin(String login) {
        return this.userManagementService.getUserByLogin(login);
    }

    @Override
    public SignupOrganisation getSignupOrganisation(String context) {
        return this.signupDAO.getSignupOrganisation(context);
    }

    @Override
    public boolean usernameExists(String username) {
        return this.signupDAO.usernameExists(username);
    }

    @Override
    public boolean courseKeyIsValid(String context, String courseKey) {
        return this.signupDAO.courseKeyIsValid(context, courseKey);
    }

    @Override
    public List getSignupOrganisations() {
        return this.signupDAO.getSignupOrganisations();
    }

    @Override
    public List getOrganisationCandidates() {
        return this.signupDAO.getOrganisationCandidates();
    }

    @Override
    public boolean contextExists(Integer soid, String context) {
        return this.signupDAO.contextExists(soid, context);
    }

    public void setSignupDAO(ISignupDAO signupDAO) {
        this.signupDAO = signupDAO;
    }

    public void setUserManagementService(IUserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    public void setLessonService(ILessonService lessonService) {
        this.lessonService = lessonService;
    }

    private AuthenticationMethod getAuthenticationMethod(Integer id) {
        return (AuthenticationMethod)this.userManagementService.findById(AuthenticationMethod.class, id);
    }

    private SupportedLocale getDefaultLocale() {
        String localeName = Configuration.get(ConfigurationKeys.SERVER_LANGUAGE);
        String langIsoCode = "en";
        String countryIsoCode = "AU";
        if (StringUtils.isNotBlank((String)localeName) && localeName.length() > 2) {
            langIsoCode = localeName.substring(0, 2);
            countryIsoCode = localeName.substring(3);
        }
        SupportedLocale locale = null;
        locale = this.getSupportedLocaleOrNull(langIsoCode, countryIsoCode);
        if (locale == null) {
            locale = this.getSupportedLocaleOrNull("en", "AU");
        }
        return locale;
    }

    private SupportedLocale getSupportedLocaleOrNull(String langIsoCode, String countryIsoCode) {
        SupportedLocale locale = null;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)countryIsoCode)) {
            properties.put("countryIsoCode", countryIsoCode.trim());
        }
        if (StringUtils.isNotBlank((String)langIsoCode)) {
            properties.put("languageIsoCode", langIsoCode.trim());
        }
        if (properties.isEmpty()) {
            return null;
        }
        List list = this.userManagementService.findByProperties(SupportedLocale.class, properties);
        if (list != null && list.size() > 0) {
            Collections.sort(list);
            locale = (SupportedLocale)list.get(0);
        } else {
            locale = null;
        }
        return locale;
    }
}

