/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.timezone.dao.hibernate;

import java.util.List;
import org.lamsfoundation.lams.dao.hibernate.LAMSBaseDAO;
import org.lamsfoundation.lams.timezone.Timezone;
import org.lamsfoundation.lams.timezone.dao.ITimezoneDAO;
import org.springframework.stereotype.Repository;

@Repository
public class TimezoneDAO
extends LAMSBaseDAO
implements ITimezoneDAO {
    private static final String FIND_DEFAULT_TIMEZONES = "from " + Timezone.class.getName() + " timezone where timezone.serverTimezone=false";
    private static final String FIND_SERVER_TIMEZONE = "from " + Timezone.class.getName() + " timezone where timezone.serverTimezone=true";

    @Override
    public List<Timezone> getDefaultTimezones() {
        List<Timezone> timezones = this.doFind(FIND_DEFAULT_TIMEZONES, new Object[0]);
        return timezones;
    }

    @Override
    public void addTimezone(Timezone timezone) {
        super.insert(timezone);
    }

    @Override
    public void removeTimezone(Timezone timezone) {
        super.delete(timezone);
    }

    @Override
    public Timezone getServerTimezone() {
        List<?> list = this.doFind(FIND_SERVER_TIMEZONE, new Object[0]);
        if (list.size() > 0) {
            return (Timezone)list.get(0);
        }
        return null;
    }

    @Override
    public void setServerTimezone(Timezone serverTimezone) {
        super.update(serverTimezone);
    }
}

