/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool;

import org.lamsfoundation.lams.tool.OutputType;
import org.lamsfoundation.lams.tool.ToolOutputFormatException;

public class ToolOutputValue {
    private OutputType type;
    private Object value;

    public ToolOutputValue(Boolean val) {
        this.type = OutputType.OUTPUT_BOOLEAN;
        this.value = val;
    }

    public ToolOutputValue(Long val) {
        this.type = OutputType.OUTPUT_LONG;
        this.value = val;
    }

    public ToolOutputValue(Integer val) {
        this.type = OutputType.OUTPUT_LONG;
        this.value = new Long(val.longValue());
    }

    public ToolOutputValue(Double val) {
        this.type = OutputType.OUTPUT_DOUBLE;
        this.value = val;
    }

    public ToolOutputValue(Float val) {
        this.type = OutputType.OUTPUT_DOUBLE;
        this.value = new Double(val.doubleValue());
    }

    public ToolOutputValue(String val) {
        this.type = OutputType.OUTPUT_STRING;
        this.value = val;
    }

    public ToolOutputValue(String val, OutputType type) {
        this.type = type;
        try {
            switch (type) {
                case OUTPUT_LONG: {
                    this.value = Long.parseLong(val);
                    break;
                }
                case OUTPUT_DOUBLE: {
                    this.value = Double.parseDouble(val);
                    break;
                }
                case OUTPUT_BOOLEAN: {
                    this.value = Boolean.parseBoolean(val);
                    break;
                }
                default: {
                    this.value = val;
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new ToolOutputFormatException("Unable to convert value " + this.value + " to Long.", e);
        }
    }

    public ToolOutputValue(Object val, Boolean junk) {
        this.type = OutputType.OUTPUT_COMPLEX;
        this.value = val;
    }

    public OutputType getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public String getString() throws ToolOutputFormatException {
        switch (this.type) {
            case OUTPUT_STRING: {
                return (String)this.value;
            }
            case OUTPUT_COMPLEX: {
                if (this.value instanceof Object[]) {
                    Object[] array = (Object[])this.value;
                    StringBuilder result = new StringBuilder("[");
                    for (Object valuePart : array) {
                        result.append(valuePart.toString()).append(",");
                    }
                    if (array.length > 0) {
                        result.replace(result.length() - 1, result.length(), "]");
                    } else {
                        result.append("]");
                    }
                    return result.toString();
                }
                return this.value.toString();
            }
        }
        return this.value.toString();
    }

    public Long getLong() throws ToolOutputFormatException {
        try {
            switch (this.type) {
                case OUTPUT_LONG: {
                    return (Long)this.value;
                }
                case OUTPUT_DOUBLE: {
                    return new Long(((Double)this.value).longValue());
                }
                case OUTPUT_BOOLEAN: {
                    return (Boolean)this.value != false ? new Long(1L) : new Long(0L);
                }
                case OUTPUT_STRING: {
                    return Long.parseLong((String)this.value);
                }
                case OUTPUT_COMPLEX: {
                    throw new ToolOutputFormatException("Unable to convert value " + this.value + " to Long.");
                }
            }
            throw new ToolOutputFormatException("Unable to convert value " + this.value + " to Long.");
        }
        catch (Exception e) {
            throw new ToolOutputFormatException("Unable to convert value " + this.value + " to Long.", e);
        }
    }

    public Double getDouble() throws ToolOutputFormatException {
        try {
            switch (this.type) {
                case OUTPUT_LONG: {
                    return new Double(((Long)this.value).doubleValue());
                }
                case OUTPUT_DOUBLE: {
                    return (Double)this.value;
                }
                case OUTPUT_BOOLEAN: {
                    return (Boolean)this.value != false ? new Double(1.0) : new Double(0.0);
                }
                case OUTPUT_STRING: {
                    return Double.parseDouble((String)this.value);
                }
                case OUTPUT_COMPLEX: {
                    throw new ToolOutputFormatException("Unable to convert value " + this.value + " to Double.");
                }
            }
            throw new ToolOutputFormatException("Unable to convert value " + this.value + " to Double.");
        }
        catch (Exception e) {
            throw new ToolOutputFormatException("Unable to convert value " + this.value + " to Double.", e);
        }
    }

    public Boolean getBoolean() throws ToolOutputFormatException {
        try {
            switch (this.type) {
                case OUTPUT_LONG: {
                    return (Long)this.value == 1L;
                }
                case OUTPUT_DOUBLE: {
                    return ((Double)this.value).longValue() == 1L;
                }
                case OUTPUT_BOOLEAN: {
                    return (Boolean)this.value;
                }
                case OUTPUT_STRING: {
                    return Boolean.parseBoolean((String)this.value);
                }
                case OUTPUT_COMPLEX: {
                    throw new ToolOutputFormatException("Unable to convert value " + this.value + " to Boolean.");
                }
            }
            throw new ToolOutputFormatException("Unable to convert value " + this.value + " to Boolean.");
        }
        catch (Exception e) {
            throw new ToolOutputFormatException("Unable to convert value " + this.value + " to Boolean.", e);
        }
    }

    public Object getComplex() throws ToolOutputFormatException {
        return this.value;
    }
}

