/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.usermanagement.dao.hibernate;

import org.apache.commons.lang.StringUtils;
import org.hibernate.Query;
import org.lamsfoundation.lams.dao.hibernate.LAMSBaseDAO;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.UserOrganisationRole;
import org.lamsfoundation.lams.usermanagement.dao.IRoleDAO;
import org.springframework.stereotype.Repository;

@Repository
public class RoleDAO
extends LAMSBaseDAO
implements IRoleDAO {
    private static final String LOAD_USER_BY_ORG_AND_ROLE = "select u from User u, UserOrganisation uo, UserOrganisationRole uor where u.id = :userId and u.id = uo.user.id and uo.organisation = :org and uor.userOrganisation.id = uo.id and uor.role.id = :roleId";
    private static final String COUNT_ROLE = "select count(distinct userOrganisationRole.userOrganisation.user) from " + UserOrganisationRole.class.getName() + " userOrganisationRole" + " where userOrganisationRole.role.roleId = :roleId";
    private static final String COUNT_ROLE_FOR_ORG = "select count(distinct uor.userOrganisation.user) from " + UserOrganisationRole.class.getName() + " uor where uor.role.roleId = :roleId" + " and uor.userOrganisation.organisation.organisationId = :orgId";

    @Override
    public User getUserByOrganisationAndRole(Integer userId, Integer roleId, Organisation organisation) {
        return (User)this.getSession().createQuery(LOAD_USER_BY_ORG_AND_ROLE).setInteger("userId", userId.intValue()).setEntity("org", (Object)organisation).setInteger("roleId", roleId.intValue()).uniqueResult();
    }

    @Override
    public Integer getCountRoleForSystem(Integer roleId) {
        Query query = this.getSession().createQuery(COUNT_ROLE);
        query.setInteger("roleId", roleId.intValue());
        Object value = query.uniqueResult();
        return new Integer(((Number)value).intValue());
    }

    @Override
    public Integer getCountRoleForOrg(Integer roleId, Integer orgId, String searchPhrase) {
        StringBuilder queryTextBuilder = new StringBuilder(COUNT_ROLE_FOR_ORG);
        if (!StringUtils.isBlank((String)searchPhrase)) {
            String[] tokens;
            for (String token : tokens = searchPhrase.trim().split("\\s+")) {
                queryTextBuilder.append(" AND (uor.userOrganisation.user.firstName LIKE '%").append(token).append("%' OR uor.userOrganisation.user.lastName LIKE '%").append(token).append("%' OR uor.userOrganisation.user.login LIKE '%").append(token).append("%')");
            }
        }
        Query query = this.getSession().createQuery(queryTextBuilder.toString());
        query.setInteger("roleId", roleId.intValue());
        query.setInteger("orgId", orgId.intValue());
        Object value = query.uniqueResult();
        return new Integer(((Number)value).intValue());
    }
}

