/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.config.ConfigurationItem;
import org.lamsfoundation.lams.config.Registration;
import org.lamsfoundation.lams.config.dao.IConfigurationDAO;
import org.lamsfoundation.lams.config.dao.IRegistrationDAO;
import org.lamsfoundation.lams.usermanagement.WorkspaceFolder;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.ConfigurationRefreshCacheJob;
import org.lamsfoundation.lams.util.LanguageUtil;
import org.lamsfoundation.lams.util.MessageService;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.springframework.beans.factory.InitializingBean;

public class Configuration
implements InitializingBean {
    protected static Logger log = Logger.getLogger(Configuration.class);
    public static String CONFIGURATION_HELP_PAGE = "LAMS+Configuration";
    public static final int ITEMS_ALL = 1;
    public static final int ITEMS_NON_LDAP = 2;
    public static final int ITEMS_ONLY_LDAP = 3;
    private static Map<String, ConfigurationItem> items = null;
    protected static IConfigurationDAO configurationDAO;
    protected static IRegistrationDAO registrationDAO;
    protected static MessageService messageService;
    protected static Scheduler scheduler;

    public static String get(String key) {
        if (items != null && items.get(key) != null && Configuration.getItemValue(items.get(key)) != null) {
            return Configuration.getItemValue(items.get(key));
        }
        return null;
    }

    public static Map<String, ConfigurationItem> getAll() {
        return items;
    }

    public static boolean getAsBoolean(String key) {
        if (items != null && items.get(key) != null && Configuration.getItemValue(items.get(key)) != null) {
            return new Boolean(Configuration.getItemValue(items.get(key)));
        }
        return false;
    }

    public static int getAsInt(String key) {
        if (items != null && items.get(key) != null && Configuration.getItemValue(items.get(key)) != null) {
            return new Integer(Configuration.getItemValue(items.get(key)));
        }
        return -1;
    }

    public static String getItemValue(Object obj) {
        ConfigurationItem item = (ConfigurationItem)obj;
        if (item.getValue() != null) {
            return item.getValue().trim();
        }
        return null;
    }

    public static Registration getRegistration() {
        return registrationDAO.get();
    }

    public static void refreshCache() {
        Map<String, ConfigurationItem> itemMap = Collections.synchronizedMap(new LinkedHashMap());
        try {
            List<ConfigurationItem> itemList = Configuration.getAllItems();
            if (itemList.size() > 0) {
                for (ConfigurationItem item : itemList) {
                    itemMap.put(item.getKey(), item);
                }
            }
            items = itemMap;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Configuration cache refreshed");
            }
        }
        catch (Exception e) {
            log.error((Object)"Exception while refreshing Configuration cache", (Throwable)e);
        }
    }

    public static void saveOrUpdateRegistration(Registration reg) {
        registrationDAO.saveOrUpdate(reg);
    }

    public static void setItemValue(Object obj, String value) {
        ConfigurationItem item = (ConfigurationItem)obj;
        item.setValue(value);
    }

    public static void updateItem(String key, String value) {
        if (value != null) {
            value = value.trim();
        }
        if (items.containsKey(key)) {
            Configuration.setItemValue(items.get(key), value);
        }
    }

    private static List<ConfigurationItem> getAllItems() {
        return configurationDAO.getAllItems();
    }

    public void afterPropertiesSet() {
        Integer refreshCacheInterval;
        if (items != null) {
            return;
        }
        Configuration.refreshCache();
        if (items == null) {
            return;
        }
        String refreshCacheIntervalString = Configuration.get(ConfigurationKeys.CONFIGURATION_CACHE_REFRESH_INTERVAL);
        Integer n = refreshCacheInterval = StringUtils.isBlank((String)refreshCacheIntervalString) ? null : Integer.valueOf(refreshCacheIntervalString);
        if (refreshCacheInterval != null && refreshCacheInterval > 0) {
            JobDetail jobDetail = JobBuilder.newJob(ConfigurationRefreshCacheJob.class).withIdentity("configurationCacheRefresh").build();
            try {
                if (scheduler.checkExists(jobDetail.getKey())) {
                    return;
                }
                Trigger trigger = TriggerBuilder.newTrigger().withIdentity("configurationCacheRefreshTrigger").withSchedule((ScheduleBuilder)SimpleScheduleBuilder.repeatMinutelyForever((int)refreshCacheInterval)).build();
                scheduler.scheduleJob(jobDetail, trigger);
            }
            catch (SchedulerException e) {
                log.error((Object)"Error while scheduling Configuration cache refresh. The cache will NOT be periodically updated.", (Throwable)e);
            }
        }
    }

    public HashMap<String, ArrayList<ConfigurationItem>> arrangeItems() {
        return this.arrangeItems(1);
    }

    /*
     * Enabled aggressive block sorting
     */
    public HashMap<String, ArrayList<ConfigurationItem>> arrangeItems(int filter) {
        List<ConfigurationItem> originalList = Configuration.getAllItems();
        HashMap<String, ArrayList<ConfigurationItem>> groupedList = new HashMap<String, ArrayList<ConfigurationItem>>();
        int i = 0;
        while (true) {
            block8: {
                if (i >= originalList.size()) {
                    return groupedList;
                }
                ConfigurationItem item = originalList.get(i);
                String header = item.getHeaderName();
                switch (filter) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        if (!StringUtils.contains((String)header, (String)"config.header.ldap")) break;
                        break block8;
                    }
                    case 3: {
                        if (!StringUtils.contains((String)header, (String)"config.header.ldap")) break block8;
                    }
                }
                if (!groupedList.containsKey(header)) {
                    groupedList.put(header, new ArrayList());
                }
                ArrayList<ConfigurationItem> currentList = groupedList.get(header);
                currentList.add(item);
                groupedList.put(header, currentList);
            }
            ++i;
        }
    }

    public ConfigurationItem getConfigItemByKey(String key) {
        if (items != null && items.get(key) != null && items.get(key) != null) {
            return items.get(key);
        }
        return null;
    }

    public MessageService getMessageService() {
        return messageService;
    }

    public IRegistrationDAO getRegistrationDAO() {
        return registrationDAO;
    }

    public void persistUpdate() {
        this.updatePublicFolderName();
        configurationDAO.insertOrUpdateAll(items.values());
    }

    public void setConfigurationDAO(IConfigurationDAO configurationDAO) {
        Configuration.configurationDAO = configurationDAO;
    }

    public void setMessageService(MessageService messageService) {
        Configuration.messageService = messageService;
    }

    public void setRegistrationDAO(IRegistrationDAO registrationDAO) {
        Configuration.registrationDAO = registrationDAO;
    }

    public void setScheduler(Scheduler scheduler) {
        Configuration.scheduler = scheduler;
    }

    public String toString() {
        return "Configuration items:" + (items != null ? items.toString() : "none");
    }

    private void updatePublicFolderName() {
        WorkspaceFolder publicFolder = null;
        List list = configurationDAO.findByProperty(WorkspaceFolder.class, "workspaceFolderType", WorkspaceFolder.PUBLIC_SEQUENCES);
        if (list != null && list.size() > 0) {
            publicFolder = (WorkspaceFolder)list.get(0);
            String[] langCountry = LanguageUtil.getDefaultLangCountry();
            Locale locale = new Locale(langCountry[0], langCountry[1]);
            publicFolder.setName(messageService.getMessageSource().getMessage("public.folder.name", null, locale));
            configurationDAO.update(publicFolder);
        }
    }
}

