/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.apache.commons.codec.binary.Hex;

public class HashUtil {
    private static final SecureRandom secureRandom = new SecureRandom();
    public static final int SALT_BYTE_LENGTH = 32;
    public static final int SALT_HEX_LENGTH = 64;
    public static final int SHA1_HEX_LENGTH = 40;
    public static final int SHA256_HEX_LENGTH = 64;

    public static String sha1(String plaintext) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            return new String(Hex.encodeHex((byte[])md.digest(plaintext.getBytes())));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String sha256(String plaintext) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            return new String(Hex.encodeHex((byte[])md.digest(plaintext.getBytes())));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String sha256(String password, String salt) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            String plaintext = salt + password;
            return new String(Hex.encodeHex((byte[])md.digest(plaintext.getBytes())));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String md5(String plaintext) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return new String(Hex.encodeHex((byte[])md.digest(plaintext.getBytes())));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String salt() {
        return HashUtil.salt(32);
    }

    public static String salt(int length) {
        byte[] salt = new byte[length];
        secureRandom.nextBytes(salt);
        return Hex.encodeHexString((byte[])salt);
    }
}

