/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.WebUtil;

public class ValidationUtil {
    private static final Pattern REGEX_USER_NAME = Pattern.compile("^[^<>^!#&()/\\|\"?,:{}= ~`*%$]*$");
    private static final Pattern REGEX_FIRST_LAST_NAME = Pattern.compile("^[\\p{L}]++(?:[' -][\\p{L}]++)*+\\.?$");
    private static final Pattern REGEX_EMAIL = Pattern.compile("^[_A-Za-z0-9-\\+']+(\\.[_A-Za-z0-9-']+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$");
    private static final Pattern REGEX_ORGANISATION_NAME = Pattern.compile("^[^<>^*@%$]*$");

    public static boolean isUserNameValid(String userName) {
        boolean isValidationRequired = Configuration.getAsBoolean(ConfigurationKeys.USER_VALIDATION_REQUIRED_USERNAME);
        if (isValidationRequired) {
            return ValidationUtil.isRegexMatches(REGEX_USER_NAME, userName);
        }
        return true;
    }

    public static boolean isFirstLastNameValid(String name) {
        boolean isValidationRequired = Configuration.getAsBoolean(ConfigurationKeys.USER_VALIDATION_REQUIRED_FIRST_LAST_NAME);
        if (isValidationRequired) {
            return ValidationUtil.isRegexMatches(REGEX_FIRST_LAST_NAME, name);
        }
        return true;
    }

    public static boolean isEmailValid(String email) {
        return ValidationUtil.isEmailValid(email, true);
    }

    public static boolean isEmailValid(String email, boolean checkConfiguration) {
        boolean isValidationRequired = Configuration.getAsBoolean(ConfigurationKeys.USER_VALIDATION_REQUIRED_EMAIL);
        if (!checkConfiguration || checkConfiguration && isValidationRequired) {
            return ValidationUtil.isRegexMatches(REGEX_EMAIL, email);
        }
        return true;
    }

    public static boolean isOrgNameValid(String orgName) {
        boolean isOrgNameValid = ValidationUtil.isRegexMatches(REGEX_ORGANISATION_NAME, orgName);
        return isOrgNameValid;
    }

    private static boolean isRegexMatches(Pattern pattern, String input) {
        if (input == null) {
            return true;
        }
        Matcher m = pattern.matcher(input.trim());
        return m.matches();
    }

    public static boolean isMinWordsLimitReached(String text, int minWordsLimit, boolean isDerivedFromCKEditor) {
        if (minWordsLimit <= 0) {
            return true;
        }
        if (StringUtils.isBlank((String)text)) {
            return false;
        }
        text = isDerivedFromCKEditor ? WebUtil.removeHTMLtags(text) : text.replaceAll("(?:<BR>)", " ");
        int wordCount = text.length() == 0 ? 0 : text.replaceAll("['\";:,\\.\\?\\-!]+", "").trim().split("\\S+").length;
        return wordCount >= minWordsLimit;
    }
}

