/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util.hibernate;

import javax.servlet.ServletContext;
import org.hibernate.SessionFactory;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.orm.hibernate4.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class HibernateSessionManager {
    private static SessionFactory sessionFactory;

    public static void bindHibernateSessionToCurrentThread(boolean recreate) {
        SessionFactory sessionFactory = HibernateSessionManager.getSessionFactory();
        Object session = TransactionSynchronizationManager.getResource((Object)sessionFactory);
        if (session != null) {
            if (recreate) {
                TransactionSynchronizationManager.unbindResource((Object)sessionFactory);
            } else {
                return;
            }
        }
        SessionHolder sessionHolder = new SessionHolder(sessionFactory.openSession());
        TransactionSynchronizationManager.bindResource((Object)sessionFactory, (Object)sessionHolder);
    }

    private static SessionFactory getSessionFactory() {
        if (sessionFactory == null) {
            WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)SessionManager.getServletContext());
            sessionFactory = (SessionFactory)wac.getBean("coreSessionFactory");
        }
        return sessionFactory;
    }
}

