/*
 * Decompiled with CFR 0.152.
 */
package com.tacitknowledge.util.discovery;

import com.tacitknowledge.util.discovery.ResourceCriteria;
import com.tacitknowledge.util.discovery.ResourceListSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class AggregateResourceListSource
implements ResourceListSource {
    private List sources = new ArrayList();

    public AggregateResourceListSource() {
    }

    public AggregateResourceListSource(List l) {
        if (l == null) {
            throw new IllegalArgumentException("ResourceListSources list cannot be null");
        }
        this.sources.addAll(l);
    }

    public AggregateResourceListSource(ResourceListSource[] sources) {
        if (sources == null) {
            throw new IllegalArgumentException("ResourceListSources array cannot be null");
        }
        this.sources.addAll(Arrays.asList(sources));
    }

    public String[] getResources(String basePath, ResourceCriteria criteria) {
        HashSet<String> resourceNames = new HashSet<String>();
        for (ResourceListSource source : this.sources) {
            resourceNames.addAll(Arrays.asList(source.getResources(basePath, criteria)));
        }
        return resourceNames.toArray(new String[resourceNames.size()]);
    }

    public void addResourceListSource(ResourceListSource source) {
        this.sources.add(source);
    }
}

