/*
 * Decompiled with CFR 0.152.
 */
package com.tacitknowledge.util.discovery;

import com.tacitknowledge.util.discovery.AggregateResourceListSource;
import com.tacitknowledge.util.discovery.ArchiveResourceListSource;
import com.tacitknowledge.util.discovery.ClassCriteria;
import com.tacitknowledge.util.discovery.DirectoryResourceListSource;
import com.tacitknowledge.util.discovery.RegexResourceCriteria;
import com.tacitknowledge.util.discovery.ResourceListSource;
import java.io.File;
import java.util.ArrayList;

public final class ClassDiscoveryUtil {
    private static AggregateResourceListSource classpathResources = null;

    private ClassDiscoveryUtil() {
    }

    public static void addResourceListSource(ResourceListSource source) {
        classpathResources.addResourceListSource(source);
    }

    public static String[] getResources(String basePath) {
        return ClassDiscoveryUtil.getResources(basePath, null);
    }

    public static String[] getResources(String basePath, String regex) {
        RegexResourceCriteria criteria = new RegexResourceCriteria(regex);
        String[] resourcesNames = classpathResources.getResources(basePath, criteria);
        return resourcesNames;
    }

    public static Class[] getClasses(String basePackage, Class requiredInterface) {
        return ClassDiscoveryUtil.getClasses(basePackage, new Class[]{requiredInterface});
    }

    public static Class[] getClasses(String basePackage, Class[] requiredInterfaces) {
        ArrayList classes = new ArrayList();
        ClassCriteria criteria = new ClassCriteria(requiredInterfaces);
        String basePath = basePackage.replace('.', File.separatorChar);
        String[] resourcesNames = classpathResources.getResources(basePath, criteria);
        for (int i = 0; i < resourcesNames.length; ++i) {
            String resourceName = resourcesNames[i];
            if (resourceName == null) continue;
            String className = ClassDiscoveryUtil.getClassName(resourceName);
            try {
                Class<?> c = Class.forName(className);
                classes.add(c);
                continue;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        return classes.toArray(new Class[classes.size()]);
    }

    public static String getClassName(String resourceName) {
        String className = resourceName.replace(File.separatorChar, '.');
        if (className.length() > 7) {
            className = className.substring(0, className.length() - 6);
        }
        return className;
    }

    static {
        classpathResources = new AggregateResourceListSource(new ResourceListSource[]{new DirectoryResourceListSource(), new ArchiveResourceListSource()});
    }
}

