/*
 * Decompiled with CFR 0.152.
 */
package com.tacitknowledge.util.discovery;

import com.tacitknowledge.util.discovery.ClasspathUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClasspathFileReader {
    private static final int MILLIS_PER_SECOND = 1000;
    private Log log = LogFactory.getLog(this.getClass());
    private Map cache = new HashMap();
    private long lastTimeDiskWasAccessed = 0L;
    private long reloadMillis = 0L;

    public File getFile(String fileName) throws FileNotFoundException {
        String methodName = "getFile(): ";
        this.lastTimeDiskWasAccessed = System.currentTimeMillis();
        List classpath = ClasspathUtils.getClasspathDirectories();
        this.log.debug((Object)("getFile(): looking for file '" + fileName + "' in classpath"));
        File file = this.findFile(fileName, classpath);
        if (file != null) {
            this.log.debug((Object)("getFile():  found file '" + fileName + "'"));
            return file;
        }
        this.log.debug((Object)("getFile():  did not find file '" + fileName + "'"));
        throw new FileNotFoundException("Could not locate file in classpath");
    }

    private File findFile(String fileName, List path) {
        String methodName = "findFile(): ";
        String fileSeparator = System.getProperty("file.separator");
        for (String directory : path) {
            if (!directory.endsWith(fileSeparator) && !fileName.startsWith(fileSeparator)) {
                directory = directory + fileSeparator;
            }
            File file = new File(directory + fileName);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("findFile():  checking '" + file.getAbsolutePath() + "'"));
            }
            if (!file.exists() || !file.canRead()) continue;
            this.log.debug((Object)("findFile():  found it - file is '" + file.getAbsolutePath() + "'"));
            this.cache.put(fileName, new CacheEntry(file));
            return file;
        }
        return null;
    }

    public InputStream getResourceAsStream(String fileName) {
        try {
            File file = this.getFile(fileName);
            this.cache.put(fileName, new CacheEntry(file));
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
            if (is != null) {
                this.cache.put(fileName, new CacheEntry());
            }
            return is;
        }
    }

    public boolean isModified(String fileName) {
        if (this.lastTimeDiskWasAccessed + this.reloadMillis > System.currentTimeMillis()) {
            return false;
        }
        this.lastTimeDiskWasAccessed = System.currentTimeMillis();
        CacheEntry cacheEntry = (CacheEntry)this.cache.get(fileName);
        if (cacheEntry != null) {
            return cacheEntry.isModified();
        }
        return true;
    }

    public void setReloadSeconds(int seconds) {
        this.reloadMillis = seconds * 1000;
    }

    public int getReloadSeconds() {
        return (int)this.reloadMillis / 1000;
    }

    private class CacheEntry {
        private String fullPath = null;
        private long lastModTime = 0L;
        private boolean isFileDirectlyOnDisk = true;

        public CacheEntry() {
            this.isFileDirectlyOnDisk = false;
        }

        public CacheEntry(File file) {
            this.fullPath = file.getAbsolutePath();
            this.lastModTime = file.lastModified();
        }

        public boolean isModified() {
            if (this.isFileDirectlyOnDisk) {
                File file = new File(this.fullPath);
                if (!file.exists()) {
                    return true;
                }
                return this.lastModTime != file.lastModified();
            }
            return false;
        }
    }
}

