/*
 * Decompiled with CFR 0.152.
 */
package com.tacitknowledge.util.discovery;

import com.tacitknowledge.util.discovery.JarFilter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ClasspathUtils {
    private static Log log = LogFactory.getLog(ClasspathUtils.class);

    private ClasspathUtils() {
    }

    public static List getClasspathDirectories() {
        ArrayList<String> directories = new ArrayList<String>();
        List components = ClasspathUtils.getClasspathComponents();
        for (String possibleDir : components) {
            File file = new File(possibleDir);
            if (!file.isDirectory()) continue;
            directories.add(possibleDir);
        }
        List tomcatPaths = ClasspathUtils.getTomcatPaths();
        if (tomcatPaths != null) {
            directories.addAll(tomcatPaths);
        }
        return directories;
    }

    public static List getClasspathArchives() {
        ArrayList<String> archives = new ArrayList<String>();
        List components = ClasspathUtils.getClasspathComponents();
        for (String possibleDir : components) {
            File file = new File(possibleDir);
            if (!file.isFile() || !file.getName().endsWith(".jar") && !file.getName().endsWith(".zip")) continue;
            log.debug((Object)("Found archive " + file.getAbsolutePath()));
            archives.add(possibleDir);
        }
        return archives;
    }

    public static List getClasspathComponents() {
        File currentDir;
        LinkedList<String> components = new LinkedList<String>();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        while (null != cl && cl instanceof URLClassLoader) {
            URLClassLoader ucl = (URLClassLoader)cl;
            components.addAll(ClasspathUtils.getUrlClassLoaderClasspathComponents(ucl));
            try {
                cl = ucl.getParent();
            }
            catch (SecurityException se) {
                cl = null;
            }
        }
        String classpath = System.getProperty("java.class.path");
        String separator = System.getProperty("path.separator");
        StringTokenizer st = new StringTokenizer(classpath, separator);
        while (st.hasMoreTokens()) {
            String component = st.nextToken();
            component = ClasspathUtils.getCanonicalPath(component);
            log.debug((Object)("System classpath: " + component));
            components.add(component);
        }
        URL url = ClasspathUtils.class.getProtectionDomain().getCodeSource().getLocation();
        String path = url.getPath();
        String realPath = path.substring(path.indexOf(58) + 1);
        File thisJar = new File(realPath);
        if (thisJar != null && (currentDir = thisJar.getParentFile()).isDirectory()) {
            File[] jars;
            for (File jar : jars = currentDir.listFiles(new JarFilter())) {
                try {
                    components.add(jar.getCanonicalPath());
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage());
                    e.printStackTrace();
                }
            }
        }
        return new LinkedList(new HashSet(components));
    }

    public static String getCanonicalPath(String path) {
        File file = new File(path);
        String canonicalPath = null;
        if (file.exists()) {
            try {
                canonicalPath = file.getCanonicalPath();
            }
            catch (IOException e) {
                log.warn((Object)("Error resolving filename to canonical file: " + e.toString()));
            }
        }
        if (canonicalPath == null) {
            canonicalPath = file.getPath();
        }
        return canonicalPath;
    }

    private static List getUrlClassLoaderClasspathComponents(URLClassLoader ucl) {
        ArrayList<String> components = new ArrayList<String>();
        URL[] urls = new URL[]{};
        log.debug((Object)("URLClassLoader.getName() = " + ucl.getClass().getName()));
        if (ucl.getClass().getName().equals("org.jboss.mx.loading.UnifiedClassLoader3")) {
            try {
                Method classPathMethod = ucl.getClass().getMethod("getClasspath", new Class[0]);
                urls = (URL[])classPathMethod.invoke((Object)ucl, new Object[0]);
            }
            catch (Exception e) {
                LogFactory.getLog(ClasspathUtils.class).debug((Object)"Error invoking getClasspath on UnifiedClassLoader3: ", (Throwable)e);
            }
        } else {
            urls = ucl.getURLs();
        }
        for (int i = 0; i < urls.length; ++i) {
            URL url = urls[i];
            String path = ClasspathUtils.getCanonicalPath(url.getPath());
            components.add(path);
            log.debug((Object)("URLClassLoader found path: " + path));
        }
        return components;
    }

    private static List getTomcatPaths() {
        String tomcatPath = System.getProperty("catalina.home");
        if (tomcatPath == null) {
            return null;
        }
        String commonClasspath = System.getProperty("common.loader");
        if (commonClasspath == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(commonClasspath);
        String pathDeclaration = "${catalina.home}";
        int length = pathDeclaration.length();
        boolean doneReplace = false;
        do {
            int start;
            if ((start = commonClasspath.indexOf(pathDeclaration)) >= 0) {
                buffer.replace(start, start + length, tomcatPath);
                commonClasspath = buffer.toString();
                continue;
            }
            doneReplace = true;
        } while (!doneReplace);
        String[] paths = commonClasspath.split(",");
        ArrayList<String> pathList = new ArrayList<String>(paths.length);
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i];
            pathList.add(ClasspathUtils.getCanonicalPath(path));
        }
        return pathList;
    }
}

