/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.integration.security;

import com.warrenstrange.googleauth.GoogleAuthenticator;
import io.undertow.Handlers;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.servlet.ServletExtension;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.HttpSessionImpl;
import io.undertow.util.Headers;
import java.io.IOException;
import java.security.AccessController;
import java.util.Date;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.usermanagement.service.UserManagementService;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.audit.IAuditService;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SsoHandler
implements ServletExtension {
    private static IAuditService auditService = null;
    private static IUserManagementService userManagementService = null;
    protected static final String SESSION_KEY = "io.undertow.servlet.form.auth.redirect.location";
    public static final String NO_FLUSH_FLAG = "noFlush";

    public void handleDeployment(DeploymentInfo deploymentInfo, ServletContext servletContext) {
        SessionManager.setServletContext(servletContext);
        deploymentInfo.addOuterHandlerChainWrapper(handler -> Handlers.path().addPrefixPath("/", handler).addExactPath("/j_security_check", exchange -> {
            Object gAuth;
            ServletRequestContext context = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
            HttpServletResponse response = (HttpServletResponse)context.getServletResponse();
            HttpServletRequest request = (HttpServletRequest)context.getServletRequest();
            if (SessionManager.getJvmRoute() == null) {
                SsoHandler.setJvmRoute(request);
            }
            HttpSession session = request.getSession();
            String login = request.getParameter("j_username");
            User user = null;
            if (StringUtils.isBlank((String)login)) {
                this.serveLoginPage(exchange, "/login.jsp?failed=true");
                return;
            }
            user = this.getUserManagementService(session.getServletContext()).getUserByLogin(login);
            if (user == null) {
                this.serveLoginPage(exchange, "/login.jsp?failed=true");
                return;
            }
            UserDTO userDTO = user.getUserDTO();
            String password = request.getParameter("j_password");
            if (user.getLockOutTime() != null && user.getLockOutTime().getTime() > System.currentTimeMillis() && password != null && !password.startsWith("#LAMS")) {
                this.serveLoginPage(exchange, "/login.jsp?lockedOut=true");
                return;
            }
            String redirectURL = request.getParameter("redirectURL");
            if (!StringUtils.isBlank((String)redirectURL)) {
                SsoHandler.handleRedirectBack(context, redirectURL);
            }
            if (request.getRemoteUser() == null && user.isTwoFactorAuthenticationEnabled().booleanValue() && user.getTwoFactorAuthenticationSecret() != null) {
                String verificationCodeStr = request.getParameter("verificationCode");
                int verificationCode = NumberUtils.toInt((String)verificationCodeStr);
                gAuth = new GoogleAuthenticator();
                boolean isCodeValid = gAuth.authorize(user.getTwoFactorAuthenticationSecret(), verificationCode);
                if (!isCodeValid) {
                    session.setAttribute("login", (Object)login);
                    session.setAttribute("password", (Object)password);
                    String redirectUrl = "/lams/loginTwoFactorAuth.jsp" + (verificationCodeStr == null ? "" : "?failed=true");
                    response.sendRedirect(redirectUrl);
                    return;
                }
            }
            SessionManager.removeSessionByID(session.getId(), false);
            session = request.getSession();
            SessionManager.startSession(request);
            handler.handleRequest(exchange);
            if (login.equals(request.getRemoteUser())) {
                session.setAttribute("user", (Object)userDTO);
                HttpSession existingSession = SessionManager.getSessionForLogin(login);
                if (existingSession != null) {
                    try {
                        existingSession.setAttribute(NO_FLUSH_FLAG, (Object)true);
                    }
                    catch (IllegalStateException verificationCode) {
                        // empty catch block
                    }
                    SessionManager.removeSessionByLogin(login, true);
                }
                SessionManager.addSession(login, session);
                Integer failedAttempts2 = user.getFailedAttempts();
                if (failedAttempts2 != null && failedAttempts2 > 0 && password != null && !password.startsWith("#LAMS")) {
                    user.setFailedAttempts(null);
                    user.setLockOutTime(null);
                    this.getUserManagementService(session.getServletContext()).save(user);
                }
            } else {
                Integer failedAttempts = user.getFailedAttempts();
                if (failedAttempts == null) {
                    failedAttempts = 1;
                } else {
                    Integer failedAttempts2 = failedAttempts;
                    failedAttempts = failedAttempts + 1;
                    gAuth = failedAttempts;
                }
                user.setFailedAttempts(failedAttempts);
                Integer failedAttemptsConfig = Configuration.getAsInt(ConfigurationKeys.FAILED_ATTEMPTS);
                if (failedAttempts >= failedAttemptsConfig) {
                    Integer lockOutTimeConfig = Configuration.getAsInt(ConfigurationKeys.LOCK_OUT_TIME);
                    Long lockOutTimeMillis = (long)lockOutTimeConfig.intValue() * 60L * 1000L;
                    Long currentTimeMillis = System.currentTimeMillis();
                    Date date = new Date(currentTimeMillis + lockOutTimeMillis);
                    user.setLockOutTime(date);
                    this.getAuditService(session.getServletContext()).log(userDTO, "sso", "User is locked out for " + Configuration.getAsInt(ConfigurationKeys.LOCK_OUT_TIME) + " mins after " + failedAttempts + " failed attempts.");
                }
                this.getUserManagementService(session.getServletContext()).save(user);
            }
            SessionManager.endSession();
        }));
    }

    protected Integer serveLoginPage(HttpServerExchange exchange, String location) throws ServletException, IOException {
        ServletRequestContext context = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        HttpServletRequest request = (HttpServletRequest)context.getServletRequest();
        HttpServletResponse response = (HttpServletResponse)context.getServletResponse();
        exchange.getResponseHeaders().add(Headers.CACHE_CONTROL, "no-cache, no-store, must-revalidate");
        exchange.getResponseHeaders().add(Headers.PRAGMA, "no-cache");
        exchange.getResponseHeaders().add(Headers.EXPIRES, "0");
        request.getRequestDispatcher(location).forward((ServletRequest)request, (ServletResponse)response);
        return null;
    }

    protected static void handleRedirectBack(ServletRequestContext context, String redirectURL) {
        if (redirectURL.contains("\n") || redirectURL.contains("\r")) {
            throw new SecurityException("redirectURL contains forbidden characters: \\n or \\r. Possible HTTP Response Splitting attack.");
        }
        HttpSessionImpl httpSession = context.getCurrentServletContext().getSession(context.getExchange(), true);
        if (httpSession != null) {
            Session session = System.getSecurityManager() == null ? httpSession.getSession() : (Session)AccessController.doPrivileged(new HttpSessionImpl.UnwrapSessionAction((HttpSession)httpSession));
            session.setAttribute(SESSION_KEY, (Object)redirectURL);
        }
    }

    protected static void setJvmRoute(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return;
        }
        for (Cookie cookie : cookies) {
            int index;
            if (!cookie.getName().equals("JSESSIONID") || (index = cookie.getValue().indexOf(46)) <= 0) continue;
            SessionManager.setJvmRoute(cookie.getValue().substring(index + 1));
            return;
        }
    }

    protected IUserManagementService getUserManagementService(ServletContext context) {
        if (userManagementService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)context);
            userManagementService = (UserManagementService)ctx.getBean("userManagementService");
        }
        return userManagementService;
    }

    protected IAuditService getAuditService(ServletContext context) {
        if (auditService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)context);
            auditService = (IAuditService)ctx.getBean("auditService");
        }
        return auditService;
    }
}

