/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.dto;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ActivityDTOOrderComparator;
import org.lamsfoundation.lams.learningdesign.Competence;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.LearningDesignAnnotation;
import org.lamsfoundation.lams.learningdesign.Transition;
import org.lamsfoundation.lams.learningdesign.dao.IActivityDAO;
import org.lamsfoundation.lams.learningdesign.dao.IGroupingDAO;
import org.lamsfoundation.lams.learningdesign.dto.AuthoringActivityDTO;
import org.lamsfoundation.lams.learningdesign.dto.BaseDTO;
import org.lamsfoundation.lams.learningdesign.dto.CompetenceDTO;
import org.lamsfoundation.lams.learningdesign.dto.GroupingDTO;
import org.lamsfoundation.lams.learningdesign.dto.TransitionDTO;

public class LearningDesignDTO
extends BaseDTO {
    private Long learningDesignID;
    private Integer learningDesignUIID;
    private String description;
    private String title;
    private Long firstActivityID;
    private Integer firstActivityUIID;
    private Long floatingActivityID;
    private Integer floatingActivityUIID;
    private Integer maxID;
    private Boolean validDesign;
    private Boolean readOnly;
    private Boolean editOverrideLock;
    private Date dateReadOnly;
    private Integer userID;
    private Integer originalUserID;
    private Integer editOverrideUserID;
    private String editOverrideUserFullName;
    private String helpText;
    private Integer copyTypeID;
    private Date createDateTime;
    private String version;
    private Integer designVersion;
    private Long originalLearningDesignID;
    private Integer workspaceFolderID;
    private Long duration;
    private String licenseText;
    private Long licenseID;
    private Date lastModifiedDateTime;
    private String contentFolderID;
    private String designType;
    private ArrayList groupings;
    private ArrayList activities;
    private ArrayList transitions;
    private ArrayList branchMappings;
    private ArrayList<CompetenceDTO> competences;
    private ArrayList<LearningDesignAnnotation> annotations;

    public LearningDesignDTO() {
    }

    public LearningDesignDTO(LearningDesign learningDesign, IActivityDAO activityDAO, IGroupingDAO groupingDAO, String languageCode) {
        this.learningDesignID = learningDesign.getLearningDesignId();
        this.learningDesignUIID = learningDesign.getLearningDesignUIID();
        this.description = learningDesign.getDescription();
        this.title = learningDesign.getTitle();
        this.firstActivityID = learningDesign.getFirstActivity() != null ? learningDesign.getFirstActivity().getActivityId() : null;
        this.firstActivityUIID = learningDesign.getFirstActivity() != null ? learningDesign.getFirstActivity().getActivityUIID() : null;
        this.floatingActivityID = learningDesign.getFirstActivity() != null ? learningDesign.getFirstActivity().getActivityId() : null;
        this.floatingActivityUIID = learningDesign.getFloatingActivity() != null ? learningDesign.getFloatingActivity().getActivityUIID() : null;
        this.maxID = learningDesign.getMaxID();
        this.validDesign = learningDesign.getValidDesign();
        this.designVersion = learningDesign.getDesignVersion();
        this.readOnly = learningDesign.getReadOnly();
        this.editOverrideLock = learningDesign.getEditOverrideLock();
        this.dateReadOnly = learningDesign.getDateReadOnly();
        this.userID = learningDesign.getUser() != null ? learningDesign.getUser().getUserId() : null;
        this.originalUserID = learningDesign.getOriginalUser() != null ? learningDesign.getOriginalUser().getUserId() : null;
        this.editOverrideUserID = learningDesign.getEditOverrideUser() != null ? learningDesign.getEditOverrideUser().getUserId() : null;
        this.editOverrideUserFullName = learningDesign.getEditOverrideUser() != null ? learningDesign.getEditOverrideUser().getFullName() : null;
        this.helpText = learningDesign.getHelpText();
        this.copyTypeID = learningDesign.getCopyTypeID();
        this.contentFolderID = learningDesign.getContentFolderID();
        this.createDateTime = learningDesign.getCreateDateTime();
        this.version = learningDesign.getVersion();
        this.originalLearningDesignID = learningDesign.getOriginalLearningDesign() != null ? learningDesign.getOriginalLearningDesign().getLearningDesignId() : null;
        this.workspaceFolderID = learningDesign.getWorkspaceFolder() != null ? learningDesign.getWorkspaceFolder().getWorkspaceFolderId() : null;
        this.duration = learningDesign.getDuration();
        this.licenseText = learningDesign.getLicenseText();
        this.licenseID = learningDesign.getLicense() != null ? learningDesign.getLicense().getLicenseID() : null;
        this.designType = learningDesign.getDesignType();
        this.lastModifiedDateTime = learningDesign.getLastModifiedDateTime();
        this.branchMappings = new ArrayList();
        this.groupings = this.populateGroupings(learningDesign, groupingDAO);
        this.activities = this.populateActivities(learningDesign, languageCode);
        this.transitions = this.populateTransitions(learningDesign);
        this.competences = this.populateCompetences(learningDesign);
        this.annotations = new ArrayList();
        this.annotations.addAll(learningDesign.getAnnotations());
    }

    public String getContentFolderID() {
        return this.contentFolderID;
    }

    public Integer getCopyTypeID() {
        return this.copyTypeID;
    }

    public Date getCreateDateTime() {
        return this.createDateTime;
    }

    public Date getDateReadOnly() {
        return this.dateReadOnly;
    }

    public String getDescription() {
        return this.description;
    }

    public Long getDuration() {
        return this.duration;
    }

    public Long getFirstActivityID() {
        return this.firstActivityID;
    }

    public Long getFloatingActivityID() {
        return this.floatingActivityID;
    }

    public String getHelpText() {
        return this.helpText;
    }

    public Date getLastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    public Long getLearningDesignID() {
        return this.learningDesignID;
    }

    public Integer getLearningDesignUIID() {
        return this.learningDesignUIID;
    }

    public Long getLicenseID() {
        return this.licenseID;
    }

    public String getLicenseText() {
        return this.licenseText;
    }

    public Integer getMaxID() {
        return this.maxID;
    }

    public Long getOriginalLearningDesignID() {
        return this.originalLearningDesignID;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public Boolean getEditOverrideLock() {
        return this.editOverrideLock;
    }

    public String getTitle() {
        return this.title;
    }

    public Integer getUserID() {
        return this.userID;
    }

    public Integer getOriginalUserID() {
        return this.originalUserID;
    }

    public Integer getEditOverrideUserID() {
        return this.editOverrideUserID;
    }

    public String getEditOverrideUserFullName() {
        return this.editOverrideUserFullName;
    }

    public Boolean getValidDesign() {
        return this.validDesign;
    }

    public String getVersion() {
        return this.version;
    }

    public Integer getDesignVersion() {
        return this.designVersion;
    }

    public Integer getWorkspaceFolderID() {
        return this.workspaceFolderID;
    }

    public ArrayList getActivities() {
        return this.activities;
    }

    public ArrayList populateGroupings(LearningDesign design, IGroupingDAO groupingDAO) {
        ArrayList<GroupingDTO> groupingList = new ArrayList<GroupingDTO>();
        List dbGroupings = groupingDAO.getGroupingsByLearningDesign(design.getLearningDesignId());
        if (dbGroupings != null) {
            for (Grouping grouping : dbGroupings) {
                groupingList.add(grouping.getGroupingDTO(false));
            }
        }
        return groupingList;
    }

    public ArrayList populateActivities(LearningDesign design, String languageCode) {
        TreeSet<AuthoringActivityDTO> dtoSet = new TreeSet<AuthoringActivityDTO>(new ActivityDTOOrderComparator());
        for (Activity object : design.getParentActivities()) {
            dtoSet.addAll(object.getAuthoringActivityDTOSet(this.branchMappings, languageCode));
        }
        return new ArrayList<AuthoringActivityDTO>(dtoSet);
    }

    public ArrayList populateTransitions(LearningDesign design) {
        ArrayList<TransitionDTO> transitions = new ArrayList<TransitionDTO>();
        if (design.getTransitions() != null) {
            for (Transition trans : design.getTransitions()) {
                transitions.add(trans.getTransitionDTO());
            }
        }
        return transitions;
    }

    public ArrayList<CompetenceDTO> populateCompetences(LearningDesign design) {
        ArrayList<CompetenceDTO> competenceDTOs = new ArrayList<CompetenceDTO>();
        if (design.getCompetences() != null) {
            for (Competence competence : design.getCompetences()) {
                CompetenceDTO competenceDTO = new CompetenceDTO(competence);
                competenceDTOs.add(competenceDTO);
            }
        }
        return competenceDTOs;
    }

    public ArrayList getTransitions() {
        return this.transitions;
    }

    public void setActivities(ArrayList activities) {
        this.activities = activities;
    }

    public void setContentFolderID(String contentFolderID) {
        this.contentFolderID = contentFolderID;
    }

    public void setCopyTypeID(Integer copyTypeID) {
        this.copyTypeID = copyTypeID;
    }

    public void setCreateDateTime(Date createDateTime) {
        this.createDateTime = createDateTime;
    }

    public void setDateReadOnly(Date dateReadOnly) {
        this.dateReadOnly = dateReadOnly;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public void setFirstActivityID(Long firstActivityID) {
        this.firstActivityID = firstActivityID;
    }

    public void setFloatingActivityID(Long floatingActivityID) {
        this.floatingActivityID = floatingActivityID;
    }

    public void setHelpText(String helpText) {
        this.helpText = helpText;
    }

    public void setLastModifiedDateTime(Date lastModifiedDateTime) {
        this.lastModifiedDateTime = lastModifiedDateTime;
    }

    public void setLearningDesignID(Long learningDesignId) {
        this.learningDesignID = learningDesignId;
    }

    public void setLearningDesignUIID(Integer learningDesignUIID) {
        this.learningDesignUIID = learningDesignUIID;
    }

    public void setLicenseID(Long licenseID) {
        this.licenseID = licenseID;
    }

    public void setLicenseText(String licenseText) {
        this.licenseText = licenseText;
    }

    public void setMaxID(Integer maxID) {
        this.maxID = maxID;
    }

    public void setOriginalLearningDesignID(Long originalLearningDesignID) {
        this.originalLearningDesignID = originalLearningDesignID;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setTransitions(ArrayList transitions) {
        this.transitions = transitions;
    }

    public void setUserID(Integer userID) {
        this.userID = userID;
    }

    public void setOriginalUserID(Integer originalUserID) {
        this.originalUserID = originalUserID;
    }

    public void setEditOverrideUserID(Integer editOverrideUserID) {
        this.editOverrideUserID = editOverrideUserID;
    }

    public void setEditOverrideUserFullName(String editOverrideUserFullName) {
        this.editOverrideUserFullName = editOverrideUserFullName;
    }

    public void setValidDesign(Boolean validDesign) {
        this.validDesign = validDesign;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setVersion(Integer designVersion) {
        this.designVersion = designVersion;
    }

    public void setWorkspaceFolderID(Integer workspaceFolderID) {
        this.workspaceFolderID = workspaceFolderID;
    }

    public Integer getFirstActivityUIID() {
        return this.firstActivityUIID;
    }

    public Integer getFloatingActivityUIID() {
        return this.floatingActivityUIID;
    }

    public void setFirstActivityUIID(Integer firstActivityUIID) {
        this.firstActivityUIID = firstActivityUIID;
    }

    public void setFloatingActivityUIID(Integer floatingActivityUIID) {
        this.floatingActivityUIID = floatingActivityUIID;
    }

    public ArrayList getGroupings() {
        return this.groupings;
    }

    public void setGroupings(ArrayList groupings) {
        this.groupings = groupings;
    }

    public ArrayList getBranchMappings() {
        return this.branchMappings;
    }

    public void setBranchMappings(ArrayList branchMappings) {
        this.branchMappings = branchMappings;
    }

    public ArrayList<CompetenceDTO> getCompetences() {
        return this.competences;
    }

    public void setCompetences(ArrayList<CompetenceDTO> competences) {
        this.competences = competences;
    }

    public ArrayList<LearningDesignAnnotation> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(ArrayList<LearningDesignAnnotation> annotations) {
        this.annotations = annotations;
    }

    public String getDesignType() {
        return this.designType;
    }

    public void setDesignType(String designType) {
        this.designType = designType;
    }
}

