/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.service;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.SunUnsafeReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.security.AnyTypePermission;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.contentrepository.ItemNotFoundException;
import org.lamsfoundation.lams.contentrepository.NodeKey;
import org.lamsfoundation.lams.contentrepository.RepositoryCheckedException;
import org.lamsfoundation.lams.contentrepository.client.IToolContentHandler;
import org.lamsfoundation.lams.dao.IBaseDAO;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ActivityEvaluation;
import org.lamsfoundation.lams.learningdesign.ActivityOrderComparator;
import org.lamsfoundation.lams.learningdesign.BranchActivityEntry;
import org.lamsfoundation.lams.learningdesign.BranchCondition;
import org.lamsfoundation.lams.learningdesign.BranchingActivity;
import org.lamsfoundation.lams.learningdesign.ChosenGrouping;
import org.lamsfoundation.lams.learningdesign.Competence;
import org.lamsfoundation.lams.learningdesign.CompetenceMapping;
import org.lamsfoundation.lams.learningdesign.ComplexActivity;
import org.lamsfoundation.lams.learningdesign.ConditionGateActivity;
import org.lamsfoundation.lams.learningdesign.DataFlowObject;
import org.lamsfoundation.lams.learningdesign.DataTransition;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.GroupingActivity;
import org.lamsfoundation.lams.learningdesign.LearnerChoiceGrouping;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.License;
import org.lamsfoundation.lams.learningdesign.OptionsActivity;
import org.lamsfoundation.lams.learningdesign.PermissionGateActivity;
import org.lamsfoundation.lams.learningdesign.RandomGrouping;
import org.lamsfoundation.lams.learningdesign.ScheduleGateActivity;
import org.lamsfoundation.lams.learningdesign.SequenceActivity;
import org.lamsfoundation.lams.learningdesign.SynchGateActivity;
import org.lamsfoundation.lams.learningdesign.ToolActivity;
import org.lamsfoundation.lams.learningdesign.Transition;
import org.lamsfoundation.lams.learningdesign.dao.IActivityDAO;
import org.lamsfoundation.lams.learningdesign.dao.IGroupingDAO;
import org.lamsfoundation.lams.learningdesign.dao.ILearningDesignDAO;
import org.lamsfoundation.lams.learningdesign.dao.ILearningLibraryDAO;
import org.lamsfoundation.lams.learningdesign.dao.ILicenseDAO;
import org.lamsfoundation.lams.learningdesign.dao.ITransitionDAO;
import org.lamsfoundation.lams.learningdesign.dto.AuthoringActivityDTO;
import org.lamsfoundation.lams.learningdesign.dto.BranchActivityEntryDTO;
import org.lamsfoundation.lams.learningdesign.dto.BranchConditionDTO;
import org.lamsfoundation.lams.learningdesign.dto.CompetenceDTO;
import org.lamsfoundation.lams.learningdesign.dto.DataFlowObjectDTO;
import org.lamsfoundation.lams.learningdesign.dto.GroupDTO;
import org.lamsfoundation.lams.learningdesign.dto.GroupingDTO;
import org.lamsfoundation.lams.learningdesign.dto.LearningDesignDTO;
import org.lamsfoundation.lams.learningdesign.dto.ToolOutputBranchActivityEntryDTO;
import org.lamsfoundation.lams.learningdesign.dto.ToolOutputGateActivityEntryDTO;
import org.lamsfoundation.lams.learningdesign.dto.TransitionDTO;
import org.lamsfoundation.lams.learningdesign.dto.ValidationErrorDTO;
import org.lamsfoundation.lams.learningdesign.service.ExportToolContentException;
import org.lamsfoundation.lams.learningdesign.service.IExportToolContentService;
import org.lamsfoundation.lams.learningdesign.service.ILearningDesignService;
import org.lamsfoundation.lams.learningdesign.service.ImportToolContentException;
import org.lamsfoundation.lams.learningdesign.service.LearningDesignService;
import org.lamsfoundation.lams.learningdesign.service.ToolContentVersionFilter;
import org.lamsfoundation.lams.lesson.LessonClass;
import org.lamsfoundation.lams.planner.PedagogicalPlannerActivityMetadata;
import org.lamsfoundation.lams.tool.SystemTool;
import org.lamsfoundation.lams.tool.Tool;
import org.lamsfoundation.lams.tool.ToolAdapterContentManager;
import org.lamsfoundation.lams.tool.ToolContent;
import org.lamsfoundation.lams.tool.ToolContentManager;
import org.lamsfoundation.lams.tool.dao.ISystemToolDAO;
import org.lamsfoundation.lams.tool.dao.IToolContentDAO;
import org.lamsfoundation.lams.tool.dao.IToolDAO;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.WorkspaceFolder;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.FileUtil;
import org.lamsfoundation.lams.util.FileUtilException;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.VersionUtil;
import org.lamsfoundation.lams.util.zipfile.ZipFileUtil;
import org.lamsfoundation.lams.util.zipfile.ZipFileUtilException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ExportToolContentService
implements IExportToolContentService,
ApplicationContextAware {
    private Logger log = Logger.getLogger(ExportToolContentService.class);
    public static final String LEARNING_DESIGN_SERVICE_BEAN_NAME = "learningDesignService";
    public static final String MESSAGE_SERVICE_BEAN_NAME = "commonMessageService";
    public static final String EXPORT_TOOLCONTNET_ZIP_PREFIX = "lams_toolcontent_";
    public static final String EXPORT_LDCONTENT_ZIP_PREFIX = "lams_ldcontent_";
    public static final String EXPORT_TOOLCONTNET_FOLDER_SUFFIX = "export_toolcontent";
    public static final String EXPORT_TOOLCONTNET_ZIP_SUFFIX = ".zip";
    public static final String EXPORT_LDCONTENT_ZIP_SUFFIX = ".zip";
    public static final String LEARNING_DESIGN_FILE_NAME = "learning_design.xml";
    public static final String TOOL_FILE_NAME = "tool.xml";
    public static final String TOOL_FAILED_FILE_NAME = "export_failed.xml";
    public static final String SVG_IMAGE_FILE_NAME = "learning_design.svg";
    private static final String ERROR_TOOL_NOT_FOUND = "error.import.matching.tool.not.found";
    private static final String ERROR_SERVICE_ERROR = "error.import.tool.service.fail";
    private static final String ERROR_NO_VALID_TOOL = "error.no.valid.tool";
    private static final String ERROR_INCOMPATIBLE_VERSION = "error.possibly.incompatible.version";
    private static final String FILTER_METHOD_PREFIX_DOWN = "down";
    private static final String FILTER_METHOD_PREFIX_UP = "up";
    private static final String FILTER_METHOD_MIDDLE = "To";
    private static final String LAMS_VERSION = "version";
    private static final String LAMS_TITLE = "title";
    private static final String DIR_CONTENT = "content";
    private static final String KEY_MSG_IMPORT_FILE_FORMAT = "msg.import.file.format";
    private static MessageService messageService;
    private ApplicationContext applicationContext;
    private List<NameInfo> fileHandleClassList = new ArrayList<NameInfo>();
    private Class filterClass;
    private IActivityDAO activityDAO;
    private IToolDAO toolDAO;
    private IToolContentDAO toolContentDAO;
    private ISystemToolDAO systemToolDAO;
    private IBaseDAO baseDAO;
    private ILicenseDAO licenseDAO;
    private IGroupingDAO groupingDAO;
    private ITransitionDAO transitionDAO;
    private ILearningDesignDAO learningDesignDAO;
    private ILearningLibraryDAO learningLibraryDAO;

    @Override
    public String exportLearningDesign(Long learningDesignId, List<String> toolsErrorMsgs) throws ExportToolContentException {
        try {
            String targetZipFileName = null;
            String rootDir = FileUtil.createTempDirectory(EXPORT_TOOLCONTNET_FOLDER_SUFFIX);
            String contentDir = FileUtil.getFullPath(rootDir, DIR_CONTENT);
            FileUtil.createDirectory(contentDir);
            String ldFileName = FileUtil.getFullPath(contentDir, LEARNING_DESIGN_FILE_NAME);
            OutputStreamWriter ldFile = new OutputStreamWriter((OutputStream)new FileOutputStream(ldFileName), "UTF-8");
            ILearningDesignService service = this.getLearningDesignService();
            LearningDesignDTO ldDto = service.getLearningDesignDTO(learningDesignId, "");
            ldDto.setVersion(Configuration.get(ConfigurationKeys.SERVER_VERSION_NUMBER));
            TreeSet<Long> groupingsToSkip = new TreeSet<Long>();
            ArrayList activities = ldDto.getActivities();
            for (AuthoringActivityDTO activity : activities) {
                int activityTypeID = activity.getActivityTypeID();
                if (activityTypeID == 10 || activityTypeID == 12) {
                    Long groupingID = activity.getGroupingID();
                    if (groupingID != null) {
                        groupingsToSkip.add(groupingID);
                    }
                    activity.setApplyGrouping(false);
                    activity.setGroupingID(null);
                    activity.setGroupingUIID(null);
                    continue;
                }
                if (activityTypeID != 1) continue;
                ToolContentManager contentManager = (ToolContentManager)this.findToolService(this.toolDAO.getToolByID(activity.getToolID()));
                this.log.debug((Object)("Tool export content : " + activity.getActivityTitle() + " by contentID :" + activity.getToolContentID()));
                try {
                    contentManager.exportToolContent(activity.getToolContentID(), contentDir);
                }
                catch (Exception e) {
                    String msg = activity.getToolDisplayName() + " export tool content failed:" + e.toString();
                    this.log.error((Object)msg, (Throwable)e);
                    String toolPath = FileUtil.getFullPath(contentDir, activity.getToolContentID().toString());
                    String toolFileName = FileUtil.getFullPath(toolPath, TOOL_FILE_NAME);
                    File toolFile = new File(toolFileName);
                    if (toolFile.exists()) {
                        toolFile.delete();
                    }
                    this.writeErrorToToolFile(contentDir, activity.getToolContentID(), msg);
                    toolsErrorMsgs.add(msg);
                }
            }
            Iterator groupingIter = ldDto.getGroupings().iterator();
            while (groupingIter.hasNext()) {
                if (!groupingsToSkip.contains(((GroupingDTO)groupingIter.next()).getGroupingID())) continue;
                groupingIter.remove();
            }
            XStream designXml = new XStream((ReflectionProvider)new SunUnsafeReflectionProvider());
            designXml.addPermission(AnyTypePermission.ANY);
            designXml.toXML((Object)ldDto, (Writer)ldFile);
            ((Writer)ldFile).close();
            String destinationPath = FileUtil.getFullPath(contentDir, SVG_IMAGE_FILE_NAME);
            String svgPath = LearningDesignService.getLearningDesignSVGPath(learningDesignId);
            File svgFile = new File(svgPath);
            if (svgFile.canRead()) {
                FileUtils.copyFile((File)svgFile, (File)new File(destinationPath));
            }
            this.log.debug((Object)"Learning design xml export success");
            try {
                String targetContentZipFileName = EXPORT_LDCONTENT_ZIP_PREFIX + ldDto.getContentFolderID() + ".zip";
                String secureDir = Configuration.get(ConfigurationKeys.LAMS_EAR_DIR) + File.separator + "lams-www.war" + File.separator + "secure";
                String ldContentDir = FileUtil.getFullPath(secureDir, ldDto.getContentFolderID());
                if (!FileUtil.isEmptyDirectory(ldContentDir, true)) {
                    this.log.debug((Object)("Create export Learning Design content target zip file. File name is " + targetContentZipFileName));
                    ZipFileUtil.createZipFile(targetContentZipFileName, ldContentDir, contentDir);
                } else {
                    this.log.debug((Object)("No such directory (or empty directory):" + ldContentDir));
                }
            }
            catch (Exception e) {
                this.log.error((Object)"Error thrown while creating LD XML", (Throwable)e);
                throw new ExportToolContentException(e);
            }
            targetZipFileName = ldDto.getTitle() + ".zip";
            this.log.debug((Object)("Create export content target zip file. File name is " + targetZipFileName));
            return ZipFileUtil.createZipFile(targetZipFileName, contentDir, rootDir);
        }
        catch (FileUtilException e) {
            this.log.error((Object)"FileUtilException:", (Throwable)e);
            throw new ExportToolContentException(e);
        }
        catch (ZipFileUtilException e) {
            this.log.error((Object)"ZipFileUtilException:", (Throwable)e);
            throw new ExportToolContentException(e);
        }
        catch (IOException e) {
            this.log.error((Object)"IOException:", (Throwable)e);
            throw new ExportToolContentException(e);
        }
    }

    @Override
    public void exportToolContent(Long toolContentId, Object toolContentObj, IToolContentHandler toolContentHandler, String rootPath) throws ExportToolContentException {
        try {
            String toolPath = FileUtil.getFullPath(rootPath, toolContentId.toString());
            FileUtil.createDirectory(toolPath);
            String toolFileName = FileUtil.getFullPath(toolPath, TOOL_FILE_NAME);
            OutputStreamWriter toolFile = new OutputStreamWriter((OutputStream)new FileOutputStream(toolFileName), "UTF-8");
            XStream toolXml = new XStream((ReflectionProvider)new SunUnsafeReflectionProvider());
            toolXml.addPermission(AnyTypePermission.ANY);
            FileConverter fileConverter = null;
            if (!this.fileHandleClassList.isEmpty()) {
                fileConverter = new FileConverter(toolXml);
                toolXml.registerConverter((Converter)fileConverter);
            }
            toolXml.toXML(toolContentObj, (Writer)toolFile);
            ((Writer)toolFile).flush();
            ((Writer)toolFile).close();
            if (fileConverter != null) {
                for (ValueInfo fileNode : fileConverter.getFileNodes()) {
                    this.log.debug((Object)("Tool attachement file is going to save : " + fileNode.fileUuid));
                    toolContentHandler.saveFile(fileNode.fileUuid, FileUtil.getFullPath(toolPath, fileNode.fileUuid.toString()));
                }
            }
        }
        catch (ItemNotFoundException e) {
            throw new ExportToolContentException(e);
        }
        catch (RepositoryCheckedException e) {
            throw new ExportToolContentException(e);
        }
        catch (IOException e) {
            throw new ExportToolContentException(e);
        }
        catch (FileUtilException e) {
            throw new ExportToolContentException(e);
        }
        finally {
            if (this.fileHandleClassList != null) {
                this.fileHandleClassList.clear();
            }
        }
    }

    @Override
    public void registerFileClassForExport(String fileNodeClassName, String fileUuidFieldName, String fileVersionFieldName) {
        this.fileHandleClassList.add(new NameInfo(fileNodeClassName, fileUuidFieldName, fileVersionFieldName));
    }

    @Override
    public void registerFileClassForImport(String fileNodeClassName, String fileUuidFieldName, String fileVersionFieldName, String fileNameFieldName, String mimeTypeFieldName, String initialItemFieldName) {
        this.fileHandleClassList.add(new NameInfo(fileNodeClassName, fileUuidFieldName, fileVersionFieldName, fileNameFieldName, mimeTypeFieldName, initialItemFieldName));
    }

    @Override
    public void registerImportVersionFilterClass(Class filterClass) {
        this.filterClass = filterClass;
    }

    @Override
    public Object[] importLearningDesign(File designFile, User importer, Integer workspaceFolderUid, List<String> toolsErrorMsgs, String customCSV) throws ImportToolContentException {
        Object[] ldResults = new Object[3];
        Long ldId = null;
        ArrayList<String> ldErrorMsgs = new ArrayList<String>();
        String filename = designFile.getName();
        String extension = filename != null && filename.length() >= 4 ? filename.substring(filename.length() - 4) : "";
        try {
            if (extension.equalsIgnoreCase(".zip")) {
                String ldPath = ZipFileUtil.expandZip(new FileInputStream(designFile), filename);
                File fullFilePath = new File(FileUtil.getFullPath(ldPath, LEARNING_DESIGN_FILE_NAME));
                if (fullFilePath.canRead()) {
                    ldId = this.importLearningDesign(ldPath, importer, workspaceFolderUid, toolsErrorMsgs, customCSV);
                } else {
                    this.badFileType(ldErrorMsgs, filename, "Learning design file not found.");
                }
            } else {
                this.badFileType(ldErrorMsgs, filename, "Unexpected extension");
            }
        }
        catch (Exception e) {
            throw new ImportToolContentException("Error while importing a sequence", e);
        }
        ldResults[0] = ldId;
        ldResults[1] = ldErrorMsgs;
        ldResults[2] = toolsErrorMsgs;
        return ldResults;
    }

    protected String getPacket(InputStream sis) throws IOException {
        BufferedReader buff = new BufferedReader(new InputStreamReader(sis));
        StringBuffer tempStrBuf = new StringBuffer(200);
        String tempStr = buff.readLine();
        while (tempStr != null) {
            tempStrBuf.append(tempStr);
            tempStr = buff.readLine();
        }
        return tempStrBuf.toString();
    }

    private Long importLearningDesign(String learningDesignPath, User importer, Integer workspaceFolderUid, List<String> toolsErrorMsgs, String customCSV) throws ImportToolContentException {
        try {
            String fullFilePath = FileUtil.getFullPath(learningDesignPath, LEARNING_DESIGN_FILE_NAME);
            String importedFileVersion = this.checkImportVersion(fullFilePath, toolsErrorMsgs);
            this.filterCoreVersion(fullFilePath, importedFileVersion);
            LearningDesignDTO ldDto = (LearningDesignDTO)FileUtil.getObjectFromXML(null, fullFilePath);
            this.log.debug((Object)"Learning design xml deserialize to LearingDesignDTO success.");
            HashMap<Long, ToolContent> toolMapper = new HashMap<Long, ToolContent>();
            HashMap<Long, AuthoringActivityDTO> removedActMap = new HashMap<Long, AuthoringActivityDTO>();
            ArrayList activities = ldDto.getActivities();
            for (AuthoringActivityDTO activity : activities) {
                this.getLearningDesignService().fillLearningLibraryID(activity);
                if (!activity.getActivityTypeID().equals(1)) continue;
                String toolPath = FileUtil.getFullPath(learningDesignPath, activity.getToolContentID().toString());
                Tool newTool = new ToolCompatibleStrategy().getTool(activity.getToolSignature());
                if (newTool == null) {
                    this.log.warn((Object)("An activity can not found matching tool [" + activity.getToolSignature() + "]."));
                    toolsErrorMsgs.add(this.getMessageService().getMessage(ERROR_TOOL_NOT_FOUND, new Object[]{activity.getToolSignature()}));
                    removedActMap.put(activity.getActivityID(), activity);
                    continue;
                }
                activity.setLearningLibraryID(newTool.getLearningLibraryId());
                ToolContent newContent = new ToolContent(newTool);
                this.toolContentDAO.saveToolContent(newContent);
                toolMapper.put(activity.getActivityID(), newContent);
                try {
                    this.log.debug((Object)("Tool begin to import content : " + activity.getActivityTitle() + " by contentID :" + activity.getToolContentID()));
                    String toVersion = newTool.getToolVersion();
                    String fromVersion = activity.getToolVersion();
                    ToolContentManager contentManager = (ToolContentManager)this.findToolService(newTool);
                    if (contentManager instanceof ToolAdapterContentManager) {
                        ToolAdapterContentManager toolAdapterContentManager = (ToolAdapterContentManager)contentManager;
                        toolAdapterContentManager.importToolContent(newContent.getToolContentId(), importer.getUserId(), toolPath, fromVersion, toVersion, customCSV);
                    } else {
                        contentManager.importToolContent(newContent.getToolContentId(), importer.getUserId(), toolPath, fromVersion, toVersion);
                    }
                    this.log.debug((Object)"Tool content import success.");
                }
                catch (Exception e) {
                    String error = this.getMessageService().getMessage(ERROR_SERVICE_ERROR, new Object[]{newTool.getToolDisplayName(), e.toString()});
                    this.log.error((Object)error, (Throwable)e);
                    toolsErrorMsgs.add(error);
                    removedActMap.put(activity.getActivityID(), activity);
                }
            }
            if (removedActMap.size() == activities.size()) {
                toolsErrorMsgs.add(this.getMessageService().getMessage(ERROR_NO_VALID_TOOL));
                return -1L;
            }
            try {
                String contentZipFileName = EXPORT_LDCONTENT_ZIP_PREFIX + ldDto.getContentFolderID() + ".zip";
                String secureDir = Configuration.get(ConfigurationKeys.LAMS_EAR_DIR) + File.separator + "lams-www.war" + File.separator + "secure" + File.separator + ldDto.getContentFolderID();
                File contentZipFile = new File(FileUtil.getFullPath(learningDesignPath, contentZipFileName));
                if (contentZipFile.exists()) {
                    FileInputStream is = new FileInputStream(contentZipFile);
                    ZipFileUtil.expandZipToFolder(is, secureDir);
                }
            }
            catch (Exception e) {
                throw new ImportToolContentException(e);
            }
            ldDto.setDateReadOnly(null);
            ldDto.setReadOnly(false);
            WorkspaceFolder folder = this.getWorkspaceFolderForDesign(importer, workspaceFolderUid);
            return this.saveLearningDesign(ldDto, importer, folder, toolMapper, removedActMap);
        }
        catch (Exception e) {
            this.log.error((Object)"Exception occured during import.", (Throwable)e);
            throw new ImportToolContentException(e);
        }
    }

    private String checkImportVersion(String fullFilePath, List<String> toolsErrorMsgs) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = docBuilder.parse(new FileInputStream(fullFilePath));
        Element root = doc.getDocumentElement();
        String title = root.getElementsByTagName(LAMS_TITLE).item(0).getTextContent().trim();
        String versionString = root.getElementsByTagName(LAMS_VERSION).item(0).getTextContent().trim();
        String currentVersionString = Configuration.get(ConfigurationKeys.SERVER_VERSION_NUMBER);
        try {
            boolean isLaterVersion;
            boolean bl = isLaterVersion = !VersionUtil.isSameOrLaterVersionAsServer(versionString, true);
            if (isLaterVersion) {
                this.log.warn((Object)("Importing a design from a later version of LAMS. There may be parts of the design that will fail to import. Design name '" + title + "'. Version in import file " + versionString));
                toolsErrorMsgs.add(this.getMessageService().getMessage(ERROR_INCOMPATIBLE_VERSION, new Object[]{versionString, currentVersionString}));
            }
        }
        catch (Exception e) {
            this.log.warn((Object)("Unable to properly determine current version from an import file. Design name '" + title + "'. Version in import file " + versionString));
            toolsErrorMsgs.add(this.getMessageService().getMessage(ERROR_INCOMPATIBLE_VERSION, new Object[]{versionString, currentVersionString}));
        }
        return versionString;
    }

    private void filterCoreVersion(String fullFilePath, String versionString) throws Exception {
        boolean isEarlierVersionThan242;
        ToolContentVersionFilter contentFilter = new ToolContentVersionFilter();
        boolean bl = isEarlierVersionThan242 = !VersionUtil.isSameOrLaterVersion("2.4.2", versionString, true);
        if (isEarlierVersionThan242) {
            Class<?> problemClass = Class.forName(AuthoringActivityDTO.class.getName());
            contentFilter.removeField(problemClass, "defineLater");
            contentFilter.removeField(problemClass, "runOffline");
            contentFilter.transformXML(fullFilePath);
        }
    }

    private WorkspaceFolder getWorkspaceFolderForDesign(User importer, Integer workspaceFolderUid) throws ImportToolContentException {
        WorkspaceFolder folder = null;
        if (workspaceFolderUid != null) {
            folder = (WorkspaceFolder)this.baseDAO.find(WorkspaceFolder.class, workspaceFolderUid);
        }
        if (folder == null && importer.getWorkspaceFolder() != null) {
            folder = importer.getWorkspaceFolder();
        }
        if (folder == null) {
            String error = "Unable to save design in a folder - folder not found. Input folder uid " + workspaceFolderUid + ", user  " + importer.getUserId();
            this.log.error((Object)error);
            throw new ImportToolContentException(error);
        }
        return folder;
    }

    private void badFileType(List<String> ldErrorMsgs, String filename, String errDescription) {
        this.log.error((Object)("Uploaded file not an expected type. Filename was " + filename + " " + errDescription));
        MessageService msgService = this.getMessageService();
        String msg = msgService.getMessage(KEY_MSG_IMPORT_FILE_FORMAT);
        ldErrorMsgs.add(msg != null ? msg : "Uploaded file not an expected type.");
    }

    @Override
    public Object importToolContent(String toolContentPath, IToolContentHandler toolContentHandler, String fromVersion, String toVersion) throws ImportToolContentException {
        Object toolPOJO;
        block17: {
            toolPOJO = null;
            XStream toolXml = new XStream((ReflectionProvider)new SunUnsafeReflectionProvider());
            toolXml.addPermission(AnyTypePermission.ANY);
            FileConverter fileConverter = null;
            if (!this.fileHandleClassList.isEmpty()) {
                fileConverter = new FileConverter(toolXml);
                toolXml.registerConverter((Converter)fileConverter);
            }
            try {
                String toolFilePath = FileUtil.getFullPath(toolContentPath, TOOL_FILE_NAME);
                if (this.filterClass != null && !StringUtils.equals((String)fromVersion, (String)toVersion)) {
                    this.filterVersion(toolFilePath, fromVersion, toVersion);
                }
                this.filterClass = null;
                toolPOJO = FileUtil.getObjectFromXML(toolXml, toolFilePath);
                if (fileConverter == null) break block17;
                for (ValueInfo fileNode : fileConverter.getFileNodes()) {
                    NodeKey key;
                    Long uuid = NumberUtils.createLong((String)BeanUtils.getProperty((Object)fileNode.instance, (String)fileNode.name.uuidFieldName));
                    if (uuid == null) continue;
                    String realFileName = uuid.toString();
                    String fullFileName = FileUtil.getFullPath(toolContentPath, realFileName);
                    this.log.debug((Object)("Tool attachement files/packages are going to upload to repository " + fullFileName));
                    File file = new File(fullFileName);
                    boolean isPackage = false;
                    if (!file.exists()) {
                        file = new File(fullFileName + ".zip");
                        realFileName = realFileName + ".zip";
                        isPackage = true;
                        if (!file.exists()) {
                            throw new ImportToolContentException("Content attached file/package can not be found: " + fullFileName + "(.zip)");
                        }
                    }
                    String fileName = BeanUtils.getProperty((Object)fileNode.instance, (String)fileNode.name.fileNameFieldName);
                    String mimeType = null;
                    try {
                        mimeType = BeanUtils.getProperty((Object)fileNode.instance, (String)fileNode.name.mimeTypeFieldName);
                    }
                    catch (Exception e) {
                        this.log.debug((Object)("No method for mimeType:" + fileNode.instance));
                    }
                    String initalItem = null;
                    try {
                        initalItem = BeanUtils.getProperty((Object)fileNode.instance, (String)fileNode.name.initalItemFieldName);
                    }
                    catch (Exception e) {
                        this.log.debug((Object)("No method for initial item:" + fileNode.instance));
                    }
                    FileInputStream is = new FileInputStream(file);
                    if (!isPackage) {
                        key = toolContentHandler.uploadFile((InputStream)is, fileName, mimeType);
                    } else {
                        String packageDirectory = ZipFileUtil.expandZip(is, realFileName);
                        key = toolContentHandler.uploadPackage(packageDirectory, initalItem);
                    }
                    BeanUtils.setProperty((Object)fileNode.instance, (String)fileNode.name.uuidFieldName, (Object)key.getUuid());
                    if (fileNode.name.versionFieldName == null) continue;
                    BeanUtils.setProperty((Object)fileNode.instance, (String)fileNode.name.versionFieldName, (Object)key.getVersion());
                }
            }
            catch (Exception e) {
                throw new ImportToolContentException(e);
            }
            finally {
                if (this.fileHandleClassList != null) {
                    this.fileHandleClassList.clear();
                }
            }
        }
        return toolPOJO;
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.applicationContext = context;
    }

    private void filterVersion(String toolFilePath, String fromVersion, String toVersion) throws Exception {
        float from = 0.0f;
        try {
            from = NumberUtils.createFloat((String)fromVersion).floatValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        float to = 0.0f;
        try {
            to = NumberUtils.createFloat((String)toVersion).floatValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String filterMethodPrefix = from > to ? FILTER_METHOD_PREFIX_DOWN : FILTER_METHOD_PREFIX_UP;
        this.log.debug((Object)("Version filter class will filter from version " + from + " to " + to));
        Object filter = this.filterClass.newInstance();
        Method[] methods = this.filterClass.getDeclaredMethods();
        TreeMap<Float, Method> methodNeeds = new TreeMap<Float, Method>();
        for (Method method : methods) {
            String name = method.getName();
            if (!name.startsWith(filterMethodPrefix)) continue;
            String[] ver = name.split(filterMethodPrefix + "|" + FILTER_METHOD_MIDDLE);
            Float mf = Float.valueOf(0.0f);
            Float mt = Float.valueOf(0.0f);
            for (int idx = 0; idx < ver.length; ++idx) {
                if (StringUtils.isBlank((String)ver[idx])) continue;
                mf = NumberUtils.createFloat((String)ver[idx]);
                if (ver.length <= idx) break;
                mt = NumberUtils.createFloat((String)ver[++idx]);
                break;
            }
            if (!(mf.floatValue() >= from) || !(mt.floatValue() <= to)) continue;
            methodNeeds.put(mf, method);
        }
        Collection calls = methodNeeds.values();
        for (Method method : calls) {
            method.invoke(filter, new Object[0]);
            this.log.debug((Object)("Version filter class method " + method.getName() + " is executed."));
        }
        Method transform = this.filterClass.getMethod("transformXML", String.class);
        transform.invoke(filter, toolFilePath);
    }

    private void writeErrorToToolFile(String rootPath, Long toolContentId, String msg) {
        try {
            String toolPath = FileUtil.getFullPath(rootPath, toolContentId.toString());
            FileUtil.createDirectory(toolPath);
            String toolFileName = FileUtil.getFullPath(toolPath, TOOL_FAILED_FILE_NAME);
            FileWriter toolFile = new FileWriter(new File(toolFileName));
            toolFile.write(msg);
            ((Writer)toolFile).flush();
            ((Writer)toolFile).close();
        }
        catch (FileUtilException e) {
            this.log.warn((Object)"Export error file write error:", (Throwable)e);
        }
        catch (IOException e) {
            this.log.warn((Object)"Export error file write error:", (Throwable)e);
        }
    }

    private ILearningDesignService getLearningDesignService() {
        return (ILearningDesignService)this.applicationContext.getBean(LEARNING_DESIGN_SERVICE_BEAN_NAME);
    }

    private MessageService getMessageService() {
        if (messageService != null) {
            return messageService;
        }
        messageService = (MessageService)this.applicationContext.getBean(MESSAGE_SERVICE_BEAN_NAME);
        return messageService;
    }

    private Object findToolService(Tool tool) throws NoSuchBeanDefinitionException {
        return this.applicationContext.getBean(tool.getServiceName());
    }

    public Long saveLearningDesign(LearningDesignDTO dto, User importer, WorkspaceFolder folder, Map<Long, ToolContent> toolMapper, Map<Long, AuthoringActivityDTO> removedActMap) throws ImportToolContentException {
        ArrayList entryDtoList;
        Integer actUiid;
        Activity act;
        ArrayList groupingDtoList = dto.getGroupings();
        HashMap<Long, Grouping> groupingMapper = new HashMap<Long, Grouping>();
        HashMap<Integer, Group> groupByUIIDMapper = new HashMap<Integer, Group>();
        for (GroupingDTO groupingDto : groupingDtoList) {
            Grouping grouping = this.getGrouping(groupingDto, groupByUIIDMapper);
            groupingMapper.put(grouping.getGroupingId(), grouping);
            grouping.setGroupingId(null);
            this.groupingDAO.insert(grouping);
        }
        List<AuthoringActivityDTO> actDtoList = this.getSortedParentList(dto.getActivities());
        if (this.log.isDebugEnabled()) {
            int idx = 0;
            for (AuthoringActivityDTO activityDTO : actDtoList) {
                this.log.debug((Object)(idx + ": ActivityID is [" + activityDTO.getActivityID() + "], parent ID is [" + activityDTO.getParentActivityID() + "]"));
                ++idx;
            }
        }
        TreeSet<Activity> actList = new TreeSet<Activity>(new ActivityOrderComparator());
        HashMap<Long, Activity> activityMapper = new HashMap<Long, Activity>();
        HashMap<Integer, Activity> activityByUIIDMapper = new HashMap<Integer, Activity>();
        HashMap<Integer, ComplexActivity> defaultActivityToParentActivityMapping = new HashMap<Integer, ComplexActivity>();
        for (AuthoringActivityDTO actDto : actDtoList) {
            act = this.getActivity(actDto, groupingMapper, toolMapper, defaultActivityToParentActivityMapping);
            activityMapper.put(act.getActivityId(), act);
            activityByUIIDMapper.put(act.getActivityUIID(), act);
            if (removedActMap.containsKey(actDto.getActivityID())) continue;
            actList.add(act);
        }
        for (AuthoringActivityDTO actDto : actDtoList) {
            act = (Activity)activityMapper.get(actDto.getActivityID());
            if (removedActMap.containsKey(actDto.getActivityID())) continue;
            if (actDto.getParentActivityID() != null) {
                Activity parent = (Activity)activityMapper.get(actDto.getParentActivityID());
                if (removedActMap.containsKey(parent.getActivityId())) {
                    act.setParentActivity(null);
                    act.setParentUIID(null);
                } else {
                    act.setParentActivity(parent);
                    if (parent.isComplexActivity()) {
                        TreeSet<Activity> set = ((ComplexActivity)parent).getActivities();
                        if (set == null) {
                            set = new TreeSet<Activity>(new ActivityOrderComparator());
                            ((ComplexActivity)parent).setActivities(set);
                        }
                        if (!removedActMap.containsKey(actDto.getActivityID())) {
                            set.add(act);
                        }
                    }
                }
            }
            if (actDto.getInputActivities() != null) {
                act.setInputActivities(new HashSet());
                for (Integer inputActivityUIID : actDto.getInputActivities()) {
                    Activity inputAct = (Activity)activityByUIIDMapper.get(inputActivityUIID);
                    if (inputAct == null) {
                        this.log.error((Object)("Unable to find input activity with UIID " + inputActivityUIID + " for activity " + act));
                        continue;
                    }
                    act.getInputActivities().add(inputAct);
                }
            }
            act.setActivityId(null);
            this.activityDAO.insert(act);
            if (actDto.getActivityEvaluations() == null) continue;
            for (String toolOutputDefinition : actDto.getActivityEvaluations()) {
                ActivityEvaluation activityEvaluation = new ActivityEvaluation();
                activityEvaluation.setToolOutputDefinition(toolOutputDefinition);
                activityEvaluation.setActivity(act);
                this.baseDAO.insertOrUpdate(activityEvaluation);
            }
        }
        if (defaultActivityToParentActivityMapping.size() > 0) {
            for (Object childUIID : defaultActivityToParentActivityMapping.keySet()) {
                ComplexActivity complex = (ComplexActivity)defaultActivityToParentActivityMapping.get(childUIID);
                Activity childActivity = (Activity)activityByUIIDMapper.get(childUIID);
                if (childActivity == null) {
                    this.log.error((Object)("Unable to find the default child activity (" + childUIID + ") for the activity (" + complex.getTitle() + "). The activity " + complex.getTitle() + " will need to be fixed in authoring otherwise the progress engine will just do the best it can."));
                    continue;
                }
                complex.setDefaultActivity(childActivity);
            }
        }
        if ((actUiid = dto.getFirstActivityUIID()) != null) {
            for (AuthoringActivityDTO actDto : actDtoList) {
                if (!actUiid.equals(actDto.getActivityUIID())) continue;
                if (!removedActMap.containsKey(actDto.getActivityID())) break;
                ArrayList transDtoList = dto.getTransitions();
                Long existFirstAct = null;
                Long nextActId = actDto.getActivityID();
                boolean found = false;
                block8: for (int idx = 0; idx < 1000 && transDtoList != null && !transDtoList.isEmpty(); ++idx) {
                    boolean transitionBreak = true;
                    Iterator<Object> iterator = transDtoList.iterator();
                    while (iterator.hasNext()) {
                        TransitionDTO transDto = (TransitionDTO)iterator.next();
                        if ((transDto.getTransitionType() == null || transDto.getTransitionType().equals(0)) && nextActId.equals(transDto.getFromActivityID())) {
                            transitionBreak = false;
                            nextActId = transDto.getToActivityID();
                            if (nextActId != null && !removedActMap.containsKey(nextActId)) {
                                existFirstAct = nextActId;
                                found = true;
                                continue block8;
                            }
                            if (nextActId != null) continue block8;
                            found = true;
                            continue block8;
                        }
                        if (!found && !transitionBreak) continue;
                        continue block8;
                    }
                }
                Activity next = (Activity)activityMapper.get(existFirstAct);
                dto.setFirstActivityUIID(next == null ? null : next.getActivityUIID());
                break;
            }
        }
        ArrayList transDtoList = dto.getTransitions();
        HashSet<Transition> transList = new HashSet<Transition>();
        for (Object transDto : transDtoList) {
            Long fromId = ((TransitionDTO)transDto).getFromActivityID();
            Long toId = ((TransitionDTO)transDto).getToActivityID();
            if (fromId != null && removedActMap.containsKey(fromId) || toId != null && removedActMap.containsKey(toId)) continue;
            Transition trans = this.getTransition((TransitionDTO)transDto, activityMapper);
            transList.add(trans);
            trans.setTransitionId(null);
        }
        HashSet<Competence> competenceList = new HashSet<Competence>();
        if (dto.getCompetences() != null) {
            for (CompetenceDTO competenceDTO : dto.getCompetences()) {
                Competence competence = new Competence();
                competence.setDescription(competenceDTO.getDescription());
                competence.setTitle(competenceDTO.getTitle());
                competenceList.add(competence);
            }
        }
        if ((entryDtoList = dto.getBranchMappings()) != null) {
            HashSet<BranchActivityEntry> entryList = new HashSet<BranchActivityEntry>();
            for (BranchActivityEntryDTO entryDto : entryDtoList) {
                BranchActivityEntry entry = this.getBranchActivityEntry(entryDto, groupByUIIDMapper, activityByUIIDMapper);
                entryList.add(entry);
            }
        }
        LearningDesign ld = this.getLearningDesign(dto, importer, folder, actList, transList, activityMapper, competenceList);
        Vector<ValidationErrorDTO> listOfValidationErrorDTOs = this.getLearningDesignService().validateLearningDesign(ld);
        if (listOfValidationErrorDTOs.size() > 0) {
            ld.setValidDesign(false);
            this.log.error(listOfValidationErrorDTOs);
        } else {
            ld.setValidDesign(true);
        }
        this.learningDesignDAO.insert(ld);
        String addSuffix = Configuration.get(ConfigurationKeys.SUFFIX_IMPORTED_LD);
        if (addSuffix == null || Boolean.valueOf(addSuffix).booleanValue()) {
            ld.setTitle(ExportToolContentService.generateUniqueLDTitle(folder, ld.getTitle(), this.learningDesignDAO));
            this.learningDesignDAO.update(ld);
        }
        HashSet<CompetenceMapping> allCompetenceMappings = new HashSet<CompetenceMapping>();
        for (AuthoringActivityDTO actDto : actDtoList) {
            if (removedActMap.containsKey(actDto.getActivityID()) || actDto.getActivityTypeID() != 1) continue;
            for (Activity act2 : actList) {
                block15: for (Competence competence : competenceList) {
                    for (String comptenceMappingStr : actDto.getCompetenceMappingTitles()) {
                        if (competence.getTitle() != comptenceMappingStr || ((Activity)activityMapper.get(actDto.getActivityID())).getActivityId() != act2.getActivityId()) continue;
                        CompetenceMapping competenceMapping = new CompetenceMapping();
                        competenceMapping.setToolActivity((ToolActivity)act2);
                        competenceMapping.setCompetence(competence);
                        allCompetenceMappings.add(competenceMapping);
                        continue block15;
                    }
                }
            }
        }
        this.baseDAO.insertOrUpdateAll(allCompetenceMappings);
        return ld.getLearningDesignId();
    }

    private List<AuthoringActivityDTO> getSortedParentList(List<AuthoringActivityDTO> activities) {
        ArrayList<AuthoringActivityDTO> result = new ArrayList<AuthoringActivityDTO>();
        ArrayList<Long> actIdList = new ArrayList<Long>();
        for (int failureToleranceCount = 5000; !activities.isEmpty() && failureToleranceCount > 0; --failureToleranceCount) {
            Iterator<AuthoringActivityDTO> iter = activities.iterator();
            while (iter.hasNext()) {
                AuthoringActivityDTO actDto = iter.next();
                if (actDto.getParentActivityID() == null) {
                    result.add(actDto);
                    actIdList.add(actDto.getActivityID());
                    iter.remove();
                    continue;
                }
                if (!actIdList.contains(actDto.getParentActivityID())) continue;
                result.add(actDto);
                actIdList.add(actDto.getActivityID());
                iter.remove();
            }
        }
        if (!activities.isEmpty()) {
            this.log.warn((Object)"Some activities cannot found their parent actitivy.");
            for (AuthoringActivityDTO actDto : activities) {
                this.log.warn((Object)("Activity ID[" + actDto.getActivityID() + "] cannot found parent [" + actDto.getParentActivityID() + "]"));
            }
            result.addAll(activities);
        }
        return result;
    }

    private LearningDesign getLearningDesign(LearningDesignDTO dto, User importer, WorkspaceFolder folder, Set<Activity> actList, Set<Transition> transList, Map<Long, Activity> activityMapper, Set<Competence> competenceList) throws ImportToolContentException {
        LearningDesign ld = new LearningDesign();
        if (dto == null) {
            return ld;
        }
        ld.setLearningDesignId(dto.getLearningDesignID());
        ld.setLearningDesignUIID(dto.getLearningDesignUIID());
        ld.setDescription(dto.getDescription());
        ld.setTitle(dto.getTitle());
        Integer actUiid = dto.getFirstActivityUIID();
        if (actUiid != null) {
            for (Activity act : activityMapper.values()) {
                if (!actUiid.equals(act.getActivityUIID())) continue;
                ld.setFirstActivity(act);
                break;
            }
        }
        ld.setMaxID(dto.getMaxID());
        ld.setValidDesign(dto.getValidDesign());
        ld.setReadOnly(dto.getReadOnly());
        ld.setDateReadOnly(dto.getDateReadOnly());
        ld.setHelpText(dto.getHelpText());
        ld.setCopyTypeID(1);
        ld.setCreateDateTime(dto.getCreateDateTime());
        ld.setVersion(dto.getVersion());
        if (folder != null) {
            ld.setWorkspaceFolder(folder);
        }
        ld.setDuration(dto.getDuration());
        ld.setLicenseText(dto.getLicenseText());
        Long licenseId = dto.getLicenseID();
        if (licenseId != null) {
            License license = this.licenseDAO.getLicenseByID(licenseId);
            if (license == null) {
                throw new ImportToolContentException("Import failed: License [" + dto.getLicenseText() + "] does not exist in target database");
            }
            ld.setLicense(this.licenseDAO.getLicenseByID(licenseId));
            ld.setLicenseText(dto.getLicenseText());
        }
        ld.setLastModifiedDateTime(dto.getLastModifiedDateTime());
        ld.setContentFolderID(dto.getContentFolderID());
        ld.setDesignType(dto.getDesignType());
        for (Transition trans : transList) {
            trans.setLearningDesign(ld);
        }
        ld.setTransitions(transList);
        for (Competence competence : competenceList) {
            competence.setLearningDesign(ld);
        }
        ld.setCompetences(competenceList);
        for (Activity act : actList) {
            act.setLearningDesign(ld);
        }
        ld.setActivities(actList);
        ld.setCreateDateTime(new Date());
        ld.setLastModifiedDateTime(new Date());
        ld.setUser(importer);
        ld.setOriginalUser(importer);
        return ld;
    }

    private Grouping getGrouping(GroupingDTO groupingDto, Map<Integer, Group> groupByUIIDMapper) {
        Grouping grouping = null;
        if (groupingDto == null) {
            return grouping;
        }
        Integer type = groupingDto.getGroupingTypeID();
        if (Grouping.CHOSEN_GROUPING_TYPE.equals(type)) {
            grouping = new ChosenGrouping();
        } else if (Grouping.RANDOM_GROUPING_TYPE.equals(type)) {
            grouping = new RandomGrouping();
            ((RandomGrouping)grouping).setLearnersPerGroup(groupingDto.getLearnersPerGroup());
            ((RandomGrouping)grouping).setNumberOfGroups(groupingDto.getNumberOfGroups());
        } else if (Grouping.CLASS_GROUPING_TYPE.equals(type)) {
            grouping = new LessonClass();
        } else if (Grouping.LEARNER_CHOICE_GROUPING_TYPE.equals(type)) {
            grouping = new LearnerChoiceGrouping();
            ((LearnerChoiceGrouping)grouping).setLearnersPerGroup(groupingDto.getLearnersPerGroup());
            ((LearnerChoiceGrouping)grouping).setNumberOfGroups(groupingDto.getNumberOfGroups());
            ((LearnerChoiceGrouping)grouping).setEqualNumberOfLearnersPerGroup(groupingDto.getEqualNumberOfLearnersPerGroup());
            ((LearnerChoiceGrouping)grouping).setViewStudentsBeforeSelection(groupingDto.getViewStudentsBeforeSelection());
        } else {
            this.log.error((Object)("Unable to determine the grouping type. Creating a random grouping. GroupingDTO was " + groupingDto));
        }
        grouping.setGroupingId(groupingDto.getGroupingID());
        grouping.setGroupingUIID(groupingDto.getGroupingUIID());
        grouping.setMaxNumberOfGroups(groupingDto.getMaxNumberOfGroups());
        if (groupingDto.getGroups() != null) {
            for (GroupDTO groupDto : groupingDto.getGroups()) {
                Group group = this.getGroup(groupDto, grouping);
                grouping.getGroups().add(group);
                groupByUIIDMapper.put(group.getGroupUIID(), group);
            }
        }
        return grouping;
    }

    private Group getGroup(GroupDTO groupDto, Grouping grouping) {
        Group group = new Group();
        group.setBranchActivities(null);
        group.setGrouping(grouping);
        group.setGroupName(groupDto.getGroupName());
        group.setGroupUIID(groupDto.getGroupUIID());
        group.setOrderId(groupDto.getOrderID());
        return group;
    }

    private BranchActivityEntry getBranchActivityEntry(BranchActivityEntryDTO entryDto, Map<Integer, Group> groupByUIIDMapper, Map<Integer, Activity> activityByUIIDMapper) {
        SequenceActivity branch = (SequenceActivity)activityByUIIDMapper.get(entryDto.getSequenceActivityUIID());
        Activity branchingActivity = activityByUIIDMapper.get(entryDto.getBranchingActivityUIID());
        if (branchingActivity == null) {
            this.log.error((Object)("Unable to find matching branching activity for group to branch mapping " + entryDto + " Skipping entry"));
            return null;
        }
        Group group = groupByUIIDMapper.get(entryDto.getGroupUIID());
        BranchCondition condition = null;
        Boolean gateOpenWhenConditionMet = null;
        if (entryDto instanceof ToolOutputBranchActivityEntryDTO) {
            BranchConditionDTO dto = ((ToolOutputBranchActivityEntryDTO)entryDto).getCondition();
            if (dto != null) {
                condition = dto.getCondition();
                condition.setConditionId(null);
            }
            if (entryDto instanceof ToolOutputGateActivityEntryDTO) {
                gateOpenWhenConditionMet = ((ToolOutputGateActivityEntryDTO)entryDto).getGateOpenWhenConditionMet();
            }
        }
        BranchActivityEntry entry = null;
        if (condition != null) {
            entry = condition.allocateBranchToCondition(entryDto.getEntryUIID(), branch, branchingActivity, gateOpenWhenConditionMet);
        } else if (group != null) {
            entry = group.allocateBranchToGroup(entryDto.getEntryUIID(), branch, (BranchingActivity)branchingActivity);
        }
        if (entry != null) {
            if (branch == null) {
                if (branchingActivity.getBranchActivityEntries() == null) {
                    branchingActivity.setBranchActivityEntries(new HashSet());
                }
                branchingActivity.getBranchActivityEntries().add(entry);
            } else {
                if (branch.getBranchEntries() == null) {
                    branch.setBranchEntries(new HashSet());
                }
                branch.getBranchEntries().add(entry);
            }
            return entry;
        }
        this.log.error((Object)("Unable to find group or condition for branch mapping " + entryDto + " Skipping entry"));
        return null;
    }

    private Transition getTransition(TransitionDTO transDto, Map<Long, Activity> activityMapper) {
        Transition trans = null;
        if (transDto == null) {
            return trans;
        }
        trans = transDto.getTransitionType() != null && transDto.getTransitionType().equals(1) ? new DataTransition() : new Transition();
        trans.setDescription(transDto.getDescription());
        Activity fromAct = activityMapper.get(transDto.getFromActivityID());
        trans.setFromActivity(fromAct);
        trans.setFromUIID(fromAct.getActivityUIID());
        if (trans.isProgressTransition()) {
            fromAct.setTransitionFrom(trans);
        }
        trans.setTitle(transDto.getTitle());
        Activity toAct = activityMapper.get(transDto.getToActivityID());
        trans.setToActivity(toAct);
        trans.setToUIID(toAct.getActivityUIID());
        if (trans.isProgressTransition()) {
            toAct.setTransitionTo(trans);
        }
        trans.setTransitionId(transDto.getTransitionID());
        trans.setTransitionUIID(transDto.getTransitionUIID());
        trans.setCreateDateTime(new Date());
        if (trans.isDataTransition()) {
            DataTransition dataTransition = (DataTransition)trans;
            for (DataFlowObjectDTO dataFlowObjectDto : transDto.getDataFlowObjects()) {
                DataFlowObject dataFlowObject = new DataFlowObject();
                dataFlowObject.setDataTransition(dataTransition);
                dataFlowObject.setName(dataFlowObjectDto.getName());
                dataFlowObject.setDisplayName(dataFlowObjectDto.getDisplayName());
                dataFlowObject.setOrderId(dataFlowObjectDto.getOrderId());
                Integer toolAssigmentId = StringUtils.isBlank((String)dataFlowObjectDto.getToolAssigmentId()) ? null : new Integer(dataFlowObjectDto.getToolAssigmentId());
                dataFlowObject.setToolAssigmentId(toolAssigmentId);
                dataTransition.getDataFlowObjects().add(dataFlowObject);
            }
        }
        return trans;
    }

    private Activity getActivity(AuthoringActivityDTO actDto, Map<Long, Grouping> groupingList, Map<Long, ToolContent> toolMapper, Map<Integer, ComplexActivity> defaultActivityToParentActivityMapping) {
        Grouping newGrouping;
        if (actDto == null) {
            return null;
        }
        int type = actDto.getActivityTypeID();
        Activity act = Activity.getActivityInstance(type);
        switch (act.getActivityTypeId()) {
            case 1: {
                ToolContent content = toolMapper.get(actDto.getActivityID());
                if (content != null) {
                    ((ToolActivity)act).setTool(content.getTool());
                    ((ToolActivity)act).setToolContentId(content.getToolContentId());
                    ((ToolActivity)act).setToolSessions(null);
                }
                if (actDto.getPlannerMetadataDTO() != null) {
                    PedagogicalPlannerActivityMetadata plannerMetadata = actDto.getPlannerMetadataDTO().toPlannerMetadata();
                    plannerMetadata.setActivity((ToolActivity)act);
                    ((ToolActivity)act).setPlannerMetadata(plannerMetadata);
                }
                act.setLearningLibrary(this.learningLibraryDAO.getLearningLibraryById(actDto.getLearningLibraryID()));
                break;
            }
            case 2: {
                newGrouping = groupingList.get(actDto.getCreateGroupingID());
                ((GroupingActivity)act).setCreateGrouping(newGrouping);
                ((GroupingActivity)act).setCreateGroupingUIID(newGrouping.getGroupingUIID());
                ((GroupingActivity)act).setSystemTool(this.systemToolDAO.getSystemToolByID(SystemTool.GROUPING));
                break;
            }
            case 3: {
                ((SynchGateActivity)act).setGateActivityLevelId(actDto.getGateActivityLevelID());
                ((SynchGateActivity)act).setGateOpen(false);
                ((SynchGateActivity)act).setSystemTool(this.systemToolDAO.getSystemToolByID(SystemTool.SYNC_GATE));
                break;
            }
            case 4: {
                ((ScheduleGateActivity)act).setGateActivityLevelId(actDto.getGateActivityLevelID());
                ((ScheduleGateActivity)act).setGateOpen(false);
                ((ScheduleGateActivity)act).setGateStartTimeOffset(actDto.getGateStartTimeOffset());
                ((ScheduleGateActivity)act).setGateEndTimeOffset(actDto.getGateEndTimeOffset());
                ((ScheduleGateActivity)act).setGateActivityCompletionBased(actDto.getGateActivityCompletionBased());
                ((ScheduleGateActivity)act).setSystemTool(this.systemToolDAO.getSystemToolByID(SystemTool.SCHEDULE_GATE));
                break;
            }
            case 5: {
                ((PermissionGateActivity)act).setGateActivityLevelId(actDto.getGateActivityLevelID());
                ((PermissionGateActivity)act).setGateOpen(false);
                ((PermissionGateActivity)act).setSystemTool(this.systemToolDAO.getSystemToolByID(SystemTool.PERMISSION_GATE));
                break;
            }
            case 14: {
                ((ConditionGateActivity)act).setGateActivityLevelId(actDto.getGateActivityLevelID());
                ((ConditionGateActivity)act).setGateOpen(false);
                ((ConditionGateActivity)act).setSystemTool(this.systemToolDAO.getSystemToolByID(SystemTool.PERMISSION_GATE));
                break;
            }
            case 6: {
                act.setLearningLibrary(this.learningLibraryDAO.getLearningLibraryById(actDto.getLearningLibraryID()));
                break;
            }
            case 7: 
            case 13: {
                ((OptionsActivity)act).setMaxNumberOfOptions(actDto.getMaxOptions());
                ((OptionsActivity)act).setMinNumberOfOptions(actDto.getMinOptions());
                ((OptionsActivity)act).setOptionsInstructions(actDto.getOptionsInstructions());
                break;
            }
            case 8: {
                break;
            }
            case 10: {
                ((BranchingActivity)act).setSystemTool(this.systemToolDAO.getSystemToolByID(SystemTool.TEACHER_CHOSEN_BRANCHING));
                this.processBranchingFields((BranchingActivity)act, actDto);
                break;
            }
            case 11: {
                ((BranchingActivity)act).setSystemTool(this.systemToolDAO.getSystemToolByID(SystemTool.GROUP_BASED_BRANCHING));
                this.processBranchingFields((BranchingActivity)act, actDto);
                break;
            }
            case 12: {
                ((BranchingActivity)act).setSystemTool(this.systemToolDAO.getSystemToolByID(SystemTool.TOOL_BASED_BRANCHING));
                this.processBranchingFields((BranchingActivity)act, actDto);
            }
        }
        if (act.isComplexActivity() && actDto.getDefaultActivityUIID() != null) {
            defaultActivityToParentActivityMapping.put(actDto.getDefaultActivityUIID(), (ComplexActivity)act);
        }
        act.setGroupingSupportType(actDto.getGroupingSupportType());
        act.setActivityUIID(actDto.getActivityUIID());
        act.setActivityCategoryID(actDto.getActivityCategoryID());
        act.setActivityId(actDto.getActivityID());
        act.setActivityTypeId(actDto.getActivityTypeID());
        act.setApplyGrouping(actDto.getApplyGrouping());
        act.setDescription(actDto.getDescription());
        act.setHelpText(actDto.getHelpText());
        act.setLanguageFile(actDto.getLanguageFile());
        if (actDto.getStopAfterActivity() != null) {
            act.setStopAfterActivity(actDto.getStopAfterActivity());
        }
        act.setLibraryActivityUiImage(actDto.getLibraryActivityUIImage());
        act.setOrderId(actDto.getOrderID());
        act.setParentActivity(null);
        act.setParentUIID(actDto.getParentUIID());
        act.setTitle(actDto.getActivityTitle());
        act.setXcoord(actDto.getxCoord());
        act.setYcoord(actDto.getyCoord());
        newGrouping = groupingList.get(actDto.getGroupingID());
        act.setGrouping(newGrouping);
        if (newGrouping != null) {
            act.setGroupingUIID(newGrouping.getGroupingUIID());
        }
        act.setCreateDateTime(new Date());
        return act;
    }

    private void processBranchingFields(BranchingActivity act, AuthoringActivityDTO actDto) {
        act.setStartXcoord(actDto.getStartXCoord());
        act.setEndXcoord(actDto.getEndXCoord());
        act.setStartYcoord(actDto.getStartYCoord());
        act.setEndYcoord(actDto.getEndYCoord());
    }

    private static String generateUniqueLDTitle(WorkspaceFolder folder, String titleFromFile, ILearningDesignDAO learningDesignDAO) {
        String newTitle = titleFromFile;
        if (newTitle == null || newTitle.length() == 0) {
            newTitle = "unknown";
        }
        if (folder != null) {
            List ldList = learningDesignDAO.getAllLearningDesignsInFolder(folder.getWorkspaceFolderId());
            int idx = 1;
            Calendar calendar = Calendar.getInstance();
            int mth = calendar.get(2) + 1;
            String mthStr = new Integer(mth).toString();
            if (mth < 10) {
                mthStr = "0" + mthStr;
            }
            int day = calendar.get(5);
            String dayStr = new Integer(day).toString();
            if (day < 10) {
                dayStr = "0" + dayStr;
            }
            String nameMid = dayStr + mthStr + calendar.get(1);
            while (true) {
                boolean dupName = false;
                for (LearningDesign eld : ldList) {
                    if (!StringUtils.equals((String)eld.getTitle(), (String)newTitle)) continue;
                    dupName = true;
                    break;
                }
                if (!dupName) break;
                newTitle = titleFromFile + "_" + nameMid + "_" + idx;
                ++idx;
            }
        }
        return newTitle;
    }

    public IActivityDAO getActivityDAO() {
        return this.activityDAO;
    }

    public void setActivityDAO(IActivityDAO activityDAO) {
        this.activityDAO = activityDAO;
    }

    public IGroupingDAO getGroupingDAO() {
        return this.groupingDAO;
    }

    public void setGroupingDAO(IGroupingDAO groupingDAO) {
        this.groupingDAO = groupingDAO;
    }

    public ILearningDesignDAO getLearningDesignDAO() {
        return this.learningDesignDAO;
    }

    public void setLearningDesignDAO(ILearningDesignDAO learningDesignDAO) {
        this.learningDesignDAO = learningDesignDAO;
    }

    public ILicenseDAO getLicenseDAO() {
        return this.licenseDAO;
    }

    public void setBaseDAO(IBaseDAO baseDAO) {
        this.baseDAO = baseDAO;
    }

    public void setLicenseDAO(ILicenseDAO licenseDAO) {
        this.licenseDAO = licenseDAO;
    }

    public IToolContentDAO getToolContentDAO() {
        return this.toolContentDAO;
    }

    public void setToolContentDAO(IToolContentDAO toolContentDAO) {
        this.toolContentDAO = toolContentDAO;
    }

    public IToolDAO getToolDAO() {
        return this.toolDAO;
    }

    public void setToolDAO(IToolDAO toolDAO) {
        this.toolDAO = toolDAO;
    }

    public ITransitionDAO getTransitionDAO() {
        return this.transitionDAO;
    }

    public void setTransitionDAO(ITransitionDAO transitionDAO) {
        this.transitionDAO = transitionDAO;
    }

    public void setLearningLibraryDAO(ILearningLibraryDAO learningLibraryDAO) {
        this.learningLibraryDAO = learningLibraryDAO;
    }

    public void setSystemToolDAO(ISystemToolDAO systemToolDAO) {
        this.systemToolDAO = systemToolDAO;
    }

    public class ToolCompatibleStrategy {
        public Tool getTool(String toolSignature) {
            return ExportToolContentService.this.toolDAO.getToolBySignature(toolSignature);
        }
    }

    private class FileConverter
    implements Converter {
        private Converter defaultConverter;
        private List<ValueInfo> fileNodes = new ArrayList<ValueInfo>();

        public FileConverter(XStream xstream) {
            this.defaultConverter = new ReflectionConverter(xstream.getMapper(), xstream.getReflectionProvider());
        }

        public List<ValueInfo> getFileNodes() {
            return this.fileNodes;
        }

        public boolean canConvert(Class<?> type) {
            for (NameInfo info : ExportToolContentService.this.fileHandleClassList) {
                if (!info.className.equals(type.getName())) continue;
                ExportToolContentService.this.log.debug((Object)("XStream will handle [" + info.className + "] as file node class."));
                return true;
            }
            return false;
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            if (source != null) {
                String className = source.getClass().getName();
                try {
                    for (NameInfo name : ExportToolContentService.this.fileHandleClassList) {
                        Long uuid;
                        if (!name.className.equals(className) || (uuid = NumberUtils.createLong((String)BeanUtils.getProperty((Object)source, (String)name.uuidFieldName))) == null) continue;
                        Long version = null;
                        if (name.versionFieldName != null) {
                            version = NumberUtils.createLong((String)BeanUtils.getProperty((Object)source, (String)name.versionFieldName));
                        }
                        ExportToolContentService.this.log.debug((Object)("XStream get file node [" + uuid + "," + version + "]."));
                        ExportToolContentService exportToolContentService = ExportToolContentService.this;
                        exportToolContentService.getClass();
                        this.fileNodes.add(exportToolContentService.new ValueInfo(uuid, version));
                    }
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    ExportToolContentService.this.log.error((Object)"Error while marshalling a file", (Throwable)e);
                }
            }
            this.defaultConverter.marshal(source, writer, context);
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            Object result = this.defaultConverter.unmarshal(reader, context);
            if (result != null) {
                String className = result.getClass().getName();
                for (NameInfo name : ExportToolContentService.this.fileHandleClassList) {
                    if (!name.className.equals(className)) continue;
                    ExportToolContentService exportToolContentService = ExportToolContentService.this;
                    exportToolContentService.getClass();
                    this.fileNodes.add(exportToolContentService.new ValueInfo(name, result));
                    break;
                }
            }
            return result;
        }
    }

    private class ValueInfo {
        public NameInfo name;
        public Object instance;
        public Long fileUuid;
        public Long fileVersionId;

        public ValueInfo(NameInfo name, Object instance) {
            this.name = name;
            this.instance = instance;
        }

        public ValueInfo(Long uuid, Long versionId) {
            this.fileUuid = uuid;
            this.fileVersionId = versionId;
        }
    }

    private class NameInfo {
        public String className;
        public String uuidFieldName;
        public String versionFieldName;
        public String fileNameFieldName;
        public String mimeTypeFieldName;
        public String initalItemFieldName;

        public NameInfo(String className, String uuidFieldName, String versionFieldName) {
            this.className = className;
            this.uuidFieldName = uuidFieldName;
            this.versionFieldName = versionFieldName;
        }

        public NameInfo(String className, String uuidFieldName, String versionFieldName, String fileNameFieldName, String mimeTypeFieldName, String initalItemFieldName) {
            this.className = className;
            this.uuidFieldName = uuidFieldName;
            this.versionFieldName = versionFieldName;
            this.fileNameFieldName = fileNameFieldName;
            this.mimeTypeFieldName = mimeTypeFieldName;
            this.initalItemFieldName = initalItemFieldName;
        }
    }
}

