/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.lesson;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ActivityOrderComparator;
import org.lamsfoundation.lams.learningdesign.ComplexActivity;
import org.lamsfoundation.lams.learningdesign.dao.IActivityDAO;
import org.lamsfoundation.lams.lesson.CompletedActivityProgress;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.dto.CompletedActivityDTO;
import org.lamsfoundation.lams.lesson.dto.LearnerProgressCompletedDTO;
import org.lamsfoundation.lams.lesson.dto.LearnerProgressDTO;
import org.lamsfoundation.lams.usermanagement.User;

public class LearnerProgress
implements Serializable {
    private static final long serialVersionUID = -7866830317967062822L;
    private static Logger log = Logger.getLogger(LearnerProgress.class);
    public static final byte ACTIVITY_COMPLETED = 1;
    public static final byte ACTIVITY_ATTEMPTED = 2;
    public static final byte ACTIVITY_NOT_ATTEMPTED = 3;
    public static final byte PARALLEL_NO_WAIT = 0;
    public static final byte PARALLEL_WAITING = 1;
    public static final byte PARALLEL_WAITING_COMPLETE = 2;
    public static final byte LESSON_NOT_COMPLETE = 0;
    public static final byte LESSON_END_OF_DESIGN_COMPLETE = 1;
    public static final byte LESSON_IN_DESIGN_COMPLETE = 2;
    private Long learnerProgressId;
    private User user;
    private Lesson lesson;
    private Map<Activity, Date> attemptedActivities;
    private Map<Activity, CompletedActivityProgress> completedActivities;
    private Activity previousActivity;
    private Activity currentActivity;
    private Activity nextActivity;
    private Byte lessonComplete;
    private byte parallelWaiting;
    private List currentCompletedActivitiesList;
    private boolean restarting;
    private Date startDate;
    private Date finishDate;

    public LearnerProgress() {
        this.lessonComplete = new Byte(0);
    }

    public LearnerProgress(User user, Lesson lesson) {
        this(null, user, lesson, new TreeMap<Activity, Date>(new ActivityOrderComparator()), new TreeMap<Activity, CompletedActivityProgress>(new ActivityOrderComparator()));
    }

    public LearnerProgress(Long learnerProgressId, User user, Lesson lesson, Map<Activity, Date> attemptedActivities, Map<Activity, CompletedActivityProgress> completedActivities) {
        this.learnerProgressId = learnerProgressId;
        this.user = user;
        this.lesson = lesson;
        this.attemptedActivities = attemptedActivities;
        this.completedActivities = completedActivities;
        this.lessonComplete = new Byte(0);
    }

    public Long getLearnerProgressId() {
        return this.learnerProgressId;
    }

    public void setLearnerProgressId(Long learnerProgressId) {
        this.learnerProgressId = learnerProgressId;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Lesson getLesson() {
        return this.lesson;
    }

    public void setLesson(Lesson lesson) {
        this.lesson = lesson;
    }

    public Map<Activity, Date> getAttemptedActivities() {
        return this.attemptedActivities;
    }

    public void setAttemptedActivities(Map<Activity, Date> attemptedActivities) {
        this.attemptedActivities = attemptedActivities;
    }

    public Map<Activity, CompletedActivityProgress> getCompletedActivities() {
        return this.completedActivities;
    }

    public void setCompletedActivities(Map<Activity, CompletedActivityProgress> completedActivities) {
        this.completedActivities = completedActivities;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("learnerProgressId", (Object)this.getLearnerProgressId()).toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LearnerProgress)) {
            return false;
        }
        LearnerProgress castOther = (LearnerProgress)other;
        return new EqualsBuilder().append((Object)this.getLearnerProgressId(), (Object)castOther.getLearnerProgressId()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getLearnerProgressId()).toHashCode();
    }

    public Activity getCurrentActivity() {
        return this.currentActivity;
    }

    public void setCurrentActivity(Activity currentActivity) {
        this.currentActivity = currentActivity;
    }

    public byte getProgressState(Activity activity) {
        if (this.getCompletedActivities().containsKey(activity)) {
            return 1;
        }
        if (this.getAttemptedActivities().containsKey(activity)) {
            return 2;
        }
        return 3;
    }

    public synchronized void setProgressState(Activity activity, byte state, IActivityDAO activityDAO) {
        byte oldState = this.getProgressState(activity);
        if (oldState == state) {
            return;
        }
        Date activityStartDate = this.getAttemptedActivities().get(activity);
        if (activityStartDate != null && state == 2) {
            log.warn((Object)("Progress " + this.getLearnerProgressId() + " found newly attempted activity " + activity.getActivityId() + " already in in the attempted activities set."));
        } else if (activityStartDate == null && state != 2) {
            log.warn((Object)("Progress " + this.getLearnerProgressId() + " found NULL start date of activity " + activity.getActivityId() + ". Activity missing from attempted activities list."));
        }
        if (oldState != 3) {
            if (oldState == 2) {
                this.getAttemptedActivities().remove(activity);
            } else if (oldState == 1) {
                this.getCompletedActivities().remove(activity);
                if (activity.isComplexActivity()) {
                    ComplexActivity complex = (ComplexActivity)activityDAO.getActivityByActivityId(activity.getActivityId(), ComplexActivity.class);
                    for (Activity child : complex.getActivities()) {
                        this.setProgressState(child, state, activityDAO);
                    }
                }
            }
        }
        if (state != 3) {
            if (state == 2) {
                this.getAttemptedActivities().put(activity, new Date());
            } else if (state == 1) {
                this.getCompletedActivities().put(activity, new CompletedActivityProgress(this, activity, activityStartDate, new Date()));
            }
        }
    }

    public boolean isComplete() {
        return this.lessonComplete == 1 || this.lessonComplete == 2;
    }

    public Byte getLessonComplete() {
        return this.lessonComplete;
    }

    public void setLessonComplete(Byte lessonComplete) {
        this.lessonComplete = lessonComplete;
    }

    public Activity getNextActivity() {
        return this.nextActivity;
    }

    public void setNextActivity(Activity nextActivity) {
        this.nextActivity = nextActivity;
    }

    public Activity getPreviousActivity() {
        return this.previousActivity;
    }

    public void setPreviousActivity(Activity previousActivity) {
        this.previousActivity = previousActivity;
    }

    public byte getParallelWaiting() {
        return this.parallelWaiting;
    }

    public void setParallelWaiting(byte parallelWaiting) {
        this.parallelWaiting = parallelWaiting;
    }

    public List getCurrentCompletedActivitiesList() {
        return this.currentCompletedActivitiesList;
    }

    public void setCurrentCompletedActivitiesList(List completedActivitiesList) {
        this.currentCompletedActivitiesList = new LinkedList();
        this.currentCompletedActivitiesList.addAll(completedActivitiesList);
    }

    public boolean isRestarting() {
        return this.restarting;
    }

    public void setRestarting(boolean restarting) {
        this.restarting = restarting;
    }

    public LearnerProgressDTO getLearnerProgressData() {
        return new LearnerProgressDTO(this.lesson.getLessonId(), this.lesson.getLessonName(), this.user.getLogin(), this.user.getLastName(), this.user.getFirstName(), this.user.getUserId(), this.currentActivity != null ? this.currentActivity.getActivityId() : null, this.createIdArrayFrom(this.getAttemptedActivities().keySet()), this.createIdArrayFrom(this.getCompletedActivities().keySet()), this.isComplete());
    }

    public LearnerProgressCompletedDTO getLearnerProgressCompletedData() {
        return new LearnerProgressCompletedDTO(this.lesson.getLessonId(), this.lesson.getLessonName(), this.user.getLogin(), this.user.getLastName(), this.user.getFirstName(), this.user.getUserId(), this.createCompletedActivityArrayFromMap(this.getCompletedActivities()), this.isComplete(), this.lesson.getStartDateTime().getTime(), this.startDate.getTime());
    }

    private Long[] createIdArrayFrom(Set activities) {
        if (activities == null) {
            throw new IllegalArgumentException("Fail to create id array from null activity set");
        }
        ArrayList<Long> activitiesIds = new ArrayList<Long>();
        for (Activity activity : activities) {
            activitiesIds.add(activity.getActivityId());
        }
        return activitiesIds.toArray(new Long[activitiesIds.size()]);
    }

    private CompletedActivityDTO[] createCompletedActivityArrayFromMap(Map<Activity, CompletedActivityProgress> completedActivityProgs) {
        if (completedActivityProgs == null) {
            throw new IllegalArgumentException("Fail to create id array from null activity set");
        }
        ArrayList<CompletedActivityDTO> activitiesCompleted = new ArrayList<CompletedActivityDTO>();
        for (Map.Entry<Activity, CompletedActivityProgress> ent : completedActivityProgs.entrySet()) {
            Activity activity = ent.getKey();
            CompletedActivityProgress compProg = ent.getValue();
            if (compProg == null) continue;
            Date end = compProg.getFinishDate();
            Date start = compProg.getStartDate();
            if (end == null || start == null || this.startDate == null) continue;
            Long completedTime = end.getTime() - this.startDate.getTime();
            Long startTime = start.getTime() - this.startDate.getTime();
            activitiesCompleted.add(new CompletedActivityDTO(activity, startTime, completedTime));
        }
        return activitiesCompleted.toArray(new CompletedActivityDTO[activitiesCompleted.size()]);
    }

    public Date getFinishDate() {
        return this.finishDate;
    }

    public void setFinishDate(Date finishDate) {
        this.finishDate = finishDate;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
}

