/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.lesson.dao.hibernate;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.lamsfoundation.lams.dao.hibernate.LAMSBaseDAO;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.lesson.LearnerProgress;
import org.lamsfoundation.lams.lesson.dao.ILearnerProgressDAO;
import org.lamsfoundation.lams.usermanagement.User;
import org.springframework.stereotype.Repository;

@Repository
public class LearnerProgressDAO
extends LAMSBaseDAO
implements ILearnerProgressDAO {
    protected Logger log = Logger.getLogger(LearnerProgressDAO.class);
    private static final String LOAD_PROGRESS_BY_LEARNER = "from LearnerProgress p where p.user.id = :learnerId and p.lesson.id = :lessonId";
    private static final String LOAD_PROGRESS_REFFERING_TO_ACTIVITY = "from LearnerProgress p where p.previousActivity = :activity or p.currentActivity = :activity or p.nextActivity = :activity ";
    private static final String LOAD_COMPLETED_PROGRESS_BY_LESSON = "FROM LearnerProgress p WHERE p.lessonComplete > 0 AND p.lesson.id = :lessonId ORDER BY p.user.firstName <ORDER>, p.user.lastName <ORDER>, p.user.login <ORDER>";
    private static final String LOAD_LEARNERS_LATEST_COMPLETED_BY_LESSON = "SELECT p.user FROM LearnerProgress p WHERE p.lessonComplete > 0 and p.lesson.id = :lessonId ORDER BY p.finishDate DESC";
    private static final String LOAD_LEARNERS_ATTEMPTED_ACTIVITY = "SELECT prog.user FROM LearnerProgress prog,  Activity act join prog.attemptedActivities attAct where act.id = :activityId and index(attAct) = act";
    private static final String LOAD_LEARNERS_COMPLETED_ACTIVITY = "SELECT prog.user FROM LearnerProgress prog,  Activity act join prog.completedActivities compAct where act.id = :activityId and index(compAct) = act";
    private static final String COUNT_COMPLETED_PROGRESS_BY_LESSON = "select count(*) from LearnerProgress p  where p.lessonComplete > 0 and p.lesson.id = :lessonId";
    private static final String COUNT_ATTEMPTED_ACTIVITY = "select count(*) from LearnerProgress prog,  Activity act join prog.attemptedActivities attAct where act.id = :activityId and  index(attAct) = act";
    private static final String COUNT_COMPLETED_ACTIVITY = "select count(*) from LearnerProgress prog,  Activity act join prog.completedActivities compAct where act.id = :activityId and  index(compAct) = act";
    private static final String COUNT_CURRENT_ACTIVITY = "select prog.currentActivity.activityId, count(prog) from LearnerProgress prog WHERE prog.currentActivity.activityId IN (:activityIds) GROUP BY prog.currentActivity.activityId";
    private static final String LOAD_PROGRESS_BY_LESSON = "from LearnerProgress p  where p.lesson.id = :lessonId order by p.user.lastName, p.user.firstName, p.user.userId";
    private static final String LOAD_PROGRESS_BY_LESSON_AND_USER_IDS = "from LearnerProgress p  where p.lesson.id = :lessonId AND p.user.userId IN (:userIds) order by p.user.lastName, p.user.firstName, p.user.userId";
    private static final String LOAD_PROGRESSES_BY_LESSON_LIST = "FROM LearnerProgress progress WHERE  progress.lesson.lessonId IN (:lessonIds)";
    private static final String LOAD_LEARNERS_LATEST_BY_ACTIVITY = "SELECT u.* FROM lams_learner_progress AS prog JOIN lams_progress_attempted AS att USING (learner_progress_id) JOIN lams_user AS u USING (user_id) WHERE prog.current_activity_id = :activityId AND att.activity_id = :activityId ORDER BY att.start_date_time DESC";
    private static final String LOAD_LEARNERS_BY_ACTIVITIES = "SELECT prog.user FROM LearnerProgress prog WHERE  prog.currentActivity.id IN (:activityIds) ORDER BY prog.user.firstName <ORDER>, prog.user.lastName <ORDER>, prog.user.login <ORDER>";
    private static final String COUNT_LEARNERS_BY_LESSON = "COUNT(*) FROM LearnerProgress prog WHERE prog.lesson.id = :lessonId";
    private static final String COUNT_LEARNERS_BY_LESSON_ORDER_CLAUSE = " ORDER BY prog.user.firstName ASC, prog.user.lastName ASC, prog.user.login ASC";
    private static final String LOAD_LEARNERS_BY_MOST_PROGRESS = "SELECT u.*, COUNT(comp.activity_id) AS comp_count FROM lams_lesson AS lesson JOIN lams_grouping AS grouping ON lesson.class_grouping_id = grouping.grouping_id JOIN lams_group AS g USING (grouping_id) JOIN lams_user_group AS ug USING (group_id) JOIN lams_user AS u ON ug.user_id = u.user_id LEFT JOIN lams_learner_progress AS prog ON prog.lesson_id = lesson.lesson_id AND prog.user_id = u.user_id LEFT JOIN lams_progress_completed AS comp USING (learner_progress_id) WHERE lesson.lesson_id = :lessonId AND g.group_name NOT LIKE '%Staff%'";
    private static final String LOAD_LEARNERS_BY_MOST_PROGRESS_ORDER_CLAUSE = " GROUP BY u.user_id ORDER BY prog.lesson_completed_flag DESC, comp_count DESC, u.first_name ASC, u.last_name ASC, u.login ASC";
    private static final String FIND_PROGRESS_ARCHIVE_MAX_ATTEMPT = "SELECT MAX(p.attemptId) FROM LearnerProgressArchive p WHERE p.user.id = :learnerId AND p.lesson.id = :lessonId";

    @Override
    public LearnerProgress getLearnerProgress(Long learnerProgressId) {
        return (LearnerProgress)this.getSession().get(LearnerProgress.class, (Serializable)learnerProgressId);
    }

    @Override
    public void saveLearnerProgress(LearnerProgress learnerProgress) {
        this.getSession().save((Object)learnerProgress);
    }

    @Override
    public void deleteLearnerProgress(LearnerProgress learnerProgress) {
        this.getSession().delete((Object)learnerProgress);
    }

    @Override
    public LearnerProgress getLearnerProgressByLearner(Integer learnerId, Long lessonId) {
        return (LearnerProgress)this.getSession().createQuery(LOAD_PROGRESS_BY_LEARNER).setInteger("learnerId", learnerId.intValue()).setLong("lessonId", lessonId.longValue()).uniqueResult();
    }

    @Override
    public void updateLearnerProgress(LearnerProgress learnerProgress) {
        this.getSession().update((Object)learnerProgress);
    }

    @Override
    public List<LearnerProgress> getLearnerProgressReferringToActivity(Activity activity) {
        return this.getSession().createQuery(LOAD_PROGRESS_REFFERING_TO_ACTIVITY).setEntity("activity", (Object)activity).list();
    }

    @Override
    public List<User> getLearnersLatestByActivity(Long activityId, Integer limit, Integer offset) {
        Query query = this.getSession().createSQLQuery(LOAD_LEARNERS_LATEST_BY_ACTIVITY).addEntity(User.class).setLong("activityId", activityId.longValue());
        if (limit != null) {
            query.setMaxResults(limit.intValue());
        }
        if (offset != null) {
            query.setFirstResult(offset.intValue());
        }
        return query.list();
    }

    @Override
    public List<User> getLearnersByActivities(Long[] activityIds, Integer limit, Integer offset, boolean orderAscending) {
        Query query = this.getSession().createQuery(LOAD_LEARNERS_BY_ACTIVITIES.replaceAll("<ORDER>", orderAscending ? "ASC" : "DESC")).setParameterList("activityIds", (Object[])activityIds);
        if (limit != null) {
            query.setMaxResults(limit.intValue());
        }
        if (offset != null) {
            query.setFirstResult(offset.intValue());
        }
        return query.list();
    }

    @Override
    public List<User> getLearnersLatestCompletedForLesson(Long lessonId, Integer limit, Integer offset) {
        Query query = this.getSession().createQuery(LOAD_LEARNERS_LATEST_COMPLETED_BY_LESSON).setLong("lessonId", lessonId.longValue());
        if (limit != null) {
            query.setMaxResults(limit.intValue());
        }
        if (offset != null) {
            query.setFirstResult(offset.intValue());
        }
        return query.list();
    }

    @Override
    public List<User> getLearnersByMostProgress(Long lessonId, String searchPhrase, Integer limit, Integer offset) {
        StringBuilder queryText = new StringBuilder(LOAD_LEARNERS_BY_MOST_PROGRESS);
        if (!StringUtils.isBlank((String)searchPhrase)) {
            String[] tokens;
            for (String token : tokens = searchPhrase.trim().split("\\s+")) {
                queryText.append(" AND (u.first_name LIKE '%").append(token).append("%' OR u.last_name LIKE '%").append(token).append("%' OR u.login LIKE '%").append(token).append("%')");
            }
        }
        queryText.append(LOAD_LEARNERS_BY_MOST_PROGRESS_ORDER_CLAUSE);
        Query query = this.getSession().createSQLQuery(queryText.toString()).addEntity(User.class).setLong("lessonId", lessonId.longValue());
        if (limit != null) {
            query.setMaxResults(limit.intValue());
        }
        if (offset != null) {
            query.setFirstResult(offset.intValue());
        }
        return query.list();
    }

    @Override
    public List<LearnerProgress> getCompletedLearnerProgressForLesson(Long lessonId, Integer limit, Integer offset, boolean orderAscending) {
        Query query = this.getSession().createQuery(LOAD_COMPLETED_PROGRESS_BY_LESSON.replaceAll("<ORDER>", orderAscending ? "ASC" : "DESC")).setLong("lessonId", lessonId.longValue());
        if (limit != null) {
            query.setMaxResults(limit.intValue());
        }
        if (offset != null) {
            query.setFirstResult(offset.intValue());
        }
        return query.list();
    }

    @Override
    public List<LearnerProgress> getLearnerProgressForLesson(Long lessonId) {
        return this.getSession().createQuery(LOAD_PROGRESS_BY_LESSON).setLong("lessonId", lessonId.longValue()).list();
    }

    @Override
    public List<LearnerProgress> getLearnerProgressForLesson(Long lessonId, List<Integer> userIds) {
        return this.getSession().createQuery(LOAD_PROGRESS_BY_LESSON_AND_USER_IDS).setLong("lessonId", lessonId.longValue()).setParameterList("userIds", userIds).list();
    }

    @Override
    public List<LearnerProgress> getLearnerProgressForLessons(List<Long> lessonIds) {
        return this.getSession().createQuery(LOAD_PROGRESSES_BY_LESSON_LIST).setParameterList("lessonIds", lessonIds).list();
    }

    @Override
    public List<User> getLearnersAttemptedOrCompletedActivity(Activity activity) {
        List users = this.getSession().createQuery(LOAD_LEARNERS_ATTEMPTED_ACTIVITY).setLong("activityId", activity.getActivityId().longValue()).list();
        users.addAll(this.getSession().createQuery(LOAD_LEARNERS_COMPLETED_ACTIVITY).setLong("activityId", activity.getActivityId().longValue()).list());
        return users;
    }

    @Override
    public List<User> getLearnersAttemptedActivity(Activity activity) {
        List users = this.getSession().createQuery(LOAD_LEARNERS_ATTEMPTED_ACTIVITY).setLong("activityId", activity.getActivityId().longValue()).list();
        return users;
    }

    @Override
    public List<User> getLearnersCompletedActivity(Activity activity) {
        List users = this.getSession().createQuery(LOAD_LEARNERS_COMPLETED_ACTIVITY).setLong("activityId", activity.getActivityId().longValue()).list();
        return users;
    }

    @Override
    public Integer getNumUsersAttemptedActivity(Activity activity) {
        Object value = this.getSession().createQuery(COUNT_ATTEMPTED_ACTIVITY).setLong("activityId", activity.getActivityId().longValue()).uniqueResult();
        Integer attempted = new Integer(((Number)value).intValue());
        return new Integer(attempted + this.getNumUsersCompletedActivity(activity));
    }

    @Override
    public Integer getNumUsersCompletedActivity(Activity activity) {
        Object value = this.getSession().createQuery(COUNT_COMPLETED_ACTIVITY).setLong("activityId", activity.getActivityId().longValue()).uniqueResult();
        return new Integer(((Number)value).intValue());
    }

    @Override
    public Integer getNumUsersByLesson(Long lessonId, String searchPhrase) {
        StringBuilder queryText = new StringBuilder(COUNT_LEARNERS_BY_LESSON);
        if (!StringUtils.isBlank((String)searchPhrase)) {
            String[] tokens;
            for (String token : tokens = searchPhrase.trim().split("\\s+")) {
                queryText.append(" AND (prog.user.firstName LIKE '%").append(token).append("%' OR prog.user.lastName LIKE '%").append(token).append("%' OR prog.user.login LIKE '%").append(token).append("%')");
            }
        }
        queryText.append(COUNT_LEARNERS_BY_LESSON_ORDER_CLAUSE);
        Object value = this.getSession().createQuery(queryText.toString()).setLong("lessonId", lessonId.longValue()).uniqueResult();
        return ((Number)value).intValue();
    }

    @Override
    public Integer getNumUsersCompletedLesson(Long lessonId) {
        Object value = this.getSession().createQuery(COUNT_COMPLETED_PROGRESS_BY_LESSON).setLong("lessonId", lessonId.longValue()).uniqueResult();
        return ((Number)value).intValue();
    }

    @Override
    public Map<Long, Integer> getNumUsersCurrentActivities(Long[] activityIds) {
        List resultQuery = this.getSession().createQuery(COUNT_CURRENT_ACTIVITY).setParameterList("activityIds", (Object[])activityIds).list();
        TreeMap<Long, Integer> result = new TreeMap<Long, Integer>();
        for (Long activityId : activityIds) {
            result.put(activityId, 0);
        }
        for (Object[] entry : resultQuery) {
            if (entry == null) continue;
            result.put((Long)entry[0], ((Long)entry[1]).intValue());
        }
        return result;
    }

    @Override
    public Integer getLearnerProgressArchiveMaxAttemptID(Integer userId, Long lessonId) {
        Object value = this.getSession().createQuery(FIND_PROGRESS_ARCHIVE_MAX_ATTEMPT).setInteger("learnerId", userId.intValue()).setLong("lessonId", lessonId.longValue()).uniqueResult();
        return value == null ? null : Integer.valueOf(((Number)value).intValue());
    }
}

